/*
 *  decoding routine to unpack event by event data and pass this on to user routines
 *  *** Data style == ANU ***
 *
 *         NOT YET FINISHED !!!!
 *  version that first eight modules only (8*16 = 128 adcs)
 *
 *  started on new version 9/8/95
 *  modified 9/2/96
 */

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_thread.h"
#include "rdtape.h"

#define SWAPSHORT(s) ( ((s&0x00ff) << 8) + ((s&0xff00) >> 8) )

#define ANU_RECORD_COUNT     8192
#define ANU_RECORD_HWM       8100
#define ANU_BUFHEADER_WORDS  16

static unsigned short Emask[] = {0x1,   0x2,    0x4,    0x8,
				0x10,   0x20,   0x40,   0x80,
				0x100,  0x200,  0x400,  0x800,
				0x1000, 0x2000, 0x4000, 0x8000};
static short fevents;

int
rdtape_anu(
#if NeedFunctionPrototype
	  int filter)
#else
      filter)
      int filter;
#endif
{
      short *bitpattern[NOS_ADCS_GROUPS], *adc[NOS_ADCS_GROUPS];
      
      register short *ebye;            /* pointer to input buffer */

      register short *eptr, *header_ptr;
      register short nos_events, mheader, pattern;
      register short event_len;
      
      time_t start_time, time_now;
      int bytes, record = 0;
      long in_counter = 0;
      
      register int i, j;
      register int adc_bytes, bit_bytes;

/* initialize event sorting */
      for (i=0; i<NOS_ADCS_GROUPS; i++) {
	    adc[i] = &adcs_.adcs[i*16];
	    bitpattern[i] = &adcs_.bitpattern[7-i];
      }
      adc_bytes = adcnum_.nos_adcs * sizeof(short);
      bit_bytes = sizeof(adcs_.bitpattern);
      
/* call user's initialization function */      
      (void) init_();

/* set start time */
      start_time = time(NULL);
      
/* sort requested number of records or until end of file etc */
      for (record=1; ; record++) {
	    if ( (ebye = read_block(&bytes)) == NULL) 
		  break;
	    
	    /* check start of record header */
	    if (strncmp("P1DC",(char *)ebye, 4) != 0) {
		  fprintf(stderr,"Invalid record header ... trying next record\n");
		  continue;
	    }

	    /* get number of events in this block */
	    nos_events = SWAPSHORT(ebye[13]);
	    if (nos_events <= 0 || nos_events > 4080) {
		  fprintf(stderr,"faulty record structure, header gives %d events\n",nos_events);
		  fprintf(stderr,"... stopping sorting at record %d\n",record);
		  break;
	    }
	    
	    /* skip buffer header */
	    eptr = ebye + ANU_BUFHEADER_WORDS;

	    /* start decoding event block */
	    while (nos_events > 0) {
		  /* reset adcs_ common block */
		  (void) memset((char *) adcs_.adcs, -1, adc_bytes);
		  (void) memset((char *) adcs_.bitpattern, 0, bit_bytes);
	    
		  /* decode event header */
		  header_ptr = eptr++;
		  mheader = (*header_ptr & 0xff00) >> 8;

		  /* for the first 8 modules only */
		  for (i=0; i<8; i++) {
			/* check whether this module is present */
			if (mheader & Emask[i]) {
			      /* decode pattern register for module */
			      pattern = *bitpattern[i] = SWAPSHORT(*eptr);
			      eptr++;
			      /* for each bit in pattern put data into appropriate adc */
			      for (j=0; j<16; j++) {
				    if (pattern & Emask[j]) {
					  adc[i][j] = SWAPSHORT(*eptr);
					  eptr++;
				    }
			      }
			}
		  }

		  /* check that eptr is still within valid range */
		  if (eptr > ebye+bytes) {
			fprintf(stderr,"Error ...  event extents beyond data block with %d events left to read\n",
				nos_events);
			fprintf(stderr,"... skipping rest of record %d\n",record);
			break;
		  }

		  /* calculate the event_len */
		  adcs_.triggernos = event_len = eptr - header_ptr;

		  /* call user provided event sorting routine */
		  in_counter++;
                  adcs_.wrtevt = 0;
		  (void) sortin_(); 
		  
		  /* write out event if wrtevt set to true */
		  if (filter && adcs_.wrtevt) {
			if ( write_filt(header_ptr, event_len) )
			      filter = 0;
			/* increment fevents ... must be after write_filt call */
			fevents++;
		  }
		  
		  nos_events--;
	    }   /* loop over buffer until no more events */
	    
      }         /* loop over requested number of records or until eof */
      
/* lets note the time at end */
      time_now = time(NULL);

/* call user provided clearup routine  */
      (void) finish_();
      
/* output statistics */
      fprintf(stderr,"\n*** sort statistics ***\n");
        fprintf(stderr,"\nread %ld events in %d seconds\nAverage sort rate = %g events per second\n",
	      in_counter, (int) (time_now-start_time),
	      (double) in_counter / (time_now-start_time));

      fprintf(stderr,"\nfinished sorting data after reading %d records\n",record-1);
      
      return(filter);
}





/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */
static void
filt_tail(
#if NeedFunctionPrototype
	  short *base, short *fptr)
#else
      base, fptr)
      short *base;
      short *fptr;
#endif
{
      base[13] = SWAPSHORT(fevents);
      return;
}
/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head(
#if NeedFunctionPrototype
	  short *base)
#else
      base)
      short *base;
#endif
{
      fevents = 0;
      (void) strcpy((char *)base, "P1DC");
      return(base+16);
}

/* ANU filter data specification */
static filtdat_t anu_filtdat = {
      ANU_RECORD_COUNT,
      ANU_RECORD_HWM/2,
      filt_head,
      filt_tail,
      NULL,
      "ANU"
};

/* routine to get pointer to nsf_filtdat */
filtdat_t *
get_anu_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&anu_filtdat);
}
