/*
 * decoding routine to unpack event by event data and 
 * pass this on to user routines
 * *** Data style == JYFL ***
 *
 * started on 10/7/97
 */

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_thread.h"
#include "rdtape.h"

#define NUM_ADCS 4

int
rdtape_jyfl
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    time_t start_time, time_now;
    int i, record, bytes, first = 1;
    unsigned short *ptr, *ebye, *recordend;
    short *adcp;
    long in_events = 0;
    int adc_bytes;

    adc_bytes = adcnum_.nos_adcs * sizeof(short);

    /* call user's initialization function */      
    (void) init_();
      
    /* set start time */
    start_time = time(NULL);
      
    /* sort requested number of records or until end of file etc */
    for (record=1; ;record++) {
	if ( (ebye = (unsigned short *) read_block(&bytes)) == NULL) 
	    break;

	recordend = ebye + bytes/sizeof(short);

	if (first || *ebye == 0xffff)
	{
	    ebye += 8;
	    first = 0;
	}

	while(ebye < recordend && *ebye != 0xffff)
	{
	    memset((char *) adcs_.adcs, -1, adc_bytes);
	    
	    for(i = NUM_ADCS, ptr = ebye, adcp = adcs_.adcs; i--; )
		*adcp++ = *ptr++;
	    
	    adcs_.triggernos = NUM_ADCS;
	    adcs_.event = ++in_events;
	    adcs_.record = record;
	    adcs_.wrtevt = 0;
	    
	    (void) sortin_();
	    
	    if (filter && adcs_.wrtevt)
		if (write_filt((short *) ebye, NUM_ADCS))
		    filter = 0;
	    
	    ebye = ptr;
	}
    }

    /* lets note the time at end */
    time_now = time(NULL);
    
    /* call user provided clearup routine  */
    (void) finish_();
    
    /* output statistics */
    record--;
    fprintf(stderr, "\n*** sort statistics ***\n");
    fprintf(stderr, "\nsorted %ld events in %d seconds\n"
	    "Average sort rate = %g events per second\n",
	    in_events, (int) (time_now-start_time),
	    (double) in_events / (time_now-start_time));

    return(filter);
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */

static void
filt_tail
#if NeedFunctionPrototype
(short *base, short *fptr)
#else
(base, fptr)
short *base;
short *fptr;
#endif
{
    *fptr = 0xffff;

    return;
}

/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head
#if NeedFunctionPrototype
(short *base)
#else
(base)
short *base;
#endif
{
    int i;

    for(i = 8; i--; )
	*base++ = 0xffff;

    return(base);
}

/* jyfl filter data specification */
static filtdat_t jyfl_filtdat = {
      4096,
      2040,
      filt_head,
      filt_tail,
      NULL,
      "JYFL"
};

/* routine to get pointer to jyfl_filtdat */
filtdat_t *
get_jyfl_filtdat
#if NeedFunctionPrototype
(void)
#else
()
#endif
{
      return(&jyfl_filtdat);
}
