/*
 * MEGHA data decoder. This is a true Eurogam format.
 * Most of the functionality is in rdtape_eg.c
 */

#include <stdio.h>

#include "sort_thread.h"
#include "rdtape.h"
#include "rdtape_eg.h"

int
rdtape_megha(
#if NeedFunctionPrototype
	  int filter)
#else
      filter)
      int filter;
#endif
{
    return(rdtape_eg(filter, STYLE_MEGHA));
}

int
write_megha(
#if NeedFunctionPrototype
	  int size, short *array)
#else
      size, array)
      int size;
      short *array;
#endif
{
    return(write_eg(size, array, STYLE_MEGHA));
}

/* megha filter data specification */
static filtdat_t megha_filtdat = {
      EG_RECORD_COUNT,
      EG_RECORD_HWM/2,        /* in terms of shorts */
      eg_filt_head,
      eg_filt_tail,
      write_megha,
      "MEGHA"
};

/* routine to get pointer to megha_filtdat */
filtdat_t *
get_megha_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&megha_filtdat);
}

