#define DTVERSION 15		/* version number (int) */


#define READ_MODE  0
#define WRITE_MODE 1
#define NEWVOL_MODE 2


/* bit used to switch operations in dtopen */
#define REWIND_OPT 	  0x1	/* sunsort control options	rewind to beginning of tape */
#define HOLD_OPT	  0x2	/*				rewind tp beginning of file */
#define ANSI_VAR_REC      0x10   
#define ANSI_FIXED_REC    0x20
#define NONANSI           0x40


#define FALSE 0
#define TRUE  1

#define HEAD 0
#define TAIL 1

#define NOPROTECT ' '         /* space if no protection             */
#define REC_VARIABLE 'D'      /* Records are preceeded by a 4-digit
                               * zero-filled count of their length,
                               * including the 4 digits themselves  */
#define REC_FIXED 'F'
#define REC_UNIX  'U'

#define HDR_BLOCK_LEN 80	/* all header blocks are 80 bytes */

/* error codes */
#define SUCCESS                 0
#define MOUNT_UNKNOWN_MODE     -1
#define MOUNT_OPEN_ERROR       -2
#define MOUNT_INVALID_DEVICE   -3
#define MOUNT_WRONG_TAPE       -4
#define MOUNT_NOT_ANSI_FORMAT  -5
#define MOUNT_INVALID_VOL      -6
#define FOPEN_VOL_NOT_MOUNTED -10
#define FOPEN_EOV			-11
#define FOPEN_FAULTY_STRUCT   -12
#define FOPEN_FILE_OPEN       -13
#define FOPEN_NOT_FOUND		-14
#define FOPEN_UNKNOWN_MODE	-15
#define FOPEN_REC_SIZE		-16
#define FOPEN_BLOCK_SIZE	-17
#define FOPEN_INTERUPT          -18
#define FCLOSE_FILE_CLOSED	-20
#define FCLOSE_FAULTY_STRUCT	-21
#define FCLOSE_UNKNOWN_MODE	-22
#define FCLOSE_UNRECOVEABLE_ERR -23
#define WRITE_REC_SIZE		-30
#define TAPE_ERROR              -50

/*
 * VOLUME 1 Describes the owner of and access to the volume. 
 */

struct ansi_vol1 {
    char            header[4];	/* VOL1 */
    char            label[6];	/* volume name, A-Z0-9 */
    char            access;	/* access code */
    char            __ignored1[20];	/* reserved, space fill */
    char            __ignored2[6];	/* reserved, space fill */
    char            owner[14];	/* user name */
    char            __ignored3[28];	/* reserved, space fill */
    char            ansi_level;	/* ansi standard level, always 3 */
};

/*
 * VOLUME 2 optional, ignored by this software. 
 */

/*
 * HEADER 1 Begins basic description of a tape file. 
 */

struct ansi_hdr1 {
    char            header[4];	/* HDR1 */
    char            name[17];       /* rightmost 17 characters of filename */
    char            fileset[6];	/* should be same as volume id of 1st
                               	 * tape */
    char            volume_num[4];	/* number of volume in set */
    char            file_num[4];	/* number of file on tape */
    char            gen[4];		/* generation number */
    char            genver[2];	/* generation version number */
    char            created[6];	/* date of creation, "bYYDDD" */
    char            expires[6];	/* expiration date "bYYDDD" */
    char            access;		/* protection, space = unprotected */
    char            blockcount[6];	/* zero in header */
    char            tapesys[13];	/* name of software creating tape */
    char            __ignored[7];	/* reserved, space fill */
};

/*
 * HEADER 2 Record format, record size, block size. 
 */

struct ansi_hdr2 {
    char            header[4];	/* HDR2 */
    char            recfmt;		/* record format */
    char            blocklen[5];	/* file tape block length */
    char            reclen[5];	/* file logical record length */
    char            density;		/* density/recording mode. Should be 2
                            		 * for 800 bpi, 3 for 1600 bpi. */
    char            vol_switch;	/* 0, or 1 if this file was continued */
    char            job[17];		/* job name (8), /, job step (8) of
                            		 * creator */
    char            recording[2];	/* parity/conversion, space
                                 	 * fill */
    char            carriage_control;
    char            alignment;	/* reserved, space fill */
    char            blocked_records;/* 'B' if records are blocked */
    char            __ignored2[11];
    char            block_offset[2];/* ignore 1st n char of each
                                     * block */
    char            __ignored3[28];
};

/* HEADER 3 - ignore */

struct ansi_hdr3 {
    char            header[4];	/* HDR3 */
    char            os_reserved[76];	/* reserved to OS, space fill */
};

/* HEADER 4 - the rest of the filename if its longer than 17 characters. */

struct ansi_hdr4 {
    char            header[4];	/* HDR4 */
    char            name2[63];	/* leftmost char, if name is more than
				 * 17 characters long. */
    char            unknown[2];	/* fill with 00 */
    char            __ignored[11];
};


/*
 * FORMAT NOTES 
 *
 * 1.  The tape always starts with a VOL1 record.  Other volume records
 * are optional.  We ignore them, and do not generate them on output. 
 *
 * 2.  Each file starts with a set of HDRn records.  The headers are
 * followed by a tape mark. 
 *
 * 3.  The data is written to the tape in fixed-length blocks.  Valid ANSI
 * block lengths are 18 to 2048 bytes, although VMS will support longer
 * blocks. The block does not have to be full.  If the block is not
 * completely filled, the remainder of the block is padded with
 * circumflex (^) characters.  The file is followed by a tape mark. 
 *
 * 4.  Trailing records are written.  Either EOF or EOV records may be
 * used. The record formats are the same as the HDR records, except: 
 *
 * a. the "HDR" is replaced by "EOF" or "EOV". 
 *
 * b. the blockcount field in EOF1/EOV1 contains the actual number of
 * physical tape blocks written in the preceding file section.  In the
 * HDR1 record, the blockcount is 000000. 
 *
 * 5.  A tape file may extend across a volume boundary.  If it does, EOV
 * labels are used, indicating that another tape must be read.  If the
 * file ends here, an EOF label is used. 
 *
 * 6.  After the EOF records, a tape mark is written.  This separates the
 * trailers from the headers for the next file.  At the end of the
 * tape, two tape marks are written. 
 */


