/* values possibly found in EGerrno following EGlib calls */
/* DB, September 1991 */

#ifndef EG_h
#define EG_h

#define EG_MY_DATA_OFFSET 768

typedef struct eg_data_array {
	 int layout;
	 int type;
	 char reserved[8];
	 int pointer;
   } DATA_ARRAY;

typedef
struct eg_spectrum_header {
   int magic;
   int version;
   char spec_name[32];
   int dim;
   char creation[20];
   char modification[20];
   int bases[8];
   int ranges[8];
   int information[32];
   int annotation[8];
   int calibration[8];
   int efficiency[8];
   DATA_ARRAY data_array1;
   DATA_ARRAY data_array2;
   int str_base_addr;
   int str_free_addr;
   int str_top_addr;
   int count_base_addr;
   int count_free_addr;
   int count_top_addr;
   char buf[332];
   } SPECTRUM_HDR;

#ifdef EG_ENVIR

extern int EGerrno;

#define EGERR 1
#define EG_not_yet_implemented				((EGERR<<16)+1)
#define EG_no_suitable_resource_claimed 		((EGERR<<16)+2)
#define EG_name_or_pattern_too_long 			((EGERR<<16)+3)
#define EG_register_not_known 				((EGERR<<16)+4)
#define EG_experiment_already_connected 		((EGERR<<16)+5)
#define EG_cant_open_experiment_file 			((EGERR<<16)+6)
#define EG_cant_memorymap_experiment_file 		((EGERR<<16)+7)
#define EG_no_experiment_connected 			((EGERR<<16)+8)
#define EG_apparatus_already_attached 			((EGERR<<16)+9)
#define EG_cant_open_apparatus_file 			((EGERR<<16)+10)
#define EG_error_parsing_apparatus_file 		((EGERR<<16)+11)
#define EG_some_resources_still_claimed 		((EGERR<<16)+12)
#define EG_cant_claim_all_resources 			((EGERR<<16)+13)
#define EG_cant_free_all_resources 			((EGERR<<16)+14)
#define EG_apparatus_file_punctuation_expected 		((EGERR<<16)+15)
#define EG_apparatus_file_number_expected 		((EGERR<<16)+16)
#define EG_apparatus_file_string_expected 		((EGERR<<16)+17)
#define EG_apparatus_file_keyword_expected 		((EGERR<<16)+18)
#define EG_apparatus_file_invalid_character 		((EGERR<<16)+19)
#define EG_apparatus_file_premature_EOF 		((EGERR<<16)+20)
#define EG_cant_create_RPC_client 			((EGERR<<16)+21)
#define EG_too_many_resources 				((EGERR<<16)+22)
#define EG_capability_file_already_exists               ((EGERR<<16)+23)
#define EG_cant_open_capability_file                    ((EGERR<<16)+24)
#define EG_cant_initialise_capability_file              ((EGERR<<16)+25)
#define EG_cant_access_experiment_directory             ((EGERR<<16)+26)
#define EG_cant_delete_capability_file                  ((EGERR<<16)+27)
#define EG_max_errno 27

#define ERSERR 2
#define ERS_resource_not_known                          ((ERSERR<<16)+1)
#define ERS_resource_already_in_use                     ((ERSERR<<16)+2)
#define ERS_capability_invalid                          ((ERSERR<<16)+3)
#define ERS_register_not_known                          ((ERSERR<<16)+4)
#define ERS_types_incompatible                          ((ERSERR<<16)+5)
#define ERS_register_already_defined                    ((ERSERR<<16)+6)
#define ERS_class_not_known                             ((ERSERR<<16)+7)
#define ERS_application_not_responding                  ((ERSERR<<16)+8)
#define ERS_invalid_cookie                              ((ERSERR<<16)+9)
#define ERS_application_detected_failure                ((ERSERR<<16)+10)
#define ERS_illegal_register_name                       ((ERSERR<<16)+11)
#define ERS_out_of_memory                               ((ERSERR<<16)+12)
#define ERS_count_too_small                             ((ERSERR<<16)+13)
#define ERS_bad_request                                 ((ERSERR<<16)+14)
#define ERS_invalid_file_name                           ((ERSERR<<16)+15)

#define ESSERR 3
#define ESSERRNO    	        	                ((ESSERR<<16)+(unsigned short)(errno))
#define ESS_cannot_locate_spectrum                      ((ESSERR<<16)+1)

#define ETSERR 4
#define ETSERRNO    	        	                ((ETSERR<<16)+(unsigned short)(errno))



#if NeedFunctionPrototype

extern int EGsetRegisterPath (char *name);
extern int EGinquireRegisters (char* pattern, char *buf);
extern int EGinquireRegistersMore (char *buf);
extern int EGreadRegister (char *name, char *value);
extern int EGwriteRegister (char *name, char *value);
extern int EGinitialiseRegister (char *name);
extern int EGreadRegisters (char* pattern, char *namebuf, char *valuebuf);
extern int EGreadRegistersMore (char *namebuf, char *valuebuf);
extern int EGwriteRegisters (char *pattern, char *value);
extern int EGinitialiseRegisters (char *pattern);
extern int EGcreateRegister (char *name, char *rclass);
extern int EGdestroyRegister (char *name);
extern int EGdestroyRegisters (char *pattern);
extern int EGgetObject (char *name, char *attributes);
extern int EGsetObject (char *name, char *attributes);
extern int EGgetObjects (char* pattern, char *namebuf, char *attributesbuf);
extern int EGgetObjectsMore (char *namebuf, char *attributesbuf);
extern int EGsetObjects (char *pattern, char *attributes);
extern int EGsetExperimentPath (char *name);
extern int EGcreateExperiment (char *name);
extern int EGdeleteExperiment (char *name);
extern int EGconnectExperiment (char *name);
extern int EGdisconnectExperiment ();
extern int EGsetApparatusPath (char *name);
extern int EGattachApparatus (char *name);
extern int EGdetachApparatus (char *name);
extern int EGclaimApparatus (char *name);
extern int EGfreeApparatus (char *name);
extern int EGdisplayResources (FILE *fp);
extern char *EGerrorMessage (int num);
extern int EGauthorise (char *user, char *password);
extern int EGsetSpectrumPath (char *name);
extern int EGsetDefaultArray (int number);
extern int EGcreate1dSpectrum (char *name, int base, int range, int layout, int type);
extern int EGcreate2dSpectrum (char *name, int base1, int range1, 
                                           int base2, int range2, int layout, int type);
extern int EGcreateSpectrum (char *name, int dimension, 
                                           int *base, int *range, int layout, int type);
extern int EGdeleteSpectrum (char *name);
extern int EGzeroSpectrum (char *name);
extern int EGreadInformation (char *name, int number, char *buf);
extern int EGwriteInformation (char *name, int number, char *buf);
extern int EGreadAnnotation (char *name, int number, char *buf);
extern int EGwriteAnnotation (char *name, int number, char *buf);
extern int EGreadCalibration (char *name, int number, char *buf);
extern int EGwriteCalibration (char *name, int number, char *buf);
extern int EGreadEfficiency (char *name, int number, char *buf);
extern int EGwriteEfficiency (char *name, int number, char *buf);
extern int EGinquireSpectrum (char *name, int *dim, 
                              int *bases, int *ranges, int *layouts, int *types);
extern int EGsetSpectrumArray (char *name, int number, int layout, int type);
extern int EGinquireAddress (char *name, int *address);
extern int EGsetDefaultCompression (int *ranges);
extern int EGinquireDirectory (char* name, char *buf);
extern int EGinquireDirectoryMore (char *buf);
extern int EGread1dSpectrum (char *name, int base, int range, int *array, int type);
extern int EGwrite1dSpectrum (char *name, int base, int range, int *array, int type);
extern int EGread2dSpectrum (char *name, int base1, int range1, 
                             int base2, int range2, int *array, int type);
extern int EGwrite2dSpectrum (char *name, int base1, int range1, int base2, 
                              int range2, int *array, int type);
extern int EGreadSpectrum (char *name, int dimension, 
                             int *base, int *range, int *array, int type);
extern int EGwriteSpectrum (char *name, int dimension,
                             int *base, int *range, int *array, int type);
extern int EGspectrumErrorReport (char *name, char *report);
extern int EGTSsetPath (char *name);
extern int EGTSclaimDrive (char *name, char *requested, char *allocated);
extern int EGTSfreeDrive (char *name);
extern int EGTSmountVolume (char *name, char *volume);
extern int EGTSdismountVolume (char *name);
extern int EGTSinquireFileStatus (char *name, int *lstatus, int *sstate,
				  char *info, char *device, char *rdevice,
				  char *vname, char *fname, int *mode,
				  int *ltype, int *rlen, int *blen, int *dlen,
				  int *magic, int *magicwr, int *magicrd,
				  int *blkCnt, int *bytCnt, int *rate);
extern int EGTSopenFile (char *name, int mode, int ltype, int rlen, int blen,
			 char *fname);
extern int EGTScloseFile (char *name);
extern int EGTSsetState (char *name, long state);
extern int EGTSgetState (char *name, long *state);
extern int EGTSsetStream (char *name, int stream, int mode, int len,
			  char **ids);
extern int EGTSgetStream (char *name, int stream, int *mode, int *len,
			  char **ids);
extern int EGTSinquireStreamState (char *name, int stream,  int *state,
				   int *blkCnt, int *bytCnt, int *rate);
extern int EGTSinquireDriveStatus(char *name, char *type, int *length,
				  int *written, int *remain, int *errors,
				  int *infolen, char *info);
extern int EGTSidentifyVolume(char *name);
extern int EGTSresetDrive(char *name);
extern int EGTSinitialiseVolume(char *name, char *volume, int labelling,
				int density, char *oldvolume);
extern int EGTSinquireDrives (char *name, int *len, int *statuses,
			      char **realnames, char **typenames);
extern int EGTSmoveTape(char *name, int source, int dest);
extern int EGTSpositionChanger(char *name, int dest);
extern int EGTSinquireElementStatus(char *name, int location, int *state, int *full, int *source);

#else

extern int EGsetRegisterPath ();
extern int EGinquireRegisters ();
extern int EGinquireRegistersMore ();
extern int EGreadRegister ();
extern int EGwriteRegister ();
extern int EGinitialiseRegister ();
extern int EGreadRegisters ();
extern int EGreadRegistersMore ();
extern int EGwriteRegisters ();
extern int EGinitialiseRegisters ();
extern int EGcreateRegister ();
extern int EGdestroyRegister ();
extern int EGdestroyRegisters ();
extern int EGgetObject ();
extern int EGsetObject ();
extern int EGgetObjects ();
extern int EGgetObjectsMore ();
extern int EGsetObjects ();
extern int EGsetExperimentPath ();
extern int EGcreateExperiment ();
extern int EGdeleteExperiment ();
extern int EGconnectExperiment ();
extern int EGdisconnectExperiment ();
extern int EGsetApparatusPath ();
extern int EGattachApparatus ();
extern int EGdetachApparatus ();
extern int EGclaimApparatus ();
extern int EGfreeApparatus ();
extern int EGdisplayResources ();
extern char *EGerrorMessage ();
extern int EGauthorise ();
extern int EGsetSpectrumPath ();
extern int EGsetDefaultArray ();
extern int EGcreate1dSpectrum ();
extern int EGcreate2dSpectrum ();
extern int EGcreateSpectrum ();
extern int EGdeleteSpectrum ();
extern int EGzeroSpectrum ();
extern int EGreadInformation ();
extern int EGwriteInformation ();
extern int EGreadAnnotation ();
extern int EGwriteAnnotation ();
extern int EGreadCalibration ();
extern int EGwriteCalibration ();
extern int EGreadEfficiency ();
extern int EGwriteEfficiency ();
extern int EGinquireSpectrum ();
extern int EGsetSpectrumArray ();
extern int EGinquireAddress ();
extern int EGsetDefaultCompression ();
extern int EGinquireDirectory ();
extern int EGinquireDirectoryMore ();
extern int EGread1dSpectrum ();
extern int EGwrite1dSpectrum ();
extern int EGread2dSpectrum ();
extern int EGwrite2dSpectrum ();
extern int EGreadSpectrum ();
extern int EGwriteSpectrum ();
extern int EGTSclaimDrive ();
extern int EGTSfreeDrive ();
extern int EGTSmountVolume ();
extern int EGTSdismountVolume ();
extern int EGTSinquireFileStatus ();
extern int EGTSopenFile ();
extern int EGTScloseFile ();
extern int EGTSsetState ();
extern int EGTSgetState ();
extern int EGTSsetStream ();
extern int EGTSgetStream ();
extern int EGTSinquireStreamState ();
extern int EGTSinquireDriveStatus();
extern int EGTSidentifyVolume();
extern int EGTSresetDrive();
extern int EGTSinitialiseVolume();
extern int EGTSinquireDrives ();
extern int EGTSmoveTape();
extern int EGTSpositionChanger();
extern int EGTSinquireElementStatus();

#endif /* NeedFunctionPrototypes ifdef EG_ENVIR*/

#else

#if NeedFunctionPrototype

extern int SMEGinquireSpectrum (char *name, int *dim, 
                              int *bases, int *ranges, int *layouts, int *types);
extern int SMEGcreate1dSpectrum (char *name, int base, int range, int layout, int type);
extern int SMEGcreate2dSpectrum (char *name, int base1, int range1, 
                                           int base2, int range2, int layout, int type);
extern int SMEGread1dSpectrum (char *name, int base, int range, int *array, int type);
extern int SMEGwrite1dSpectrum (char *name, int base, int range, int *array, int type);
extern int SMEGread2dSpectrum (char *name, int base1, int range1, 
                             int base2, int range2, int *array, int type);
extern int SMEGwrite2dSpectrum (char *name, int base1, int range1, int base2, 
                              int range2, int *array, int type);

#else

extern int SMEGinquireSpectrum ();
extern int SMEGcreate1dSpectrum ();
extern int SMEGcreate2dSpectrum ();
extern int SMEGread1dSpectrum ();
extern int SMEGwrite1dSpectrum ();
extern int SMEGread2dSpectrum ();
extern int SMEGwrite2dSpectrum ();

#endif /* NeedFunctionPrototypes ifndef EG_ENVIR*/

#endif /* EG_ENVIR */

#endif /* ! EG_h */



