/* monDrv.h - Monitoring data driver definitions */

/*
 * Copyright 1991,1992 Universite Catholique de Louvain
 *
 * $Id: monDrv.h,v 1.2.1.2 1995/12/07 09:37:05 nina Exp $
 *
 * $Log: monDrv.h,v $
 * Revision 1.2.1.2  1995/12/07  09:37:05  nina
 * Added !unix cpp directives.
 *
 * Revision 1.2.1.1  1993/07/23  07:14:48  nina
 * Added a stopOnClose flag.  When such a channel exits, it (should) stop
 * automatically the acquisition.  NOT YET WORKING !!
 *
 * Revision 1.2  1993/03/18  17:07:43  nina
 * Changed definitions of O_MONDEV_...so the default (0) is O_MONDEV_PRECIOUS.
 * Removed everything related to monServer which is now useless.
 *
 * Revision 1.1  1992/07/28  09:50:21  nina
 * From monDrv.h(03b,14oct91,an) and acqRpc.h(02h,20aug91,mn)
 * written 01a,06mar91,an
 *
 */

#ifndef INCmonDrvh
#define INCmonDrvh

/******************************************************************************/
/*                                                                            */
/* Monitoring device software configuration                                   */
/*                                                                            */
/* MON_CHANNELS_NUM must be <= sizeof(acqDev.dataConsumer) = sizeof(ULONG)    */
/*                                                                            */
/******************************************************************************/

#define     MON_DEVICE_NAME     "/dev/mon"
#define     MON_CHANNELS_NUM            32  /* Number of monitoring channels */
#define     MON_ACCESS_TIMEOUT           5  /* In seconds */

/* mon device ioctl functions */

#define     MONIO_GET_BUF_SIZE  0x01

/* Monitoring device open modes */

#define O_MONDEV_PRECIOUS   0x00
#define O_MONDEV_SAMPLE     0x02
#define O_MONDEV_NDELAY     0x04
#define O_MONDEV_STOP_ONCL  0x08

/* We don't need these */
#if 0

/* monDrv STATUS codes */

#include    "../h/localModNum.h"

#define S_monDrv_NO_DRIVER          (M_monDrv   |  1)
#define S_monDrv_BAD_DEV_NAME       (M_monDrv   |  2)
#define S_monDrv_ACCESS_TIMEOUT     (M_monDrv   |  3)
#define S_monDrv_NO_SUCH_FCT        (M_monDrv   |  5)
#define S_monDrv_ALREADY_CREATED    (M_monDrv   |  6)
#define S_monDrv_NO_MEMORY          (M_monDrv   | 12)
#define S_monDrv_NO_CHANNELS        (M_monDrv   | 13)
#define S_monDrv_NO_SUCH_CHANNEL    (M_monDrv   | 14)
#define S_monDrv_NO_SEMAPHORE       (M_monDrv   | 15)
#define S_monDrv_INVALID_ARGUMENT   (M_monDrv   | 16)
#define S_monDrv_WOULD_BLOCK        (M_monDrv   | 17)

#endif

/* Monitoring channel description */

#ifndef unix
typedef struct monChannel
        {   
            /* Channel number */

            int channel;

            /* Father device pointer */

            struct monShDev *pMonShDev;        /* To early to use MON_DEV ! */

            /* Semaphore to protect channel data */

            SEM_ID sem;

            /* Precious flag. - set if channel must monitor *all* data */

            BOOL precious;
            BOOL stopOnClose;

            /* Can't block flag - set if read must returns with a  */
            /* S_monDrv_WOULD_BLOCK error if no data are available */

            BOOL cannotBlock;

        } MON_CHANNEL;

/* Device shared description */

typedef struct monShDev
        {
            MP_SEM  sem;    /* Multiprocessor semaphore to protect device */

            MON_CHANNEL *pChannel[MON_CHANNELS_NUM];    /* Mon. channels */

            int nextChannel;        /* Next available channel */

        } MON_SH_DEV;

/* Device private description */

typedef struct monDev
        {
            DEV_HDR devHdr;         /* Basic device structure */

            MON_SH_DEV *pMonShDev;  /* Shared monitoring device structure */

        } MON_DEV;
#endif /* !unix */

#endif /* INCmonDrvh */
