/* r_dev.h - Generic distributed device i/o */

/*
 * Copyright 1993 Universite Catholique de Louvain
 *
 * TODO
 *  R_FD should be a pointer rather than a structure !
 *
 * $Id: r_dev.h,v 1.8 1995/11/21 10:20:13 nina Exp $
 *
 * $Log: r_dev.h,v $
 * Revision 1.8  1995/11/21  10:20:13  nina
 * Changed cpp directive c_plusplus by __cplusplus.  Added decl. of r_exec().
 *
 * Revision 1.7  1994/06/20  09:48:05  demon
 * Added declarations of r_read() and r_tie().
 *
 * Revision 1.6  1994/01/17  11:22:19  nina
 * Added definitions for c++.  Added defs for r_error() and r_errlnk().
 *
 * Revision 1.5  1993/11/04  08:58:23  nina
 * Include the rpc/rpc.h if and only if it has not been included elsewhere.
 *
 * Revision 1.4  1993/05/11  06:05:46  nina
 * Added RPC_RUN with the rpc_run structure and the xdr_run function.
 *
 * Revision 1.3  1993/04/09  11:25:14  nina
 * RPC_DEV_OPEN now carries the flags to open a file.  The file name and
 * the flags are encapsulated into a xdr_file structure.
 *
 * Revision 1.2  1993/04/08  06:55:04  nina
 * Added RPC_CD, RPC_PWD and RPC_LOAD_MODULE.  Added a rpc_directory
 * structure and relayed xdr declaration.
 *
 * Revision 1.1  1993/04/05  14:02:12  nina
 * Initial revision
 *
 */

#ifndef __device_h__
#define __device_h__

/*
 * Client program definitions
 *
 * R_FD is the distributed version of the file descriptor
 * Note:
 * By convention, if _fd is NULL, there is no (remote) device associated to
 * the R_FD.  In this case, only the _cl member is meaningful. The advantage
 * of such a scheme is that the r_open() and r_close() routines are
 * advantageous replacements of clnttcp_create and clnt_destroy.
 */

#if !defined(__RPC_H) && !defined(INCrpch) && !defined(RPC_TYPES_INCLUDED)\
      && !defined(_rpc_rpc_h) && !defined(_RPC_RPC_H)
#include    <rpc/rpc.h>
#endif

typedef struct devFd
    {   int _fd;            /* The remote file descriptor                 */
        int _sck;           /* Socket for TCP/IP data transfer (tie mode) */
        CLIENT* _cl;        /* RPC Client to the server                   */
    } R_FD;

#define FD(x)   x._fd
#define CL(x)   x._cl
#define SCK(x)  x._sck

/* declarations of standard i/o calls */

#ifdef __cplusplus
extern "C"  {   int r_close(R_FD);
                int r_ioctl(R_FD,int,void*,xdrproc_t);
                R_FD r_open(const char*,int ...);
                int r_errlnk();
                const char *r_error(R_FD);
				int r_tie(R_FD*,int);
				int r_read(R_FD,char*,int);
            }
#else
extern R_FD r_open();
extern int r_close();
extern int r_ioctl();
extern int r_read();
extern int r_write();
extern int r_tie();
extern char *r_error();
extern int r_exec();

extern R_FD R_FD_ERROR;     /* = {-1,0,NULL} */
extern R_FD R_FD_NULL;      /* = { 0,0,NULL} */
#endif

/*
 * Server program definitions
 *
 * RPC program and procedures numbers
 */

#define DEV_SERVER_PROG 0x26900090L
#define DEV_SERVER_VERS 0x00000001L

#define RPC_DEV_OPEN     0x01
#define RPC_DEV_CLOSE    0x02
#define RPC_DEV_IOCTL    0x03
#define RPC_DEV_READ     0x04
#define RPC_DEV_WRITE    0x05
#define RPC_DEV_TIE      0x06

#define RPC_CD           0x80
#define RPC_PWD          0x81
#define RPC_LOAD_MODULE  0x82
#define RPC_RUN          0x83

/* RPC structures */

struct rpc_open             /*   Valid when ...  */
    {   int errno;          /* client <-  server */
        int fd;             /*        <-         */
    };

struct rpc_close            /* client <-  server */
    {   int errno;
    };

struct rpc_ioctl
    {   int errno;          /* client <-  server */
        int fd;             /*         ->        */
        int request;        /*        <->        */
        char *argp;         /*        <->        */
        xdrproc_t proc;     /* Client usage only */
    };

struct rpc_read
    {   int errno;          /* client <-  server */
        int fd;             /*         ->        */
        int size;           /*        <->        */
        char *argp;         /*        <-         */
    };

struct rpc_tie
    {   int errno;
        int fd;
        int size;
        int port;
        int tid;
    };

struct rpc_file             /*   Valid when ...  */
    {   char *path;         /* client  -> server */
        int flags;          /* client  -> server */
    };

struct rpc_directory
    {   int errno;          /* client <-  server */
        char *dir;          /*        <->        */
    };

struct rpc_run
    {   int errno;          /* client <-  server */
        int tid;            /*        <-         */ 
    };

/* RPC xdr functions */

extern int xdr_open();
extern int xdr_close();
extern int xdr_ioctl_request();
extern int xdr_ioctl_reply();
extern int xdr_read_request();
extern int xdr_read_reply();
extern int xdr_tie_request();
extern int xdr_tie_reply();

extern int xdr_file();
extern int xdr_directory();
extern int xdr_run();

/* We don't need these */

#if 0

/* RPC status codes */

#include    "../h/localModNum.h"

#define S_devServer_NO_UDP_CREATE       (M_devServer | 1)
#define S_devServer_NO_TCP_CREATE       (M_devServer | 2)
#define S_devServer_NO_UDP_REGISTER     (M_devServer | 3)
#define S_devServer_NO_TCP_REGISTER     (M_devServer | 4)
#define S_devServer_SVC_RETURNS         (M_devServer | 5)
#define S_devServer_INVALID_ARGUMENT    (M_devServer | 6)
#define S_devServer_HASH_COLLISION      (M_devServer | 7)

#endif

#endif /* __device_h__ */
