#ifndef SUNSORT_EXTERN_h
#define SUNSORT_EXTERN_h

#ifdef SVR4
#include <unistd.h> 
#define NeedFunctionPrototype 1
#else
#define NeedFunctionPrototype 0
#endif

#include "sort_thread.h"

#ifdef SUNSORT_MAIN

/* I/O streams */
int FDIN  = STDIN_FILENO;        /* user command input stream (connected to gui) */
int FDOUT = STDOUT_FILENO;       /* user command output stream (connected to gui) */
int FDDAT = STDOUT_FILENO;       /* batch data output stream (if !batch_mode connected to gui) */
int FDBAT = STDIN_FILENO;        /* batch command input stream */
int FDSIN  = STDIN_FILENO;       /* Input stream from sort process */
int FDSOUT = STDOUT_FILENO;      /* Output stream from sort process */

int poll_period = POLL_PERIOD;

/* graphics process information */
int                             sort_proc_OK = SORT_FALSE;
int				graf_proc1_OK = SORT_FALSE;
int				graf_proc2_OK = SORT_FALSE;
int				nogui  = SORT_FALSE;
int				nograf = SORT_FALSE;

#if NeedFunctionPrototype
pid_t				sort_pid;
pid_t				graf_1d_pid;
pid_t				graf_2d_pid;
pid_t				gui_pid;
#else
int                             sort_pid;
int				graf_1d_pid;
int				graf_2d_pid;
int				gui_pid;
#endif

/* other status information */
int                             refresh_time = REFRESH_OFF;
int                             batch_mode = SORT_FALSE;
char                            *tmp_spectrum_dir = NULL;
char                            *sunsort_proc = NULL;
int				DBX_val = 0;
/* ----------------------------------------------------------------
   DBX_val >= 1  ... server partial
   DBX_val >= 2  ... gui    partial
   DBX_val >= 3  ... sort   partial
   DBX_val >= 4
   DBX_val >= 5  ... server full
   DBX_val >= 6  ... gui    full
   DBX_val >= 7  ... sort   full
   DBX_val >= 8
   DBX_val >= 9
   DBX_val >= 10 ... very detailed debug level
   ----------------------------------------------------------------- */


#endif  /* SUNSORT_MAIN */

/* graphics process data */
extern int                              sort_proc_OK;
extern int				graf_proc1_OK;
extern int				graf_proc2_OK;
extern int				nogui;
extern int				nograf;

#if NeedFunctionPrototype
extern pid_t				sort_pid;
extern pid_t				graf_1d_pid;
extern pid_t				graf_2d_pid;
extern pid_t				gui_pid;
#else
extern int 				sort_pid;
extern int				graf_1d_pid;
extern int				graf_2d_pid;
extern int 				gui_pid;
#endif
 
/* other status information */
extern int                              refresh_time;
extern char                             *tmp_spectrum_dir;
extern char                             *sunsort_proc;
extern int                              batch_mode;
extern int		                DBX_val;

/* routines in read_spec.c */
#if NeedFunctionPrototype
extern int 		read_spectra_file(char *spectra_file);
extern spec_1d_t	**get_nametab_1d(void);
extern spec_2d_t	**get_nametab_2d(void);
extern var_str_t	**get_nametab_var(void);
extern int		load_spectrum_file(char *dir_name, char	*file_name, int IO_state);
extern void		clear_1d(spec_1d_t *ptr);
extern void		clear_2d(spec_2d_t *ptr);
extern int              msync_1d(spec_1d_t *ptr, int flags);
extern int              msync_2d(spec_2d_t *ptr, int flags);
#else
extern int 		read_spectra_file();
extern spec_1d_t	**get_nametab_1d();
extern spec_2d_t	**get_nametab_2d();
extern var_str_t	**get_nametab_var();
extern int		load_spectrum_file();
extern void		clear_1d();
extern void		clear_2d();
extern int              msync_1d();
extern int              msync_2d();
#endif

/* routines in discsubs.c */
#if NeedFunctionPrototype
extern int      Save_all(dirs_IO_t *ptr);
extern int      Save_windows(dirs_IO_t *ptr);
extern int      Save_variables(dirs_IO_t *ptr);
extern int      Save_selected(dirs_IO_t *ptr);
extern int      Save_selected_1d(dirs_IO_t *ptr, char *buf);
extern int      Save_selected_2d(dirs_IO_t *ptr, char *buf);
extern int 	Save_1d(spec_1d_t *ptr_1d, char *save_dir, int mode, int type);
extern int 	Save_2d(spec_2d_t *ptr_2d, char *save_dir, int mode, int type);
extern int	inquire(char *file_name);
extern void     swap2d_c2f(int *fort, int *c, int sizex, int sizey);
extern void     swap2d_f2c(int *fort, int *c, int sizex, int sizey);
#else
extern int      Save_all();
extern int      Save_windows();
extern int      Save_variables();
extern int      Save_selected();
extern int      Save_selected_1d();
extern int      Save_selected_2d();
extern int 	Save_1d();
extern int 	Save_2d();
extern void     swap2d_c2f();
extern void     swap2d_f2c();
extern int	inquire();
#endif


/* routines orginally declared in the beginning of sort_main.c */
#if NeedFunctionPrototype
      extern void     read_args( int argc, char** argv);
      extern void     main_event_loop( void);
      extern int      decode_command( char *command_str, char *reply_str);
      extern int      start_gui(char *process, int argc, char **argv);
      extern void     start_graphics(int argc, char **argv);
      extern void     sigusr2_handler(int signal);
      extern void     sigwin2d_handler(int signal);
      extern void     setup_intervaltimer(int bool);
      extern int      setup_sighandlers(void);
      extern char     *make_tmp_dir(void);
#else
      extern void     read_args();
      extern void     main_event_loop();
      extern int      decode_command();
      extern int      start_gui();
      extern void     start_graphics();
      extern void     sigusr2_handler();
      extern void     sigwin2d_handler();
      extern void     setup_intervaltimer();
      extern int      setup_sighandlers();
      extern char     *make_tmp_dir();
#endif

/* general utility routines */
#if NeedFunctionPrototype
extern char 			*rm_leading_blanks(char *string, int length);
extern void                     check_writetape_onexit(void);
extern int                      check_input(void);
extern int                      read_input(int fd, char *ipbuf);
extern void                     check_children(void);
extern void                     write_reply(int status, char *reply, int input_fd);
extern void                     write_to_sortproc(char *message);
#else
extern char 			*rm_leading_blanks();
extern void                     check_writetape_onexit();
extern int                      check_input();
extern int                      read_input();
extern void                     check_children();
extern void                     write_reply();
extern void                     write_to_sortproc();
#endif

/* routines in sdb.c */
#if NeedFunctionPrototype
extern int             sname(int *id, char * name, int namelen);
extern int             sdef(int *id, int xbase, int xrange, int ybase, int yrange,
			    int precision, char *name, int namelen);
extern int             sread(int id, int xbase, int xrange, int ybase, int yrange,
			     int *array, int precision);
extern int             swrit(int id, int xbase, int xrange, int ybase, int yrange,
			     int *array, int precision);
extern int             sinq(int id, int *xbase, int *xrange, int *ybase,
			    int *yrange, int *precision);
#else
extern int sname();
extern int sdef();
extern int sread();
extern int swrit();
extern int sinq();
#endif

/* routines in eg.c */
#if NeedFunctionPrototype
extern void    eexpt(int *ierr);
extern int     ename(int *id, char * name, int namelen);
extern int     edef(int *id, int xbase, int xrange, int ybase, int yrange,
			    int precision, char *name, int namelen);
extern int     eread(int id, int xbase, int xrange, int ybase, int yrange,
			     int *array, int precision);
extern int     ewrit(int id, int xbase, int xrange, int ybase, int yrange,
			     int *array, int precision);
extern int     einq(int id, int *xbase, int *xrange, int *ybase,
			    int *yrange, int *precision);
extern int     *map_spectrum(int spec_dim, char *name, int nos, int range);
extern int     unmap_spectrum(int *data_base, int elements);
#else
extern void eexpt();
extern int ename();
extern int edef();
extern int eread();
extern int ewrit();
extern int einq();
extern int *map_spectrum();
extern int     unmap_spectrum();
#endif

/* routines defined in sort_comms.c */
#if NeedFunctionPrototype
extern int open_sort_file( char *opt_string, char *reply);
extern int close_sort_file( char *opt_string, char *reply);
extern int open_filt_file( char *opt_string, char *reply);
extern int close_filt_file( char *opt_string, char *reply);
extern int sort_data( char *opt_string, char *reply);
extern int tapemount( char *opt_string, char *reply);
extern int tapemove( char *opt_string, char *reply);
extern int tapeumount( char *opt_string, char *reply);
extern int eject_func( char *opt_string, char *reply);
extern int save_spectra( char *opt_string, char *reply);
extern int load_spectra( char *opt_string, char *reply);
extern int display_1d( char *opt_string, char *reply);
extern int overlay_1d( char *opt_string, char *reply);
extern int display_2d( char *opt_string, char *reply);
extern int clear_spectra( char *opt_string, char *reply);
extern int setwindow( char *opt_string, char *reply);
extern int showwindow( char *opt_string, char *reply);
extern int viewwindow( char *opt_string, char *reply);
extern int change_var( char *opt_string, char *reply);
extern int print_vars( char *opt_string, char *reply);
extern int reset_command( char *opt_string, char *reply);
extern int batch_read( char *opt_string, char *reply);
extern int exit_sunsort( char *opt_string, char *reply);
extern int end_batch( char *opt_string, char *reply);
extern int comment_line( char *opt_string, char *reply);
extern int help_func( char *opt_string, char *reply);
extern int status_func( char *opt_string, char *reply);
extern int sleep_func( char *opt_string, char *reply);
extern int refresh_func( char *opt_string, char *reply);
extern int newWtape( char *opt_string, char *reply);
extern int loadsort( char *opt_string, char *reply);
extern int loadspec( char *opt_string, char *reply);
extern int makesort( char *opt_string, char *reply);
extern int killsort( char *opt_string, char *reply);
extern int debugsort( char *opt_string, char *reply);
extern int editsort( char *opt_string, char *reply);
extern int set_sortenv( char *opt_string, char *reply);
extern int print_sortenv( char *opt_string, char *reply);
extern int set_format(const char *opt_string);
extern int update_gui( char *opt_string, char *reply);
#else
extern int open_sort_file();
extern int close_sort_file();
extern int open_filt_file();
extern int close_filt_file();
extern int sort_data();
extern int tapemount();
extern int tapemove();
extern int tapeumount();
extern int eject_func();
extern int save_spectra();
extern int load_spectra();
extern int display_1d();
extern int overlay_1d();
extern int display_2d();
extern int clear_spectra();
extern int setwindow();
extern int showwindow();
extern int viewwindow();
extern int change_var();
extern int print_vars();
extern int reset_command();
extern int batch_read();
extern int exit_sunsort();
extern int end_batch();
extern int comment_line();
extern int help_func();
extern int status_func();
extern int sleep_func();
extern int refresh_func();
extern int newWtape();
extern int loadsort();
extern int loadspec();
extern int makesort();
extern int killsort();
extern int debugsort();
extern int editsort();
extern int set_sortenv();
extern int print_sortenv();
extern int set_format();
extern int update_gui();
#endif

/* routines defined in sort_thread.c */
#if NeedFunctionPrototype
extern int Stop_interupt(int, ...);
extern int Sorting_data(int, ...);
#else
extern int Stop_interupt();
extern int Sorting_data();
#endif


#endif   /* endif ! SUNSORT_EXTERN_h */
