/* version for systems without ipcs ...use named pipe (FIFO file) */
/*
 * prev modified 1/9/93
 * prev modified 31/11/93
 * last modified 14/3/94
 */
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>

#ifdef SVR4
#define NeedFunctionPrototype 1
#include <unistd.h>
#include <sys/uio.h>
#else
#define NeedFunctionPrototype 0
#endif

#include "sort_mem.h"
extern int DBX_val;

static struct sm_data_buf	sm_data;
struct sm_data_buf		*pshm = &sm_data;

int
write_to_pipe(
#if NeedFunctionPrototype
	      char      *filename,
	      int	size)
#else
      filename, size)
      char      *filename; 
      int	size;
#endif
{
	char	*ptr = (char *)pshm;
	int 	header_len = sizeof(struct sm_data_buf) - sizeof(int)*SHM_ARRAY_SIZE;
	FILE    *wfp;
	int     ipc_fd;

	if ( (wfp = fopen(filename,"w")) == NULL) {
	      fprintf(stderr,"write_to_pipe: failed to open %s\n",filename);
	      return(SORT_FAIL);
	}
	ipc_fd = fileno(wfp);
	
/* write spectrum data header */
	if ( write(ipc_fd,ptr,header_len) != header_len) {
		fprintf(stderr,"write_to_pipe: Error detected during write #header\n");
		return(SORT_FAIL);
	}
/* advance pointer to begining of spectrum data */
	ptr += header_len;

/* write out spectrum data */
	if ( write(ipc_fd,ptr,sizeof(int)*size) != sizeof(int)*size) {
		fprintf(stderr,"write_to_pipe: Error detected during write #spectrum\n");
		return(SORT_FAIL);
	}

	(void) fclose(wfp);
/* diagnostic to check what data I think is being sent*/	
	if (DBX_val >= 10) {
	      int i;
	      if ( (wfp = fopen("SORT_dump","w")) == NULL) {
		    fprintf(stderr,"write_to_pipe: failed to open SORT_dump\n");
		    return(SORT_FAIL);
	      }
	      fprintf(wfp,"com string = %s\n name = %s\n",pshm->com_str,pshm->name);
	      fprintf(wfp,"size = %d, win2d = %d\n",pshm->size,pshm->win2d);
	      for (i=0; i<pshm->size; i+=5) {
		    fprintf(wfp,"%d: %d %d %d %d %d\n",i,pshm->array[i],pshm->array[i+1],
			    pshm->array[i+2],pshm->array[i+3],pshm->array[i+4]);
	      }
	      (void) fclose(wfp);
	}
	      
	return(0);
}

int
read_from_pipe(
#if NeedFunctionPrototype
char *filename)
#else
     filename)
     char  *filename;
#endif
{
    int	size;
    int	bytes;
    char	command[NAME_SIZE];
    int	spec_type;
    char	*ptr = (char *)pshm;
    int 	header_len = sizeof(struct sm_data_buf) - sizeof(int)*SHM_ARRAY_SIZE;
    FILE    *rfp;
    int     ipc_fd;
    
    if ( (rfp = fopen(filename,"r")) == NULL) {
	fprintf(stderr,"write_to_pipe: failed to open %s\n",filename);
	return(SORT_FAIL);
    }
    ipc_fd = fileno(rfp);
    
    /* read spectrum data header */
    size = header_len;
    while (size > 0) {
	if ( (bytes = (int) read(ipc_fd,ptr,size)) <= 0) {
	    fprintf(stderr,"read_from_pipe: Error detected during read #header\n");
	    return(SORT_FAIL);
	}
	size -= bytes;
	ptr += bytes;
    }
    if ( size < 0 ) {
	fprintf(stderr,"read_from_pipe: Error during read of #header ... too many bytes read\n");
	return(SORT_FAIL);
    }
    
    /* parse data from command string in stack */
    (void) sscanf(pshm->com_str,"%s %d",command,&spec_type);
    
    /* use header to determine size of spectrum */
    size = sizeof(int) * pshm->size * ( (spec_type != 1)  ? pshm->size : 1);
    
    /* read spectrum data */
    while (size > 0) {
	if ( (bytes = (int) read(ipc_fd,ptr, (size > PIPE_BUF) ? PIPE_BUF : size)) <= 0) {
	    if (bytes == 0)
	    {
		fprintf(stderr, "read_from_pipe: Unexpected end of file with %d bytes to go\n", size);
		return(SORT_FAIL);
	    }
	    if (errno != EINTR)
	    {
		fprintf(stderr,"read_from_pipe: Error detected during read #spectrum\n");
		return(SORT_FAIL);
	    }
	}
	else
	{
	    size -= bytes;
	    ptr += bytes;
	}
    }
    
    (void) fclose(rfp);
    return(0);
}
