/*
 *
 *	sunsort header file for shared memory facility
 *      prev modified 8/8/94
 *      last modified 16/1/95
 *
 */
#ifndef SUNSORT_MEM_h
#define SUNSORT_MEM_h

#include <sys/types.h>
#include "sort_def.h"

#define SHM_ARRAY_SIZE			262144	/* max size of (int) data array in shared memory */

struct sm_data_buf {
	char com_str[NAME_SIZE];
	char name[NAME_SIZE];
	int size;
	int win2d;
	int more;
#ifdef SVR4
	pid_t pid_1d;
	pid_t pid_2d;
#else
	int  pid_1d;
	int  pid_2d;
#endif
	int array[SHM_ARRAY_SIZE];
};

extern struct sm_data_buf 		*pshm;

/* modification to get around absence of ipcs */
#if NeedFunctionPrototype
extern int				write_to_pipe(char *, int);
extern int				read_from_pipe(char *);
#else
extern int				write_to_pipe();
extern int				read_from_pipe();
#endif

#define SHM_ERR				(struct sm_data_buf *)-1

#endif /* ! SUNSORT_MEM_h */
