C
C 
C     *****************************************************************
C
C
C
      SUBROUTINE BUFFIT(SPEC,NCHAN,ICHAN,JCHAN,NPEAK,NBACK,
     >IPKSHAPE,IBKSHAPE,CENTIN,
     >FWHMIN,FWLOIN,WIDTH,WIDLO,IPKSCH,IDIFFWD,ISKEW,IFIXWD,IFIXCN,  
     >LORENTZ,TOTAL,FIT,PEAKS,BKGRD,CENTR,AREA,HEIGHT,
     >FWHM,FWHMLO,GWIDHI,GWIDLO,PKAREA,CENTAIL,TAILEXP,TAIL,
     >BKAREA,BAKFIT,bknorm, CENERR,ARERR,HTERR,FWERR,FWLERR,
     >GWHERR,GWLERR,PKAERR,CTAILERR,TEXPERR,TAILERR,
     >BKAERR,BAKERR,bknerr,CHISQ,
     > fitplot,pkplot,bkplot,dxplot,nplot)
c
c                                        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan),CENTIN(npeak),
     >FWHMIN(npeak),FWLOIN(npeak)
      DIMENSION FIT(nchan),BKGRD(nchan),PEAKS(nchan)
      DIMENSION CENTR(npeak),AREA(npeak),
     >FWHM(npeak),FWHMLO(npeak),BAKFIT(nback)
      DIMENSION HEIGHT(npeak),GWIDHI(npeak),GWIDLO(npeak)
      DIMENSION CENERR(npeak),ARERR(npeak),
     >FWERR(npeak),FWLERR(npeak),BAKERR(nback)
      DIMENSION HTERR(npeak),GWHERR(npeak),GWLERR(npeak)
C
C      NEW FOR VS 3.2  ****************************
C
      DIMENSION PKAREA(npeak),CENTAIL(npeak),
     >TAILEXP(npeak),TAIL(npeak),
     > PKAERR(npeak),CTAILERR(npeak),
     >TEXPERR(npeak),TAILERR(npeak)
C
C     **********************************************
c
c     new for vs 4.1 onwards
c
      dimension fitplot(nplot),pkplot(nplot),bkplot(nplot)
c
c
      PARAMETER ( NCA=150 ,NCA1=NCA+2)
      dimension A(NCA),COVAR(NCA,NCA)
       dimension zp(nca),zb(nca)
c
c     new for vs. 4.0 onwards
      dimension index(nca)              
C 
c      comment cards inserted where array lista is used
c      since buffit's use of lista is superceded by array index    
C
C
C
C
C
  660 FORMAT(8F10.2)
      write(6,'(/''************************************************'')')
      write(6,'( ''*                                              *'')')
      WRITE(6,'( ''*   BUFFIT-Birmingham University Fast FITting  *'')')
      WRITE(6,'( ''*   by N.M.Clarke: vs 4.8 8/6/98             *'')')          
      write(6,'( ''*    Report errors to: nmc@np.ph.bham.ac.uk    *'')')
      write(6,'( ''*                                              *'')')
      write(6,'(''************************************************''/)')
c
c
c      new section for vs 4.0
c
c      peak shapes and background options may be specified
c      by input variable  ipkshape,ibkshape. 
c      when these are nonzero, reconstruct the values
c      of shape controls IDIFFWD,ISKEW,IFIXCN,IFIXWD,LORENTZ
c
       if(ipkshape.ne.0) then
c
c      ipkshape lies in range 1 to 8 for symmetric gaussians
c      ipkshape lies in range 11 to 18 for skew gaussians
c      ipkshape lies in range 21 to 28 for skew+tail gaussians
c       ipkshape lies in range 31 to 38 for lorentzians
c
       iskew=ipkshape/10
        if(iskew.eq.0) then
          iopt=ipkshape-1
        else
          iopt=mod(ipkshape,10*iskew) -1
        endif
c
        lorentz=0
           if ( iskew.gt.2) then
            lorentz=1
            iskew=0
           endif
        ifixwd=iopt/4
        ifixcn=(iopt-4*ifixwd)/2
        idiffwd=(iopt-4*ifixwd-2*ifixcn)


        else
c
c        reconstruct ipkshape from shape controls if ipkshape.eq.0
c
        ipkshape=10*iskew + 30*lorentz +(1+idiffwd+ 2*ifixcn+ 4*ifixwd)
c
c
        endif
c
c        write(6,*)ipkshape,ipksch,iskew,idiffwd,ifixwd,ifixcn,lorentz

c
c
       IF(LORENTZ.NE.0)THEN
      WRITE(6,'('' Peak shape = Lorentzian:''
     >'' Number of peaks [npeak]='',I5)')NPEAK
       ISKEW=0
       ELSE   IF(ISKEW.eq.1) THEN
      WRITE(6,'('' Peak shape = skew Gaussian:''
     > '' Number of peaks [npeak]='',I5)')NPEAK
       else IF(ISKEW.EQ.2) THEN
      WRITE(6,'('' Peak shape = skew Gaussian+exponential tails ''
     > '' Number of peaks [npeak]='',I5)')NPEAK
       ELSE IF(ISKEW.EQ.0) THEN
      WRITE(6,'('' Peak shape = symmetric Gaussian:''
     >'' Number of peaks [npeak]='',I5)')NPEAK
      ENDIF
c
c     set background to polynomial default if ibkshape=0
c
      if(ibkshape.eq.0) ibkshape=1


      if(ibkshape.eq.1) then
      WRITE(6,'('' Background shape = polynomial:''
     >''    No. of coeffs. [nback] ='',I5)')NBACK
       nbkparm=nback
      elseif (ibkshape.eq.2) then
      write(6,'('' Background shape = const+exponentials:''
     >''    No. of coeffs. [nback] ='',I5)')NBACK
       nback=2* ((nback-1)/2 )  +1
       nbkparm=nback
      elseif (ibkshape.eq.3) then
       write(6,'('' Background shape = const+woods-saxons:''
     > ''   No. of coeffs. [nback] ='',i5)')nback
         nback= 3*((nback-1)/3) +1
        nbkparm=nback
       elseif( ibkshape.eq.4) then
       write(6,'('' Background shape = previous [bkgrd] * [bknorm]:''
     > ''  [bknorm ]='',1pe12.4)')bknorm
        nbkparm=1
       write(6,'(''                    - search on [bknorm]'')')
       elseif(ibkshape.eq.5) then
       write(6,'('' Background shape = previous [bkgrd] * [bknorm]:''
     > ''  [bknorm]='',1pe12.4)')bknorm
        nbkparm=0
        if(bknorm.eq.0.0) bknorm=1.0d0
c

      endif
       

      ndata=jchan-ichan+1
      WRITE(6,'('' Start(End) channel [ichan(jchan)]='',I4,
     > ''('',I4,'')''
     > ''   No. channels [ndata]='',i4)')             
     > ICHAN,JCHAN,ndata

c
       IF(IPKSCH.NE.0)WRITE(6,'('' Pre-search on peak centres'')')
       IF(IFIXCN.NE.0) THEN
      WRITE(6,'('' Centres of peaks fixed in search'')')
      write(6,'('' [centin]='',8f8.2)') (centin(j),j=1,npeak)
       ENDIF
      IF(IDIFFWD.EQ.0)THEN
      WRITE(6,'('' Constrained width for all peaks'')')
      if(iskew.eq.0) then
       write(6,'('' [width]='',F8.2)')width
       else
       if(fwhmin(1).eq.0.0) fwhmin(1)=width
        if(fwloin(1).eq.0.0) fwloin(1)=width
       write(6,'('' [fwhmin(1)]='',f8.2,'' [fwloin(1)]='',f8.2)')
     > fwhmin(1),fwloin(1)
       endif
      ELSE
             WRITE(6,'('' Different widths for peaks'')')
       write(6,'('' [fwhmin]='',6f8.2)')(fwhmin(j),j=1,npeak)
       if(iskew.ge.1) then
      write(6,'('' [fwloin]='',6f8.2)')(fwloin(j),j=1,npeak)
       endif

      ENDIF
      
      IF(IFIXWD.NE.0) THEN
      WRITE(6,'('' Width of peaks fixed in search'')')
      ENDIF
c          
C
C
      IF(IPKSCH.NE.0) THEN
      CALL PKSRCH(SPEC,CENTIN,NCHAN,NPEAK,IPKSCH)
      ENDIF
C
C
      DATN=REAL(NDATA)
C
      TOTAL=0.0D0
      DO 1 J=ICHAN,JCHAN
      TOTAL=TOTAL+SPEC(J)
  1   CONTINUE
C
C
C
C
C     BEGIN CALLS TO SETUP SEARCHES
C      **********************************************************
C
c     set step size for plotted arrays fitplot, pkplot,bkplot
c
      if(dxplot.eq.0.0) then
         ndx= nint(8192.0/real(ndata) )
       dxplot =  1.0d0/ real(min ( 10, ndx))
       endif
c
      IF(ipkshape/10.EQ.0) THEN
C
C
c     pack array A for search with peaks and bkgrd parameters
c     for case of symmetric gaussian peak shape with optional
c     background
c
      call pakgauss(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
c
c
c
c    unpack array A to reconstruct the fits to spectrum,
c    peaks and background and extract areas and errors
c
      call unpakgauss(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,	 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     > fitplot,pkplot,bkplot,dxplot,nplot)
c
c
       elseif (ipkshape/10.eq.1) then
C
C
c     pack array A for search with peaks and bkgrd parameters
c     for case of skew gaussian peak shape with optional
c     background
c
      call pakskewg(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,fwloin,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
c
c
c
c    unpack array A to reconstruct the fits to spectrum,
c    peaks and background and extract areas and errors
c
      call unpakskewg(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,	 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     >fitplot,pkplot,bkplot,dxplot,nplot)
c
c
      elseif(ipkshape/10.eq.2) then

c     pack array A for search with peaks and bkgrd parameters
c     for case of skew gaussian shape with exponential tail on
c     low side of peak
c
      call  paktailg(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,fwloin,centail,tailexp,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
C
c    unpack array A to reconstruct the fits to spectrum,
c    peaks and background and extract areas and errors
c
      call unpaktailg(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,	 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > PKAREA,CENTAIL,TAILEXP,TAIL,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     > PKAERR,CTAILERR,
     > TEXPERR,TAILERR,
     > fitplot,pkplot,bkplot,dxplot,nplot)


c
c
       elseif (ipkshape/10.eq.3) then
C
C
c     pack array A for search with peaks and bkgrd parameters
c     for case of lorentzian peak shape with optional
c     background
c
      call paklorz(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
c
c
c
c    unpack array A to reconstruct the fits to spectrum,
c    peaks and background and extract areas and errors
c
      call unpaklorz(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,	 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     > fitplot,pkplot,bkplot,dxplot,nplot)
c


   


      ENDIF
C
  800 CONTINUE
C
C    
      SUMG=0.0D0
      DO 810 J=1,NPEAK
      SUMG=SUMG+AREA(J)
 810  CONTINUE
C
C
      CHECK=1.0D2*( ( SUMG+BKAREA)-TOTAL)/TOTAL
      WRITE(6,'(''   Check=100*(Fit-Total)/Total = '',F7.2,'' %'')')     
     > CHECK
      CHISQF= DATN*CHISQ/(REAL(NDATA-nfit))
      WRITE(6,'(''   Chisq per data point        = '',F10.2)')CHISQ             
      WRITE(6,'(''   Chisq per degree of freedom = '',F10.2/)')CHISQF
      WRITE(6,998)
  998 FORMAT(80('*'))
 1000 CONTINUE
  100 RETURN 
      END
