#define FIT_DIM 30		/* maximum number of peaks */
#define BK_ORDER 8		/* maximum packground order */

#define BACKGROUND_POLY 1
#define BACKGROUND_EXP  2
#define BACKGROUND_WS   3

/*
  All data at this point are in channels. The conversion factors held
  in offset and gradient are purely for the use of sort_xvgr and are
  passed back unused.
*/

typedef struct buffit_in {
    double centin[FIT_DIM];   /* input guesses for centroids */
    double fwhmin[FIT_DIM];   /* fwhm for each peak */
    double fwloin[FIT_DIM];   /* fwhm on low side for skew */
    double width;             /* fwhm of the peaks */
    double widlo;             /* fwhm of low side of the peaks */
    double dxplot;	      /* step size to use for fitted plot */
    double offset;	      /* offset to convert channels to units */
    double gradient;	      /* gradient to convert channels to units */
    int nchan;                /* dimension of input array */ 
    int ichan;                /* start channel for fit */
    int jchan;                /* end channel for fit */
    int npeak;                /* number of peaks */
    int nback;                /* order of background fit */
    int ibkshape;	      /* shape of background */
    int ipksch;               /* flag > 0 search on peak centroid positions
				 using value of ipksch */
    int idiffwd;              /* flag == TRUE use fwhmin for peak widths ELSE
				 use same width */
    int iskew;                /* flag == TRUE use skew guassian */
    int ifixwd;               /* flag == TRUE use fixed centroid widths */
    int ifixcn;               /* flag == TRUE use fixed centroid positions */
    int lorentz;              /* flag == TRUE use lorentzian shape for peak */
} buffit_in_t;

/* data follows in file after above header */

typedef struct buffit_out {
    double total;             /* total nos of counts between ichan & jchan */
    double centr[FIT_DIM];    /* calculated peak centroids */
    double cenerr[FIT_DIM];   /* error on peak centroids */
    double area[FIT_DIM];     /* calculated peak areas */
    double arerr[FIT_DIM];    /* error on peak areas */
    double height[FIT_DIM];   /* height of Gaussian */
    double hterr[FIT_DIM];    /* error on Gaussian height */
    double fwhm[FIT_DIM];     /* fwhm of peak */
    double fwerr[FIT_DIM];    /* error on fwhm of peak */
    double fwhmlo[FIT_DIM];   /* fwhm of low side of peak for skew peaks */
    double fwlerr[FIT_DIM];   /* error on fwhmlo */
    double gwidhi[FIT_DIM];   /* width for calculated gaussians */
    double gwherr[FIT_DIM];   /* error on width */
    double gwidlo[FIT_DIM];   /* width for calculated gaussians low side*/
    double gwlerr[FIT_DIM];   /* error on low side  width */
    double bkarea;            /* calculated background area */
    double bkaerr;            /* error on background area */
    double bakfit[BK_ORDER];  /* background parameters */
    double bakerr[BK_ORDER];  /* errors on background from fit */
    double chisq;             /* final chisq for fit */
    double dxplot;	      /* step size to use for fitted plot */
    double offset;	      /* offset to convert channels to units */
    double gradient;	      /* gradient to convert channels to units */
    int    iplot;             /* start channel for fit */
    int    jplot;             /* end channel for fit */
    int    npeak;             /* number of peaks */
} buffit_out_t;

/* calculated fits follow in file after above header in order total fit,
   background, peaks */
