#include <stdio.h>
#include <memory.h>
#include "buffitio.h"

/*
 * Interface to buffit. The following features are not supported:
 * peak shape of gaussian+tail
 * pre-determined backgrouds, with or without normalisation.
 */

int main(int  argc, char *argv[])
{
    FILE *fp;
    int i, nplot;
    char *in_file, **ptr;
    char out_file[L_tmpnam+24];
    buffit_in_t bi;
    buffit_out_t bo;
    double *spec, *fit, *peaks, *bkgrnd, *fitplot, *pkplot, *bkplot;
    double pkarea[FIT_DIM], centail[FIT_DIM], tailexp[FIT_DIM], tail[FIT_DIM];
    double pkaerr[FIT_DIM], ctailerr[FIT_DIM], texperr[FIT_DIM];
    double tailerr[FIT_DIM], bknorm = 0, bknerr = 0;
    int verbose = 0, ipkshape = 0;
    
    for (ptr = argv; *ptr != NULL; ptr++) {
	if (strcmp("-spectrum",*ptr) == 0) 
	    in_file = *(++ptr);
	else if (strcmp("-verbose",*ptr) == 0)
	    verbose = 1;
    }
    
    if ( (fp = fopen(in_file,"r")) == NULL) {
	perror("Buffit proc: input file open");
	return 1;
    }
    
    if (fread((char *) &bi, sizeof(buffit_in_t), 1, fp) != 1) {
	perror("Buffit proc: input file read");
	return 2;
    }

    (void) memset((char *) &bo, 0, sizeof(buffit_out_t));

    bo.iplot = bi.ichan/bi.dxplot;
    bo.jplot = bi.jchan/bi.dxplot;
    bo.dxplot = bi.dxplot;
    nplot = bi.nchan/bi.dxplot + 1;

    if ((spec = (double *) malloc(bi.nchan*sizeof(double))) == NULL ||
	(fit = (double *) malloc(bi.nchan*sizeof(double))) == NULL ||
	(peaks = (double *) malloc(bi.nchan*sizeof(double))) == NULL ||
	(bkgrnd = (double *) malloc(bi.nchan*sizeof(double))) == NULL ||
	(fitplot = (double *) malloc(nplot*sizeof(double))) == NULL ||
	(pkplot = (double *) malloc(nplot*sizeof(double))) == NULL ||
	(bkplot = (double *) malloc(nplot*sizeof(double))) == NULL)
    {
	fprintf(stderr, "Buffit proc: unable to allocate memory for data.\n");
	return 1;
    }

    if (fread((char *) spec, bi.nchan*sizeof(double), 1, fp) != 1) {
	perror("Buffit proc: input file read");
	return 2;
    }

    (void) fclose(fp);
    (void) unlink(in_file);

    f_init();

    (void) buffit_(
	spec, &bi.nchan, &bi.ichan, &bi.jchan, &bi.npeak, &bi.nback,
	&ipkshape, &bi.ibkshape, bi.centin, bi.fwhmin, bi.fwloin, &bi.width,
	&bi.widlo, &bi.ipksch, &bi.idiffwd, &bi.iskew, &bi.ifixwd, &bi.ifixcn,
	&bi.lorentz, &bo.total, fit, peaks, bkgrnd, bo.centr, bo.area,
	bo.height, bo.fwhm, bo.fwhmlo, bo.gwidhi, bo.gwidlo, pkarea, centail,
	tailexp, tail, &bo.bkarea, bo.bakfit, &bknorm, bo.cenerr, bo.arerr,
	bo.hterr, bo.fwerr, bo.fwlerr, bo.gwherr, bo.gwlerr, pkaerr, ctailerr,
	texperr, tailerr, &bo.bkaerr, bo.bakerr, &bknerr, &bo.chisq, fitplot,
	pkplot, bkplot, &bi.dxplot, &nplot);

    bo.npeak = bi.npeak;
    bo.gradient = bi.gradient;
    bo.offset = bi.offset;

    sprintf(out_file,"%sBUFFIT_%d",P_tmpdir,getpid());

    if ( (fp = fopen(out_file,"w")) == NULL) {
	perror("Buffit proc: output file open");
	return 1;
    }

    if (fwrite((char *) &bo, sizeof(buffit_out_t), 1, fp) != 1) {
	perror("Buffit proc: output file write");
	return 2;
    }

    i = bo.jplot - bo.iplot;

    if (fwrite((char *) (fitplot + bo.iplot), sizeof(double), i, fp) != i) {
	perror("Buffit proc: output file write");
	return 2;
    }

    if (fwrite((char *) (pkplot + bo.iplot), sizeof(double), i, fp) != i) {
	perror("Buffit proc: output file write");
	return 2;
    }

    if (fwrite((char *) (bkplot + bo.iplot), sizeof(double), i, fp) != i) {
	perror("Buffit proc: output file write");
	return 2;
    }

    (void) fclose(fp);
    
    if (verbose) {
	if ((fp = fopen("bfit.dat","w")) == NULL) {
	    perror("Buffir proc verbose file open");
	    return 1;
	}
	for (i=bi.ichan; i<= bi.jchan; i++)
	    fprintf(fp,"%d %lf\n", i, fit[i-1]);
	(void) fclose(fp);
	    
	if ( (fp = fopen("bpeaks.dat","w")) == NULL) {
	    perror("Buffir proc verbose file open");
	    exit(1);
	}
	for (i=bi.ichan; i<= bi.jchan; i++)
	    fprintf(fp,"%d %lf\n", i, peaks[i-1]);
	(void) fclose(fp);
	
	if ( (fp = fopen("bbkgrnd.dat","w")) == NULL) {
	    perror("Buffir proc verbose file open");
	    exit(1);
	}
	for (i=bi.ichan; i<= bi.jchan; i++)
	    fprintf(fp,"%d %lf\n", i, bkgrnd[i-1]);
	(void) fclose(fp);
    }

    return 0;
}
