CC
C
***********************************************************************
c

C     ****************************************************************
C
      SUBROUTINE unpakskewg(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax, 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     >fitplot,pkplot,bkplot,dxplot,nplot)
c
c
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan)                       
      DIMENSION FIT(nchan),BKGRD(nchan),PEAKS(nchan)
      DIMENSION CENTR(npeak),AREA(npeak),
     >FWHM(npeak),FWHMLO(npeak),BAKFIT(nbkparm)
      DIMENSION HEIGHT(npeak),GWIDHI(npeak),GWIDLO(npeak)
      DIMENSION CENERR(npeak),ARERR(npeak),
     >FWERR(npeak),FWLERR(npeak),BAKERR(nbkparm)
      DIMENSION HTERR(npeak),GWHERR(npeak),GWLERR(npeak)
      dimension index(nca),zp(np),zb(nb)
      dimension A(NCA),COVAR(NCA,NCA),out(12)
      dimension fitplot(nplot), pkplot(nplot),bkplot(nplot)
      DATA SQRFW/1.665109223D0/
      DATA SQRPI/1.772453851D0/              
C     
C
C
C
C     FILL OUTPUT ARRAYS, CONSTRUCT PEAKS, BACKGROUND & FIT
C
      DATN=REAL(NDATA)
C
C
c     fill peak arrays with peak parameters
c
      WRITE(6,10)
 10   FORMAT(80('*'))
c
c     write out peak function shape
c

      write(6,15)
 15   format(/'Peak function',
     > '  p(i)= h* exp(-(( i-c)*1.6651/w)**2 )'/
     > 13x,'          h=height, c=centre, i=ichan, jchan'/
     > 13x,'          w=fwhmhi(fwhmlo) for i>c (i<c)'/)

C
      WRITE(6,'(''Peak'',8X,''Centroid'',17X,
     >''Area'',21X,''Fwhm ''/
     > 37x,''Height'',19x,''Fwhmhi''/62x,''Fwhmlo'')')
c
c
      DO  20  j = 1, npeak
c
c     get indices of h,c,wh,wl
c
       ih=abs(index(4*(j-1)+1))
         ic=abs(index(4*(j-1)+2))
           iwh=abs(index(4*(j-1)+3))
            iwl= abs(index(4*(j-1)+4))
c
c       get h,c,wh,wl,w
c
         h=a(ih)
          c=a(ic)
           wh=a(iwh)
            wl=a(iwl)
          w= 0.5d0*(wh+wl)
c
c        get errors
c
        errh = SQRT(COVAR(ih,ih))
         errc = SQRT(COVAR(ic,ic))
          errwh = SQRT(COVAR(iwh,iwh))
           errwl=sqrt(covar(iwl,iwl))
            errw=0.5d0*sqrt(errwh**2 +errwl**2)
c
c        fill output list in out
c
        out(1) = c + ICHAN
        out(2) = errc
        out(3) = SQRPI*h*w
        temp1= ( wh * h)**2 * ( (errh/h)**2 +(errwh/wh)**2 
     >          +2.0*COVAR(ih,iwh)/(h*wh) )
        temp2= ( wl * h)**2 * ( (errh/h)**2 +(errwl/wl)**2 
     >          +2.0*COVAR(ih,iwl)/(h*wl) )
         temp3= 2.0d0* h * covar(iwl,iwh)
c
        out(4) = SQRPI*0.5d0*SQRT(temp1+temp2+temp3)
        out(5) = SQRFW*w
        out(6) = SQRFW*errw
         out(7)=h
          out(8)=errh
        out(9)= sqrfw *wh
         out(10)= sqrfw *errwh
         out(11) =sqrfw * wl
         out(12)= sqrfw * errwl
C
        CENTR( j )=out(1)
        CENERR( j )=out(2)
        AREA( j )=out(3)
        ARERR( j)=out(4)
C
        HEIGHT( j )=h
        HTERR( j )=errh
C
        FWHM( j )=out(7)
        FWERR( j )=out(8)
         fwhmlo(j)= out(9)
         fwlerr(j)=out(10)
C
        GWIDHI( j )=wh
        GWHERR( j )=errwh
         gwidlo(j)= wl
          gwlerr(j)=errwl
c
c      writeout array out
c
       WRITE(6,'(/i3,3(1X,F11.2,'' +/-'',F9.2))') j,(out(nj),nj=1,6)
       write(6,'(28x,2(1x,f11.2,'' +/-'',f9.2)/
     > 54x,f11.2,'' +/-'',f9.2)')( out(nj),nj=7,12 )
c
 20    CONTINUE
c

c
C     fill background arrays with parameters,areas and errors
c
c     set starting value of index in ix
c
      ix=4*npeak
c
      call unpakbak(bkgrd,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix, 
     > BKAREA,BAKFIT,bknorm,
     > BKAERR,BAKERR,bknerr,
     > bkplot,dxplot,nplot)
c
c
c
c
c      construct  fit to spectrum
c
      do 50 i=ichan,jchan
c
c
c      add sum of peaks to each channel
c
      sump=0.0d0
c
        DO  40  J = 1, NPEAK
c
c       skew gaussian
c
       z= real(i) -centr(j)
          if(z.lt.0.0) then
             w= gwidlo(j)
           else
              w= gwidhi(j)
           endif
c
          ARG = z/w
          IF( ARG .LT. 10.0 ) THEN
            EX = EXP(-ARG**2)
          ELSE
            EX = 0.0d0
          ENDIF
c
c
          sump = sump + height(j)*ex
 40      CONTINUE
c
      peaks(i)=sump
c
c        add peaksum and background to fit
c
          FIT(I)=sump+bkgrd(i)
c
c
   50 CONTINUE
c
c
c
c      construct plotting arrays
c
        ndx=nint(1.0d0/dxplot)
        dxplot= 1.0d0/real(ndx)
         iplot=ichan*ndx
         jplot=jchan*ndx
c
       do 70 i= iplot,jplot
          x= (i-iplot)*dxplot
           sum=0.0d0
        do  60  j = 1, npeak
c
c       skew gaussian
c
          z= (x-(centr(j)-ichan))
          if(z.lt.0.0) then
             w= gwidlo(j)
           else
              w= gwidhi(j)
           endif

          ARG =z/w
          IF( ARG .LT. 10.0 ) THEN
            EX = EXP(-ARG**2)
          ELSE
            EX = 0.0d0
          ENDIF
c
c
          sum = sum + height(j)*ex
  60  continue
c
          pkplot(i)=sum
          fitplot(i)=sum+bkplot(i)
c
 70   continue
c
C
      RETURN
      END
