CC
C
***********************************************************************
c

C     ****************************************************************
C
      SUBROUTINE unpaktailg(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax, 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > PKAREA,CENTAIL,TAILEXP,TAIL,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     > PKAERR,CTAILERR,
     > TEXPERR,TAILERR,
     > fitplot,pkplot,bkplot,dxplot,nplot)

c
c
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan)                       
      DIMENSION FIT(nchan),BKGRD(nchan),PEAKS(nchan)
      DIMENSION CENTR(npeak),AREA(npeak),
     >FWHM(npeak),FWHMLO(npeak),BAKFIT(nbkparm)
      DIMENSION HEIGHT(npeak),GWIDHI(npeak),GWIDLO(npeak)
c
      dimension pkarea(npeak),centail(npeak),tailexp(npeak),
     > tail(npeak),pkaerr(npeak),ctailerr(npeak),
     > texperr(npeak),tailerr(npeak)
c
      DIMENSION CENERR(npeak),ARERR(npeak),
     >FWERR(npeak),FWLERR(npeak),BAKERR(nbkparm)
      DIMENSION HTERR(npeak),GWHERR(npeak),GWLERR(npeak)
      dimension index(nca),zp(np),zb(nb)
      dimension A(NCA),COVAR(NCA,NCA),out(20)
      dimension fitplot(nplot), pkplot(nplot),bkplot(nplot)
      DATA SQRFW/1.665109223D0/
      DATA SQRPI/1.772453851D0/              
C     
C
C
C
C     FILL OUTPUT ARRAYS, CONSTRUCT PEAKS, BACKGROUND & FIT
C
      DATN=REAL(NDATA)
C
C
c     fill peak arrays with peak parameters
c
      WRITE(6,10)
 10   FORMAT(80('*'))
c
c     write out peak function shape
c
c      do 1012 i=1,ixmax
c      write(6,1011)i,index(i),a(abs(index(i)))
c 1011 format(i3,i4,f10.4)
c 1012 continue
c
c
      write(6,15)
 15   format(/'Peak function'/
     > ' (if i>c2)  p(i) = h* exp(-(( i-c1)*1.6651/w)**2 )'/
     > '                   h=height, c1=centre, i=ichan, jchan'/
     > '                   w=fwhmhi(fwhmlo) for i>c1 (i<c1)'/
     > ' (if i<=c2) p(i) = p(c2) +1/t2 dp(c2)/di [exp(t2(i-c2))- 1] '/
     > '                   c2=tailcentre, t2=tailexponent'/)

C
      WRITE(6,'(''Peak'',8x,''Centre'',19x,
     >''TotalArea'',16x,''Fwhm ''/
     > 12x,''Height'',19x,''Peakarea'',17x,''Fwhmhi''/
     > 62x,''Fwhmlo''/
     >''Tail'',8x,''Tailcentre'',15x,''Tailarea'',17x,
     > ''Tailexponent''/)')
c
c
      DO  20  j = 1, npeak
c
c     get indices of h,c,wh,wl
c
       ih=abs(index(6*(j-1)+1))
         ic1=abs(index(6*(j-1)+2))
           ic2=abs(index(6*(j-1)+3))
           iwh=abs(index(6*(j-1)+4))
            iwl= abs(index(6*(j-1)+5))
             it2=abs(index(6*(j-1)+6))
c
c       get h,c1,c2, wh,wl,w, t2
c
         h=a(ih)
          c1=a(ic1)
            c2c1=a(ic2)
              c2=c2c1+c1
              wh=a(iwh)
                wl=a(iwl)
                 w= 0.5d0*(wh+wl)
                  t2=a(it2)
c
c        get errors
c
        errh = SQRT(COVAR(ih,ih))
         errc1 = SQRT(COVAR(ic1,ic1))
          errc2 = sqrt(covar(ic2,ic2))
            errwh = SQRT(COVAR(iwh,iwh))
             errwl=sqrt(covar(iwl,iwl))
               errw=0.5d0*sqrt(errwh**2 +errwl**2)
                errt2=sqrt(covar(it2,it2))

c
c        fill output list in out
c
c        gaussian peaks
c
        out(1) = c1 + ICHAN
        out(2) = errc1
        out(9) = SQRPI*h*w
        temp1= ( wh * h)**2 * ( (errh/h)**2 +(errwh/wh)**2 
     >          +2.0*COVAR(ih,iwh)/(h*wh) )
        temp2= ( wl * h)**2 * ( (errh/h)**2 +(errwl/wl)**2 
     >          +2.0*COVAR(ih,iwl)/(h*wl) )
         temp3= 2.0d0* h * covar(iwl,iwh)
c
         out(10) = SQRPI*0.5d0*SQRT(temp1+temp2+temp3)
        out(5) = SQRFW*w
          out(6) = SQRFW*errw
        out(7)=h
          out(8)=errh
        out(11)= sqrfw *wh
          out(12)= sqrfw *errwh
        out(13) =sqrfw * wl
          out(14)= sqrfw * errwl
C
        CENTR( j )=out(1)
         CENERR( j )=out(2)
        pkarea( j )=out(9)
         pkaerr( j)=out(10)
C
        HEIGHT( j )=h
         HTERR( j )=errh
C
        FWHM( j )=out(11)
         FWERR( j )=out(12)
        fwhmlo(j)= out(13)
         fwlerr(j)=out(14)
C
        GWIDHI( j )=wh
         GWHERR( j )=errwh
        gwidlo(j)= wl
         gwlerr(j)=errwl
c
c
c       tail part of peak
c
c         tailcentre
c
       ct = c2 +ichan
         centail(j) = ct
           ctailerr(j)= errc2
            out(15)=ct
             out(16)=errc2
c
c          tailexponent
c
          tailexp(j)=t2
           texperr(j) =errt2
            out(19) =t2
              out(20) =errt2
c
c           get tail area & error
c
c              -  get gaussian and derivative at c2
c
               argc2= (c2-c1)/wl
            if(abs(argc2).lt.10.0) then
              exc2=exp(-argc2**2)
            else
              exc2=0.0d0
            endif
c
            yc2= h* exc2
            deriyc2 = yc2*argc2*(-2.0d0/wl)
c
c        full tail area (including bit under gaussian) 
c           = p(c2) c2 - 1/t2 dp(c2)/dx [ -c2 +1/t2 ( 1- exp(-t2 c2))]    
c
          tc= t2*c2
          if(abs(tc).lt.100.0 ) then
            exct=exp(-tc)
          else
             exct=0.0d0
          endif
c          
          tarea= yc2*c2 - deriyc2/t2 * ( -c2 +1.0d0/t2 *
     >     ( 1.0d0-exct) )
c
c          ***************
c         get error on tail area
c
c
         argsq=argc2**2
          arg4=argsq**2
       exsq= exc2**2
       hsq=h**2
        wsq=wl**2
c
c      get error on y
c
       t1= exsq * errh**2
        t2=  hsq* exsq* 4.0d0*arg4/wsq**2 *  errwl**2 
          t3= hsq* exsq * 4.0d0* argsq/ wsq  *  errc2**2
       erry= sqrt( t1+t2+t3)
c
c      get erors on dydx
c
         term1= exsq*4.0d0*argsq/wsq*errh**2
          term2= hsq * exsq*( 4.0d0*argc2/wsq - 4.0d0*argc2*argsq/wsq)**2 *errwl**2
            term3= hsq*exsq* (2.0d0/wsq - 4.0d0*argsq/wsq)**2 * errc2**2
           errdy=sqrt (term1+term2+term3)
c
c        error on tail area
c
         term1= c2**2 * erry**2
          term2= ( -c2+1.0d0/t2 *(1.0d0-exct))**2 *errdy**2
         term3= (yc2+ deriyc2/t2 *(-1.0d0 +t2*exct))**2 * errc2**2
          term4= ( deriyc2*( c2/t2**2 -2.0d0/t2**3 
     > +exct *( 2.0d0/t2**3 +c2/t2**2) ) )**2 * errt2**2
c

           taerr=sqrt( term1+term2+term3+term4)
c
c
c         get overlap area where tail and gaussian overlap
c              = area of gaussian from 0 to c2
c              = sqrpi * h*wl *0.5*( 1+erf( (c2-c1)/wl )
c
         ofac= 0.5*(1.0d0 + derf(-argc2))
           overlap= sqrpi* h* wl* ofac
c
           out(17)= tarea-overlap
              tail(j) =out(17)
c           ********************
             out(18) = sqrt ( taerr**2 + (pkaerr(j)*ofac)**2 )
              tailerr(j) = out(18)
c
c        get total area = peak area + tail area
c
         out(3)= pkarea(j)+tail(j)
            area(j)=out(3)
c        ************************
           out(4) =sqrt(pkaerr(j)**2 +tailerr(j)**2 )
             arerr(j)= out(4)
c
c

c
c      writeout array out
c
       WRITE(6,'(/''P''i2,3(1X,F11.2,'' +/-'',F9.2))')
     >  j,(out(nj),nj=1,6)
       write(6,'(3x,3(1x,f11.2,'' +/-'',f9.2)/
     > 54x,f11.2,'' +/-'',f9.2)')( out(nj),nj=7,14 )
       write( 6,'(''T'',i2,2(1x,f11.2,'' +/-'',f9.2)
     > 1pe12.4,'' +/-'',e12.4 )')
     >  j,(out(nj),nj=15,20)
c
c
 20    CONTINUE
c

c
C     fill background arrays with parameters,areas and errors
c
c     set starting value of index in ix
c
      ix=6*npeak
c
      call unpakbak(bkgrd,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix, 
     > BKAREA,BAKFIT,bknorm,
     > BKAERR,BAKERR,bknerr,
     > bkplot,dxplot,nplot)
c
c
c
c
c      construct  fit to spectrum
c
      do 50 i=ichan,jchan
c
c
c      add sum of peaks to each channel
c
      sump=0.0d0
c
        DO  40  J = 1, NPEAK
c
c
c       if i < c2 then calculate only tail
c
       zt= real(i)-centail(j)
       if(zt.le.0.0) then
c
c          get gaussian & derivative at c2
c
               argc2= (centail(j)-centr(j))/gwidlo(j)
            if(abs(argc2).lt.10.0) then
              exc2=exp(-argc2**2)
            else
              exc2=0.0d0
            endif
c
            yc2= height(j)* exc2
            deriyc2 = yc2*argc2*(-2.0d0/gwidlo(j))
c
c            get expoenential factor
c
             tz=tailexp(j)*zt
            if(abs(tz).lt.100.0) then
              exct=exp(tz)
             else
               exct=0.0d0
             endif

c
c         tail = p(c2)+ 1/t2 dp(c2)/dx [ exp(t2*zt) -1]
c
       sump=sump+ yc2 +1.0d0/tailexp(j) * deriyc2* (exct-1.0d0)
c
c
c          zt>0
c
      else
c
c
c       skew gaussian
c
       z= real(i) -centr(j)
          if(z.lt.0.0) then
             w= gwidlo(j)
           else
              w= gwidhi(j)
           endif
c
          ARG = z/w
          IF( ARG .LT. 10.0 ) THEN
            EX = EXP(-ARG**2)
          ELSE
            EX = 0.0d0
          ENDIF
c
c
          sump = sump + height(j)*ex
c
c
      endif
c
c
 40      CONTINUE
c
      peaks(i)=sump
c
c        add peaksum and background to fit
c
          FIT(I)=sump+bkgrd(i)
c
c
   50 CONTINUE
c
c
c
c      construct plotting arrays
c
        ndx=nint(1.0d0/dxplot)
        dxplot= 1.0d0/real(ndx)
         iplot=ichan*ndx
         jplot=jchan*ndx
c
       do 70 i= iplot,jplot
          x= (i-iplot)*dxplot
           sum=0.0d0
        do  60  j = 1, npeak
c
c       if i < c2 then calculate only tail
c
       zt= real(i)-centail(j)
       if(zt.le.0.0) then
c
c          get gaussian & derivative at c2
c
               argc2= (centail(j)-centr(j))/gwidlo(j)
            if(abs(argc2).lt.10.0) then
              exc2=exp(-argc2**2)
            else
              exc2=0.0d0
            endif
c
            yc2= height(j)* exc2
            deriyc2 = yc2*argc2*(-2.0d0/gwidlo(j))
c
c            get exponential factor
c
             tz=tailexp(j)*zt
            if(abs(tz).lt.100.0) then
              exct=exp(tz)
             else
               exct=0.0d0
             endif

c
c         tail = p(c2)+ 1/t2 dp(c2)/dx [ exp(t2*zt) -1]
c
       sum=sum+ yc2 +1.0d0/tailexp(j) * deriyc2* (exct-1.0d0)
c
c
c          zt>0
c
      else

c
c       skew gaussian
c
          z= (x-(centr(j)-ichan))
          if(z.lt.0.0) then
             w= gwidlo(j)
           else
              w= gwidhi(j)
           endif

          ARG =z/w
          IF( ARG .LT. 10.0 ) THEN
            EX = EXP(-ARG**2)
          ELSE
            EX = 0.0d0
          ENDIF
c
c
          sum = sum + height(j)*ex
c
c
       endif
c

  60  continue
c
          pkplot(i)=sum
          fitplot(i)=sum+bkplot(i)
c
 70   continue
c
C
      RETURN
      END
