;GIL-3
(
(
	:type                   :menu
	:name                   palettes
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Hues" "Greyscale" "Set Gamma..." "Monochrome Display" "Colour Display" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :inactive )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (palettes "Monochrome Display")
		:when                   (Notify )
		:to                     (specWindow spectrumControls)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (changeToMonochrome)
		)
		(
		:from                   (palettes "Colour Display")
		:when                   (Notify )
		:to                     (specWindow spectrumControls)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (changeToColour)
		)
		(
		:from                   (palettes "Greyscale")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (contourColourGreyscale)
		)
		(
		:from                   (palettes "Hues")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (contourColourHues)
		)
		(
		:from                   (palettes "Set Gamma...")
		:when                   (Notify )
		:to                     (gammaPopup)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :menu
	:name                   levelMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Default" "Linear..." "Pseudo-log..." "Add level" "Remove level" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :inactive :active )
	:menu-item-defaults     (t nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (levelMenu "Default")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (contourLevelDefault)
		)
		(
		:from                   (levelMenu "Add level")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (addLevel)
		)
		(
		:from                   (levelMenu "Remove level")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (removeLevel)
		)
		(
		:from                   (levelMenu "Linear...")
		:when                   (Notify )
		:to                     (levelPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (popupLinear)
		)
		(
		:from                   (levelMenu "Pseudo-log...")
		:when                   (Notify )
		:to                     (levelPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (popupPseudo)
		)
	)
)
(
	:type                   :menu
	:name                   windowMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Show without window" "Show inside window" "Show outside window" "Show window" "Set window" "Clear window" "Abort set window" )
	:menu-item-label-types  (:string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :inactive )
	:menu-item-defaults     (nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil nil nil )
	:menu-item-menus        (nil nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (windowMenu "Set window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (setWindow)
		)
		(
		:from                   (windowMenu "Show inside window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (showInsideWindow)
		)
		(
		:from                   (windowMenu "Show outside window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (showOutsideWindow)
		)
		(
		:from                   (windowMenu "Clear window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (clearWindow)
		)
		(
		:from                   (windowMenu "Show without window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (showWithoutWindow)
		)
		(
		:from                   (windowMenu "Abort set window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (abortSetWindow)
		)
		(
		:from                   (windowMenu "Show window")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (showWindow)
		)
	)
)
(
	:type                   :menu
	:name                   autoscaleMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Linear" "Pseudo-logarithmic" )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (t nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (nil nil )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (autoscaleMenu "Linear")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (autoscaleLinear)
		)
		(
		:from                   (autoscaleMenu "Pseudo-logarithmic")
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (autoscaleLogarithmic)
		)
	)
)
(
	:type                   :menu
	:name                   magnifyMenu
	:help                   ""
	:columns                4
	:menu-type              :exclusive
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" )
	:menu-item-label-types  (:string :string :string :string :string :string :string :string :string :string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active :active :active :active :active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil t nil nil nil nil nil nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil t nil nil nil nil nil nil nil nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil )
	:menu-item-menus        (nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (magnifyMenu "1")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "2")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "3")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "4")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "5")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "6")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "7")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "8")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "9")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "10")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "11")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "12")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "13")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "14")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "15")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
		(
		:from                   (magnifyMenu "16")
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (menuSetMagnification)
		)
	)
)
(
	:type                   :base-window
	:name                   specWindow
	:owner                  nil
	:width                  514
	:height                 578
	:background-color       ""
	:foreground-color       ""
	:label                  "Spectrum nn"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              ""
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   spectrumControls
	:owner                  specWindow
	:help                   ""
	:x                      0
	:y                      0
	:width                  514
	:height                 64
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   printButton
	:owner                  spectrumControls
	:help                   ""
	:x                      8
	:y                      7
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Print..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (specWindow printButton)
		:when                   (Notify )
		:to                     (printerPopup)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   contourButton
	:owner                  spectrumControls
	:help                   ""
	:x                      73
	:y                      7
	:width                  82
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Contours..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (specWindow contourButton)
		:when                   (Notify )
		:to                     (contourPopup)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   windowButton
	:owner                  spectrumControls
	:help                   ""
	:x                      163
	:y                      7
	:width                  81
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Window"
	:label-type             :string
	:initial-state          :active
	:menu                   windowMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   autoscaleButton
	:owner                  spectrumControls
	:help                   ""
	:x                      252
	:y                      7
	:width                  90
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Autoscale"
	:label-type             :string
	:initial-state          :active
	:menu                   autoscaleMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   sliceButton
	:owner                  spectrumControls
	:help                   ""
	:x                      350
	:y                      7
	:width                  67
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Slicing..."
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (specWindow sliceButton)
		:when                   (Notify )
		:to                     (slicePopup)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   magnifyButton
	:owner                  spectrumControls
	:help                   ""
	:x                      425
	:y                      7
	:width                  81
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Magnify"
	:label-type             :string
	:initial-state          :active
	:menu                   magnifyMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   forkButton
	:owner                  spectrumControls
	:help                   ""
	:x                      456
	:y                      32
	:width                  44
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Fork"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         forkProgram
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (specWindow forkButton)
		:when                   (Notify )
		:to                     (specWindow forkButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (forkProgram)
		)
	)
)
(
	:type                   :message
	:name                   xy
	:owner                  spectrumControls
	:help                   ""
	:x                      8
	:y                      34
	:width                  75
	:height                 13
	:foreground-color       ""
	:label                  "X,Y,Counts:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   coordinates
	:owner                  spectrumControls
	:help                   ""
	:x                      91
	:y                      34
	:width                  90
	:height                 13
	:foreground-color       ""
	:label                  "(X, Y) = Counts"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :canvas-pane
	:name                   spectrum
	:owner                  specWindow
	:help                   ""
	:x                      0
	:y                      64
	:width                  514
	:height                 514
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       514
	:vertical-scrollbar     nil
	:scrollable-height      514
	:repaint-proc           repaintSpectrum
	:event-handler          rubberBand
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (specWindow spectrum)
		:when                   (Repaint )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (repaintSpectrum)
		)
		(
		:from                   (specWindow spectrum)
		:when                   (AnyEvent )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (rubberBand)
		)
		(
		:from                   (specWindow spectrum)
		:when                   (Select )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (newPoint)
		)
		(
		:from                   (specWindow spectrum)
		:when                   (Adjust )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (deletePoint)
		)
		(
		:from                   (specWindow spectrum)
		:when                   (Menu )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (closeWindow)
		)
	)
)
(
	:type                   :popup-window
	:name                   contourPopup
	:owner                  specWindow
	:width                  540
	:height                 548
	:background-color       ""
	:foreground-color       ""
	:label                  "Contours"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   contourControls
	:owner                  contourPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  540
	:height                 548
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   presetPalette
	:owner                  contourControls
	:help                   ""
	:x                      16
	:y                      8
	:width                  81
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Palettes"
	:label-type             :string
	:initial-state          :active
	:menu                   palettes
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   levels
	:owner                  contourControls
	:help                   ""
	:x                      105
	:y                      8
	:width                  69
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Levels"
	:label-type             :string
	:initial-state          :active
	:menu                   levelMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   levelPopup
	:owner                  specWindow
	:width                  240
	:height                 120
	:background-color       ""
	:foreground-color       ""
	:label                  "Set contour levels"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   levelControls
	:owner                  levelPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  240
	:height                 120
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   firstValue
	:owner                  levelControls
	:help                   ""
	:x                      65
	:y                      8
	:width                  162
	:height                 15
	:value-x                163
	:value-y                8
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "First contour:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   spacing
	:owner                  levelControls
	:help                   ""
	:x                      98
	:y                      32
	:width                  129
	:height                 15
	:value-x                163
	:value-y                32
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Spacing:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   step
	:owner                  levelControls
	:help                   ""
	:x                      122
	:y                      32
	:width                  105
	:height                 15
	:value-x                163
	:value-y                32
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Step:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   numContours
	:owner                  levelControls
	:help                   ""
	:x                      13
	:y                      58
	:width                  214
	:height                 15
	:value-x                163
	:value-y                58
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Number of Contours:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   levelSetApply
	:owner                  levelControls
	:help                   ""
	:x                      94
	:y                      88
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   gammaPopup
	:owner                  specWindow
	:width                  334
	:height                 55
	:background-color       ""
	:foreground-color       ""
	:label                  "Set Gamma"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   gammaControls
	:owner                  gammaPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  334
	:height                 55
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   displayGammaLabel
	:owner                  gammaControls
	:help                   ""
	:x                      8
	:y                      8
	:width                  111
	:height                 13
	:foreground-color       ""
	:label                  "Display Gamma:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   displayGammaValue
	:owner                  gammaControls
	:help                   ""
	:x                      123
	:y                      8
	:width                  40
	:height                 15
	:value-x                123
	:value-y                8
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "2.00"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (gammaPopup displayGammaValue)
		:when                   (Notify )
		:to                     (gammaPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (valueSetDisplayGamma)
		)
	)
)
(
	:type                   :slider
	:name                   displayGammaSlider
	:owner                  gammaControls
	:help                   ""
	:x                      167
	:y                      8
	:width                  157
	:height                 20
	:value-x                167
	:value-y                8
	:slider-width           100
	:ticks                  0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              10
	:max-value              1000
	:min-value-string       "0.1"
	:max-value-string       "10"
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          200
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (gammaPopup displayGammaSlider)
		:when                   (Notify )
		:to                     (gammaPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (sliderSetDisplayGamma)
		)
	)
)
(
	:type                   :message
	:name                   printoutGammaLabel
	:owner                  gammaControls
	:help                   ""
	:x                      6
	:y                      32
	:width                  113
	:height                 13
	:foreground-color       ""
	:label                  "Printout Gamma:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printoutGammaValue
	:owner                  gammaControls
	:help                   ""
	:x                      123
	:y                      32
	:width                  40
	:height                 15
	:value-x                123
	:value-y                32
	:value-length           5
	:stored-length          5
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "1.00"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (gammaPopup printoutGammaValue)
		:when                   (Notify )
		:to                     (gammaPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (valueSetPrintoutGamma)
		)
	)
)
(
	:type                   :slider
	:name                   printoutGammaSlider
	:owner                  gammaControls
	:help                   ""
	:x                      167
	:y                      32
	:width                  157
	:height                 20
	:value-x                167
	:value-y                32
	:slider-width           100
	:ticks                  0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             nil
	:min-value              10
	:max-value              1000
	:min-value-string       "0.1"
	:max-value-string       "10"
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          100
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (gammaPopup printoutGammaSlider)
		:when                   (Notify )
		:to                     (gammaPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (sliderSetPrintoutGamma)
		)
	)
)
(
	:type                   :popup-window
	:name                   rgbPopup
	:owner                  specWindow
	:width                  323
	:height                 83
	:background-color       ""
	:foreground-color       ""
	:label                  "Set Colour"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   rgbControls
	:owner                  rgbPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  323
	:height                 83
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   redSlider
	:owner                  rgbControls
	:help                   ""
	:x                      24
	:y                      8
	:width                  281
	:height                 20
	:value-x                55
	:value-y                8
	:slider-width           128
	:ticks                  0
	:foreground-color       ""
	:label                  "Red:"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          t
	:show-range             t
	:show-value             t
	:min-value              0
	:max-value              255
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (rgbPopup redSlider)
		:when                   (Notify )
		:to                     (rgbPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (changeRed)
		)
	)
)
(
	:type                   :slider
	:name                   greenSlider
	:owner                  rgbControls
	:help                   ""
	:x                      9
	:y                      32
	:width                  296
	:height                 20
	:value-x                55
	:value-y                32
	:slider-width           128
	:ticks                  0
	:foreground-color       ""
	:label                  "Green:"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          t
	:show-range             t
	:show-value             t
	:min-value              0
	:max-value              255
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (rgbPopup greenSlider)
		:when                   (Notify )
		:to                     (rgbPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (changeGreen)
		)
	)
)
(
	:type                   :slider
	:name                   blueSlider
	:owner                  rgbControls
	:help                   ""
	:x                      18
	:y                      56
	:width                  287
	:height                 20
	:value-x                55
	:value-y                56
	:slider-width           128
	:ticks                  0
	:foreground-color       ""
	:label                  "Blue:"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          t
	:show-range             t
	:show-value             t
	:min-value              0
	:max-value              255
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (rgbPopup blueSlider)
		:when                   (Notify )
		:to                     (rgbPopup)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (changeBlue)
		)
	)
)
(
	:type                   :popup-window
	:name                   printerPopup
	:owner                  specWindow
	:width                  450
	:height                 295
	:background-color       ""
	:foreground-color       ""
	:label                  "Printer select"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   printerControls
	:owner                  printerPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  450
	:height                 295
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   printTo
	:owner                  printerControls
	:help                   ""
	:x                      102
	:y                      8
	:width                  276
	:height                 23
	:value-x                163
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Print to:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Printer" "File (Postscript)" "File (Encapsulated Postscript)" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (t nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (printerPopup printTo "File (Postscript)")
		:when                   (Notify )
		:to                     (printerPopup printTo)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (printToFile)
		)
		(
		:from                   (printerPopup printTo "Printer")
		:when                   (Notify )
		:to                     (printerPopup printTo)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (printToPrinter)
		)
		(
		:from                   (printerPopup printTo "File (Encapsulated Postscript)")
		:when                   (Notify )
		:to                     (printerPopup printTo)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (printToFile)
		)
	)
)
(
	:type                   :setting
	:name                   printerPalette
	:owner                  printerControls
	:help                   ""
	:x                      54
	:y                      39
	:width                  372
	:height                 23
	:value-x                163
	:value-y                39
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Printer Palette:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("White to Black (no gamma)" "Greyscale version of display (gamma)" "Colour (gamma)" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printString
	:owner                  printerControls
	:help                   ""
	:x                      8
	:y                      70
	:width                  435
	:height                 15
	:value-x                163
	:value-y                70
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Printer control string:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "lp -d sp -o nobanner -c"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printFilename
	:owner                  printerControls
	:help                   ""
	:x                      52
	:y                      70
	:width                  391
	:height                 15
	:value-x                163
	:value-y                70
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Print Filename:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "pout.ps"
	:initial-state          :invisible
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printXLabel
	:owner                  printerControls
	:help                   ""
	:x                      104
	:y                      93
	:width                  339
	:height                 15
	:value-x                163
	:value-y                93
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "X label:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printYLabel
	:owner                  printerControls
	:help                   ""
	:x                      101
	:y                      116
	:width                  342
	:height                 15
	:value-x                163
	:value-y                116
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Y Label:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printTitle
	:owner                  printerControls
	:help                   ""
	:x                      120
	:y                      139
	:width                  323
	:height                 15
	:value-x                163
	:value-y                139
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Title:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printSubtitle
	:owner                  printerControls
	:help                   ""
	:x                      98
	:y                      160
	:width                  345
	:height                 15
	:value-x                163
	:value-y                160
	:value-length           35
	:stored-length          255
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Subtitle:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   printScaleSlider
	:owner                  printerControls
	:help                   ""
	:x                      77
	:y                      184
	:width                  340
	:height                 26
	:value-x                158
	:value-y                184
	:slider-width           150
	:ticks                  16
	:foreground-color       ""
	:label                  "Scaling (%):"
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             t
	:show-value             t
	:min-value              25
	:max-value              400
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          100
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printXGain
	:owner                  printerControls
	:help                   ""
	:x                      13
	:y                      208
	:width                  214
	:height                 15
	:value-x                163
	:value-y                208
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "X: Units = channels *"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "1"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printXOffset
	:owner                  printerControls
	:help                   ""
	:x                      235
	:y                      208
	:width                  80
	:height                 15
	:value-x                251
	:value-y                208
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "+"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printYGain
	:owner                  printerControls
	:help                   ""
	:x                      13
	:y                      232
	:width                  214
	:height                 15
	:value-x                163
	:value-y                232
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Y: Units = channels *"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "1"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   printYOffset
	:owner                  printerControls
	:help                   ""
	:x                      235
	:y                      232
	:width                  80
	:height                 15
	:value-x                251
	:value-y                232
	:value-length           8
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "+"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   doPrint
	:owner                  printerControls
	:help                   ""
	:x                      201
	:y                      264
	:width                  48
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Print"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (printerPopup doPrint)
		:when                   (Notify )
		:to                     (specWindow spectrum)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (printSpectrum)
		)
	)
)
(
	:type                   :popup-window
	:name                   slicePopup
	:owner                  specWindow
	:width                  460
	:height                 180
	:background-color       ""
	:foreground-color       ""
	:label                  "Slicing"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   sliceControls
	:owner                  slicePopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  460
	:height                 180
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   sliceArea
	:owner                  sliceControls
	:help                   ""
	:x                      8
	:y                      8
	:width                  213
	:height                 23
	:value-x                87
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Slice Area:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole spectrum" "Inside window" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   sliceType
	:owner                  sliceControls
	:help                   ""
	:x                      264
	:y                      8
	:width                  191
	:height                 23
	:value-x                346
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Slice Type:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Project onto" "Slice along" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceSet1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceSet1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceY)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceY)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceSet2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceSet2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceX)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceX)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceSet3)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceSet3)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceX1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceX1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (slicePopup sliceType "Project onto")
		:when                   (Notify )
		:to                     (slicePopup sliceY1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (slicePopup sliceType "Slice along")
		:when                   (Notify )
		:to                     (slicePopup sliceY1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :setting
	:name                   sliceDirection
	:owner                  sliceControls
	:help                   ""
	:x                      8
	:y                      40
	:width                  190
	:height                 69
	:value-x                119
	:value-y                40
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Slice Direction:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Horizontal" "Vertical" "Arbitrary" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceSet1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceSet1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceSet1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceY)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceY)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceY)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceSet2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceSet2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceSet2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceX)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceX)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceX)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceSet4)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceSet4)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceSet4)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceAngle)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceAngle)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceAngle)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceSet3)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceSet3)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceSet3)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceX1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceX1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceX1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
		(
		:from                   (slicePopup sliceDirection "Horizontal")
		:when                   (Notify )
		:to                     (slicePopup sliceY1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Vertical")
		:when                   (Notify )
		:to                     (slicePopup sliceY1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Disable)
		)
		(
		:from                   (slicePopup sliceDirection "Arbitrary")
		:when                   (Notify )
		:to                     (slicePopup sliceY1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Enable)
		)
	)
)
(
	:type                   :button
	:name                   sliceSet1
	:owner                  sliceControls
	:help                   ""
	:x                      312
	:y                      40
	:width                  37
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Set"
	:label-type             :string
	:initial-state          :invisible
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   sliceY
	:owner                  sliceControls
	:help                   ""
	:x                      208
	:y                      42
	:width                  96
	:height                 15
	:value-x                233
	:value-y                42
	:value-length           3
	:stored-length          10
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Y="
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              128
	:min-value              1
	:initial-value          1
	:initial-state          :invisible
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   sliceSet2
	:owner                  sliceControls
	:help                   ""
	:x                      312
	:y                      64
	:width                  37
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Set"
	:label-type             :string
	:initial-state          :invisible
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   sliceX
	:owner                  sliceControls
	:help                   ""
	:x                      208
	:y                      66
	:width                  96
	:height                 15
	:value-x                233
	:value-y                66
	:value-length           3
	:stored-length          10
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "X="
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              128
	:min-value              1
	:initial-value          1
	:initial-state          :invisible
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   sliceSet4
	:owner                  sliceControls
	:help                   ""
	:x                      342
	:y                      88
	:width                  37
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Set"
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   sliceAngle
	:owner                  sliceControls
	:help                   ""
	:x                      208
	:y                      90
	:width                  126
	:height                 15
	:value-x                263
	:value-y                90
	:value-length           3
	:stored-length          10
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Angle="
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              180
	:min-value              0
	:initial-value          45
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   sliceSet3
	:owner                  sliceControls
	:help                   ""
	:x                      414
	:y                      112
	:width                  37
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Set"
	:label-type             :string
	:initial-state          :invisible
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   sliceX1
	:owner                  sliceControls
	:help                   ""
	:x                      208
	:y                      114
	:width                  108
	:height                 15
	:value-x                245
	:value-y                114
	:value-length           3
	:stored-length          10
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "X,Y="
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              128
	:min-value              1
	:initial-value          1
	:initial-state          :invisible
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   sliceY1
	:owner                  sliceControls
	:help                   ""
	:x                      324
	:y                      114
	:width                  82
	:height                 15
	:value-x                335
	:value-y                114
	:value-length           3
	:stored-length          10
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ","
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              128
	:min-value              1
	:initial-value          1
	:initial-state          :invisible
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   slicePreviewButton
	:owner                  sliceControls
	:help                   ""
	:x                      121
	:y                      144
	:width                  76
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Preview..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (slicePopup slicePreviewButton)
		:when                   (Notify )
		:to                     (slicePreviewPopup)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   makeSlice
	:owner                  sliceControls
	:help                   ""
	:x                      257
	:y                      144
	:width                  82
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Make Slice"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   slicePreviewPopup
	:owner                  specWindow
	:width                  256
	:height                 256
	:background-color       ""
	:foreground-color       ""
	:label                  "Slice Preview"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :canvas-pane
	:name                   sliceCanvas
	:owner                  slicePreviewPopup
	:help                   ""
	:x                      0
	:y                      0
	:width                  256
	:height                 256
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       256
	:vertical-scrollbar     nil
	:scrollable-height      256
	:repaint-proc           nil
	:event-handler          nil
	:drawing-model          :xwindows
	:user-data              ()
	:actions                ()
)
)
