/*
 * spec_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `spec.G'.
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/xv_xrect.h>
#include "spec_ui.h"
#include <xview/cms.h>
#include <xview/wmgr.h>
#include <math.h>
#include <xview/notice.h>
#include <sys/socket.h>
#include <errno.h>
#include <X11/Xutil.h>
#include "lookup_proc.h"

double legendre();

void	popupLinear();
void	popupPseudo();
void	contourColourGreyscale();
void	contourColourHues();
void	contourColourHeat();
void	contourColourReverseGreyscale();
void	contourColourTopographic();
void	contourLevelDefault();
void	initialiseColourmap();
void	initialiseContourObjects();
void	repaintSpectrum();
void	setContoursAndRedraw();
void	addLevel();
void	removeLevel();
void	valueSetDisplayGamma();
void	sliderSetDisplayGamma();
void	valueSetPrintoutGamma();
void	sliderSetPrintoutGamma();
void	setWindow();
void	showInsideWindow();
void	showOutsideWindow();
void	clearWindow();
void	showWithoutWindow();
void	abortSetWindow();
void	showWindow();
void	newPoint();
void	deletePoint();
void	closeWindow();
void	freeWindowList();
void	changeRed();
void	changeGreen();
void	changeBlue();
void	showRgbPopup();
void	store_window();
int     store_spectrum();
void    do_projection();
void	printSpectrum();
void	printToFile();
void	printToPrinter();
void	autoscaleLinear();
void	autoscaleLogarithmic();
void	createDithers();
void	initialiseMonochrome();
void	setContourImages();
void	setContourDithers();
void	changeToMonochrome();
void	changeToColour();
void	setContourArray();
void	setMagnification();
void	menuSetMagnification();
void	readSpectrumFromPipe();
void	spectrumLoaded();
void	valueSetProjectAngle();
void	sliderSetProjectAngle();
void	repaintProjection();
void	setProjectArea();
void	drawGuidelines();
void	projectXGain();
void	projectXOffset();
void	projectYGain();
void	projectYOffset();
void	printXGain();
void	printXOffset();
void	printYGain();
void	printYOffset();
void	RRP();
void	projectXTarget();
void	projectYTarget();
void	setProjectAxis();
int	calcScaleAndOffset();
void	brighten();
void	contourLevelDefaultSet();
int	goodInteger();
FILE *	mypopen();
int	mypopenfd();
#ifdef SVR4
int	getdtablesize();
#endif
int	writeSpectrumToPipe();
void	setPolynomial();
Notify_value destroy_func();

extern int sys_nerr;
extern char *sys_errlist[];

/*
 * Global object definitions.
 */
spec_specWindow_objects	        *Spec_specWindow;
spec_contourPopup_objects	*Spec_contourPopup;
spec_levelPopup_objects	        *Spec_levelPopup;
spec_gammaPopup_objects	        *Spec_gammaPopup;
spec_rgbPopup_objects	        *Spec_rgbPopup;
spec_printerPopup_objects	*Spec_printerPopup;
spec_projectPopup_objects	*Spec_projectPopup;

struct windowPointList {
    int x;
    int y;
    struct windowPointList *next;
};

#define MAXCONTOURS 32
#define COLOUROFFSET CMS_CONTROL_COLORS
#define MYCMS "SPEC CMS"
#define MAXSPECX 512
#define MAXSPECY 512
#define MAXPROJWIDTH 730 /* > sqrt(MAXSPECX^2 + MAXSPECY^2), > 256 */
#define WINDOW_NONE 0
#define WINDOW_OUTSIDE 1
#define WINDOW_INSIDE 2
#define WINDOW_ONLY 3
#define WINDOW_SET 4
#define NCOLOURS MAXCONTOURS + COLOUROFFSET + 3
#define ERRSTRING ((errno > sys_nerr) ? "*** Unknown error ***" : \
                   sys_errlist[errno])
#define MAXSCALE 16
#define MAXSPECSIZE 1023
#define POLYARRAYLEN 1024 /* must be power of 2 */

static Xv_opaque contourSlider[MAXCONTOURS], contourButton[MAXCONTOURS];
static Xv_opaque contourObject[MAXCONTOURS+1];
int usedContours = MAXCONTOURS;
static Xv_opaque squareblack;
static unsigned short squarebits[] = {
#include "/usr/openwin/include/images/square_black.pr"
	};
static Xv_singlecolor rawColour[NCOLOURS];
static Xv_singlecolor displayColour[NCOLOURS];
static int Bg_index = NCOLOURS - 2;
static int Fg_index = NCOLOURS - 1;
static Cms cms = XV_NULL;
static int specx = 73, specy = 73, spec2d[MAXSPECX][MAXSPECY], specMax = 0;
static unsigned char spec2dcontour[MAXSPECX][MAXSPECY];
static unsigned char window[MAXSPECX][MAXSPECY];
static char spectrumName[80];
static int windowStatus = WINDOW_NONE;
static float displayGamma = 2, printoutGamma = 1, projectAngle = 90;
static unsigned char iconBits[4096];
static Xv_opaque iconBitmap = XV_NULL;
static Icon iconIcon = XV_NULL;
static int rgbColour = 0;
int debuglevel = 0;
int DBX_val = 0;
int sort_window = 0;
static int monochrome = 0;
static Pixmap dither[MAXSCALE*MAXSCALE+1], windither;
static Xv_opaque XVdither[MAXSCALE*MAXSCALE+1];
static int forceRedraw;
static int mag = 4;
static char *programName;
static int projection[MAXPROJWIDTH], forceProject = 1, projectArea = 0;
static int showGuidelines = 0, projectAxis = 0;
static float Xgain = 1.0, Ygain = 1.0, Xoffset = 0.0, Yoffset = 0.0;
static float screenAngle = M_PI/2, Xtarget = 0.0, Ytarget = 0.0;
static int polynomialOrder = 0;
static float polynomial[POLYARRAYLEN], polynomialScale = 1.0;

/**** 16/1/95 ****/

static int Slicing;
extern void do_simple_slice();

#define SLICING 0x1
#define PROJECTION 0x2

/*****************/

#define SORT_TRUE   1
#define SORT_FALSE  0
#define SORT_FAIL  -1
#define SORT_NOS_ERR -2

Notify_client sort_client = (Notify_client) 104;

void testSpectrum()
{
    int i,j;
    double x,y,r,t;

    for(i=0; i<specx; i++)
    {
	x = ((double) i)/(specx-1) * 2 - 1;
	for(j=0; j<specy; j++)
	{
	    y = ((double) j)/(specy-1) * 2 -1;
	    r = sqrt(x*x + y*y);
	    t = (r > 0) ? atan2(y,x) : 0 ;
	    if (r < 0.1 || (r >= 0.95 && r < 1.01)
		|| (r > 0.15 && r < 0.9 && sin(t*3) > 0))
		spec2d[i][j] = (int) (r*300) + 1;
	    else
		spec2d[i][j] = 0;
    }
  }
    specMax = 303;
    strcpy(spectrumName, "startup");

}

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

int main(argc, argv)
      int	argc;
      char	**argv;
{
      int i, piped = 0;
      extern Notify_value   sort_sigusr2_handler();
      extern Notify_value	destroy_func();

      programName = *argv;
/* check options*/
      for(i=1; i<argc; i++)
      {
	    if (!strcmp(argv[i],"-sort"))
	    {
		  sort_window = 1;
		  fprintf(stderr,"sort_spec2d started\n");
	    }
  	    else if (!strcmp(argv[i],"-dbx"))
	    {
		  debuglevel = (int) atof(argv[++i]);
		  DBX_val = debuglevel;
		  fprintf(stderr,"sort_spec2d: diagnostics level set to %d\n",
			  debuglevel);
	    } 
	    else if (!strcmp(argv[i], "-pipe"))
		piped = 1;
      }
/*
 * Initialize XView.
 */
      xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
      INSTANCE = xv_unique_key();

/* initialize the signal handler for SIGUSR2 */
      notify_set_signal_func(sort_client,sort_sigusr2_handler,SIGUSR2,NOTIFY_SYNC);
      notify_set_destroy_func(sort_client,destroy_func);

/* generate file name of SORT pipe for use with communications with sort process */
      if (sort_window)
      {
#ifdef SVR4
	  sigset(SIGINT, SIG_IGN);
#else
	  signal(SIGINT, SIG_IGN);
#endif
      }
      
      /*
       * Initialize user interface components.
       * Do NOT edit the object initializations by hand.
       */
      Spec_specWindow = spec_specWindow_objects_initialize(NULL, NULL);
      Spec_contourPopup = spec_contourPopup_objects_initialize(NULL, Spec_specWindow->specWindow);
      Spec_levelPopup = spec_levelPopup_objects_initialize(NULL, Spec_specWindow->specWindow);
      Spec_gammaPopup = spec_gammaPopup_objects_initialize(NULL, Spec_specWindow->specWindow);
      Spec_rgbPopup = spec_rgbPopup_objects_initialize(NULL, Spec_specWindow->specWindow); 
      Spec_printerPopup = spec_printerPopup_objects_initialize(NULL, Spec_specWindow->specWindow);
      Spec_projectPopup = spec_projectPopup_objects_initialize(NULL, Spec_specWindow->specWindow);
      
      for(i=MAXSCALE*MAXSCALE+1; i--; )
      {
	  dither[i] = 0;
	  XVdither[i] = XV_NULL;
      }

      initialiseColourmap(Spec_contourPopup->contourControls);
      if (!monochrome)
	  initialiseColourmap(Spec_specWindow->spectrum);
      initialiseContourObjects();
      if (piped)
	  readSpectrumFromPipe();
      else
      {
	  testSpectrum();	
	  spectrumLoaded();
	  contourLevelDefaultSet();
	  setMagnification(4);
      }
      setContourImages(Spec_contourPopup->contourControls);
      
      setContourArray();
      
      xv_set(Spec_specWindow->spectrum, CANVAS_X_PAINT_WINDOW, TRUE, 
	     CANVAS_RETAINED, TRUE, CANVAS_AUTO_EXPAND, FALSE,
	     CANVAS_AUTO_SHRINK, FALSE, CANVAS_AUTO_CLEAR, FALSE, NULL);
      xv_set(Spec_gammaPopup->displayGammaSlider,
	     PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
      xv_set(Spec_gammaPopup->printoutGammaSlider,
	     PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
      xv_set(canvas_paint_window(Spec_specWindow->spectrum),
	     WIN_IGNORE_EVENTS, WIN_UP_EVENTS, NULL,
	     WIN_CONSUME_EVENTS, LOC_MOVE, LOC_DRAG, NULL,
	     NULL);
      xv_set(Spec_rgbPopup->redSlider, PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
      xv_set(Spec_rgbPopup->greenSlider,
	     PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
      xv_set(Spec_rgbPopup->blueSlider, PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL); 
      xv_set(Spec_projectPopup->projectAngleSlider, PANEL_NOTIFY_LEVEL,
	     PANEL_ALL, NULL); 
      xv_set(Spec_specWindow->specWindow,
	     FRAME_LEFT_FOOTER, "Sort_spec2d version 1.05", NULL);
      if (monochrome)
	  xv_set(Spec_specWindow->specWindow,
		 FRAME_RIGHT_FOOTER, "Monochrome display - Yuk !", NULL);

      if (sort_window)
	  xv_set(Spec_specWindow->specWindow, FRAME_CLOSED, TRUE, NULL);
      
      /*
       * Turn control over to XView.
       */
      xv_main_loop(Spec_specWindow->specWindow);
      return(0);
}

#endif

void initialiseContourObjects()
{
    int i;
    char label[10];

    if (!contourObject[0])
    {
        squareblack = xv_create(XV_NULL, SERVER_IMAGE,
                                SERVER_IMAGE_DEPTH, 1,
                                SERVER_IMAGE_BITS, squarebits,
                                XV_WIDTH, 16,
                                XV_HEIGHT, 16,
                                NULL);
        for(i=0; i<MAXCONTOURS; i++)
        {
	    int rstep = (i>MAXCONTOURS/2) ? 0 : 1;
	    int y_pos = (rstep) ? 25+i*30 : (i-MAXCONTOURS/2)*30;
	    if (i == MAXCONTOURS-1)
		sprintf(label, "%8d", specMax);
	    else
		sprintf(label, "%6d", i);
            if (i == 0 || i == MAXCONTOURS - 1)
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_MESSAGE,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, xv_col(Spec_contourPopup->contourPopup,
				       (rstep) ? 23 : 51),
			      XV_Y, y_pos+8,
                              PANEL_LABEL_STRING, label,
			      NULL);
            else
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_SLIDER,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, xv_col(Spec_contourPopup->contourPopup,
					   (rstep) ? 1 : 34),
			      XV_Y, y_pos+7,
                              PANEL_SLIDER_WIDTH, 100,
                              PANEL_TICKS, 0,
                              PANEL_LABEL_STRING, label,
                              PANEL_DIRECTION, PANEL_HORIZONTAL,
                              PANEL_SLIDER_END_BOXES, FALSE,
                              PANEL_SHOW_RANGE, FALSE,
                              PANEL_SHOW_VALUE, TRUE,
                              PANEL_MIN_VALUE, 0,
                              PANEL_MAX_VALUE, specMax,
                              PANEL_VALUE, i,
			      PANEL_NOTIFY_LEVEL, PANEL_DONE,
			      PANEL_NOTIFY_PROC, setContoursAndRedraw,
                              NULL);
            contourButton[i] =
                xv_create(Spec_contourPopup->contourControls,
                          PANEL_BUTTON,
			  XV_X, xv_col(Spec_contourPopup->contourPopup,
				       (rstep) ? 28 : 61),
			  XV_Y, y_pos,
                          PANEL_LABEL_IMAGE, squareblack,
                          PANEL_ITEM_COLOR, i+COLOUROFFSET,
                          PANEL_NOTIFY_PROC, showRgbPopup,
                          PANEL_CLIENT_DATA, i,
                          NULL);
        }
        contourLevelDefaultSet();
    }
}

void initialiseColourmap(win)
Xv_opaque win;
{
    int i;
    int depth = (unsigned int) xv_get(win, XV_DEPTH);
    int visual_class = (int) xv_get(win, XV_VISUAL_CLASS);
    Xv_Screen screen = (Xv_Screen) xv_get(win, XV_SCREEN);
    static Xv_cmsdata *ocms_data;

    cms = (Cms) xv_find(screen, CMS, CMS_NAME, MYCMS,
                        XV_AUTO_CREATE, FALSE, 0);

    if ((depth < 8) || !((visual_class == StaticColor) ||
			 (visual_class == PseudoColor) ||
			 (visual_class == TrueColor) ||
			 (visual_class == DirectColor)))
    {
	monochrome = 1;
	initialiseMonochrome(win);
	return;
    }

    if (cms == XV_NULL)
    {
        for(i=0; i < MAXCONTOURS + COLOUROFFSET + 2; i++)
        {
            displayColour[i].red = 0;
            displayColour[i].green = 0;
            displayColour[i].blue = 0;
        }
        ocms_data = (Xv_cmsdata *) xv_get(win, WIN_CMS_DATA);

        i = (int) xv_get(win, WIN_BACKGROUND_COLOR);
 
        displayColour[Bg_index - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[Bg_index - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[Bg_index - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];
 
        i = (int) xv_get(win, WIN_FOREGROUND_COLOR);
 
        displayColour[Fg_index - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[Fg_index - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[Fg_index - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];

        if ((cms = xv_create(screen, CMS,
			     CMS_NAME, MYCMS,
			     XV_VISUAL, (Visual *)xv_get(win, XV_VISUAL),
			     CMS_TYPE, XV_DYNAMIC_CMS,
			     CMS_CONTROL_CMS, TRUE,
			     CMS_SIZE, NCOLOURS,
			     CMS_COLORS, displayColour,
			     NULL)) == XV_NULL)
	{
	    monochrome = 1;
	    initialiseMonochrome(win);
	    return;
	}
    }

    xv_set(win, WIN_CMS_NAME, MYCMS, WIN_CMS, cms, NULL);
    xv_set(win, WIN_BACKGROUND_COLOR, Bg_index, NULL);
    xv_set(win, WIN_FOREGROUND_COLOR, Fg_index, NULL);

    contourColourHues((Menu_item) 0, (Menu_generate) 0);
}

void
loadContourValueArray(contourValue)
int *contourValue;
{
    int k;

    contourValue[0] = 0;
    for(k=1; k<usedContours-1; k++)
    {
	contourValue[k] = xv_get(contourSlider[k], PANEL_VALUE);
	if (contourValue[k] <= contourValue[k-1])
	{
	    contourValue[k] = contourValue[k-1] + 1;
	    xv_set(contourSlider[k], PANEL_VALUE, contourValue[k], NULL);
	}
    }
    contourValue[usedContours-1] = specMax;
    return;
}

void
setContourArray()
{
    int i, j, k, t, contourValue[MAXCONTOURS], u, x, y, n;
    unsigned char *p;
    float specxstep, specystep;

    loadContourValueArray(contourValue);
    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	{
	    for(k=usedContours-1; k;)
		if (spec2d[i][j] > contourValue[--k])
		{
		    k++;
		    break;
		}
	    spec2dcontour[i][j] = (unsigned char)
		(((k == usedContours-1) ? MAXCONTOURS - 1 : k) + COLOUROFFSET);
	}

    specxstep = specx/64.0;
    specystep = specy/64.0;
    p = iconBits;

    if (cms == XV_NULL)
    {
	for(j=0; j<64; j++)
	{
	    u = 1;
	    *p = 0;
	    for(i=0; i<64; i++)
	    {
		n = t = 0;
		for(x=i*specxstep; x<(i+1)*specxstep; x++)
		    for(y=j*specystep; y<(j+1)*specystep; y++)
		    {
			t += spec2d[x][y];
			n++;
		    }
		t /= n;
		if (t > 0)
		    *p |= u;
		u <<= 1;
		if (u > 128)
		{
		    *++p = 0;
		    u = 1;
		}
	    }
	}
	if (!iconBitmap)
	    iconBitmap = xv_create(XV_NULL, SERVER_IMAGE,
				   SERVER_IMAGE_DEPTH, 1,
				   SERVER_IMAGE_X_BITS, iconBits,
				   XV_WIDTH, 64, XV_HEIGHT, 64,
				   NULL);
	else
	    xv_set(iconBitmap, SERVER_IMAGE_X_BITS, iconBits, NULL);
    }
    else
    {
	for(j=0; j<64; j++)
	    for(i=0; i<64; i++)
	    {
		n = t = 0;
		for(x=i*specxstep; x<(i+1)*specxstep; x++)
		    for(y=j*specystep; y<(j+1)*specystep; y++)
		    {
			t += spec2d[x][y];
			n++;
		    }
		t /= n;
		for(k=usedContours-1; k;)
		    if (t > contourValue[--k])
		    {
			k++;
			break;
		    }
		*p++ = ((k == usedContours-1) ? MAXCONTOURS-1 : k) +
		    COLOUROFFSET;
	    }
	if (!iconBitmap)
	    iconBitmap = xv_create(XV_NULL, SERVER_IMAGE,
				   SERVER_IMAGE_DEPTH, 8,
				   SERVER_IMAGE_X_BITS, iconBits, XV_WIDTH, 64,
				   XV_HEIGHT, 64, SERVER_IMAGE_COLORMAP, MYCMS,
				   NULL);
	else
	    xv_set(iconBitmap, SERVER_IMAGE_X_BITS, iconBits, NULL);
    }
    if (!iconIcon)
	iconIcon = xv_create(XV_NULL, ICON, ICON_IMAGE, iconBitmap, NULL);
    else
	iconIcon = xv_set(iconIcon, ICON_IMAGE, iconBitmap, NULL);
    xv_set(Spec_specWindow->specWindow, FRAME_ICON, iconIcon, NULL);
}


void setContoursAndRedraw()
{
    setContourArray();
    if (monochrome)
	setContourDithers(Spec_contourPopup->contourControls);
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
    if (usedContours == MAXCONTOURS)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    if (usedContours == 2)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
}

/*
 * Menu handler for `levelMenu (Linear...)'.
 */
Menu_item
spec_levelMenu_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		popupLinear(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `levelMenu (Pseudo-log...)'.
 */
Menu_item
spec_levelMenu_item2_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		popupPseudo(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*ARGSUSED*/
void levelSetLinear(item, event)
Panel_item item;
Event *event;
{
    int first, step, number;
    int i;

    if ((first = goodInteger(Spec_levelPopup->levelControls, (char *)
			     xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			     0, specMax, event)) < 0)
	return;
    if ((step = goodInteger(Spec_levelPopup->levelControls, (char *)
			    xv_get(Spec_levelPopup->step, PANEL_VALUE),
			    1, specMax, event)) < 1)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS,
			      event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first += step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first += step;
    }
    setContoursAndRedraw();
}

int goodInteger(item, s, min, max, event)
Panel_item item;
char *s;
int min, max;
Event *event;
{
    char *p, *q;
    int num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to an integer.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return(min - 1);
    }
    sscanf(s, "%d", &num);
    if (num < min || num > max)
    {
	p = malloc(strlen(s) + 50);
	sprintf(p, "\"%s\" is not in the range %d to %d.", s, min, max);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    return(num);
}

double goodFloat(item, s, min, max, event)
Panel_item item;
char *s;
double min, max;
Event *event;
{
    char *p, *q;
    float num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    if (*p == '.')
    {
	p++;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    if ((*p == 'e' || *p == 'E') && q != p)
    {
	p++;
	if (*p == '-')
	    p++;
	q = p;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to a number.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    sscanf(s, "%f", &num);
    if (min != max)
    {
	if (num < min || num > max)
	{
	    p = malloc(strlen(s) + 70);
	    sprintf(p, "\"%s\" is not in the range %f to %f.", s, min, max);
	    notice_prompt(item, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS, p, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    free(p);
	    return(min - fabs(min/10) - 1);
	}
    }
    else if (num == min)
    { 
	p = malloc(strlen(s) + 70);
	sprintf(p, "A value of \"%s\" is not acceptable here.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min);
    }
    return(num);
}


/*ARGSUSED*/
void levelSetPseudo(item, event)
Panel_item item;
Event *event;
{
    float first, step;
    int number;
    int i;

    if ((first = goodFloat(Spec_levelPopup->levelControls, (char *)
			   xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			   1.0, (double) specMax, event)) < 1.0)
	return;
    if ((step = goodFloat(Spec_levelPopup->levelControls, (char *)
			  xv_get(Spec_levelPopup->spacing, PANEL_VALUE),
			  1.0, (double) specMax, event)) < 1.0)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS, event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, TRUE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first *= step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, FALSE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first *= step;
    }
    setContoursAndRedraw();
}

/*
 * User-defined action for `levelMenu'.
 */
/*ARGSUSED*/
void
popupLinear(item, op)
	Menu_item	item;
	Menu_generate	op;
{

	xv_set(Spec_levelPopup->spacing, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->step, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetLinear, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL, "Set linear contours",
	       XV_SHOW, TRUE, NULL);

}

/*
 * User-defined action for `levelMenu'.
 */
/*ARGSUSED*/
void
popupPseudo(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	xv_set(Spec_levelPopup->step, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->spacing, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetPseudo, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL,
	       "Set pseudo-logarithmic contours", XV_SHOW, TRUE, NULL);
}


/*
 * Notify callback function for `contourButton'.
 */

/*ARGSUSED*/
void spec_specWindow_contourButton_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Spec_contourPopup->contourPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Spec_contourPopup->contourPopup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `palettes (Hues)'.
 */
Menu_item
spec_palettes_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourColourHues(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `palettes (Greyscale)'.
 */
Menu_item
spec_palettes_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourColourGreyscale(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `palettes (Heat)'.
 */
Menu_item
spec_palettes_item2_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourColourHeat(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `palettes (Reverse Greyscale)'.
 */
Menu_item
spec_palettes_item3_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourColourReverseGreyscale(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `palettes (Topographic)'.
 */
Menu_item
spec_palettes_item4_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourColourTopographic(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
contourColourGreyscale(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i;

    for(i=0; i<usedContours; i++)
	rawColour[i].red = rawColour[i].green = rawColour[i].blue =
	    255-i*255/usedContours;
    for(; i<MAXCONTOURS; i++)
	rawColour[i].red = rawColour[i].green = rawColour[i].blue = 0;
    rawColour[i].red = 255;
    rawColour[i].green = 192;
    rawColour[i].blue = 192;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
contourColourReverseGreyscale(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i;

    for(i=0; i<usedContours; i++)
	rawColour[i].red = rawColour[i].green = rawColour[i].blue =
	    i*255/usedContours;
    for(; i<MAXCONTOURS; i++)
	rawColour[i].red = rawColour[i].green = rawColour[i].blue = 255;
    rawColour[i].red = 255;
    rawColour[i].green = 192;
    rawColour[i].blue = 192;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
contourColourHues(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, j, k, l;

    rawColour[0].red = rawColour[0].green = rawColour[0].blue = 96;

    j = usedContours/5 + 1;
    for(i=1; i<usedContours/5; i++)
    {
	k = i*255/j;
	rawColour[i].red = 0;
	rawColour[i].green = k;
	rawColour[i].blue = 255;
    }
    j = usedContours*2/5 - i + 1;
    l = i;
    for(; i<usedContours*2/5; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 0;
	rawColour[i].green = 255;
	rawColour[i].blue = 255-k;
    }
    j = usedContours*3/5 - i + 1;
    l = i;
    for(; i<usedContours*3/5; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = k;
	rawColour[i].green = 255 - k;
	rawColour[i].blue = 0;
    }
    j = usedContours*4/5 - i + 1;
    l = i;
    for(; i<usedContours*4/5; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255;
	rawColour[i].green = k;
	rawColour[i].blue = 0;
    }
    j = usedContours - i;
    l = i;
    for(; i<usedContours; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255;
	rawColour[i].green = 255;
	rawColour[i].blue = k;
    }
    j = rawColour[i-1].red;
    k = rawColour[i-1].green;
    l = rawColour[i-1].blue;
    for(; i<MAXCONTOURS; i++)
    {
	rawColour[i].red = j;
	rawColour[i].green = k;
	rawColour[i].blue = l;
    }
    rawColour[i].red = 255;
    rawColour[i].green = 192;
    rawColour[i].blue = 192;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
contourColourHeat(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, j, k, l;

    j = usedContours/4 + 1;
    for(i=0; i<usedContours/4; i++)
    {
	k = i*255/j;
	rawColour[i].red = k;
	rawColour[i].green = rawColour[i].blue = 0;
    }
    j = usedContours*2/4 - i + 1;
    l = i;
    for(; i<usedContours*2/4; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255;
	rawColour[i].green = k;
	rawColour[i].blue = 0;
    }
    j = usedContours*3/4 - i + 1;
    l = i;
    for(; i<usedContours*3/4; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255;
	rawColour[i].green = 255;
	rawColour[i].blue = k;
    }
    j = usedContours - i;
    l = i;
    for(; i<usedContours; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255 - k;
	rawColour[i].green = 255;
	rawColour[i].blue = 255;
    }
    j = rawColour[i-1].red;
    k = rawColour[i-1].green;
    l = rawColour[i-1].blue;
    for(; i<MAXCONTOURS; i++)
    {
	rawColour[i].red = j;
	rawColour[i].green = k;
	rawColour[i].blue = l;
    }
    rawColour[i].red = 255;
    rawColour[i].green = 192;
    rawColour[i].blue = 192;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
contourColourTopographic(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, j, k, l;

    j = usedContours/8 + 1;
    for(i=0; i<usedContours/8; i++)
    {
	k = i*255/j;
	rawColour[i].red = 0;
	rawColour[i].green = 0;
	rawColour[i].blue = k;
    }
    j = usedContours*2/8 - i + 1;
    l = i;
    for(; i<usedContours*2/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 0;
	rawColour[i].green = k;
	rawColour[i].blue = 255;
    }
    j = usedContours*3/8 - i + 1;
    l = i;
    for(; i<usedContours*3/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 0;
	rawColour[i].green = 255;
	rawColour[i].blue = 255-k;
    }
    j = usedContours*4/8 - i + 1;
    l = i;
    for(; i<usedContours*4/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = k/4;
	rawColour[i].green = 255-3*k/4;
	rawColour[i].blue = 0;
    }
    j = usedContours*5/8 - i + 1;
    l = i;
    for(; i<usedContours*5/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 64+k/4;
	rawColour[i].green = 64+k/4;
	rawColour[i].blue = k/2;
    }
    j = usedContours*6/8 - i + 1;
    l = i;
    for(; i<usedContours*6/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 128;
	rawColour[i].green = 128+k/2;
	rawColour[i].blue = 128+k/2;
    }
    j = usedContours*7/8 - i + 1;
    l = i;
    for(; i<usedContours*7/8; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 128+k/2;
	rawColour[i].green = 255;
	rawColour[i].blue = 255;
    }
    j = usedContours - i;
    l = i;
    for(; i<usedContours; i++)
    {
	k = (i-l)*255/j;
	rawColour[i].red = 255;
	rawColour[i].green = 255-k;
	rawColour[i].blue = 255;
    }
    j = rawColour[i-1].red;
    k = rawColour[i-1].green;
    l = rawColour[i-1].blue;
    for(; i<MAXCONTOURS; i++)
    {
	rawColour[i].red = j;
	rawColour[i].green = k;
	rawColour[i].blue = l;
    }
    rawColour[i].red = 255;
    rawColour[i].green = 128;
    rawColour[i].blue = 0;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

void
brighten(colour, i, last, newColour, gam)
Xv_singlecolor *colour, *newColour;
int i, last;
double gam;
{
    double g = 1/gam;

    newColour += i;
    colour += i;
    for(; i<last; i++)
    {
	newColour->red = pow((double) colour->red/255.0, g)*255;
	newColour->green = pow((double) colour->green/255.0, g)*255;
	newColour->blue = pow((double) colour->blue/255.0, g)*255;
	newColour++;
	colour++;
    }
}

/*
 * Menu handler for `levelMenu (Default)'.
 */
Menu_item
spec_levelMenu_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		contourLevelDefault(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

void
contourLevelDefaultSet()
{
    static int defaultLevel[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
				      14, 15, 18, 22, 27, 32, 39, 46, 55, 66,
				      80, 95, 114, 140, 166, 200, 240};
    int i;

    usedContours = sizeof(defaultLevel) / sizeof(int) + 2;
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, defaultLevel[i-1],
	       XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, specMax,
	       XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
    }
}

/*
 * User-defined action for `levelMenu'.
 */
/*ARGSUSED*/
void
contourLevelDefault(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    contourLevelDefaultSet();
    setContoursAndRedraw();
}

static GC gc = NULL;
static struct windowPointList *windowPoints = NULL, *windowTail = NULL;
static int winX, winY;

void
repaintRectangle(display, xid, index, wincol, minx, miny, maxx, maxy, uselast)
Display *display;
Window xid;
unsigned long *index, wincol;
int minx, miny, maxx, maxy, uselast;
{
    int x, y, ystart, oldcont, newcont, i;
    static char lastredraw[MAXSPECX][MAXSPECY];
    static int lastlevels = -1;

    if (monochrome*usedContours != lastlevels)
    {
	forceRedraw = 1;
	lastlevels = monochrome*usedContours;
    }
    if (forceRedraw == 1 || (windowStatus == WINDOW_SET && forceRedraw != 2))
	uselast = 0;

    if (minx < 0)
	minx = 0;
    if (miny < 0)
	miny = 0;
    if (maxx > specx)
	maxx = specx;
    if (maxy > specy)
	maxy = specy;

    for(x = minx; x < maxx; x++)
	{
	    ystart = -1;
	    oldcont = -1;
	    for(y = miny; y < maxy; y++)
	    {
		switch (windowStatus)
		{
		case WINDOW_NONE:
		case WINDOW_SET:
		    newcont = spec2dcontour[x][y];
		    break;
		case WINDOW_OUTSIDE:
		    newcont = (window[x][y]) ? 127 : spec2dcontour[x][y];
		    break;
		case WINDOW_INSIDE:
		    newcont = (window[x][y]) ? spec2dcontour[x][y] : 127;
		    break;
		case WINDOW_ONLY:
		    newcont = (window[x][y]) ? MAXCONTOURS+COLOUROFFSET-1 :
			COLOUROFFSET;
		    break;
		}
		if (uselast && newcont == lastredraw[x][y])
		    newcont = -1;
		if (newcont != -1)
		    lastredraw[x][y] = newcont;
		if (newcont != oldcont && oldcont != -1)
		{
		    if (monochrome)
		    {
			i = ((oldcont-COLOUROFFSET)*(mag*mag)
			     +usedContours/2)/(usedContours-1);
			if (i > mag*mag)
			    i = mag*mag;
			fflush(stderr);
			XSetStipple(display, gc, (oldcont == 127) ? windither
				    : dither[i]);
		    }
		    else
			XSetForeground(display, gc, (oldcont == 127) ? wincol
				       : index[oldcont]);
		    XFillRectangle(display, xid, gc, x*mag, ystart*mag, mag,
				   (y-ystart)*mag);
		}
		if (newcont != oldcont || ystart == -1)
		{
		    oldcont = newcont;
		    ystart = y;
		}
	    }
	    if (oldcont != -1)
	    {
		if (monochrome)
		{
		    i = ((oldcont-COLOUROFFSET)*(mag*mag)+usedContours/2)
			/(usedContours-1);
		    if (i > mag*mag)
			i = mag*mag;
		    XSetStipple(display, gc, (oldcont == 127) ? windither
				: dither[i]);
		}
		else
		    XSetForeground(display, gc, (oldcont == 127) ? wincol :
				   index[oldcont]);
		XFillRectangle(display, xid, gc, x*mag, ystart*mag, mag,
			       (y-ystart)*mag);
	    }
	}
}

/*
 * Repaint callback function for `spectrum'.
 */
/*ARGSUSED*/
void
repaintSpectrum(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
    int i;
    XRectangle *r;
    XGCValues gc_val;
    unsigned long *index, wincol;
    struct windowPointList *p = windowPoints;
    char spectrum_label[80];

    switch(windowStatus)
    {
    case WINDOW_NONE:
	strcpy(spectrum_label,spectrumName);
	break;
    case WINDOW_INSIDE:
	sprintf(spectrum_label," %s inside wintest",spectrumName);
	break;
    case WINDOW_OUTSIDE:
	sprintf(spectrum_label, "%s outside wintest",spectrumName);
	break;
    case WINDOW_ONLY:
	sprintf(spectrum_label, "wintest on %s",spectrumName);
	break;
    case WINDOW_SET:
        sprintf(spectrum_label, "Setting wintest on %s",spectrumName);
        break;
    }

    xv_set(Spec_specWindow->specWindow, FRAME_LABEL, spectrum_label, NULL);

    XSetFunction(display, gc, GXcopy);

    if (rects)
    {
	XSetClipRectangles(display, gc, 0, 0, rects->rect_array,
			   rects->count, Unsorted);
    }
    else
    {
	gc_val.clip_mask = None;
	XChangeGC(display, gc, GCClipMask, &gc_val);
    }

    if (showGuidelines)
	drawGuidelines(display, xid, gc);

    if (monochrome)
    {
	XSetForeground(display, gc, BlackPixel(display,
					       DefaultScreen(display)));
	XSetBackground(display, gc, WhitePixel(display,
					       DefaultScreen(display)));
	XSetFillStyle(display, gc, FillOpaqueStippled);
	index = NULL;
    }
    else
    {
	XSetFillStyle(display, gc, FillSolid);
	index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	wincol = index[COLOUROFFSET+MAXCONTOURS];
    }

    if (rects)
    {
	i = rects->count;
	r = rects->rect_array;
	while(i--)
	{
	    repaintRectangle(display, xid, index, wincol, (r->x-1)/mag,
			     (r->y-1)/mag, (r->x+r->width+mag-2)/mag,
			     (r->y+r->height+mag-2)/mag, 0);
	    r++;
	}
    }
    else
    {
	repaintRectangle(display, xid, index, wincol, 0, 0, specx, specy, 1);
    }
    
    if (monochrome)
	XSetFillStyle(display, gc, FillSolid);

    if (windowStatus == WINDOW_SET && p != NULL)
    {
	if (monochrome)
	{
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	    XSetFunction(display, gc, GXxor);
	}
	else
	    XSetForeground(display, gc, wincol);

        while(p->next != NULL)
        {
            XFillRectangle(display, xid, gc, p->x*mag, p->y*mag, 4, mag);
            XDrawLine(display, xid, gc, p->x*mag+mag/2, p->y*mag+mag/2,
		      p->next->x*mag+mag/2, p->next->y*mag+mag/2);
            p = p->next;
        }
        XFillRectangle(display, xid, gc, p->x*mag, p->y*mag, mag, mag);

        if (windowTail != NULL)
        {
            XSetFunction(display, gc, GXxor);
	    if (!monochrome)
		XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1]
			       ^ index[COLOUROFFSET]);
            XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		      windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
        }

    }

    if (showGuidelines)
	drawGuidelines(display, xid, gc);
	
    forceRedraw = 0;

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Menu handler for `levelMenu (Add level)'.
 */
Menu_item
spec_levelMenu_item3_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		addLevel(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `levelMenu (Remove level)'.
 */
Menu_item
spec_levelMenu_item4_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		removeLevel(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `levelMenu'.
 */
/*ARGSUSED*/
void
addLevel(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (usedContours < MAXCONTOURS)
    {
	xv_set(contourSlider[usedContours-1], XV_SHOW, TRUE, NULL);
	xv_set(contourButton[usedContours-1], XV_SHOW, TRUE, NULL);
        usedContours++;
    }
    setContoursAndRedraw();
}

/*
 * User-defined action for `levelMenu'.
 */
/*ARGSUSED*/
void
removeLevel(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
    if (usedContours > 2)
    {
        usedContours--;
	xv_set(contourSlider[usedContours-1], XV_SHOW, FALSE, NULL);
	xv_set(contourButton[usedContours-1], XV_SHOW, FALSE, NULL);
    }
    setContoursAndRedraw();
}

/*
 * Menu handler for `palettes (Set Gamma...)'.
 */
Menu_item
spec_palettes_item5_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Spec_gammaPopup->gammaPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `displayGammaValue'.
 */

Panel_setting spec_gammaPopup_displayGammaValue_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	valueSetDisplayGamma(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * User-defined action for `displayGammaValue'.
 */
/*ARGSUSED*/
void valueSetDisplayGamma(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) < 0.1)
	return;
    xv_set(Spec_gammaPopup->displayGammaSlider, PANEL_VALUE, (int) num*100,
	   NULL);
    displayGamma = num;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * User-defined action for `displayGammaSlider'.
 */
/*ARGSUSED*/
void
sliderSetDisplayGamma(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    char buffer[6];

    displayGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", displayGamma);
    xv_set(Spec_gammaPopup->displayGammaValue, PANEL_VALUE, buffer, NULL);
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * Notify callback function for `printoutGammaValue'.
 */
Panel_setting
spec_gammaPopup_printoutGammaValue_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	valueSetPrintoutGamma(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * User-defined action for `printoutGammaValue'.
 */
/*ARGSUSED*/
void
valueSetPrintoutGamma(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) < 0.1)
	return;
    xv_set(Spec_gammaPopup->printoutGammaSlider, PANEL_VALUE, (int) num*100,
	   NULL);
    printoutGamma = num;
}

/*
 * User-defined action for `printoutGammaSlider'.
 */
/*ARGSUSED*/
void
sliderSetPrintoutGamma(item, value, event)
Panel_item item;
int value;
Event *event;
{
    char buffer[6];

    printoutGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", printoutGamma);
    xv_set(Spec_gammaPopup->printoutGammaValue, PANEL_VALUE, buffer, NULL);
}

/*
 * Notify callback function for `displayGammaSlider'.
 */
void
spec_gammaPopup_displayGammaSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	sliderSetDisplayGamma(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `printoutGammaSlider'.
 */
void
spec_gammaPopup_printoutGammaSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	sliderSetPrintoutGamma(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `windowMenu (Show without window)'.
 */
Menu_item
spec_windowMenu_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		showWithoutWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `windowMenu (Show inside window)'.
 */
Menu_item
spec_windowMenu_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		showInsideWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `windowMenu (Show outside window)'.
 */
Menu_item
spec_windowMenu_item2_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		showOutsideWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `windowMenu (Show window)'.
 */
Menu_item
spec_windowMenu_item3_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		showWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `windowMenu (Set window)'.
 */
Menu_item
spec_windowMenu_item4_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		setWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
setWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    Xv_opaque menu;

/* window menu */
    menu = xv_get(Spec_specWindow->windowButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, FALSE, NULL);

/* slice menu 16/1/95 */
    menu = xv_get(Spec_specWindow->sliceButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, TRUE, NULL);

    windowStatus = WINDOW_SET;
    forceRedraw = 2;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);

    if (windowPoints != NULL)
    {
        freeWindowList(windowPoints);
        windowPoints = NULL;
    }
    windowTail = NULL;
    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "LEFT: add point   MIDDLE: delete last point   \
RIGHT: finish",
	   FRAME_RIGHT_FOOTER, "", NULL);
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
showInsideWindow(item, op)
Menu_item	item;
Menu_generate	op;
{

    windowStatus = WINDOW_INSIDE;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
showOutsideWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
	
    windowStatus = WINDOW_OUTSIDE;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
showWindow(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
    windowStatus = WINDOW_ONLY;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
clearWindow(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, j;

    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	    window[i][j] = 0;

    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
}

/*
 * Menu handler for `windowMenu (Clear window)'.
 */
Menu_item
spec_windowMenu_item5_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		clearWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
showWithoutWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
	
    windowStatus = WINDOW_NONE;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);
}

/*
 * Menu handler for `windowMenu (Abort set window)'.
 */
Menu_item
spec_windowMenu_item6_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		abortSetWindow(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `windowMenu'.
 */
/*ARGSUSED*/
void
abortSetWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    Xv_opaque menu;

/* window menu */    
    menu = xv_get(Spec_specWindow->windowButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, TRUE, NULL);

/* slice menu 16/1/95 */
    menu = xv_get(Spec_specWindow->sliceButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, FALSE, NULL);

    windowStatus = WINDOW_OUTSIDE;
    forceRedraw = 1;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);

    if (windowPoints != NULL)
    {
        freeWindowList(windowPoints);
        windowPoints = NULL;
    }
    windowTail = NULL;
    Slicing &= (~PROJECTION);
    
    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "Window set abandoned",
	   FRAME_RIGHT_FOOTER, (Slicing & SLICING) ? "Slicing on":"", NULL);
}

/*
 * Event callback function for `spectrum'.
 */
Notify_value
rubberBand(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    unsigned long *index;
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    int move = ((event_action(event) == ACTION_SELECT ||
		 event_action(event) == ACTION_ADJUST ||
		 event_action(event) == ACTION_MENU) &&
		event_is_down(event)) || event_action(event) == LOC_MOVE ||
		    event_action(event) == LOC_DRAG,
		    newX, newY;

    static char coordinates[32];

    if (move)
    {
	newX = (event_x(event)-1)/mag;
	newY = (event_y(event)-1)/mag;

	if (newX < specx && newY < specy && newX >= 0 && newY >= 0)
	{
	    sprintf(coordinates, "(%d, %d) = %d", newX, specy-newY-1,
		    spec2d[newX][newY]);
	    xv_set(Spec_specWindow->coordinates,
		   PANEL_LABEL_STRING, coordinates, NULL);
	}
    }

    if (gc == NULL)
	gc = XCreateGC(display, xid, 0, NULL);

    XSetClipMask(display, gc, None);

    if (windowStatus == WINDOW_SET && move)
    {
	if (monochrome)
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	else
	    index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	
        if (windowTail != NULL)
        {
	    if (!monochrome)
		XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1]
			       ^ index[COLOUROFFSET]);
            XSetFunction(display, gc, GXxor);
            XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		      windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
            XSetFunction(display, gc, GXcopy);
        }
	
	if (!monochrome)
	    XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS]);
	
        winX = newX;
        winY = newY;
    }

    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    if (event_action(event) == ACTION_SELECT)
    {
	newPoint(win, event, arg, type);
    }
    
    if (event_action(event) == ACTION_ADJUST)
    {
	deletePoint(win, event, arg, type);
    }
    
    if (event_action(event) == ACTION_MENU)
    {
	closeWindow(win, event, arg, type);
    }
    
    /* gxv_end_connections */
    
    if (windowStatus == WINDOW_SET && windowTail != NULL && move)
    {
	if (monochrome)
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	else
	{
	    index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	    XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1] ^
			   index[COLOUROFFSET]);
	}
	XSetClipMask(display, gc, None);
	XSetFunction(display, gc, GXxor);
	XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		  windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
	XSetFunction(display, gc, GXcopy);
    }
    

    /*** 16/1/95 ***/
    if ( (Slicing & SLICING) && windowStatus != WINDOW_SET) {
	if (event_is_down(event) && event_action(event) ==  ACTION_SELECT)
	    do_simple_slice(event, newX, specy-newY-1);
    }

    return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*
 * User-defined action for `spectrum'.
 */
/*ARGSUSED*/
void
newPoint(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);

    if (windowStatus != WINDOW_SET || !event_is_down(event))
        return;

    if (monochrome)
	XSetFunction(display, gc, GXxor);
    XFillRectangle(display, xid, gc, winX*mag, winY*mag, mag, mag);
    if (windowTail != NULL)
    {
        XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		  windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
        windowTail = windowTail->next = (struct windowPointList *)
            malloc(sizeof(struct windowPointList));
    }
    else
        windowTail = windowPoints = (struct windowPointList *)
            malloc(sizeof(struct windowPointList));
    windowTail->x = winX;
    windowTail->y = winY;
    windowTail->next = NULL;
}

/*
 * User-defined action for `spectrum'.
 */
/*ARGSUSED*/
void
deletePoint(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Xv_xrectlist rects;
    struct windowPointList *p = windowPoints;

    if (windowStatus != WINDOW_SET || !event_is_down(event) ||
	windowTail == NULL)
        return;


    if (p == windowTail)
    {
	rects.count = 1;
	rects.rect_array->x = windowTail->x*mag;
	rects.rect_array->y = windowTail->y*mag;
	rects.rect_array->width = mag;
	rects.rect_array->height = mag;

	free(windowPoints);
	windowPoints = NULL;
	windowTail = NULL;
	p = NULL;
    }
    else
    {
	rects.count = 1;
	while(p->next != windowTail)
	    p = p->next;
	rects.rect_array->x = ((windowTail->x < p->x) ? windowTail->x :
			       p->x)*mag;
	rects.rect_array->y = ((windowTail->y < p->y) ? windowTail->y :
			       p->y)*mag;
	rects.rect_array->width = ((windowTail->x > p->x) ? windowTail->x :
				   p->x)*mag - rects.rect_array->x + mag;
	rects.rect_array->height = ((windowTail->y > p->y) ? windowTail->y :
				    p->y)*mag - rects.rect_array->y+mag;

	free(windowTail);
	p->next = NULL;
	windowTail = NULL;
    }

    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), &rects);

    windowTail = p;
}

/*
 * User-defined action for `spectrum'.
 */
/*ARGSUSED*/
void
closeWindow(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Pixmap pix;
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    XPoint *points;
    int ps = 0, i, j;
    struct windowPointList *p = windowPoints;
    XImage *filled;
    GC gc1;
    
    if (windowStatus != WINDOW_SET || !event_is_down(event))
        return;

    if (windowPoints == NULL || windowTail == windowPoints)
    {
	abortSetWindow(XV_NULL, NULL);
	return;
    }

    while(p)
    {
	ps++;
	p = p->next;
    }

    points = (XPoint *) malloc(sizeof(XPoint) * ps);

    ps = 0;

    p = windowPoints;

    while(p)
    {
	points[ps].x = p->x;
	points[ps++].y = p->y;
	p = p->next;
    }

    pix = XCreatePixmap(display, xid, specx, specy, 1);

    gc1 = XCreateGC(display, pix, 0, NULL);

    XSetForeground(display, gc1, 0);

    XSetFillStyle(display, gc1, FillSolid);
    XFillRectangle(display, pix, gc1, 0, 0, specx, specy);

    XSetForeground(display, gc1, 1);
    XSetFillRule(display, gc1, WindingRule);

    XFillPolygon(display, pix, gc1, points, ps, Complex, CoordModeOrigin);
    XDrawLines(display, pix, gc1, points, ps, CoordModeOrigin);
    XDrawLine(display, pix, gc1, windowPoints->x, windowPoints->y,
              windowTail->x, windowTail->y);

    free(points);
    XFreeGC(display, gc1);

    filled = XGetImage(display, pix, 0, 0, specx, specy, 1, XYPixmap);

    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	    window[i][j] = (unsigned char) XGetPixel(filled, i, j);

    XDestroyImage(filled);
    XFreePixmap(display, pix);

    if (Slicing & PROJECTION) {
	  do_projection(event);
	  Slicing &= (~PROJECTION);
    }
    else
	  store_window();

    RRP(0);
    abortSetWindow(XV_NULL, NULL);

    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "Window closed and stored",
	   FRAME_RIGHT_FOOTER, (Slicing & SLICING) ? "Slicing on":"", NULL);
}

void freeWindowList(p)
struct windowPointList *p;
{
    if (p->next != NULL)
        freeWindowList(p->next);
    free(p);
}

/*
 * Notify callback function for `redSlider'.
 */
void
spec_rgbPopup_redSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	changeRed(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `redSlider'.
 */
/*ARGSUSED*/
void
changeRed(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].red = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * Notify callback function for `greenSlider'.
 */
void
spec_rgbPopup_greenSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	changeGreen(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `greenSlider'.
 */
/*ARGSUSED*/
void
changeGreen(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].green = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*
 * Notify callback function for `blueSlider'.
 */
void
spec_rgbPopup_blueSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	changeBlue(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `blueSlider'.
 */
/*ARGSUSED*/
void
changeBlue(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].blue = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

/*ARGSUSED*/
void
showRgbPopup(item, event)
Panel_item item;
Event *event;
{
    int i;

    if (monochrome)
	return;
    i = (int) xv_get(item, PANEL_CLIENT_DATA);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[i].red, NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[i].green, NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[i].blue, NULL);
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, TRUE, NULL);
    rgbColour = i;
}

#include "sort_def.h"
#include "sort_mem.h"
static int win2d;
/*ARGSUSED*/
Notify_value
sort_sigusr2_handler(client,sig,mode)
      Notify_client    client;
      int              sig;
      Notify_signal_mode              mode;
{
/* receive this signal from sort process to display 2d spectra */
      int spec_type;
      char buf[BUFSIZ];
      register int x, y, data;

      if (debuglevel >= 3)
	    fprintf(stderr,"sort_spec2d: received SIGUSR2\n");
      
/* open if in iconic state and set window on top */
      xv_set(Spec_specWindow->specWindow, FRAME_CLOSED, FALSE, NULL);
      wmgr_top(Spec_specWindow->specWindow);
      
/* read data from .SORT_pipe */
      if (read_from_pipe(".SORT_pipe") == SORT_FAIL) {
	    fprintf(stderr,"sort_spec2d: Read from sort process failed");
	    return NOTIFY_DONE;
      }
      if ( sscanf(pshm->com_str,"%s %d",buf,&spec_type) != 2) {
	    fprintf(stderr,"sort_spec2d: Decoding of display spectrum command failed");
	    return NOTIFY_DONE;
      }
      if (spec_type == 2) {
	    xv_set(Spec_specWindow->windowButton,PANEL_INACTIVE,TRUE,NULL);
	    win2d = -1;
      }
      else if (spec_type == 3) {
	    win2d = pshm->win2d;
	    xv_set(Spec_specWindow->windowButton,PANEL_INACTIVE,FALSE,NULL);
      }
      else {
	    fprintf(stderr,"sort_spec2d asked to display non 2d spectrum!");
	    return NOTIFY_DONE;
      }

/* clear down old spectrum */
      for(x=0; x<MAXSPECX; x++)
	    for(y=0; y<MAXSPECY; y++)
		  spec2d[x][y] = 0;
      windowStatus = WINDOW_NONE;
      specMax = 0;

      strcpy(spectrumName,pshm->name);
      specx = (pshm->size > MAXSPECX) ? MAXSPECX : pshm->size;
      specy = specx; /* square spectra to start off with */
      
/* spec2d[0][0] is the pixel on top left hand corner of the display */
/* display still adheres to x=0, y=0 being in the bottom left hand corner however */
      for(x=0; x < specx ;x++)
	    for(y=0; y < specy ; y++) {
		  data = pshm->array[x*specy + (specy-1-y)];
		  spec2d[x][y] = data;
		  specMax = MAX(specMax, data);
	    }
      
      if (pshm != NULL)
	  xv_set(Spec_printerPopup->printTitle, PANEL_VALUE, pshm->name, NULL);
      spectrumLoaded();
      setContoursAndRedraw();

      return NOTIFY_DONE;
}
/***  16/1/95 ***/
void
store_window()
{
    if (debuglevel >= 3)
	fprintf(stderr,"sort_spec2d: storing 2d window\n");

    if (!sort_window)
	return;

    if (store_spectrum(".SORT_pipe_W", "WINDOW 4", SORT_TRUE) == -1) {
	  fprintf(stderr,"sort_spec2d: failure to write out window\n");
	  return;
    }
      
/* tell the sort process to read the window and store it */
    (void) kill(getppid(),SIGUSR2);
      
    return;
}

/*ARGSUSED*/
Notify_value
destroy_func(client,sig,mode)
      Notify_client    client;
      int              sig;
      Notify_signal_mode              mode;
{
      if (DBX_val > 3) fprintf(stderr,"sort_spec2d: received SIGTERM\n");
/*      xv_destroy_safe(Spec_specWindow->specWindow); */
      exit(0); 
#ifdef lint
      return XV_OK;
#endif
}

/*
 * Notify callback function for `printButton'.
 */
/*ARGSUSED*/
void
spec_specWindow_printButton_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Spec_printerPopup->printerPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Spec_printerPopup->printerPopup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `sliceMenu (Advanced projection)'.
 */
/*ARGSUSED*/
Menu_item
spec_slicingMenu_item3_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		xv_set(Spec_projectPopup->projectPopup, FRAME_CMD_PUSHPIN_IN,
		       TRUE, NULL);
		xv_set(Spec_projectPopup->projectPopup, XV_SHOW, TRUE, NULL);
		if (!showGuidelines)
		{
		    showGuidelines = 1;
		    drawGuidelines((Display *)
			  XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
				   (Window)
	       xv_get(canvas_paint_window(Spec_specWindow->spectrum), XV_XID),
				   gc);
		}
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
	
}

/*
 * Notify callback function for `doPrint'.
 */
void
spec_printerPopup_doPrint_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	printSpectrum(item, event);
	
	/* gxv_end_connections */

}

void
psstring(fp, s)
FILE *fp;
char *s;
{
    if (putc('(', fp) == EOF)
        return;
    while(*s != '\0')
    {
	switch(*s)
	{
	case '(':
	case ')':
	case '\\':
	    if (putc('\\', fp) == EOF)
                return;
	    /* FALL THROUGH */
	default:
	    if (putc(*s, fp) == EOF)
                return;
	    break;
	}
	s++;
    }
    if (putc(')', fp) == EOF)
        return;
    if (putc('\n', fp) == EOF)
        return;
}

float tickspacing(range)
double range;
{
    float ts;

    ts = pow(10.0, floor(log10(range)))*2;
    if (range/ts < 3)
	ts /= 2;
    if (range/ts < 3)
	ts /= 2;
    if (range/ts < 3)
	ts /= 2.5;
    if (range/ts < 3)
	ts /= 2;
    return(ts);
}

/*
 * Because of the nofitier we can't use popen as that calls system which calls
 * wait. So we have to fork() before we can system()
 */
FILE *
mypopen(command, type)
char *command, *type;
{
    int fd;
    FILE *fp;

    if ((fd = mypopenfd(command, type)) == -1)
	return(NULL);

    fp = fdopen(fd, type);

    return(fp);
}

int mypopenfd(command, type)
char *command;
char *type;
{
    int fd[2], i;
    pid_t pid;

    if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd) == -1)
	return(-1);
    switch(pid = fork())
    {
    case -1:
	close(fd[0]);
	close(fd[1]);
	return(-1);
    case 0:
	close(fd[0]);
        /* Decide which descriptor to connect to pipe, and which to leave
           as parent */
        switch(*type)
        {
        case 'r':
            dup2(fd[1], 1);
            break;
        case 'w':
            dup2(fd[1], 0);
            break;
        default:
            dup2(fd[1], 0);
            dup2(fd[1], 1);
            break;
        }
        /*
         * As recommended in xview programming manual, close all file
         * descriptors and reset all signals.
         */
	for(i=getdtablesize(); i>2; i--)
	    close(i);
	for(i=NSIG+1; i--; )
	    signal(i, SIG_DFL);
	/* Let sh worry about parsing the command line */
	_exit(system(command));
	break;
    default:
	close(fd[1]);
	break;
    }

    /* Setup child catcher */

    notify_set_wait3_func(sort_client, notify_default_wait3, pid);

    return(fd[0]);
}

/*ARGSUSED*/
Notify_value
blankfunc(client, sig, when)
Notify_client client;
int sig;
Notify_signal_mode when;
{
    return(NOTIFY_DONE);
}

/*
 * User-defined action for `doPrint'.
 */
/*ARGSUSED*/
void
printSpectrum(item, event)
	Panel_item	item;
	Event		*event;
{
    FILE *fp;
    float xgain, ygain, xoffset, yoffset, xt, yt, xf, yf;
    int i, j, v, contourValue[MAXCONTOURS], palette, dest, top, scale;

    if ((xgain = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printXGain, PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;
    if ((ygain = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printYGain, PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;
    if ((xoffset = goodFloat(Spec_printerPopup->printerPopup, (char *)
			     xv_get(Spec_printerPopup->printXOffset,
				    PANEL_VALUE),
			     -1e37, 1e37, event)) < -1e37)
	return;
    if ((yoffset = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printYOffset,
				  PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;

    palette = xv_get(Spec_printerPopup->printerPalette, PANEL_VALUE);

    switch(dest = xv_get(Spec_printerPopup->printTo, PANEL_VALUE))
    {
    case 0: /* print to command */
        if ((fp = mypopen((char *)
			  xv_get(Spec_printerPopup->printString, PANEL_VALUE),
                          "w")) == NULL)
        {
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to open output pipe. Error was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
        }
        /*
         * Ignore SIGPIPE signals, we'll detect those by looking for errors
         * returned by writing.
         */
        notify_set_signal_func(sort_client, blankfunc, SIGPIPE, NOTIFY_ASYNC);
	break;
    default: /* print to file */
	if ((fp = fopen((char *) xv_get(Spec_printerPopup->printFilename, PANEL_VALUE),
			"w")) == NULL)
	{
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Error whilst opening output file. Error was :",
			  ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
	}
	break;
    }
    
    top = 105 + 15*usedContours;
    if (top < 495)
	top = 495;
    if (*((char *) xv_get(Spec_printerPopup->printTitle, PANEL_VALUE)) != '\0'
	&& top < 580)
	top=580;
    if (*((char *) xv_get(Spec_printerPopup->printSubtitle, PANEL_VALUE))
	!= '\0' && top < 545)
	top=545;

    scale = xv_get(Spec_printerPopup->printScaleSlider, PANEL_VALUE);

    fputs("\
%!PS-Adobe-2.0\n\
%%Title: sunsort\n\
%%Creator: sort_spec2d\n", fp);
    if (!ferror(fp))
    {
	if (dest == 2)
	    fprintf(fp, "%%%%BoundingBox: %d %d %d %d\n", 30*scale/100,
		    40*scale/100, 580*scale/100, top*scale/100);
	else
	    fputs("%%Pages: 1\n", fp);
    }
    if (!ferror(fp))
	fputs("\
%%EndComments\n\
/spec2ddict 64 dict def spec2ddict begin\n\
/pixline 128 string def\n", fp);
    if (palette == 2)
    {
	if (!ferror(fp))
	    fprintf(fp, "/colline 384 string def\n/table %d string def\n",
		    MAXCONTOURS*3);
	if (!ferror(fp))
	    fputs("\
% Supply colorimage for printers which don't support it. This version from\n\
% xv which got it from xwd2ps, though I've changed the red, green and blue\n\
% multipliers to match the values in the C code\n\
/colorimage where {pop} {/colortogray {/rgbdata exch store rgbdata length 3\n\
idiv /npixls exch store /rgbindx 0 store /grays npixls string store 0 1\n\
npixls 1 sub {grays exch rgbdata rgbindx get 299 mul rgbdata rgbindx 1 add\n\
get 587 mul rgbdata rgbindx 2 add get 114 mul add add 1000 idiv put /rgbindx\n\
rgbindx 3 add store} for grays} bind def /mergeprocs {dup length 3 -1 roll\n\
dup length dup 5 1 roll 3 -1 roll add array cvx dup 3 -1 roll 0 exch\n\
putinterval dup 4 2 roll putinterval} bind def /colorimage {pop\n\
pop {colortogray} mergeprocs image} bind def} ifelse\n", fp);
    }
    else
	if (!ferror(fp))
	    fprintf(fp, "/table %d string def\n", MAXCONTOURS);
    if (!ferror(fp))
	fputs("\
/reencodeISO {dup dup findfont dup length dict begin {1 index\n\
/FID ne {def} {pop pop} ifelse } forall /Encoding ISOLatin1Encoding def\n\
currentdict end definefont def } def\n\
/ISOLatin1Encoding [\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright\n\
/parenleft/parenright/asterisk/plus/comma/minus/period/slash\n\
/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon\n\
/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N\n\
/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright\n\
/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m\n\
/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n\
/.notdef/dotlessi/grave/acute/circumflex/tilde/macron/breve\n\
/dotaccent/dieresis/.notdef/ring/cedilla/.notdef/hungarumlaut\n\
/ogonek/caron/space/exclamdown/cent/sterling/currency/yen/brokenbar\n\
/section/dieresis/copyright/ordfeminine/guillemotleft/logicalnot\n\
/hyphen/registered/macron/degree/plusminus/twosuperior/threesuperior\n\
/acute/mu/paragraph/periodcentered/cedilla/onesuperior/ordmasculine\n\
/guillemotright/onequarter/onehalf/threequarters/questiondown\n\
/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla\n\
/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex\n\
/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis\n\
/multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute\n\
/Thorn/germandbls/agrave/aacute/acircumflex/atilde/adieresis\n\
/aring/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave\n\
/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute/ocircumflex\n\
/otilde/odieresis/divide/oslash/ugrave/uacute/ucircumflex/udieresis\n\
/yacute/thorn/ydieresis] def\n\
/Times-Roman reencodeISO\n\
/Times-Bold reencodeISO\n\
/Times-Italic reencodeISO\n\
/Times-BoldItalic reencodeISO\n\
/Helvetica reencodeISO\n\
/Helvetica-Bold reencodeISO\n\
/Helvetica-Oblique reencodeISO\n\
/Helvetica-BoldOblique reencodeISO\n\
/D {load def} def\n\
/m /moveto D\n\
/l /lineto D\n\
/rm /rmoveto D\n\
/rl /rlineto D\n\
/s /stroke D\n\
/c /closepath D\n\
/cp /currentpoint D\n\
/sw /stringwidth D\n\
/ss {scalefont setfont} def\n\
/css {findfont dup /curfont exch def cursize ss} def\n\
/ccss {curfont cursize ss} def\n\
/o0 {/offset 0 def} def\n\
/o1 {/offset 128 def} def\n\
/css0 {/hbarmove exch def css o0} def\n\
/ch 1 string def\n\
/fs {/cursize cursize 0.7 mul def ccss} def\n\
/actarray 256 array def\n\
0 1 255 {actarray exch {} put} for\n\
actarray 43 {/cursize cursize 0.7 div def ccss} put\n\
actarray 45 {fs} put\n\
actarray 48 {/Times-Roman {0.33 -0.02} css0} put\n\
actarray 49 {/Times-Bold {0.33 -0.02} css0} put\n\
actarray 50 {/Times-Italic {0.33 0.05} css0} put\n\
actarray 51 {/Times-BoldItalic {0.33 0.05} css0} put\n\
actarray 52 {/Helvetica {0.4 -0.02} css0} put\n\
actarray 53 {/Helvetica-Bold {0.4 -0.02} css0} put\n\
actarray 54 {/Helvetica-Oblique {0.4 0.06} css0} put\n\
actarray 55 {/Helvetica-BoldOblique {0.4 0.08} css0} put\n\
actarray 56 {/Symbol {1 0} css0} put\n\
actarray 57 {/Symbol /hbarmove {1 0} def css o1} put\n\
actarray 67 {o1} put\n\
actarray 71 {gsave /gdepth gdepth 1 add def} put\n\
actarray 78 {/cursize initsize def ccss 0 baseline cp exch pop sub rm} put\n\
actarray 83 {0 cursize 2 div rm fs} put\n\
actarray 85 {/underline true def} put\n\
actarray 90 {/ZapfDingbats /hbarmove {1 0} def css o1} put\n\
actarray 92 {(\\\\) action} put\n\
actarray 99 {o0} put\n\
actarray 103 {gdepth 0 gt {grestore /gdepth gdepth 1 sub def} if} put\n\
actarray 104 {/cursize cursize /underline underline /underline false def\n\
gsave hbarmove cursize mul exch cursize mul rm fs 10 rotate (-) action\n\
grestore def def ccss (h) action} put\n\
actarray 115 {0 cursize 2 div neg rm fs} put\n\
actarray 117 {/underline false def} put\n\
actarray 122 {/ZapfDingbats {1 0} css0} put\n\
/fproc {/initsize exch def /cursize initsize def /underline false def\n\
/command false def /baseline cp exch pop def /Helvetica {0.4 0} css0 /gdepth\n\
0 def {command {actarray exch get exec /command false def} {dup 92 eq\n\
{/command true def pop} {offset add ch exch 0 exch put ch action} ifelse}\n\
ifelse} forall gdepth {grestore} repeat} def\n\
/fshow {/action {underline {cursize 10 div setlinewidth dup sw pop\n\
gsave 0 cursize 5 div neg rm 0 rl s grestore} if show} def fproc} def\n\
/cfshow {2 copy cp pop /left exch def gsave /action {sw pop 0 rm} def fproc\n\
cp pop left sub 2 div neg grestore 0 rm fshow} def\n\
/rshow {dup sw pop neg dup 0 rm exch show 0 rm} def\n\
/format {dup dup 0 eq {pop (0.00) cvs rshow} {abs log floor cvi dup dup 6\n\
le exch 0 ge and {pop 10 string cvs rshow} {dup 5 string cvs 3 1 roll 10\n\
exch exp div 100 mul 0.5 add floor 100 div 0.001 add 5 string cvs 0 4\n\
getinterval exch 0 5 rm currentfont dup 0.66666 ss exch\n\
rshow setfont 0 -5 rm (x10) rshow rshow } ifelse} ifelse} def\n\
/tick {/d exch def /L exch def {-10 exch h mul m 10 0 rl w 0 rm 10 0 rl\n\
w 25 add neg 0 rm L format s /L L d add def} for /d exch def /L exch def {w\n\
mul -10 m 0 10 rl 0 h rm 0 10 rl 0 h 30 add neg rm L pixline cvs dup\n\
sw neg exch neg 2 div exch rm show s /L L d add def} for {-5 exch h\n\
mul m 5 0 rl w 0 rm 5 0 rl} for {w mul -5 m 0 5 rl 0 h rm 0 5 rl} for} def\n\
/dumptwo {gsave dup scale table currentfile exch readhexstring pop pop\n\
currentfile pixline readline pop pop dup 1 add dup table exch 0 exch", fp);
    if (palette == 2)
	if (!ferror(fp))
	    fputs(" 3 mul", fp);
    if (!ferror(fp))
	fputs("\n\
getinterval exch 1 exch 8 [0.03333 0 0 0.06667 -2 -6.6667] {}", fp);
    if (!ferror(fp))
    {
	if (palette == 2)
	    fputs("false 3\ncolor", fp);
	else
	    putc('\n', fp);
    }
    if (!ferror(fp))
	fputs("\
image 0 setgray 0 setlinewidth /Helvetica findfont 10 ss -1 0 {15 mul\n\
100 add dup 60 exch newpath m 30 0 rl 0 15 rl -30 0 rl c s 9 add 55 exch m\n\
format} for 185 100 translate 1 setlinewidth /w 384 def /h 384 def tick w 2\n\
div 420 m 18 cfshow w 2 div 450 m 24 cfshow 90 rotate h 2 div 65 m 24 cfshow\n\
-90 rotate w 2 div -50 m 24 cfshow\n", fp);
    if (!ferror(fp))
	fprintf(fp, "%d %d 8 [%f 0 0 %f 0 0] {currentfile pixline readline\n",
		specx, specy, specx/384.0, specy/384.0);
    if (!ferror(fp))
    {
	if (palette == 2)
	    fputs("\
pop length dup 1 sub 0 exch 1 exch {dup pixline exch get table exch 48 sub\n\
3 mul 3 getinterval exch 3 mul exch colline 3 1 roll putinterval} for\n\
colline exch 0 exch 3 mul getinterval} false 3 colorimage", fp);
	else
	    fputs("\
pop dup length 1 sub 0 exch 1 exch {dup pixline exch get table exch 48 sub\n\
get pixline 3 1 roll put} for} image", fp);
    }
    if (!ferror(fp))
	fputs("\n\
0 0 0 h w h w 0 m l l l c s grestore} def\n\
end\n\
%%EndProlog\n\
%%Page: 1 \n\
spec2ddict begin\n", fp);
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printXLabel,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printYLabel,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printTitle,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printSubtitle,
                                     PANEL_VALUE));

    xt=tickspacing(specx*xgain);
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001\n", (ceil(xoffset/xt*10)*xt/10-xoffset)
                /xgain/specx, xt/specx/xgain/10);
    yt=tickspacing(specy*ygain);
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001\n", (ceil(yoffset/yt*10)*yt/10-yoffset)
                /ygain/specy, yt/specy/ygain/10);
    xf=ceil(xoffset/xt)*xt;
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001 %f %f\n", (xf-xoffset)/xgain/specx,
                xt/specx/xgain, xf, xt);
    yf=ceil(yoffset/yt)*yt;
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001 %f %f\n", (yf-yoffset)/ygain/specy,
                yt/specy/ygain, yf, yt);
    loadContourValueArray(contourValue);
        for(i=0; i<usedContours-1; i++)
	    if (!ferror(fp))
		fprintf(fp, "%d\n", contourValue[i]);
    if (!ferror(fp))
	fprintf(fp, "%d\n", specMax);
    if (!ferror(fp))
        fprintf(fp, "%d %f\ndumptwo\n", usedContours-1, scale/100.0);
    j = 0;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, printoutGamma);
    for(i=0; i<MAXCONTOURS; i++)
    {
	v = (i >= usedContours-1) ? MAXCONTOURS-1 : i;
	switch(palette)
	{
	case 0: /* White to black */
	    fprintf(fp, "%02x", (i >= usedContours) ? 0 :
		    (int) (255-i*255.0/(usedContours-1)));
	    j++;
	    break;
	case 1: /* Greyscale version of display */
	    fprintf(fp, "%02x", (int) (displayColour[v].red*0.299 +
				       displayColour[v].green*0.587 +
				       displayColour[v].blue*0.114 + 0.5));
	    j++;
	    break;
	case 2: /* Colour */
	    fprintf(fp, "%02x%02x%02x", displayColour[v].red,
		    displayColour[v].green, displayColour[v].blue);
	    j+=3;
	    break;
	}
	if (j >= 32)
	{
	    putc('\n', fp);
	    j = 0;
	}
    }
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (j != 0)
	putc('\n', fp);

    for(j=specy; j--;)
	for(i=0; i<specx; i++)
	{
	    v = spec2dcontour[i][j] - COLOUROFFSET + 48;
	    if (!ferror(fp))
		putc(v, fp);
	    if (i % 64 == 63 || i == specx-1)
		if (!ferror(fp))
                    putc('\n', fp);
	}
    if (!ferror(fp))
	fputs("end\n", fp);
    if (dest != 2 && !ferror(fp))
	fputs("showpage\n", fp);
    if (!ferror(fp))
        fputs("%%Trailer\n", fp);
    if (ferror(fp))
        notice_prompt(Spec_printerPopup->printerPopup, NULL,
                      NOTICE_FOCUS_XY, event_x(event), event_y(event),
                      NOTICE_MESSAGE_STRINGS,
                      "Error whilst writing output file. Error was :",
		      (errno == EPIPE) ?
		      "Broken pipe. Try checking your print command." :
		      ERRSTRING, NULL,
                      NOTICE_BUTTON_YES, "Ok",
                      NULL);
    fclose(fp);
    if (dest == 0)
        notify_set_signal_func(sort_client, NOTIFY_FUNC_NULL, SIGPIPE,
                               NOTIFY_ASYNC);

}

/*
 * Notify callback function for `printTo'.
 */
void
spec_printerPopup_printTo_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 1)
	{
		printToFile(item, value, event);
	}
	
	if (value == 0)
	{
		printToPrinter(item, value, event);
	}
	
	if (value == 2)
	{
		printToFile(item, value, event);
	}
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `printTo'.
 */
/*ARGSUSED*/
void
printToFile(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    xv_set(Spec_printerPopup->printString, XV_SHOW, FALSE, NULL);
    xv_set(Spec_printerPopup->printFilename, XV_SHOW, TRUE, NULL);
}

/*
 * User-defined action for `printTo'.
 */
/*ARGSUSED*/
void
printToPrinter(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    xv_set(Spec_printerPopup->printFilename, XV_SHOW, FALSE, NULL);
    xv_set(Spec_printerPopup->printString, XV_SHOW, TRUE, NULL);
}

/*
 * Menu handler for `autoscaleMenu (Linear)'.
 */
Menu_item
spec_autoscaleMenu_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		autoscaleLinear(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `autoscaleMenu (Pseudo-logarithmic)'.
 */
Menu_item
spec_autoscaleMenu_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		autoscaleLogarithmic(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `autoscaleMenu'.
 */
/*ARGSUSED*/
void
autoscaleLinear(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, first, step;
    char buffer[16];

    step = (((float) specMax)/(usedContours-1) + 0.5);
    if (step < 1)
	step = 1;
    first = step;
    sprintf(buffer, "%d", first);
    xv_set(Spec_levelPopup->firstValue, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->spacing, XV_SHOW, FALSE, NULL);
    sprintf(buffer, "%d", step);
    xv_set(Spec_levelPopup->step, PANEL_VALUE, buffer, XV_SHOW, TRUE, NULL);
    sprintf(buffer, "%d", usedContours);
    xv_set(Spec_levelPopup->numContours, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->levelPopup, XV_LABEL, "Set linear contours", NULL);
    xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	   levelSetLinear, NULL);
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, NULL);
	first += step;
    }
    setContoursAndRedraw();
}

/*
 * User-defined action for `autoscaleMenu'.
 */
/*ARGSUSED*/
void
autoscaleLogarithmic(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i;
    float first=1, spacing;
    char buffer[32];

    spacing = pow((double) specMax, 1.0/(usedContours-2));
    xv_set(Spec_levelPopup->firstValue, PANEL_VALUE, "1", NULL);
    xv_set(Spec_levelPopup->step, XV_SHOW, FALSE, NULL);
    sprintf(buffer, "%f", spacing);
    xv_set(Spec_levelPopup->spacing, PANEL_VALUE, buffer, XV_SHOW, TRUE, NULL);
    sprintf(buffer, "%d", usedContours);
    xv_set(Spec_levelPopup->numContours, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->levelPopup, XV_LABEL,
	   "Set pseudo-logarithmic contours", NULL);
    xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	   levelSetPseudo, NULL);
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, NULL);
	first *= spacing;
    }
    setContoursAndRedraw();
}

void
initialiseMonochrome(win)
Xv_opaque win;
{
    Xv_opaque menu;

    createDithers(win);

    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE,
	   (cms == XV_NULL) ? TRUE : FALSE, NULL);

}

void
createDithers(win)
Xv_opaque win;
{
    int i, x, y, grid[MAXSCALE][MAXSCALE], maxx, maxy, u, v, maxd, d, du, dv;
    char bitmap[MAXSCALE*2];
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    Pixmap pix;
    GC gc1;

    if (windither != 0)
	XFreePixmap(display, windither);
    if (mag > 8)
	for(x=mag; x--; )
	    bitmap[x*2+1] = bitmap[x*2] = 04444 >> (x % 3);
    else
	for(x=mag; x--; )
	    bitmap[x] = 04444 >> (x % 3);
    windither = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(x=mag; x--; )
    {
	for(y=mag; y--; )
	    grid[x][y] = 0;
	bitmap[x*2+1] = bitmap[x*2] = 0;
    }
    if (dither[0] != 0)
	XFreePixmap(display, dither[0]);
    dither[0] = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(i=1; i<=mag*mag; i++)
    {
	maxx = -1;
	maxy = -1;
	maxd = mag*mag*mag*mag;

	for(x=mag; x--; )
	    for(y=mag; y--; )
		if (!grid[x][y])
		{
		    d = 0;
		    for(u=mag; u--; )
			for(v=mag; v--; )
			    if (grid[u][v])
			    {
				du = abs(u-x);
				if (du > mag/2)
				    du = mag - du;
				dv = abs(v-y);
				if (dv > mag/2)
				    dv = mag - dv;
				d += (mag*mag)/(du*du + dv*dv);
			    }
		    if (d < maxd)
		    {
			maxd = d;
			maxx = x;
			maxy = y;
		    }
		}

	grid[maxx][maxy] = 1;

	for(y=mag; y--; )
	{
	    if (mag > 8)
	    {
		bitmap[y*2+1] = bitmap[y*2] = 0;
		u = 1;
		for(x=8; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2] |= u;
		    u <<= 1;
		}
		u = 1;
		for(x=mag; x-- > 8; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2+1] |= u;
		    u <<= 1;
		}
	    }
	    else
	    {
		u = 1;
		bitmap[y] = 0;
		for(x=mag; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y] |= u;
		    u <<= 1;
		}
	    }
	}
	if (dither[i] != 0)
	    XFreePixmap(display, dither[i]);
	dither[i] = XCreateBitmapFromData(display, xid, bitmap, mag, mag);
    }

    gc1 = XCreateGC(display, dither[1], 0, NULL);
    XSetBackground(display, gc1, 0);
    XSetForeground(display, gc1, 1);
    XSetFillStyle(display, gc1, FillOpaqueStippled);
    
    for(i=mag*mag+1; i--; )
    {
	if (XVdither[i] != XV_NULL)
	    xv_destroy(XVdither[i]); /* Also frees old pixmap */

	pix = XCreatePixmap(display, xid, 16, 16, 1);
	XSetStipple(display, gc1, dither[i]);
	XFillRectangle(display, pix, gc1, 0, 0, 16, 16);
	XVdither[i] = xv_create(XV_NULL, SERVER_IMAGE,
				SERVER_IMAGE_PIXMAP, pix,
				NULL);
    }

    XFreeGC(display, gc1);
}    

void
setContourImages(win)
Xv_opaque win;
{
    int i;

    if (monochrome)
	setContourDithers(win);
    else
	for(i=0; i<MAXCONTOURS; i++)
	    xv_set(contourButton[i], PANEL_LABEL_IMAGE, squareblack,
		   PANEL_ITEM_COLOR, i+COLOUROFFSET,
		   NULL);
}

/*ARGSUSED*/
void
setContourDithers(win)
Xv_opaque win;
{
    int i,j;

    if (!monochrome)
	return;

    for(i=0; i<MAXCONTOURS; i++)
    {
	j = (i*(mag*mag)+usedContours/2)/(usedContours-1);
	if (j > mag*mag)
	    j = mag*mag;
	xv_set(contourButton[i], PANEL_LABEL_IMAGE, XVdither[j],
	       PANEL_ITEM_COLOR, -1,
	       NULL);
    }
}

/*
 * Menu handler for `palettes (Monochrome Display)'.
 */
Menu_item
spec_palettes_item6_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		changeToMonochrome(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `palettes (Colour Display)'.
 */
Menu_item
spec_palettes_item7_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		changeToColour(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
changeToMonochrome(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (monochrome)
	return;
    monochrome = 1;
    initialiseMonochrome(Spec_contourPopup->contourControls);
    setContoursAndRedraw();
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, FALSE, NULL);
}

/*
 * User-defined action for `palettes'.
 */
/*ARGSUSED*/
void
changeToColour(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    Xv_opaque menu;
	
    if (!monochrome)
	return;
    if (cms == XV_NULL)
    {
	fprintf(stderr, "\
Activated changeToColour() without a colourmap ! Please report this.\n");
	monochrome = 1;
	return;
    }
    monochrome = 0;
	
    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, TRUE, NULL);

    setContourImages(Spec_contourPopup->contourControls);
    setContoursAndRedraw();
}

void
setMagnification(newmag)
int newmag;
{
    int wx, wy;

    if (newmag > MAXSCALE)
	newmag = MAXSCALE;

    if (newmag*specx > MAXSPECSIZE)
	newmag = (int) (MAXSPECSIZE/specx);
    if (newmag*specy > MAXSPECSIZE)
	newmag = (int) (MAXSPECSIZE/specy);

    mag = newmag;

    /* Plus 2 to each dimension, to allow for border */
    
    wx = mag * specx + 2;
    wy = mag * specy + 2;

    xv_set(Spec_specWindow->spectrum,
	   CANVAS_WIDTH, wx, CANVAS_HEIGHT, wy,
	   XV_WIDTH, wx, XV_HEIGHT, wy, NULL);

    xv_set(Spec_specWindow->specWindow,
	   XV_WIDTH, (wx < 514) ? 514 : wx, XV_HEIGHT, wy+64, NULL);

    if (monochrome)
	createDithers(Spec_specWindow->spectrum);
    forceRedraw = 1;

    /* You must now set reset the contour images */
}

/*
 * Menu handler for `magnifyMenu (1)'.
 */
Menu_item
spec_magnifyMenu_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (2)'.
 */
Menu_item
spec_magnifyMenu_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (3)'.
 */
Menu_item
spec_magnifyMenu_item2_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (4)'.
 */
Menu_item
spec_magnifyMenu_item3_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (5)'.
 */
Menu_item
spec_magnifyMenu_item4_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (6)'.
 */
Menu_item
spec_magnifyMenu_item5_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (7)'.
 */
Menu_item
spec_magnifyMenu_item6_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (8)'.
 */
Menu_item
spec_magnifyMenu_item7_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (9)'.
 */
Menu_item
spec_magnifyMenu_item8_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (10)'.
 */
Menu_item
spec_magnifyMenu_item9_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (11)'.
 */
Menu_item
spec_magnifyMenu_item10_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (12)'.
 */
Menu_item
spec_magnifyMenu_item11_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (13)'.
 */
Menu_item
spec_magnifyMenu_item12_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (14)'.
 */
Menu_item
spec_magnifyMenu_item13_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (15)'.
 */
Menu_item
spec_magnifyMenu_item14_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `magnifyMenu (16)'.
 */
Menu_item
spec_magnifyMenu_item15_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		menuSetMagnification(item, op);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * User-defined action for `magnifyMenu'.
 */
/*ARGSUSED*/
void
menuSetMagnification(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	setMagnification(atoi((char *) xv_get(item, MENU_STRING)));
	setContoursAndRedraw();
}

void readSpectrumFromPipe()
{
    int x, y;
    char buffer[6];

    read(0, (char *) &specx, sizeof(int));
    read(0, (char *) &specy, sizeof(int));
    read(0, (char *) &specMax, sizeof(int));
    for(x = specx; x--; )
	for(y = specy; y--; )
	    read(0, (char *) &spec2d[x][y], sizeof(int));
    read(0, (char *) &usedContours, sizeof(int));
    for(x = specx; x--; )
	for(y = specy; y--; )
	    read(0, (char *) &window[x][y], sizeof(unsigned char));
    read(0, (char *) &windowStatus, sizeof(int));
    read(0, (char *) &mag, sizeof(int));
    read(0, (char *) &x, sizeof(int));
    read(0, spectrumName, x);
    spectrumName[x] = '\0';
    spectrumLoaded();
    x = MAXCONTOURS-1;
    while(--x)
    {
	read(0, (char *) &y, sizeof(int));
	xv_set(contourSlider[x], PANEL_VALUE, y, NULL);
    }
    read(0, (char *) rawColour, sizeof(rawColour));
    read(0, (char *) &displayGamma, sizeof(float));

    if (strstr(spectrumName, "(copy)") == NULL)
	strcat(spectrumName, " (copy)");

    xv_set(Spec_gammaPopup->displayGammaSlider, PANEL_VALUE,
	   (int) displayGamma*100, NULL);
    sprintf(buffer, "%5.2f", displayGamma);
    xv_set(Spec_gammaPopup->displayGammaValue, PANEL_VALUE, buffer, NULL);
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (cms == XV_NULL)
	return;
    xv_set(cms, CMS_COLORS, displayColour, NULL);
}

void spectrumLoaded()
{
    char buf[16];
    int x;

    for(x=1; x<MAXCONTOURS-1; x++)
    {
	xv_set(contourSlider[x], PANEL_MAX_VALUE, specMax, NULL);
	if (((int) xv_get(contourSlider[x], PANEL_VALUE)) > specMax)
	    xv_set(contourSlider[x], PANEL_VALUE, specMax, NULL);
    }
    sprintf(buf,"%d",specMax);
    xv_set(contourSlider[x], PANEL_LABEL_STRING, buf, NULL);
    setMagnification(mag);
    RRP(0);
}

/*
 * Notify callback function for `forkButton'.
 */
/*ARGSUSED*/
void
forkProgram(item, event)
	Panel_item	item;
	Event		*event;
{
	int fd;
	char *buf;

	buf = malloc(strlen(programName) + 7);
	sprintf(buf, "%s -pipe", programName);
	
        if ((fd = mypopenfd(buf, "w")) == -1)
        {
	    free(buf);
	    notice_prompt(Spec_specWindow->specWindow, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to run copy of program. Error was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
        }
	free(buf);

        /*
         * Ignore SIGPIPE signals, we'll detect those by looking for errors
         * returned by writing.
         */
        notify_set_signal_func(sort_client, blankfunc, SIGPIPE, NOTIFY_ASYNC);

	if (writeSpectrumToPipe(fd) == -1)
	{
	    notice_prompt(Spec_specWindow->specWindow, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Error whilst writing spectrum to pipe. It was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
        }

	(void) close(fd);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

int writeSpectrumToPipe(fd)
int fd;
{
    int x, y;

    if (write(fd, (char *) &specx, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &specy, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &specMax, sizeof(int)) == -1)
	return(-1);
    for(x = specx; x--; )
	for(y = specy; y--; )
	    if (write(fd, (char *) &spec2d[x][y], sizeof(int)) == -1)
		return(-1);
    if (write(fd, (char *) &usedContours, sizeof(int)) == -1)
	return(-1);
    for(x = specx; x--; )
	for(y = specy; y--; )
	    if (write(fd, (char *) &window[x][y], sizeof(unsigned char)) == -1)
		return(-1);
    if (write(fd, (char *) &windowStatus, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &mag, sizeof(int)) == -1)
	return(-1);
    x = strlen(spectrumName);
    if (write(fd, (char *) &x, sizeof(int)) == -1)
	return(-1);
    if (write(fd, spectrumName, x) == -1)
	return(-1);
    x = MAXCONTOURS-1;
    while(--x)
    {
	y = (int) xv_get(contourSlider[x], PANEL_VALUE);
	if (write(fd, (char *) &y, sizeof(int)) == -1)
	    return(-1);
    }
    if (write(fd, (char *) rawColour, sizeof(rawColour)) == -1)
	return(-1);
    if (write(fd, (char *) &displayGamma, sizeof(float)) == -1)
	return(-1);
    return(0);
}

/****************** sjah 16/1/95 ********************************/
/*
 *  getdtablesize() is a BSD function
 *  keep name but use Solaris equivalent if SVR4
 */
#ifdef SVR4
#include <sys/time.h>
#include <sys/resource.h>

int getdtablesize(void)
{
      struct rlimit rlp;
      if ( getrlimit(RLIMIT_NOFILE, &rlp) == -1)
	    return(-1);
      else
	    return((int) rlp.rlim_cur);
}
#endif

/*
 * Menu handler for `slicingMenu (Slicing On)'.
 */
/*ARGSUSED*/
Menu_item
spec_slicingMenu_item0_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/* if Slicing is on switch it off and vice versa */
		if (Slicing & SLICING) {
		      Slicing &= (~SLICING);
		      xv_set(item, MENU_STRING, "Slicing On", NULL);
		      xv_set(Spec_specWindow->specWindow,
			     FRAME_RIGHT_FOOTER, "", NULL);		      
		}
		else {
		      Slicing |= SLICING;
		      xv_set(item, MENU_STRING, "Slicing Off", NULL);
		      xv_set(Spec_specWindow->specWindow,
			     FRAME_RIGHT_FOOTER, "Slicing On", NULL);			      
		}
		
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `slicingMenu (Set Slicing window)'.
 */
Menu_item
spec_slicingMenu_item1_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		Slicing |= PROJECTION;
		setWindow(item,op);
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `slicingMenu (Set Slicing window)'.
 */
/*ARGSUSED*/
Menu_item
spec_slicingMenu_item2_callback(item, op)
	Menu_item	item;
	Menu_generate	op;
{
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		do_projection(NULL);
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

void do_simple_slice(event,x,y)
      Event *event;
      int x;
      int y;
{
      char buf[BUFSIZ];
      int fd;

/*  set up command string */      
      sprintf(buf,"sort_slicing -spectrum .SORT_pipe -limit %d %d",x,y);

      if (DBX_val >= 3)
	    fprintf(stderr,"sort_spec2d: %s\n",buf);

/*  check that sort data file is there */
      if (access(".SORT_pipe", R_OK) == -1) {
	    if (store_spectrum(".SORT_pipe", "DISPLAY 2", SORT_FALSE) == -1) {
		  fprintf(stderr,"sort_spec2d: error writing out spectra\n");
		  return;
	    }
      }

/*  start slicing process to perform calculation...it will try to signal current sort_xvgr */      
      if ((fd = mypopenfd(buf, "w")) == -1) {
	    notice_prompt(Spec_specWindow->specWindow, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to run sort_slicing. Error was",
			  ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
      }
      (void) close(fd);
      return;
}

int
store_spectrum(outfile, command, win)
      char *outfile;
      char *command;
      int  win;
{
      register int x, y;
      
      if (debuglevel >= 3)
	    fprintf(stderr,"sort_spec2d: storing 2d spectra\n");

/* copy spectrum window data into pshm structure*/
      strncpy(pshm->com_str,command,NAME_SIZE);
      pshm->size = (specx != specy) ? MAX(specx,specy) : specx;
      pshm->win2d = win2d;
      
/*
 * x=0, y=0 on display is top right hand corner and 1st element of pshm->array
 * win == TRUE store window otherwise store displayed spectrum
 */
      if (win == SORT_TRUE) {
	    for(x=0; x < specx ;x++) {
		  for(y=0; y < specy ; y++) {
			pshm->array[x*specy + (specy-1-y)] = (window[x][y] > 0) ? 30 : 0;
		  }
	    }
      }
      else {
	    for(x=0; x < specx ;x++) {
		  for(y=0; y < specy ; y++) {
			pshm->array[x*specy + (specy-1-y)] = spec2d[x][y];
		  }
	    }
      }
      
/* no ipcs on system */
      if ( write_to_pipe(outfile,SHM_ARRAY_SIZE) == SORT_FAIL) {
	    return(-1);
      }
      return(0);
}

void do_projection(event)
    Event *event;
{
      char *buf = "sort_project -spectrum .SORT_pipe -window .SORT_pipe_W";
      int fd;
      
      if (DBX_val >= 3)
	  fprintf(stderr,"sort_spec2d: %s\n",buf);
      
      /*  check that sort data file is there */
      if (access(".SORT_pipe", R_OK) == -1) {
	  if (store_spectrum(".SORT_pipe", "DISPLAY 2", SORT_FALSE) == -1) {
	      fprintf(stderr,"sort_spec2d: error writing out spectra for projection\n");
	      return;
	  }
      }
      
      /*  store projection window */
      if (store_spectrum(".SORT_pipe_W", "WINDOW 3", SORT_TRUE) == -1) {
	  fprintf(stderr,"sort_spec2d: error writing out window for projection\n");
	  return;
      }
      
      /*  start projection process to perform calculation...it will try to signal current sort_xvgr */      
      if ((fd = mypopenfd(buf, "w")) == -1) {
	  notice_prompt(Spec_specWindow->specWindow, NULL,
			NOTICE_FOCUS_XY, event_x(event), event_y(event),
			NOTICE_MESSAGE_STRINGS,
			"Unable to run sort_slicing. Error was",
			ERRSTRING, NULL,
			NOTICE_BUTTON_YES, "Ok",
			NULL);
	  return;
      }
      (void) close(fd);
      
      if (windowStatus == WINDOW_NONE)
      {
	  windowStatus = WINDOW_OUTSIDE;
	  repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			  XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			  (Window) xv_get(
			      canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), (Xv_xrectlist *) NULL);
      }

      return;
}

/*
 * Notify callback function for `projectAngleValue'.
 */
Panel_setting
spec_projectPopup_projectAngleValue_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	valueSetProjectAngle(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `projectAngleSlider'.
 */
void
spec_projectPopup_projectAngleSlider_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	sliderSetProjectAngle(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `projectArea'.
 */
void
spec_projectPopup_projectArea_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	setProjectArea(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `projectAngleValue'.
 */
/*ARGSUSED*/
void
valueSetProjectAngle(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_projectPopup->projectControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.0, 180.0, event)) < 0.0)
	return;
    xv_set(Spec_projectPopup->projectAngleSlider, PANEL_VALUE, (int) num*10,
	   NULL);
    RRP(1);
    projectAngle = num;
    RRP(2);
}

/*
 * User-defined action for `projectAngleSlider'.
 */
/*ARGSUSED*/
void
sliderSetProjectAngle(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    char buffer[6];
    double num;

    num = ((float) value) / 10;
    sprintf(buffer, "%5.1f", num);
    xv_set(Spec_projectPopup->projectAngleValue, PANEL_VALUE, buffer, NULL);
    RRP(1);
    projectAngle = num;
    RRP(2);
}


void recalculateProjection(scale)
int scale;
{
    int x, y;
    int (*colp)[MAXSPECX], *sp;
    unsigned char (*wcolp)[MAXSPECX], *wp;
    int colpos, pos, dx, dy, f;


    dx = sin(screenAngle) * 65536;
    dy = cos(screenAngle) * 65536;
    colpos = (-(specy-2)*dy - specx*dx)/2 + MAXPROJWIDTH*32768;

    memset(projection, 0, sizeof(projection));

    switch(projectArea)
    {
    case 0:
	for(colp = spec2d, x = specx; x--; colp++, colpos += dx)
	    for(pos = colpos, sp = &(colp[0][0]), y = specy; y--;
		sp++, pos += dy)
	    {
		f = pos & 65535;
		projection[pos>>16] += *sp * ((65536-f)>>8);
		projection[(pos>>16)+1] += *sp * (f>>8);
	    }
	break;
    case 1:
	for(colp = spec2d, wcolp = window, x = specx; x--;
	    colp++, wcolp++, colpos += dx)
	    for(pos = colpos, sp = &(colp[0][0]), wp = &(wcolp[0][0]),
		y = specy; y--; sp++, wp++, pos += dy)
		if (*wp)
		{
		    f = pos & 65535;
		    projection[pos>>16] += *sp * ((65536-f)>>8);
		    projection[(pos>>16)+1] += *sp * (f>>8);
		}
	break;
    }

    if (scale)
    {
	for(x = 0, sp = projection, y=MAXPROJWIDTH; y--; sp++)
	    if (*sp > x)
		x = *sp;
	
	x = (x + 255) / 256;
	
	if (x > 0)
	    for(sp = projection, y=MAXPROJWIDTH; y--; sp++)
		*sp /= x;
	
	forceProject = 0;
    }
}

/*
 * Repaint callback function for `projection'.
 */
/*ARGSUSED*/
void
repaintProjection(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
    static GC gc = NULL;
    int i, l, x, y, lx, ly;
    double s, o;
    XPoint polypoints[MAXPROJWIDTH*2], *pp;
    
    if (forceProject)
	recalculateProjection(1);

    if (gc == NULL)
	gc = XCreateGC(display, xid, 0, NULL);

    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, BlackPixel(display,
					   DefaultScreen(display)));
    XSetBackground(display, gc, WhitePixel(display,
					   DefaultScreen(display)));

    if (rects)
        XSetClipRectangles(display, gc, 0, 0, rects->rect_array,
                           rects->count, Unsorted);
    else
    {
        XSetClipMask(display, gc, None);
        XClearWindow(display, xid);
    }

    XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);

    l = sqrt((double) (specx*specx + specy*specy))/2;
    lx = 0;
    for(pp = polypoints, i = -l; i < l; i++, pp += 2)
    {
	pp->x = lx;
	pp[1].x = lx =  i * 256 / l + 256;
	pp[1].y = pp->y = 255 - projection[i + MAXPROJWIDTH/2];
    }
    XDrawLines(display, xid, gc, polypoints, l*4, CoordModeOrigin);

    if (polynomialOrder > 0 && calcScaleAndOffset(&s, &o) == 0)
    {
	static char dashed[2] = { 4, 4 };

	o += s/2;
	s *= POLYARRAYLEN/180.0*l/256;
	o *= POLYARRAYLEN/180.0;
	lx = (int) (o - 256*s);
	ly = (int) (((o - 256*s) - lx) * 65536);
	lx = ((lx & (POLYARRAYLEN - 1))<<16)+ly;
	ly = (int) (s * 65536);

	for(pp = polypoints, x = 0; x < 512; x++, pp++)
	{
	    y = 255 - polynomial[lx>>16]*polynomialScale*255;
	    lx = (lx+ly) & ((POLYARRAYLEN<<16)-1);
	    pp->x = x;
	    pp->y = y;
	}
	XSetDashes(display, gc, 0, dashed, sizeof(dashed));
	XSetLineAttributes(display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
	XDrawLines(display, xid, gc, polypoints, 512, CoordModeOrigin);
	XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);
    }

    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    /* gxv_end_connections */

}

/*
 * User-defined action for `projectArea'.
 */

/*ARGSUSED*/
void
setProjectArea(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    projectArea = value;
    RRP(0);
}

int
projectDone(item)
Xv_opaque item;
{
    xv_set(item, XV_SHOW, FALSE, NULL);
    if (showGuidelines)
	drawGuidelines((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc);
    showGuidelines = 0;
    return XV_OK;
}

void
drawGuidelines(display, xid, gc)
Display *display;
Window xid;
GC gc;
{
    double dx, dy, i, l, tx, ty;
    unsigned long *index;

    if (monochrome)
	XSetForeground(display, gc,
		       BlackPixel(display, DefaultScreen(display)) ^
		       WhitePixel(display, DefaultScreen(display)));
    else
    {
	index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1] ^
		       index[COLOUROFFSET]);
    }
    
    XSetFunction(display, gc, GXxor);

    l = sqrt((double) specx*specx + specy*specy);

    dx = sin(screenAngle);
    dy = -cos(screenAngle);

    tx = (Xtarget - Xoffset)/Xgain;
    ty = (Ytarget - Yoffset)/Ygain;

    i = tx*dx + ty*dy;
    i -= floor(i/10)*10;

    for(i -= floor(l/10)*10; i<l; i += 10)
    {
	XDrawLine(display, xid, gc, (int) ((i*dx - l*dy + 0.5)*mag),
		  (int) ((specy - (i*dy + l*dx + 0.5))*mag),
		  (int) ((i*dx + l*dy + 0.5)*mag),
		  (int) ((specy - (i*dy - l*dx + 0.5))*mag));
    }

    switch(projectAxis)
    {
    case 0: /* Perpendicular */
	XDrawLine(display, xid, gc, (int) ((tx + l*dx + 0.5)*mag),
		  (int) ((specy - (ty + l*dy + 0.5))*mag),
		  (int) ((tx - l*dx + 0.5)*mag),
		  (int) ((specy - (ty - l*dy + 0.5))*mag));
	break;
    case 1: /* X */
	XDrawLine(display, xid, gc, 0, (int) ((specy - ty - 0.5)*mag),
		  specx*mag, (int) ((specy - ty - 0.5)*mag));
	break;
    case 2: /* Y */
	XDrawLine(display, xid, gc, (int) ((tx+ 0.5)*mag), 0,
		  (int) ((tx + 0.5)*mag), specy*mag);
	break;
    }

    XSetFunction(display, gc, GXcopy);
}

int
calcScaleAndOffset(double *s, double *o)
{
    if ((projectAxis == 1 && (projectAngle == 0 || projectAngle == 180)) ||
	(projectAxis == 2 && projectAngle == 90))
	return -1;

    switch(projectAxis)
    {
    case 0: /* Perpendicular */
	*s = sin(screenAngle)*Xgain*sin(projectAngle*M_PI/180) +
	    cos(screenAngle)*Ygain*cos(projectAngle*M_PI/180);
	*o = (specx/2.0*Xgain+Xoffset-Xtarget)*sin(projectAngle*M_PI/180) + 
	    (-specy/2.0*Ygain-Yoffset+Ytarget)*cos(projectAngle*M_PI/180);
	break;
    case 1: /* X */
	*s = sin(screenAngle)*Xgain +
	    cos(screenAngle)*Ygain/tan(projectAngle*M_PI/180);
	*o = specx/2.0*Xgain+Xoffset +
	    (-specy/2.0*Ygain-Yoffset+Ytarget)/tan(projectAngle*M_PI/180);
	break;
    case 2: /* Y */
	*s = -cos(screenAngle)*Ygain -
	    sin(screenAngle)*Xgain*tan(projectAngle*M_PI/180);
	*o = specy/2.0*Ygain+Yoffset -
	    (specx/2.0*Xgain+Xoffset-Xtarget)*tan(projectAngle*M_PI/180);
	break;
    }
    return 0;
}

void
signal_1d()
{
/* signal 1d display process to show slices */
      if ( (int) pshm->pid_1d <= 0 || kill(pshm->pid_1d, SIGUSR1) == -1) {
#ifdef SVR4
	    pid_t pid = lookup_proc("sort_xvgr");
#else
	    int   pid = lookup_proc("sort_xvgr");
#endif
	    if ((int) pid > 0) {
		  if (kill(pid, SIGUSR1) == -1) {
			perror("projecting-kill");
			fprintf(stderr,"projecting: failed to signal 1D display process pid = %d\n",
				 (int) pshm->pid_1d);
		  }
	    }
	    else {
		  fprintf(stderr,"projecting: failed to signal 1D display process pid = %d\n",
			  (int) pshm->pid_1d);
		  return;
	    }
      }
}

/*
 * Notify callback function for `doProjection'.
 */
/*ARGSUSED*/
void
doProjection(item, event)
	Panel_item	item;
	Event		*event;
{
    int i, l, y, max;
    float *p;
    double s, o;

    if (calcScaleAndOffset(&s, &o))
    {
	notice_prompt(Spec_projectPopup->projectPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Don't try to project parallel to the axis you want",
		      "to read the numbers off - it won't work.", NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    recalculateProjection(0);
    forceProject = 1;

    l = sqrt((double) (specx*specx + specy*specy))/2;
    strcpy(pshm->com_str, "DISPLAX 1");
    sprintf(pshm->name, "%5.1f\\So\\N", projectAngle);
    pshm->more = 0;
    pshm->size = l*4;

    max = 256;
    for(p = (float *) pshm->array, i = -l; i < l; i++, p += 2)
    {
	*p = i * s + o;
	y = projection[i + MAXPROJWIDTH/2];
	if (y > max)
	    max = y;
	p[1] = y / 256.0;
    }

    write_to_pipe(".SORT_pipe0", l*4); 

    signal_1d();

    if (polynomialOrder > 0)
    {
	double x;

	sleep(1);

	strcpy(pshm->com_str, "OVERLAX 1");
	sprintf(pshm->name, "|P%d|\\S2\\N", polynomialOrder);
	pshm->more = 0;
	pshm->size = 1024;

	s *= M_PI/180*l/256;
	o *= M_PI/180;

	for(p = (float *) pshm->array, i = 0; i < 512; i++, p += 2)
	{
	    x = ((i-256)*s + o);
	    *p = x*180/M_PI;
	    p[1] = pow(legendre(polynomialOrder, cos(x)),2.0) * polynomialScale
		* max / 256;
	}

	write_to_pipe(".SORT_pipe0", 1024);
	signal_1d();
    } 
}

/*
 * Notify callback function for `projectXGain'.
 */
Panel_setting
spec_projectPopup_projectXGain_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectXGain(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `projectXOffset'.
 */
Panel_setting
spec_projectPopup_projectXOffset_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectXOffset(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `projectYGain'.
 */
Panel_setting
spec_projectPopup_projectYGain_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectYGain(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `projectYOffset'.
 */
Panel_setting
spec_projectPopup_projectYOffset_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectYOffset(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
projectXGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, 0.0, 0.0, event)) == 0.0)
	return;

    xv_set(Spec_printerPopup->printXGain, PANEL_VALUE, value, NULL);
    RRP(1);
    Xgain = val;
    RRP(2);
}

/*ARGSUSED*/
void
projectXOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    xv_set(Spec_printerPopup->printXOffset, PANEL_VALUE, value, NULL);
    RRP(1);
    Xoffset = val;
    RRP(2);
}

/*ARGSUSED*/
void
projectYGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, 0.0, 0.0, event)) == 0.0)
	return;

    xv_set(Spec_printerPopup->printYGain, PANEL_VALUE, value, NULL);
    RRP(1);
    Ygain = val;
    RRP(2);
}

/*ARGSUSED*/
void
projectYOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    xv_set(Spec_printerPopup->printYOffset, PANEL_VALUE, value, NULL);
    RRP(1);
    Yoffset = val;
    RRP(2);
}

/*
 * Notify callback function for `printXGain'.
 */
Panel_setting
spec_printerPopup_printXGain_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	printXGain(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `printXOffset'.
 */
Panel_setting
spec_printerPopup_printXOffset_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	printXOffset(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `printYGain'.
 */
Panel_setting
spec_printerPopup_printYGain_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	printYGain(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `printYOffset'.
 */
Panel_setting
spec_printerPopup_printYOffset_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	printYOffset(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
printXGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) == 0.0)
	return;

    xv_set(Spec_projectPopup->projectXGain, PANEL_VALUE, value, NULL);
    RRP(1);
    Xgain = val;
    RRP(2);
}

/*ARGSUSED*/
void
printXOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    xv_set(Spec_projectPopup->projectXOffset, PANEL_VALUE, value, NULL);
    RRP(1);
    Xoffset = val;
    RRP(2);
}

/*ARGSUSED*/
void
printYGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) == 0.0)
	return;

    xv_set(Spec_projectPopup->projectYGain, PANEL_VALUE, value, NULL);
    RRP(1);
    Ygain = val;
    RRP(2);
}

/*ARGSUSED*/
void
printYOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    xv_set(Spec_projectPopup->projectYOffset, PANEL_VALUE, value, NULL);
    RRP(1);
    Yoffset = val;
    RRP(2);
}

void RRP(change) /* Recalculate and Repaint Projection */
int change;
{
    Display *disp = (Display *)
	XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow);
    Window specwin = (Window)
	xv_get(canvas_paint_window(Spec_specWindow->spectrum), XV_XID);
    Window projwin = (Window)
	xv_get(canvas_paint_window(Spec_projectPopup->projection), XV_XID);

    if (change == 1)
	drawGuidelines(disp, specwin, gc);
    else if (change == 2)
    {
	if (projectAngle == 0.0 || projectAngle == 180.0)
	    screenAngle = projectAngle * M_PI / 180.0;
	else
	    screenAngle = atan(tan(projectAngle * M_PI/180) * Xgain / Ygain);
	if (screenAngle < 0)
	    screenAngle += M_PI;
	drawGuidelines(disp, specwin, gc);
    }
    forceProject = 1;
    repaintProjection(XV_NULL, XV_NULL, disp, projwin, (Xv_xrectlist *) NULL);
}

/*
 * Notify callback function for `projectXTarget'.
 */
Panel_setting
spec_projectPopup_projectXTarget_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectXTarget(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `projectYTarget'.
 */
Panel_setting
spec_projectPopup_projectYTarget_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	projectYTarget(item, event);
	
	/* gxv_end_connections */

	return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
projectXTarget(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    RRP(1);
    Xtarget = val;
    RRP(2);
}

/*ARGSUSED*/
void
projectYTarget(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) < -1e37)
	return;

    RRP(1);
    Ytarget = val;
    RRP(2);
}

/*
 * Notify callback function for `projectAxis'.
 */
void
spec_projectPopup_projectAxis_notify_callback(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	setProjectAxis(item, value, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `projectAxis'.
 */
/*ARGSUSED*/
void
setProjectAxis(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    RRP(1);
    projectAxis = value;
    RRP(2);
}

/*
 * Notify callback function for `projectYTarget'.
 */
Panel_setting
spec_projectPopup_polynomial_notify_callback(item, event)
	Panel_item	item;
	Event		*event;
{
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    
    setPolynomial(item, event); 
    
    /* gxv_end_connections */
    
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
setPolynomial(item, event)
Panel_item item;
Event *event;
{
    int value = (int) xv_get(item, PANEL_VALUE);
    int i;
    
    polynomialOrder = value;
    if (value > 0)
    {
	for(i = 0; i < POLYARRAYLEN; i++)
	    polynomial[i] = pow(legendre(value, cos(i*M_PI/POLYARRAYLEN)),2.0);
    }
    RRP(0);
}

/*
 * Notify callback function for `scaleUp'.
 */
/*ARGSUSED*/
void
scaleUp(item, event)
	Panel_item	item;
	Event		*event;
{
    polynomialScale *= 1.1;
    RRP(0);
}

/*
 * Notify callback function for `scaleDown'.
 */
/*ARGSUSED*/
void
scaleDown(item, event)
	Panel_item	item;
	Event		*event;
{
    polynomialScale /= 1.1;
    if (polynomialScale < 1)
	polynomialScale = 1;
    RRP(0);
}

