#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include "spec_ui.h"

/*
 * Create object `palettes' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_palettes_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	spec_palettes_item0_callback();
	extern Menu_item	spec_palettes_item1_callback();
	extern Menu_item	spec_palettes_item2_callback();
	extern Menu_item	spec_palettes_item3_callback();
	extern Menu_item	spec_palettes_item4_callback();
	extern Menu_item	spec_palettes_item5_callback();
	extern Menu_item	spec_palettes_item6_callback();
	extern Menu_item	spec_palettes_item7_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Hues",
			MENU_GEN_PROC, spec_palettes_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Greyscale",
			MENU_GEN_PROC, spec_palettes_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Heat",
			MENU_GEN_PROC, spec_palettes_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reverse Greyscale",
			MENU_GEN_PROC, spec_palettes_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Topographic",
			MENU_GEN_PROC, spec_palettes_item4_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Gamma...",
			MENU_GEN_PROC, spec_palettes_item5_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Monochrome Display",
			MENU_GEN_PROC, spec_palettes_item6_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Colour Display",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, spec_palettes_item7_callback,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `levelMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_levelMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	spec_levelMenu_item0_callback();
	extern Menu_item	spec_levelMenu_item1_callback();
	extern Menu_item	spec_levelMenu_item2_callback();
	extern Menu_item	spec_levelMenu_item3_callback();
	extern Menu_item	spec_levelMenu_item4_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Default",
			MENU_GEN_PROC, spec_levelMenu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear...",
			MENU_GEN_PROC, spec_levelMenu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-log...",
			MENU_GEN_PROC, spec_levelMenu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Add level",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, spec_levelMenu_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Remove level",
			MENU_GEN_PROC, spec_levelMenu_item4_callback,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Create object `windowMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_windowMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	spec_windowMenu_item0_callback();
	extern Menu_item	spec_windowMenu_item1_callback();
	extern Menu_item	spec_windowMenu_item2_callback();
	extern Menu_item	spec_windowMenu_item3_callback();
	extern Menu_item	spec_windowMenu_item4_callback();
	extern Menu_item	spec_windowMenu_item5_callback();
	extern Menu_item	spec_windowMenu_item6_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without window",
			MENU_GEN_PROC, spec_windowMenu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside window",
			MENU_GEN_PROC, spec_windowMenu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside window",
			MENU_GEN_PROC, spec_windowMenu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show window",
			MENU_GEN_PROC, spec_windowMenu_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set window",
			MENU_GEN_PROC, spec_windowMenu_item4_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear window",
			MENU_GEN_PROC, spec_windowMenu_item5_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort set window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, spec_windowMenu_item6_callback,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `autoscaleMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_autoscaleMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	spec_autoscaleMenu_item0_callback();
	extern Menu_item	spec_autoscaleMenu_item1_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear",
			MENU_GEN_PROC, spec_autoscaleMenu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-logarithmic",
			MENU_GEN_PROC, spec_autoscaleMenu_item1_callback,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Create object `magnifyMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_magnifyMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	spec_magnifyMenu_item0_callback();
	extern Menu_item	spec_magnifyMenu_item1_callback();
	extern Menu_item	spec_magnifyMenu_item2_callback();
	extern Menu_item	spec_magnifyMenu_item3_callback();
	extern Menu_item	spec_magnifyMenu_item4_callback();
	extern Menu_item	spec_magnifyMenu_item5_callback();
	extern Menu_item	spec_magnifyMenu_item6_callback();
	extern Menu_item	spec_magnifyMenu_item7_callback();
	extern Menu_item	spec_magnifyMenu_item8_callback();
	extern Menu_item	spec_magnifyMenu_item9_callback();
	extern Menu_item	spec_magnifyMenu_item10_callback();
	extern Menu_item	spec_magnifyMenu_item11_callback();
	extern Menu_item	spec_magnifyMenu_item12_callback();
	extern Menu_item	spec_magnifyMenu_item13_callback();
	extern Menu_item	spec_magnifyMenu_item14_callback();
	extern Menu_item	spec_magnifyMenu_item15_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_CHOICE_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_NCOLS, 4,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "1",
			MENU_GEN_PROC, spec_magnifyMenu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "2",
			MENU_GEN_PROC, spec_magnifyMenu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "3",
			MENU_GEN_PROC, spec_magnifyMenu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "4",
			MENU_SELECTED, TRUE,
			MENU_GEN_PROC, spec_magnifyMenu_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "5",
			MENU_GEN_PROC, spec_magnifyMenu_item4_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "6",
			MENU_GEN_PROC, spec_magnifyMenu_item5_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "7",
			MENU_GEN_PROC, spec_magnifyMenu_item6_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "8",
			MENU_GEN_PROC, spec_magnifyMenu_item7_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "9",
			MENU_GEN_PROC, spec_magnifyMenu_item8_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "10",
			MENU_GEN_PROC, spec_magnifyMenu_item9_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "11",
			MENU_GEN_PROC, spec_magnifyMenu_item10_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "12",
			MENU_GEN_PROC, spec_magnifyMenu_item11_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "13",
			MENU_GEN_PROC, spec_magnifyMenu_item12_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "14",
			MENU_GEN_PROC, spec_magnifyMenu_item13_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "15",
			MENU_GEN_PROC, spec_magnifyMenu_item14_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "16",
			MENU_GEN_PROC, spec_magnifyMenu_item15_callback,
			NULL,
		MENU_DEFAULT, 4,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `specWindow'.
 */
spec_specWindow_objects *
spec_specWindow_objects_initialize(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_specWindow_objects *) calloc(1, sizeof (spec_specWindow_objects))))
		return (spec_specWindow_objects *) NULL;
	if (!ip->specWindow)
		ip->specWindow = spec_specWindow_specWindow_create(ip, owner);
	if (!ip->spectrumControls)
		ip->spectrumControls = spec_specWindow_spectrumControls_create(ip, ip->specWindow);
	if (!ip->printButton)
		ip->printButton = spec_specWindow_printButton_create(ip, ip->spectrumControls);
	if (!ip->contourButton)
		ip->contourButton = spec_specWindow_contourButton_create(ip, ip->spectrumControls);
	if (!ip->windowButton)
		ip->windowButton = spec_specWindow_windowButton_create(ip, ip->spectrumControls);
	if (!ip->autoscaleButton)
		ip->autoscaleButton = spec_specWindow_autoscaleButton_create(ip, ip->spectrumControls);
	if (!ip->sliceButton)
		ip->sliceButton = spec_specWindow_sliceButton_create(ip, ip->spectrumControls);
	if (!ip->magnifyButton)
		ip->magnifyButton = spec_specWindow_magnifyButton_create(ip, ip->spectrumControls);
	if (!ip->forkButton)
		ip->forkButton = spec_specWindow_forkButton_create(ip, ip->spectrumControls);
	if (!ip->xy)
		ip->xy = spec_specWindow_xy_create(ip, ip->spectrumControls);
	if (!ip->coordinates)
		ip->coordinates = spec_specWindow_coordinates_create(ip, ip->spectrumControls);
	if (!ip->spectrum)
		ip->spectrum = spec_specWindow_spectrum_create(ip, ip->specWindow);
	return ip;
}

/*
 * Create object `specWindow' in the specified instance.
 */
Xv_opaque
spec_specWindow_specWindow_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 514,
		XV_HEIGHT, 578,
		XV_LABEL, "Spectrum nn",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `spectrumControls' in the specified instance.
 */
Xv_opaque
spec_specWindow_spectrumControls_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 64,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_printButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_specWindow_printButton_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Print...",
		PANEL_NOTIFY_PROC, spec_specWindow_printButton_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `contourButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_contourButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_specWindow_contourButton_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 73,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Contours...",
		PANEL_NOTIFY_PROC, spec_specWindow_contourButton_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `windowButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_windowButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 163,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Window",
		PANEL_ITEM_MENU, spec_windowMenu_create((caddr_t) ip, ip->specWindow),
		NULL);
	return obj;
}

/*
 * Create object `autoscaleButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_autoscaleButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Autoscale",
		PANEL_ITEM_MENU, spec_autoscaleMenu_create((caddr_t) ip, ip->specWindow),
		NULL);
	return obj;
}
/************************** sjah 16/1/95 ****************************************/
/*
 * Create object `sliceButton' in the specified instance.
 */
/********Xv_opaque
spec_specWindow_sliceButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_specWindow_sliceButton_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 350,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Slicing...",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, spec_specWindow_sliceButton_notify_callback,
		NULL);
	return obj;
} **********/

/*
 * Create object `slicingMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_slicingMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{

        extern Menu_item	spec_slicingMenu_item0_callback();
	extern Menu_item	spec_slicingMenu_item1_callback();
	extern Menu_item	spec_slicingMenu_item2_callback();
	extern Menu_item	spec_slicingMenu_item3_callback();
        extern Menu_item	spec_windowMenu_item0_callback();
	extern Menu_item	spec_windowMenu_item1_callback();
	extern Menu_item	spec_windowMenu_item2_callback();
        extern Menu_item	spec_windowMenu_item6_callback();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Slicing On",
			MENU_GEN_PROC, spec_slicingMenu_item0_callback, 
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Slice Window",
			MENU_GEN_PROC, spec_slicingMenu_item1_callback, 
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reslice",
			MENU_GEN_PROC, spec_slicingMenu_item2_callback, 
			NULL,
       /* call directly the functions defined for windowMenu here */
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Arbitrary angle",
			MENU_GEN_PROC, spec_slicingMenu_item3_callback, 
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort Slice Window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, spec_windowMenu_item6_callback, 
			NULL,
		MENU_ITEM,
			MENU_STRING, "",
			MENU_INACTIVE, TRUE,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without Window",
			MENU_GEN_PROC, spec_windowMenu_item0_callback, 
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside Window",
			MENU_GEN_PROC, spec_windowMenu_item1_callback, 
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside Window",
			MENU_GEN_PROC, spec_windowMenu_item2_callback, 
			NULL,		
		NULL);
	return obj;
}

Xv_opaque
spec_specWindow_sliceButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 350,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Slicing",
		PANEL_ITEM_MENU, spec_slicingMenu_create((caddr_t) ip, ip->specWindow),
		NULL);
	return obj;
}
/*********************** end sjah 16/1/95 ****************************************/
/*
 * Create object `magnifyButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_magnifyButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 425,
		XV_Y, 7,
		PANEL_LABEL_STRING, "Magnify",
		PANEL_ITEM_MENU, spec_magnifyMenu_create((caddr_t) ip, ip->specWindow),
		NULL);
	return obj;
}

/*
 * Create object `forkButton' in the specified instance.
 */
Xv_opaque
spec_specWindow_forkButton_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	extern void		forkProgram();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 456,
		XV_Y, 32,
		PANEL_LABEL_STRING, "Fork",
		PANEL_NOTIFY_PROC, forkProgram,
		NULL);
	return obj;
}

/*
 * Create object `xy' in the specified instance.
 */
Xv_opaque
spec_specWindow_xy_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 34,
		PANEL_LABEL_STRING, "X,Y,Counts:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `coordinates' in the specified instance.
 */
Xv_opaque
spec_specWindow_coordinates_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 91,
		XV_Y, 34,
		PANEL_LABEL_STRING, "(X, Y) = Counts",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `spectrum' in the specified instance.
 */
Xv_opaque
spec_specWindow_spectrum_create(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
	extern Notify_value	rubberBand();
	extern void	repaintSpectrum();
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->spectrumControls, XV_Y) +
		      (int)xv_get(ip->spectrumControls, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, repaintSpectrum,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	xv_set(canvas_paint_window(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		NULL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) rubberBand, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Initialize an instance of object `contourPopup'.
 */
spec_contourPopup_objects *
spec_contourPopup_objects_initialize(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_contourPopup_objects *) calloc(1, sizeof (spec_contourPopup_objects))))
		return (spec_contourPopup_objects *) NULL;
	if (!ip->contourPopup)
		ip->contourPopup = spec_contourPopup_contourPopup_create(ip, owner);
	if (!ip->contourControls)
		ip->contourControls = spec_contourPopup_contourControls_create(ip, ip->contourPopup);
	if (!ip->presetPalette)
		ip->presetPalette = spec_contourPopup_presetPalette_create(ip, ip->contourControls);
	if (!ip->levels)
		ip->levels = spec_contourPopup_levels_create(ip, ip->contourControls);
	return ip;
}

/*
 * Create object `contourPopup' in the specified instance.
 */
Xv_opaque
spec_contourPopup_contourPopup_create(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 540,
		XV_HEIGHT, 548,
		XV_LABEL, "Contours",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `contourControls' in the specified instance.
 */
Xv_opaque
spec_contourPopup_contourControls_create(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `presetPalette' in the specified instance.
 */
Xv_opaque
spec_contourPopup_presetPalette_create(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Palettes",
		PANEL_ITEM_MENU, spec_palettes_create((caddr_t) ip, ip->contourPopup),
		NULL);
	return obj;
}

/*
 * Create object `levels' in the specified instance.
 */
Xv_opaque
spec_contourPopup_levels_create(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 105,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Levels",
		PANEL_ITEM_MENU, spec_levelMenu_create((caddr_t) ip, ip->contourPopup),
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `levelPopup'.
 */
spec_levelPopup_objects *
spec_levelPopup_objects_initialize(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_levelPopup_objects *) calloc(1, sizeof (spec_levelPopup_objects))))
		return (spec_levelPopup_objects *) NULL;
	if (!ip->levelPopup)
		ip->levelPopup = spec_levelPopup_levelPopup_create(ip, owner);
	if (!ip->levelControls)
		ip->levelControls = spec_levelPopup_levelControls_create(ip, ip->levelPopup);
	if (!ip->firstValue)
		ip->firstValue = spec_levelPopup_firstValue_create(ip, ip->levelControls);
	if (!ip->spacing)
		ip->spacing = spec_levelPopup_spacing_create(ip, ip->levelControls);
	if (!ip->step)
		ip->step = spec_levelPopup_step_create(ip, ip->levelControls);
	if (!ip->numContours)
		ip->numContours = spec_levelPopup_numContours_create(ip, ip->levelControls);
	if (!ip->levelSetApply)
		ip->levelSetApply = spec_levelPopup_levelSetApply_create(ip, ip->levelControls);
	return ip;
}

/*
 * Create object `levelPopup' in the specified instance.
 */
Xv_opaque
spec_levelPopup_levelPopup_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 240,
		XV_HEIGHT, 120,
		XV_LABEL, "Set contour levels",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `levelControls' in the specified instance.
 */
Xv_opaque
spec_levelPopup_levelControls_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `firstValue' in the specified instance.
 */
Xv_opaque
spec_levelPopup_firstValue_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 65,
		XV_Y, 8,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "First contour:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `spacing' in the specified instance.
 */
Xv_opaque
spec_levelPopup_spacing_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 98,
		XV_Y, 32,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Spacing:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `step' in the specified instance.
 */
Xv_opaque
spec_levelPopup_step_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 122,
		XV_Y, 32,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Step:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `numContours' in the specified instance.
 */
Xv_opaque
spec_levelPopup_numContours_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 13,
		XV_Y, 58,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Number of Contours:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `levelSetApply' in the specified instance.
 */
Xv_opaque
spec_levelPopup_levelSetApply_create(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 88,
		PANEL_LABEL_STRING, "Apply",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `gammaPopup'.
 */
spec_gammaPopup_objects *
spec_gammaPopup_objects_initialize(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_gammaPopup_objects *) calloc(1, sizeof (spec_gammaPopup_objects))))
		return (spec_gammaPopup_objects *) NULL;
	if (!ip->gammaPopup)
		ip->gammaPopup = spec_gammaPopup_gammaPopup_create(ip, owner);
	if (!ip->gammaControls)
		ip->gammaControls = spec_gammaPopup_gammaControls_create(ip, ip->gammaPopup);
	if (!ip->displayGammaLabel)
		ip->displayGammaLabel = spec_gammaPopup_displayGammaLabel_create(ip, ip->gammaControls);
	if (!ip->displayGammaValue)
		ip->displayGammaValue = spec_gammaPopup_displayGammaValue_create(ip, ip->gammaControls);
	if (!ip->displayGammaSlider)
		ip->displayGammaSlider = spec_gammaPopup_displayGammaSlider_create(ip, ip->gammaControls);
	if (!ip->printoutGammaLabel)
		ip->printoutGammaLabel = spec_gammaPopup_printoutGammaLabel_create(ip, ip->gammaControls);
	if (!ip->printoutGammaValue)
		ip->printoutGammaValue = spec_gammaPopup_printoutGammaValue_create(ip, ip->gammaControls);
	if (!ip->printoutGammaSlider)
		ip->printoutGammaSlider = spec_gammaPopup_printoutGammaSlider_create(ip, ip->gammaControls);
	return ip;
}

/*
 * Create object `gammaPopup' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_gammaPopup_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 334,
		XV_HEIGHT, 55,
		XV_LABEL, "Set Gamma",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `gammaControls' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_gammaControls_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `displayGammaLabel' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_displayGammaLabel_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Display Gamma:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `displayGammaValue' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_displayGammaValue_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	spec_gammaPopup_displayGammaValue_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 123,
		XV_Y, 8,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "2.00",
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, spec_gammaPopup_displayGammaValue_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `displayGammaSlider' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_displayGammaSlider_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_gammaPopup_displayGammaSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 167,
		XV_Y, 8,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 10,
		PANEL_MAX_VALUE, 1000,
		PANEL_MIN_VALUE_STRING, "0.1",
		PANEL_MAX_VALUE_STRING, "10",
		PANEL_VALUE, 200,
		PANEL_NOTIFY_PROC, spec_gammaPopup_displayGammaSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `printoutGammaLabel' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_printoutGammaLabel_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 6,
		XV_Y, 32,
		PANEL_LABEL_STRING, "Printout Gamma:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `printoutGammaValue' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_printoutGammaValue_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	spec_gammaPopup_printoutGammaValue_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 123,
		XV_Y, 32,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "1.00",
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, spec_gammaPopup_printoutGammaValue_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `printoutGammaSlider' in the specified instance.
 */
Xv_opaque
spec_gammaPopup_printoutGammaSlider_create(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_gammaPopup_printoutGammaSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 167,
		XV_Y, 32,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 10,
		PANEL_MAX_VALUE, 1000,
		PANEL_MIN_VALUE_STRING, "0.1",
		PANEL_MAX_VALUE_STRING, "10",
		PANEL_VALUE, 100,
		PANEL_NOTIFY_PROC, spec_gammaPopup_printoutGammaSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `rgbPopup'.
 */
spec_rgbPopup_objects *
spec_rgbPopup_objects_initialize(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_rgbPopup_objects *) calloc(1, sizeof (spec_rgbPopup_objects))))
		return (spec_rgbPopup_objects *) NULL;
	if (!ip->rgbPopup)
		ip->rgbPopup = spec_rgbPopup_rgbPopup_create(ip, owner);
	if (!ip->rgbControls)
		ip->rgbControls = spec_rgbPopup_rgbControls_create(ip, ip->rgbPopup);
	if (!ip->redSlider)
		ip->redSlider = spec_rgbPopup_redSlider_create(ip, ip->rgbControls);
	if (!ip->greenSlider)
		ip->greenSlider = spec_rgbPopup_greenSlider_create(ip, ip->rgbControls);
	if (!ip->blueSlider)
		ip->blueSlider = spec_rgbPopup_blueSlider_create(ip, ip->rgbControls);
	return ip;
}

/*
 * Create object `rgbPopup' in the specified instance.
 */
Xv_opaque
spec_rgbPopup_rgbPopup_create(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 323,
		XV_HEIGHT, 83,
		XV_LABEL, "Set Colour",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `rgbControls' in the specified instance.
 */
Xv_opaque
spec_rgbPopup_rgbControls_create(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `redSlider' in the specified instance.
 */
Xv_opaque
spec_rgbPopup_redSlider_create(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_rgbPopup_redSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 8,
		PANEL_SLIDER_WIDTH, 128,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Red:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, TRUE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 255,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, spec_rgbPopup_redSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `greenSlider' in the specified instance.
 */
Xv_opaque
spec_rgbPopup_greenSlider_create(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_rgbPopup_greenSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 9,
		XV_Y, 32,
		PANEL_SLIDER_WIDTH, 128,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Green:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, TRUE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 255,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, spec_rgbPopup_greenSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `blueSlider' in the specified instance.
 */
Xv_opaque
spec_rgbPopup_blueSlider_create(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_rgbPopup_blueSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 18,
		XV_Y, 56,
		PANEL_SLIDER_WIDTH, 128,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Blue:",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, TRUE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 255,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, spec_rgbPopup_blueSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `printerPopup'.
 */
spec_printerPopup_objects *
spec_printerPopup_objects_initialize(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_printerPopup_objects *) calloc(1, sizeof (spec_printerPopup_objects))))
		return (spec_printerPopup_objects *) NULL;
	if (!ip->printerPopup)
		ip->printerPopup = spec_printerPopup_printerPopup_create(ip, owner);
	if (!ip->printerControls)
		ip->printerControls = spec_printerPopup_printerControls_create(ip, ip->printerPopup);
	if (!ip->printTo)
		ip->printTo = spec_printerPopup_printTo_create(ip, ip->printerControls);
	if (!ip->printerPalette)
		ip->printerPalette = spec_printerPopup_printerPalette_create(ip, ip->printerControls);
	if (!ip->printString)
		ip->printString = spec_printerPopup_printString_create(ip, ip->printerControls);
	if (!ip->printFilename)
		ip->printFilename = spec_printerPopup_printFilename_create(ip, ip->printerControls);
	if (!ip->printXLabel)
		ip->printXLabel = spec_printerPopup_printXLabel_create(ip, ip->printerControls);
	if (!ip->printYLabel)
		ip->printYLabel = spec_printerPopup_printYLabel_create(ip, ip->printerControls);
	if (!ip->printTitle)
		ip->printTitle = spec_printerPopup_printTitle_create(ip, ip->printerControls);
	if (!ip->printSubtitle)
		ip->printSubtitle = spec_printerPopup_printSubtitle_create(ip, ip->printerControls);
	if (!ip->printScaleSlider)
		ip->printScaleSlider = spec_printerPopup_printScaleSlider_create(ip, ip->printerControls);
	if (!ip->printXGain)
		ip->printXGain = spec_printerPopup_printXGain_create(ip, ip->printerControls);
	if (!ip->printXOffset)
		ip->printXOffset = spec_printerPopup_printXOffset_create(ip, ip->printerControls);
	if (!ip->printYGain)
		ip->printYGain = spec_printerPopup_printYGain_create(ip, ip->printerControls);
	if (!ip->printYOffset)
		ip->printYOffset = spec_printerPopup_printYOffset_create(ip, ip->printerControls);
	if (!ip->doPrint)
		ip->doPrint = spec_printerPopup_doPrint_create(ip, ip->printerControls);
	return ip;
}

/*
 * Create object `printerPopup' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printerPopup_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 450,
		XV_HEIGHT, 295,
		XV_LABEL, "Printer select",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `printerControls' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printerControls_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printTo' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printTo_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_printerPopup_printTo_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 102,
		XV_Y, 8,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Print to:",
		PANEL_NOTIFY_PROC, spec_printerPopup_printTo_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Printer",
			"File (Postscript)",
			"File (Encapsulated Postscript)",
			NULL,
		PANEL_VALUE, 0,
		NULL);
	return obj;
}

/*
 * Create object `printerPalette' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printerPalette_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 54,
		XV_Y, 39,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Printer Palette:",
		PANEL_CHOICE_STRINGS,
			"White to Black (no gamma)",
			"Greyscale version of display (gamma)",
			"Colour (gamma)",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `printString' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printString_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 70,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Printer control string:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "lp -o nobanner -c -d lw",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printFilename' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printFilename_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 52,
		XV_Y, 70,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Print Filename:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "pout.ps",
		XV_SHOW, FALSE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printXLabel' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printXLabel_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 93,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "X label:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printYLabel' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printYLabel_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 101,
		XV_Y, 116,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Y Label:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printTitle' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printTitle_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 120,
		XV_Y, 139,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Title:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printSubtitle' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printSubtitle_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 98,
		XV_Y, 160,
		PANEL_VALUE_DISPLAY_LENGTH, 35,
		PANEL_VALUE_STORED_LENGTH, 255,
		PANEL_LABEL_STRING, "Subtitle:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `printScaleSlider' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printScaleSlider_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 77,
		XV_Y, 184,
		PANEL_SLIDER_WIDTH, 150,
		PANEL_TICKS, 16,
		PANEL_LABEL_STRING, "Scaling (%):",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, TRUE,
		PANEL_MIN_VALUE, 25,
		PANEL_MAX_VALUE, 400,
		PANEL_VALUE, 100,
		NULL);
	return obj;
}

/*
 * Create object `printXGain' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printXGain_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_printerPopup_printXGain_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 13,
		    XV_Y, 208,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "X: Units = channels *",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "1",
		    PANEL_NOTIFY_PROC,
		        spec_printerPopup_printXGain_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `printXOffset' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printXOffset_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_printerPopup_printXOffset_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 235,
		    XV_Y, 208,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "+",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_printerPopup_printXOffset_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `printYGain' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printYGain_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_printerPopup_printYGain_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 13,
		    XV_Y, 232,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "Y: Units = channels *",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "1",
		    PANEL_NOTIFY_PROC,
		        spec_printerPopup_printYGain_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `printYOffset' in the specified instance.
 */
Xv_opaque
spec_printerPopup_printYOffset_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_printerPopup_printYOffset_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 235,
		    XV_Y, 232,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "+",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_printerPopup_printYOffset_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `doPrint' in the specified instance.
 */
Xv_opaque
spec_printerPopup_doPrint_create(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_printerPopup_doPrint_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 264,
		PANEL_LABEL_STRING, "Print",
		PANEL_NOTIFY_PROC, spec_printerPopup_doPrint_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `projectPopup'.
 */
spec_projectPopup_objects *
spec_projectPopup_objects_initialize(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (spec_projectPopup_objects *) calloc(1, sizeof (spec_projectPopup_objects))))
		return (spec_projectPopup_objects *) NULL;
	if (!ip->projectPopup)
		ip->projectPopup = spec_projectPopup_projectPopup_create(ip, owner);
	if (!ip->projectControls)
		ip->projectControls = spec_projectPopup_projectControls_create(ip, ip->projectPopup);
	if (!ip->projectArea)
		ip->projectArea = spec_projectPopup_projectArea_create(ip, ip->projectControls);
	if (!ip->projectAxis)
		ip->projectAxis = spec_projectPopup_projectAxis_create(ip, ip->projectControls);
	if (!ip->projectAngleLabel)
		ip->projectAngleLabel = spec_projectPopup_projectAngleLabel_create(ip, ip->projectControls);
	if (!ip->projectAngleValue)
		ip->projectAngleValue = spec_projectPopup_projectAngleValue_create(ip, ip->projectControls);
	if (!ip->projectAngleSlider)
		ip->projectAngleSlider = spec_projectPopup_projectAngleSlider_create(ip, ip->projectControls);
	if (!ip->doProject)
		ip->doProject = spec_projectPopup_doProject_create(ip, ip->projectControls);
	if (!ip->projectXGain)
		ip->projectXGain = spec_projectPopup_projectXGain_create(ip, ip->projectControls);
	if (!ip->projectXOffset)
		ip->projectXOffset = spec_projectPopup_projectXOffset_create(ip, ip->projectControls);
	if (!ip->projectYGain)
		ip->projectYGain = spec_projectPopup_projectYGain_create(ip, ip->projectControls);
	if (!ip->projectYOffset)
		ip->projectYOffset = spec_projectPopup_projectYOffset_create(ip, ip->projectControls);
	if (!ip->passingLabel)
		ip->passingLabel = spec_projectPopup_passingLabel_create(ip, ip->projectControls);
	if (!ip->projectXTarget)
		ip->projectXTarget = spec_projectPopup_projectXTarget_create(ip, ip->projectControls);
	if (!ip->projectYTarget)
		ip->projectYTarget = spec_projectPopup_projectYTarget_create(ip, ip->projectControls);
	if (!ip->polynomial)
		ip->polynomial = spec_projectPopup_polynomial_create(ip, ip->projectControls);
	if (!ip->scaleUp)
		ip->scaleUp = spec_projectPopup_scaleUp_create(ip, ip->projectControls);
	if (!ip->scaleDown)
		ip->scaleDown = spec_projectPopup_scaleDown_create(ip, ip->projectControls);
	if (!ip->projection)
		ip->projection = spec_projectPopup_projection_create(ip, ip->projectPopup);
	return ip;
}

/*
 * Create object `projectPopup' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectPopup_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern projectDone();
	    
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 512,
		XV_HEIGHT, 416,
		XV_LABEL, "Slicing",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		FRAME_DONE_PROC, projectDone,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `projectControls' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectControls_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 160,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `projectArea' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectArea_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern void spec_projectPopup_projectArea_notify_callback();
    Xv_opaque obj;
	
    obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 8,
		    XV_Y, 8,
		    PANEL_CHOICE_NCOLS, 1,
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_LABEL_STRING, "Project Area:",
		    PANEL_CHOICE_STRINGS,
		        "Whole spectrum",
		        "Inside window",
		        NULL,
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectArea_notify_callback,
		    NULL);
    return obj;
}

/*
 * Create object `projectAngleLabel' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectAngleLabel_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 40,
		PANEL_LABEL_STRING, "Projection angle:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `projectAngleValue' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectAngleValue_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting	spec_projectPopup_projectAngleValue_notify_callback();
    Xv_opaque	obj;
    
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 130,
		    XV_Y, 40,
		    PANEL_VALUE_DISPLAY_LENGTH, 5,
		    PANEL_VALUE_STORED_LENGTH, 5,
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "90.0",
		    PANEL_READ_ONLY, FALSE,
		    PANEL_NOTIFY_PROC, spec_projectPopup_projectAngleValue_notify_callback,
		    NULL);
    return obj;
}

/*
 * Create object `projectAngleSlider' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectAngleSlider_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void		spec_projectPopup_projectAngleSlider_notify_callback();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 175,
		XV_Y, 40,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_TICKS, 0,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 1800,
		PANEL_MIN_VALUE_STRING, "0.0",
		PANEL_MAX_VALUE_STRING, "180.0",
		PANEL_VALUE, 900,
		PANEL_NOTIFY_PROC, spec_projectPopup_projectAngleSlider_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `doProject' in the specified instance.
 */
Xv_opaque
spec_projectPopup_doProject_create(ip, owner)
spec_projectPopup_objects	*ip;
Xv_opaque	owner;
{
    extern void doProjection();
    Xv_opaque	obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 408,
		    XV_Y, 8,
		    PANEL_LABEL_STRING, "Do Projection",
		    PANEL_NOTIFY_PROC, doProjection,
		    NULL);
    return obj;
}

/*
 * Create object `projection' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projection_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	extern void	repaintProjection();
	Xv_opaque	obj;
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->projectControls, XV_Y) +
		      (int)xv_get(ip->projectControls, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, repaintProjection,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	return obj;
}

/*
 * Create object `projectAxis' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectAxis_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern void spec_projectPopup_projectAxis_notify_callback();
    Xv_opaque obj;
	
    obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 240,
		    XV_Y, 8,
		    PANEL_CHOICE_NCOLS, 1,
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_LABEL_STRING, "Axis:",
		    PANEL_CHOICE_STRINGS,
		        "Perpendicular",
		        "X",
		        "Y",
		        NULL,
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectAxis_notify_callback,
		    NULL);
    return obj;
}

/*
 * Create object `projectXGain' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectXGain_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectXGain_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 8,
		    XV_Y, 72,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "X: Degrees = channels *",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "1",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectXGain_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `projectXOffset' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectXOffset_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectXOffset_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 240,
		    XV_Y, 72,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "+",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectXOffset_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `projectYGain' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectYGain_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectYGain_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 8,
		    XV_Y, 104,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "Y: Degrees = channels *",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "1",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectYGain_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `projectYOffset' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectYOffset_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectYOffset_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 240,
		    XV_Y, 104,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "+",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectYOffset_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `passingLabel' in the specified instance.
 */
Xv_opaque
spec_projectPopup_passingLabel_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 336,
		XV_Y, 88,
		PANEL_LABEL_STRING, "Project onto line through",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `projectXTarget' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectXTarget_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectXTarget_notify_callback();
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 356,
		    XV_Y, 104,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, "",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectXTarget_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `projectYTarget' in the specified instance.
 */
Xv_opaque
spec_projectPopup_projectYTarget_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_projectYTarget_notify_callback(); 
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 424,
		    XV_Y, 104,
		    PANEL_VALUE_DISPLAY_LENGTH, 8,
		    PANEL_VALUE_STORED_LENGTH, 80,
		    PANEL_LABEL_STRING, ",",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, "0",
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_projectYTarget_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `polynomial' in the specified instance.
 */
Xv_opaque
spec_projectPopup_polynomial_create(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting spec_projectPopup_polynomial_notify_callback(); 
    Xv_opaque	obj;
	
    obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 8,
		    XV_Y, 136,
		    PANEL_VALUE_DISPLAY_LENGTH, 2,
		    PANEL_VALUE_STORED_LENGTH, 4,
		    PANEL_LABEL_STRING, "|P|\262 order",
		    PANEL_LAYOUT, PANEL_HORIZONTAL,
		    PANEL_VALUE, 0,
		    PANEL_MIN_VALUE, 0,
		    PANEL_MAX_VALUE, 50,
		    PANEL_NOTIFY_PROC,
		        spec_projectPopup_polynomial_notify_callback,
		    PANEL_READ_ONLY, FALSE,
		    NULL);
    return obj;
}

/*
 * Create object `scaleUp' in the specified instance.
 */
Xv_opaque
spec_projectPopup_scaleDown_create(ip, owner)
spec_projectPopup_objects	*ip;
Xv_opaque	owner;
{
    extern void scaleDown();
    Xv_opaque	obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 160,
		    XV_Y, 136,
		    PANEL_LABEL_STRING, "-",
		    PANEL_NOTIFY_PROC, scaleDown,
		    NULL);
    return obj;
}

/*
 * Create object `scaleUp' in the specified instance.
 */
Xv_opaque
spec_projectPopup_scaleUp_create(ip, owner)
spec_projectPopup_objects	*ip;
Xv_opaque	owner;
{
    extern void scaleUp();
    Xv_opaque	obj;
    
    obj = xv_create(owner, PANEL_BUTTON,
		    XV_KEY_DATA, INSTANCE, ip,
		    XV_X, 192,
		    XV_Y, 136,
		    PANEL_LABEL_STRING, "+",
		    PANEL_NOTIFY_PROC, scaleUp,
		    NULL);
    return obj;
}

