
# line 10 "fortran.y"

/*
  fortran.c:

    Copyright (C) 1992 by Robert K. Moniot.
    This program is free software.  Permission is granted to
    modify it and/or redistribute it.  There is no warranty
    for this program.


	    This grammar is ANSI standard-conforming, except for:
		-- Sensitive to whitespace, which is used in lexical analysis
		   to separate keywords and identifiers from context.  This
		   is a design feature.  Rules are the same as for Pascal.
		   (Of course stmt fields and end-of-line still honored.)
		   Note: a complex constant cannot be split across lines.
		-- Currently, some keywords are partially reserved: may
		   only be used for scalar variables.  (See keywords.c)  This
		   is the fault of the lexical analyzer (too little lookahead).

	    Extensions supported:
	        -- Case insensitive.
	 	-- Hollerith constants.
		-- Variable names may be longer than 6 characters.  Also
		   allows underscores in names.
		-- DO ... ENDDO and DO WHILE loop forms allowed.
		-- TYPE and ACCEPT I/O statements allowed.
		-- Tabs are permitted in input, and (except in character data)
		   expand into blanks up to the next column equal to 1 mod 8.
		-- Type declarations INTEGER*2, REAL*8, etc. are allowed.
		   REAL*8 becomes DOUBLE PRECISION.  For others, length spec
		   is ignored.
		-- IMPLICIT NONE allowed.
	 */

/*  Author: R. Moniot
 *  Date:   August 1988
 *  Last revision: January 1992
 */

#include <stdio.h>
#include <string.h>
#include "ftnchek.h"
#include "symtab.h"
void exit();



int current_datatype,	/* set when parse type_name or type_stmt */
    stmt_sequence_no,   /* set when parsing, reset to 0 at end_stmt */
    control_item_count;	/* count of items in control_info_list */

extern unsigned prev_stmt_line_num; /* shared with advance */

int current_module_hash = -1,	/* hashtable index of current module name */
    current_module_type,
    executable_stmt=FALSE,
    prev_stmt_class=0,
		 /* flags for lexer */
    complex_const_allowed=FALSE, /* for help in lookahead for these */
    inside_format=FALSE,	/* when inside parens of FORMAT  */
    integer_context=FALSE,	/* says integers-only are to follow */
    prev_goto=FALSE,
    goto_flag=FALSE;	/* if unconditional GOTO was encountered */

long exec_stmt_count=0;	/* count of executable stmts in program */

PRIVATE void
  print_comlist(), print_exprlist(), END_processing();
PRIVATE Token *
  append_token();

		/* Uses of Token fields for nonterminals: */
/*
  1. dim_bound_lists: dimensioning info for arrays:
       token.class = no. of dimensions,
       token.subclass = no. of elements
  2. expressions
       token.class = type_byte = storage_class << 4 + datatype
       token.subclass = flags: CONST_EXPR, LVALUE_EXPR, etc.
  3. common variable lists
       token.subclass = flag: COMMA_FLAG used to handle extra/missing commas
*/

#define seq_header   1
#define seq_implicit 2
#define seq_specif   3
#define seq_stmt_fun 4
#define seq_exec     5
#define seq_end      6

#define DBG(S)	if(debug_parser) fprintf(list_fd,"\nproduction: S");
#define DBGstr(S,str) \
	if(debug_parser) fprintf(list_fd,"\nproduction: S%s",str);

# define tok_identifier 257
# define tok_label 258
# define tok_integer_const 259
# define tok_real_const 260
# define tok_dp_const 261
# define tok_complex_const 262
# define tok_logical_const 263
# define tok_string 264
# define tok_hollerith 265
# define tok_edit_descriptor 266
# define tok_letter 267
# define tok_relop 268
# define tok_AND 269
# define tok_OR 270
# define tok_EQV 271
# define tok_NEQV 272
# define tok_NOT 273
# define tok_power 274
# define tok_concat 275
# define tok_ASSIGN 276
# define tok_ACCEPT 277
# define tok_BACKSPACE 278
# define tok_BLOCK 279
# define tok_CALL 280
# define tok_CHARACTER 281
# define tok_CLOSE 282
# define tok_COMMON 283
# define tok_COMPLEX 284
# define tok_CONTINUE 285
# define tok_DATA 286
# define tok_DIMENSION 287
# define tok_DO 288
# define tok_DOUBLE 289
# define tok_DOWHILE 290
# define tok_ELSE 291
# define tok_ELSEIF 292
# define tok_END 293
# define tok_ENDDO 294
# define tok_ENDFILE 295
# define tok_ENDIF 296
# define tok_ENTRY 297
# define tok_EQUIVALENCE 298
# define tok_EXTERNAL 299
# define tok_FORMAT 300
# define tok_FUNCTION 301
# define tok_GO 302
# define tok_GOTO 303
# define tok_IF 304
# define tok_IMPLICIT 305
# define tok_INCLUDE 306
# define tok_INQUIRE 307
# define tok_INTEGER 308
# define tok_INTRINSIC 309
# define tok_LOGICAL 310
# define tok_OPEN 311
# define tok_PARAMETER 312
# define tok_PAUSE 313
# define tok_PRECISION 314
# define tok_PRINT 315
# define tok_PROGRAM 316
# define tok_READ 317
# define tok_REAL 318
# define tok_RETURN 319
# define tok_REWIND 320
# define tok_SAVE 321
# define tok_STOP 322
# define tok_SUBROUTINE 323
# define tok_TO 324
# define tok_TYPE 325
# define tok_THEN 326
# define tok_WHILE 327
# define tok_WRITE 328
# define tok_illegal 329
# define EOS 127
# define REDUCE 331
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 2249 "fortran.y"

void
init_parser()			/* Initialize various flags & counters */
{
	initial_flag = TRUE;	/* set flag for keyword test */
	implicit_flag=FALSE;	/* clear flags for IMPLICIT stmt */
	implicit_letter_flag = FALSE;
	implicit_type_given = FALSE;
	implicit_none = FALSE;
	prev_token_class = EOS;
	complex_const_allowed = FALSE;
	stmt_sequence_no = 0;
}

/* Debugging routine: prints the expression list of various productions */

PRIVATE void
print_exprlist(s,t)
	char *s;
	Token *t;
{

	fprintf(list_fd,"\n%s arglist: ",s);

	if(t == NULL)
		fprintf(list_fd,"(empty)");
	else {
  	    while( (t=t->next_token) != NULL) {
		  fprintf(list_fd,"%s ",type_name[datatype_of(t->class)]);
		  if( is_true(ID_EXPR,t->subclass) )
			fprintf(list_fd,"(%s) ",token_name(*t));
	    }
	}
}

PRIVATE void
print_comlist(s,t)
	char *s;
	Token *t;
{

	fprintf(list_fd,"\n%s varlist: ",s);

	if(t == NULL)
		fprintf(list_fd,"(empty)");
	else {
  	    while( (t=t->next_token) != NULL) {
		  fprintf(list_fd,"%s ",type_name[datatype_of(t->class)]);
		  if( is_true(ID_EXPR,t->subclass) )
			fprintf(list_fd,"(%s) ",token_name(*t));
		}
	  }
}

/* After having parsed prog_stmt, function_stmt, subroutine_stmt,
   block_data_stmt, the stmt_sequence_no is set to the value seq_header.
*/

void
check_seq_header(t)
     Token *t;
{
	if(stmt_sequence_no >= seq_header) {
	   syntax_error( (t == (Token *) NULL? line_num: t->line_num),
			NO_COL_NUM,
			"missing END statement inserted");
	   msg_tail( (t == (Token *) NULL? "at end of file":
		      "prior to statement") );

	   END_processing(t);
	}
	stmt_sequence_no = seq_header;
}




	/* After having parsed end_stmt, common block lists and
	   subprogram argument lists are copied over into global symbol
	   table, the local symbol table is printed out and then cleared,
	   and stmt_sequence_no is set to zero for start of next module.
	*/

PRIVATE void
END_processing(t)
	Token *t;
{
  if(current_module_hash != -1) {
        if(exec_stmt_count == 0 &&
	   current_module_type != type_BLOCK_DATA) {
	  warning(t == (Token *)NULL? line_num: t->line_num, NO_COL_NUM,
		  "Module contains no executable statements");
	}

	if(do_list && t != (Token *)NULL)
	    flush_line_out(t->line_num);
	process_lists(current_module_hash);
	debug_symtabs();
	print_loc_symbols(current_module_hash);
	init_symtab();
  }
  exec_stmt_count = 0;
  stmt_sequence_no = 0;
  current_module_hash = -1;
  implicit_type_given = FALSE;
  implicit_none = FALSE;
}

		/* Routine to add token t to the front of a token list. */
PRIVATE Token *
append_token(tlist,t)
     Token *tlist, *t;
{
	Token *tcopy;
	if((tcopy=new_token()) == (Token *)NULL){
		fprintf(stderr,
			"Out of token space at line %u\n",
			line_num);
		exit(1);
	}

	*tcopy = *t;		/* make permanent copy of token */
	tcopy->next_token = tlist; /* link it onto front of list */
	return tcopy;		/* return it as new tlist */
}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 506,
	268, 0,
	-2, 360,
-1, 576,
	42, 201,
	-2, 203,
-1, 584,
	42, 411,
	-2, 381,
	};
# define YYNPROD 414
# define YYLAST 1289
yytabelem yyact[]={

   245,   353,   369,   528,   473,   357,   527,   573,   569,   339,
   463,   223,   234,   572,   267,   427,   458,   442,   464,   546,
   255,   548,   367,   439,   457,   235,   154,   356,   374,    77,
   249,    76,   220,   115,    75,   115,   365,   128,   437,   241,
   303,   115,   242,   243,   219,   197,   181,   172,   136,   186,
   246,   240,   137,   720,   173,   207,   483,   287,   337,   153,
   315,   293,   162,   292,   281,   160,   114,   116,   270,   133,
   396,   372,   178,   372,   135,   694,   164,   382,   383,   386,
   143,   387,   178,   114,   178,   388,   133,   702,   201,   202,
   205,   135,   178,   131,   570,   134,   253,   257,   259,   141,
   158,   268,   157,   132,   115,   156,   642,   354,   155,   651,
   131,   236,   134,   338,   551,   148,   149,   115,   650,   340,
   132,   168,   275,   176,   182,   187,   187,   192,   194,   198,
   634,   232,   204,   291,   137,   212,   212,   274,   147,   170,
   630,    81,   441,   185,   284,   285,   137,   732,   211,   165,
   203,   165,   324,   213,   171,   311,   278,   279,   280,   359,
   381,   381,   468,   360,   327,   227,   228,   229,   230,   727,
   722,   717,   588,   493,   425,   290,   716,   712,   199,   381,
   711,   698,   697,   199,   696,   695,   690,   381,   689,   688,
   336,   686,   115,   676,   673,   297,   332,   672,   318,   190,
   304,   718,   462,   423,   355,   671,   400,   361,   646,   137,
   644,   398,   631,   163,   205,   625,   656,   619,   326,   176,
   618,   421,   617,   564,   176,   310,   328,   331,    82,    89,
   124,   377,   126,   316,    97,   499,   366,    85,   309,   187,
   177,   145,   317,   714,   679,   120,   358,   125,   351,   484,
   375,   371,   384,   378,   119,   118,   120,   144,   195,    98,
   385,   424,   613,    96,   368,    87,   436,    91,   137,   121,
   611,   100,   123,   477,    86,   366,   622,    92,   207,   366,
   122,   366,   137,   415,   429,   461,   413,   432,   389,   399,
   422,   402,   426,   435,   397,   404,   410,   406,   394,   395,
   179,   163,   137,   368,   431,   382,   383,   368,   420,   368,
   179,   405,   179,   167,   376,   330,   183,   188,   188,   563,
   179,   403,   460,   551,   700,   325,   556,   547,   555,   401,
   559,   553,   340,   350,   370,   379,   382,   383,   348,   474,
   552,   561,   346,   364,   115,   336,   115,   318,   137,   440,
   227,   228,   229,   230,   226,   224,   225,   137,   137,   487,
   382,   383,   580,   451,   579,   184,   137,   137,   137,   168,
   382,   383,   465,   482,   429,   452,   450,   448,   326,   176,
   328,   470,   316,   182,   495,   187,   471,   488,   137,   497,
   498,   317,   236,   137,   431,   478,   480,   479,   236,   198,
   475,   476,   236,   382,   383,   336,   137,   500,   334,   363,
   518,   362,   137,   307,   300,   298,   349,   496,   529,   320,
   525,   347,   306,   509,   510,   345,   504,   511,   343,   537,
   505,   188,   506,   296,   501,   502,   295,   526,   294,   277,
   531,   507,   508,   189,   273,   520,   521,   209,   142,   210,
    84,    57,   585,   163,   540,   163,   519,   368,   368,   577,
   532,   578,   533,   566,   534,    14,   373,   494,   417,   200,
   440,   541,   440,   567,   440,   431,   158,   393,   157,   703,
   216,   156,   392,   368,   155,   565,   268,   681,   335,   481,
   469,   333,   602,   304,   594,   595,   605,   610,   576,   729,
   600,   299,   319,   721,   607,   305,   390,   390,   391,   391,
   313,   709,   236,   312,   591,   609,   599,   604,   713,   708,
   232,   538,   218,   381,   236,   615,   616,   629,   677,   500,
   250,   486,   658,   236,   236,   208,   614,   214,   632,   640,
   553,   368,   554,   654,   592,   627,   655,   557,   558,   552,
   206,   633,   271,   269,   544,   699,   344,   390,   560,   391,
   641,   455,   638,   542,   390,   659,   391,   647,   645,   649,
   231,   648,   251,   252,   539,   183,   137,   188,   227,   228,
   229,   230,   581,   582,   583,   342,   474,   653,   460,   460,
   663,   660,   661,   440,   429,   503,   643,   490,     7,   492,
   667,   453,   268,   624,   675,   665,   492,   678,   329,   670,
   668,   669,   664,   185,   431,   623,   674,   282,   492,   217,
   217,   680,   217,   217,   621,   687,   725,   620,   603,   236,
   710,   486,   590,   529,   691,   591,   693,   707,   465,   586,
   465,   465,   587,   523,   563,   637,   524,   516,   551,   545,
   492,   556,   547,   555,   515,   559,   514,   492,   491,   492,
   485,   492,   443,   486,   701,   444,   561,   705,   577,   685,
   578,   578,   704,   321,   563,   341,   636,   635,   551,   430,
   612,   556,   529,   555,   597,   559,   596,   543,   715,   535,
   286,   593,   589,   719,   489,   454,   561,   434,   239,   418,
   409,   248,   608,   247,   408,   407,   373,   576,   706,   474,
   321,   323,   308,   723,   301,   232,   411,   414,   248,   724,
   247,   726,   529,   288,   283,   728,   730,    16,   137,     8,
   474,   276,   272,   232,   731,   256,   248,   137,   247,   227,
   228,   229,   230,   226,   224,   225,   265,    82,    89,   124,
   110,   126,   114,    97,    74,   133,    85,    71,    72,   127,
   135,   105,   101,   102,    17,   106,   125,   103,    67,    73,
    78,    68,   129,   119,   118,   120,   111,    11,    98,   131,
    79,   134,    96,    69,    87,   606,    91,    63,   121,   132,
   100,   123,    80,    86,   130,   151,    92,    16,   137,   122,
   232,    10,   628,   248,     9,   247,     3,   222,   221,   138,
   140,   238,   626,   139,   412,   522,   264,    82,    89,   124,
   110,   126,   114,    97,    74,   133,    85,    71,    72,   127,
   135,   105,   101,   102,    17,   106,   125,   103,    67,    73,
    78,    68,   129,   119,   118,   120,   111,    99,    98,   131,
    79,   134,    96,    69,    87,   562,    91,    63,   121,   132,
   100,   123,    80,    86,   130,   553,    92,   554,   580,   122,
   579,   550,   557,   558,   552,   232,   549,   150,   248,    93,
   247,    95,    94,   560,   263,   262,   261,   237,   684,   517,
   683,   513,   682,   428,   512,   553,   260,   554,   256,   248,
    88,   247,   557,   558,   552,   289,   380,   233,    90,   419,
   530,   232,   639,   560,   248,   137,   247,   227,   228,   229,
   230,   226,   224,   225,   258,   104,   256,   248,   692,   247,
   416,   244,   137,   433,   227,   228,   229,   230,   226,   224,
   225,   254,    83,   256,   248,   117,   247,   598,   244,   352,
   137,   662,   227,   228,   229,   230,   226,   224,   225,   239,
   314,   575,   248,   574,   247,   657,   244,   571,   449,   161,
   159,   196,   193,   191,   232,   652,   445,   248,   302,   247,
   568,   447,   446,   152,    70,   113,   112,   180,   174,   232,
   175,   666,   248,   467,   247,   466,   322,   169,   232,   456,
   459,   248,   166,   247,    66,   438,   109,   232,    65,   108,
   248,   601,   247,   107,    64,   146,   215,   137,   218,   227,
   228,   229,   230,   226,   224,   225,   232,   536,    62,   248,
    61,   247,    60,   244,    59,   232,    58,   472,   248,    56,
   247,    55,    54,    53,   232,    52,    51,   248,    50,   247,
    49,    48,    47,   232,    46,    45,   248,    44,   247,    43,
    42,    41,   428,   232,    40,    39,   248,    38,   247,    37,
    36,    35,    34,    33,    32,    31,    30,    29,    28,    27,
    26,    25,   137,    24,   584,   228,   229,   230,   581,   582,
   583,    23,   137,    22,   227,   228,   229,   230,   226,   224,
   225,    21,    20,    19,    18,    15,    13,    12,   244,     6,
     5,     4,     2,   137,     1,   227,   228,   229,   230,   226,
   224,   225,     0,     0,     0,     0,     0,     0,   137,   244,
   227,   228,   229,   230,   226,   224,   225,     0,     0,     0,
   266,   137,     0,   227,   228,   229,   230,   226,   224,   225,
     0,     0,     0,     0,     0,     0,     0,   244,   137,     0,
   227,   228,   229,   230,   226,   224,   225,     0,     0,     0,
     0,     0,     0,     0,   244,     0,   137,     0,   227,   228,
   229,   230,   226,   224,   225,     0,     0,     0,     0,     0,
     0,   137,   244,   227,   228,   229,   230,   226,   224,   225,
     0,     0,     0,     0,     0,     0,   137,   244,   227,   228,
   229,   230,   226,   224,   225,   137,     0,   227,   228,   229,
   230,   226,   224,   225,   137,     0,   227,   228,   229,   230,
   226,   224,   225,   137,     0,   227,   228,   229,   230,   226,
   224,   225,     0,   137,     0,   227,   228,   229,   230,   226,
   224,   225,   137,     0,   227,   228,   229,   230,   226,   224,
   225,   137,     0,   227,   228,   229,   230,   226,   224,   225,
   137,     0,   227,   228,   229,   230,   226,   224,   225,     0,
   137,     0,   227,   228,   229,   230,   226,   224,   225 };
yytabelem yypact[]={

   471, -1000,   471, -1000, -1000, -1000, -1000, -1000,   541, -1000,
 -1000,  -165, -1000, -1000, -1000, -1000,   321,   -47, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,    11,  -123, -1000,   755,
  -198,   109,  -123, -1000,    45,  -123,   101,   155,  -123,  -123,
   131,   408, -1000,   110,   -48,   320,  -111,  -111,   976,   480,
   919,   480,   480,   901,   884,   856, -1000, -1000, -1000,   706,
  1013,   -59,   692,   317,  -205,   691,   312,  -123,  -123,  -123,
  -222, -1000,   575, -1000, -1000,   684,   650, -1000, -1000,  -267,
   683, -1000, -1000, -1000, -1000, -1000,  -123, -1000,  -238, -1000,
 -1000, -1000, -1000, -1000, -1000,  -253, -1000, -1000, -1000, -1000,
 -1000,   311, -1000, -1000,   309,   306,  -123, -1000,   288,   374,
   674,  -123,   378,   286, -1000,   672, -1000,   571, -1000,   111,
 -1000,   466, -1000, -1000, -1000,   109,   375, -1000,   670,   671,
    25,    37, -1000, -1000,   564,  -123,   670, -1000,   149, -1000,
   364, -1000,   670, -1000,   361,    73, -1000,   633,   543,   301,
  -123,   298, -1000,   294, -1000, -1000,   289, -1000, -1000,  -123,
 -1000,  -152,  -152, -1000,   119,  -152, -1000,   284, -1000, -1000,
   282, -1000, -1000, -1000,   216,   693,   207,  -202, -1000, -1000,
   666,   650, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,   187,   934,   208,   479, -1000,  -194, -1000, -1000,   919,
  -191,  -188, -1000,  -183,  1023,   464,   435,    91,    91, -1000,
  -204,   167,   162,   202,   693,  -194, -1000,   194,   693,   184,
   693,   665,   664,   660,   169,   675, -1000,   156,   464, -1000,
 -1000,  -271, -1000, -1000,   407,   659, -1000, -1000,   181,   163,
   134, -1000,  -140,   835, -1000, -1000,  1004, -1000, -1000,   657,
 -1000,  -152, -1000, -1000, -1000, -1000, -1000,   139, -1000, -1000,
   100, -1000,   621, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,   109, -1000,   109,   109,   557, -1000, -1000,   655, -1000,
  -123,   958,   158,  -123, -1000,    35, -1000, -1000, -1000, -1000,
  -123,   443, -1000, -1000,  -123, -1000,  -123, -1000,   995, -1000,
 -1000,    73,    73, -1000,   146, -1000,  -123, -1000,  -123, -1000,
   136,   442,   934,  -268, -1000,   122,   619,  -152, -1000, -1000,
   654,   553, -1000, -1000, -1000,   617,  -194, -1000,   406, -1000,
 -1000,   919,    91,   835, -1000, -1000, -1000,   919,   132, -1000,
   108,   919,   934,   934,   551,   132,   934,   934,  1023,  -183,
    91,    91,    91,    91,   435,   435,    91, -1000, -1000, -1000,
 -1000, -1000,   615, -1000,   613, -1000,   606,   693,   693,   693,
 -1000, -1000,   602,  -194, -1000, -1000,   934,  1023, -1000,   934,
 -1000,   100, -1000,   100, -1000,   100, -1000,   648,   986,   463,
   530,  -194,   463,   934,   693,   519, -1000,   646,   510, -1000,
 -1000, -1000,   608,    96,  -123,   402,  -215,  -173, -1000,   825,
 -1000,   391, -1000, -1000,   934, -1000,   598, -1000,   114, -1000,
   464, -1000,   652,   591,   500,   651,   650, -1000, -1000, -1000,
 -1000, -1000,   645,   643,   464, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -194,  -123, -1000,   967, -1000, -1000,   587, -1000,
 -1000,   658,   693, -1000,   693,   143, -1000,   639,   135, -1000,
 -1000,  -191,  -191,   919,  -188, -1000, -1000,   435,   435, -1000,
 -1000, -1000,   919,   919,    95,    93,    90,   583, -1000,   215,
   574,   562,    88, -1000,   760,  -152,    99,    85,   494,   464,
   934,    89,   636,   635,   604, -1000, -1000,   521,   871,   934,
    65,   555, -1000,    83,   100,    81, -1000,   638, -1000,    74,
 -1000, -1000, -1000, -1000, -1000,  -141,  -150, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,   934, -1000,   502, -1000,
   171,   488, -1000, -1000,   523, -1000, -1000, -1000, -1000,   -94,
   -94, -1000, -1000, -1000, -1000,  1023, -1000,   958,   949,  -123,
 -1000,  -123,  -123,   835, -1000, -1000, -1000, -1000,    78,    70,
    67,  1023,  -152,    66,   487,  -152, -1000,   117,   919, -1000,
 -1000, -1000, -1000, -1000,   426,   479,   479, -1000, -1000, -1000,
  -123,    64,   693,    62,    61, -1000,    59,  -194, -1000, -1000,
 -1000, -1000,  1023,    34,    58,    57,    55,    54, -1000, -1000,
   514,  -194, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   283,
 -1000, -1000, -1000,  -194, -1000,  -173,  -180,   432,   825,   319,
 -1000, -1000,   596,   475, -1000, -1000, -1000,   470, -1000, -1000,
   589, -1000, -1000, -1000,    53, -1000, -1000,    50,   474, -1000,
   116,  1023,    49,    44, -1000,   140, -1000, -1000, -1000, -1000,
 -1000,  -152,  -273,   459,    43, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  1023, -1000,
 -1000, -1000, -1000, -1000, -1000,   585, -1000, -1000,   693, -1000,
    42,  1023, -1000,   455,  -152, -1000, -1000, -1000, -1000,  1023,
    20, -1000, -1000 };
yytabelem yypgo[]={

     0,  1114,  1112,   806,  1111,  1110,  1109,   804,  1107,  1106,
   465,  1105,  1104,  1103,  1102,  1101,   801,  1093,  1091,  1083,
  1081,  1080,  1079,  1078,  1077,  1076,  1075,  1074,  1073,  1072,
  1071,  1070,  1069,  1067,  1065,  1064,  1061,  1060,  1059,  1057,
  1055,  1054,  1052,  1051,  1050,  1048,  1046,  1045,  1043,  1042,
  1041,  1039,   451,  1036,  1034,  1032,  1030,  1028,  1015,    48,
    38,  1014,  1013,  1009,    37,    34,    31,    29,  1008,  1006,
  1005,    23,  1004,  1002,   240,   999,    24,    16,   997,   996,
    10,    18,   995,   993,    15,    28,   139,   154,    54,   990,
    47,   988,   987,   365,   986,     9,   985,    58,    46,    49,
   984,   983,    26,   982,   981,   980,     8,     4,   978,    40,
   976,   975,   973,   972,   971,    45,   970,    65,   969,   968,
   967,   965,    62,   141,    76,    13,     7,   963,   961,   960,
   951,    60,    67,   949,    20,   947,    32,   945,     5,     1,
   942,    27,    14,   450,   933,   930,   928,   925,     6,   910,
   909,     3,   449,   908,   907,    12,   906,   905,    36,   900,
   480,   894,   892,   891,   890,    22,     2,   889,   888,    25,
   887,   886,   885,   884,   882,   881,   879,   530,   877,    17,
    19,    21,   876,   871,   855,   847,   816,   815,   814,   812,
   811,    51,    39,    42,    43,     0,    50,    30,    44,   808,
   807,    11,   679 };
yytabelem yyr1[]={

     0,     1,     1,     2,     2,     3,     3,     3,     3,     4,
     4,     7,     7,     7,     7,     7,     8,     8,     8,     8,
     5,     5,    16,     6,     9,     9,     9,     9,     9,     9,
     9,     9,     9,     9,     9,     9,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    11,    11,
    11,    11,    11,    11,    11,    58,    12,    17,    17,    13,
    61,    61,    61,    61,    62,    63,    64,    64,    64,    14,
    68,    68,    69,    60,    60,    70,    70,    71,    71,    15,
    15,    72,    22,    73,    73,    74,    75,    75,    76,    76,
    76,    76,    78,    23,    79,    79,    80,    80,    81,    81,
    81,    82,    83,    83,    24,    24,    24,    87,    87,    88,
    89,    89,    89,    86,    86,    90,    90,    91,    91,    25,
    25,    25,    25,    65,    65,    65,    94,    94,    94,    94,
    96,    66,    67,    92,    92,    98,    98,    93,    93,    99,
    99,    99,    99,   100,    20,    20,   101,   103,   101,   104,
   102,   105,   105,   106,   106,    97,    97,    97,    19,   108,
   108,   110,   109,    26,   112,   112,    27,   113,   113,    28,
    28,   114,   114,   115,   115,    21,   116,   116,   116,   119,
   121,   117,   118,   118,   122,   122,   120,   120,   125,   125,
   127,   127,   126,   126,   124,   130,   130,   129,   129,   131,
   131,   133,   135,    29,   123,   123,   123,    30,    31,    32,
    32,    33,    33,    33,   140,   140,   141,   141,    34,    51,
    52,   144,   143,    53,   145,   146,    53,    54,    55,    55,
    56,   149,    56,   150,    56,   147,   147,   147,   148,   148,
    57,    57,    35,    36,    37,   152,   152,   152,   152,   154,
    40,   156,    40,   157,   153,    38,    38,    38,    38,    38,
   159,    39,    39,    41,   161,   162,    41,    42,   163,   164,
    42,   158,   158,   165,   165,   167,   167,   167,   168,   168,
   155,   155,   169,   169,   170,   171,    46,   172,    47,   173,
    48,    44,    44,   174,    45,    45,   175,    43,    43,   176,
   166,   166,   160,   160,   178,    18,   179,   179,   179,   180,
   180,   180,   181,   181,   181,   183,   183,   183,   183,   183,
   183,   184,   182,   182,   182,   186,    49,   187,    49,   189,
    49,   185,   188,   188,   188,   188,    50,    50,   111,   134,
   190,   190,   190,   191,   191,   192,   192,   193,   193,   194,
   194,   195,   195,   195,   195,   195,   196,   196,   196,   197,
   197,   177,   177,   198,   198,   198,   198,   198,   198,   198,
   198,   201,   201,   201,   201,   142,   151,   107,    77,   132,
   199,    84,    84,   202,   202,   200,   200,   137,   137,    85,
    85,    85,    85,   136,    59,   128,   128,   128,   128,   128,
   128,    95,   138,   139 };
yytabelem yyr2[]={

     0,     2,     0,     2,     4,     3,     3,     2,     2,     5,
     3,     3,     3,     3,     3,     5,     3,     3,     3,     3,
     2,     4,     4,     7,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     1,     9,     7,    13,     2,
     7,    13,     7,    13,     5,     3,     2,     2,     2,     2,
     7,    13,     3,     1,     2,     3,     7,     3,     3,     4,
     7,     5,     6,     2,     6,     9,     3,     7,     3,     7,
     3,     7,     1,     9,     6,    10,     7,     7,     3,     3,
     3,     8,     4,     4,     7,     7,     9,     3,     5,     5,
     7,     5,     3,     3,     5,     3,     5,     3,     3,     6,
     6,     6,     8,     2,     7,     2,     3,     3,     3,     3,
     5,     3,     7,     2,     6,     3,     3,     2,     6,     3,
     7,     3,     7,     3,     7,     7,     2,     1,     8,     1,
    11,     2,     6,     3,     7,     6,     2,     6,    10,     2,
     6,     1,     9,     6,     3,     7,     6,     3,     7,     4,
     6,     2,     6,     3,     7,     6,     2,     4,     6,     1,
     1,    12,     2,     6,     3,     2,     2,     6,     2,     6,
     2,     3,     2,     3,    13,     6,    10,     4,     4,     3,
     2,     1,     1,    13,     2,     2,     2,    13,     8,    12,
    14,     7,    13,    15,     2,     4,     4,     8,    20,     4,
     6,     1,    11,     4,     1,     1,    16,     4,     4,     6,
    11,     1,    15,     1,    13,     6,     8,     5,     6,    10,
     7,     5,     4,     6,     6,     0,     2,     3,     2,     1,
     6,     1,     8,     1,    11,    10,    12,    14,     6,    10,
     3,     7,    11,     6,     1,     1,    14,     7,     1,     1,
    15,     3,     7,     7,     3,     3,     7,     7,     7,     3,
     2,     6,     3,     2,    15,     1,    12,     1,    12,     1,
    12,     6,    10,     3,     6,    10,     3,     6,    10,     3,
     2,     2,     3,     2,     1,    13,     0,     4,     6,     2,
     4,     2,     6,     2,     2,     2,     2,     2,     2,     2,
     3,     2,     2,     4,     4,     1,     6,     1,    10,     1,
    12,     5,     3,     7,     7,    11,     5,     7,     3,     3,
     2,     7,     7,     2,     7,     2,     7,     2,     5,     2,
     7,     2,     5,     5,     7,     7,     2,     7,     7,     2,
     7,     2,     7,     3,     2,     2,     3,     3,     3,     3,
     7,     3,     3,     3,     3,     3,     3,     3,     3,     9,
     9,     1,     2,     3,     7,     4,     4,     4,     4,     6,
     9,     9,    11,     3,     2,     2,     4,     4,     2,     2,
     2,     2,     1,     3 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    -4,    -5,    -6,   127,   258,    -7,
   -16,   306,    -8,    -9,   -10,   -11,   256,   293,   -12,   -13,
   -14,   -15,   -17,   -18,   -19,   -20,   -21,   -22,   -23,   -24,
   -25,   -26,   -27,   -28,   -29,   -30,   -31,   -32,   -33,   -34,
   -35,   -36,   -37,   -38,   -39,   -40,   -41,   -42,   -43,   -44,
   -45,   -46,   -47,   -48,   -49,   -50,   -51,   -52,   -53,   -54,
   -55,   -56,   -57,   316,   -61,   -68,   -72,   297,   300,   312,
  -100,   286,   287,   298,   283,   -65,   -66,   -67,   299,   309,
   321,  -123,   276,  -140,  -143,   285,   322,   313,  -159,   277,
  -153,   315,   325,  -176,  -174,  -175,   311,   282,   307,  -185,
   319,   291,   292,   296,  -147,   290,   294,   -62,   -63,   -69,
   279,   305,   -94,   -96,   281,  -136,  -132,  -137,   303,   302,
   304,   317,   328,   320,   278,   295,   280,   288,   -64,   301,
   323,   308,   318,   284,   310,   289,   -59,   257,    -3,    -7,
   -16,   264,   127,   127,   304,   288,   -58,   127,   -59,   -59,
  -178,    40,  -101,   257,  -102,   -64,   -65,   -66,   -67,  -116,
  -117,  -118,  -122,  -123,  -124,    40,   -73,   -74,   -59,   -78,
   -86,   -87,   -90,   -88,   -91,   -89,   -59,   -74,    47,   275,
   -92,   -98,   -59,   -74,   -93,    42,   -99,   -59,   -74,   -93,
    44,  -112,   -59,  -113,   -59,   127,  -114,  -115,   -59,    47,
    61,  -138,  -138,    40,   -59,  -138,   -10,   326,  -143,   127,
  -152,   259,   -59,   264,  -152,    40,  -160,  -177,    42,  -198,
  -136,  -199,  -200,  -201,   264,   265,   263,   259,   260,   261,
   262,  -160,    40,  -154,  -155,  -169,  -134,  -170,  -190,    40,
  -191,  -192,  -193,  -194,   273,  -195,  -196,    45,    43,  -197,
  -177,  -160,  -160,  -166,    40,  -134,    42,  -166,    40,  -166,
    40,  -171,  -172,  -173,  -186,    40,   127,  -142,  -195,   -52,
   127,  -143,    40,   127,  -136,   327,    40,   127,   -59,   -59,
   -59,   286,    42,    40,   -85,   -85,    40,   324,    40,  -157,
   -59,  -138,   301,   314,   127,   127,   127,   -59,   127,   127,
    40,    40,  -108,  -109,   -59,   127,    44,   127,    40,   127,
  -117,    44,    47,    44,  -129,  -131,  -132,  -124,  -136,   127,
    44,    40,   -79,    40,   127,   -87,   -90,   127,   -88,    44,
   -86,   -59,    47,   127,    44,   127,    44,   -97,    40,   -95,
   259,    42,    42,   127,   -93,   127,    44,   127,    44,   127,
    44,   -59,  -133,  -139,   259,  -139,  -141,  -138,   127,    40,
    44,  -139,   127,   127,   127,  -158,  -134,  -165,   -59,  -166,
   127,    44,   275,    40,   -85,   -85,   127,    44,  -134,   127,
  -156,    44,   271,   272,  -155,  -134,   270,   269,   268,  -194,
    43,    45,    47,    42,  -196,  -196,   274,   127,    44,   127,
    44,   127,  -158,   127,  -158,   127,  -158,    40,    40,    40,
   127,    41,  -188,  -134,    42,   127,  -145,    61,    40,  -150,
   127,    40,   127,    40,   127,    40,   -95,   -84,    58,  -195,
  -202,  -134,  -195,  -144,    40,  -139,   127,   -60,   -70,   -71,
   -59,    42,  -179,    41,    44,  -110,  -103,  -104,  -117,  -119,
  -122,   -59,  -131,    44,    40,   -74,   -75,   -76,   -77,    42,
  -195,   127,    44,   -80,   -81,   -59,   -82,   -83,   127,    47,
   -98,   -99,    42,  -107,  -195,   -97,   -97,   127,   -59,   -59,
  -115,    47,  -134,   324,   127,    41,    44,  -139,  -141,    40,
    44,    41,    44,    41,    61,  -155,  -198,   -84,  -155,   127,
  -169,  -191,  -191,    44,  -192,  -193,  -194,  -196,  -196,  -197,
  -197,  -197,  -161,  -163,    41,    41,    41,  -167,  -166,   -59,
  -158,  -158,  -187,    41,    44,  -138,  -134,  -148,  -151,  -195,
  -149,  -134,   -60,   -60,   -60,    41,    41,  -195,    58,    44,
  -134,  -158,    44,    41,    44,    41,  -180,    44,  -181,  -182,
  -183,    40,   266,   257,   259,    45,    43,   264,   265,    47,
   275,    58,  -184,    36,   127,  -109,    61,  -102,  -105,  -106,
   267,  -120,  -125,  -126,  -127,  -128,   -59,   -95,  -201,    45,
    43,   263,   264,   265,   259,    61,    41,    44,    58,    40,
    41,    44,    44,    40,   -85,   -85,    41,    41,  -135,  -136,
  -142,    44,  -138,    41,  -141,  -138,   127,  -155,    44,  -165,
  -166,   127,    41,   127,  -136,  -155,  -155,   127,   127,   127,
    44,    41,    61,    41,    41,   127,  -189,  -134,    42,  -139,
    41,   127,    44,  -134,    41,    41,    41,    41,    41,    41,
  -195,  -134,    41,    41,   127,   -71,   127,  -180,  -181,  -179,
   259,   259,  -111,  -134,    41,    44,    45,  -121,    44,    42,
  -201,  -201,  -130,  -107,   -76,   -77,    42,   -80,   -81,   -81,
   -84,   127,   127,   127,  -142,  -139,   127,    41,  -139,   127,
  -155,    61,  -162,  -164,  -168,   -59,   127,  -166,   127,   127,
   127,  -138,  -146,  -151,    41,   127,   127,   127,   127,    41,
    41,  -106,   267,    47,  -125,  -126,   -59,    41,    44,    41,
    41,   127,   127,    44,   127,  -148,   127,   127,    61,  -139,
   326,    44,   127,  -107,  -138,    41,  -166,   127,  -151,    44,
  -139,  -107,   127 };
yytabelem yydef[]={

     2,    -2,     1,     3,     5,     6,     7,     8,     0,    10,
    20,     0,    11,    12,    13,    14,     0,     0,    16,    17,
    18,    19,    24,    25,    26,    27,    28,    29,    30,    31,
    32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
    62,    63,    64,    65,    69,    79,     0,     0,   314,     0,
     0,     0,     0,   102,     0,    76,    77,    78,     0,     0,
     0,     0,   412,   412,   412,     0,   255,   255,     0,     0,
   259,     0,     0,     0,     0,     0,   295,   297,   299,   335,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   153,   133,   135,   141,   214,   215,   216,   224,     0,
     0,   270,   263,   309,   303,   306,     0,   412,     0,    75,
    82,   136,   137,   138,   139,     0,   403,   404,     4,     9,
    21,     0,    15,    22,     0,     0,     0,    89,     0,     0,
     0,     0,     0,     0,   156,     0,    76,    77,    78,     0,
   186,     0,   192,   194,   195,     0,     0,    93,     0,     0,
     0,     0,   123,   117,   125,     0,   127,   128,     0,   122,
     0,   143,   145,   146,     0,     0,   147,   149,   151,     0,
     0,     0,   174,     0,   177,   179,     0,   181,   183,     0,
   211,     0,     0,   412,     0,     0,   229,     0,   412,   252,
     0,   256,   257,   258,     0,     0,     0,   312,   313,   371,
   373,   374,   375,   376,   377,   378,   379,   381,   382,   383,
   384,     0,     0,     0,   261,   290,   292,   293,   349,     0,
   350,   353,   355,   357,     0,   359,   361,     0,     0,   366,
   369,     0,     0,     0,     0,   310,   311,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   346,     0,   385,   233,
   237,     0,   234,   238,     0,     0,   243,   251,     0,     0,
     0,    91,     0,   391,   397,   398,     0,   225,   231,     0,
   341,   247,    74,   140,    23,   239,   250,     0,    90,    67,
    83,   316,     0,   169,   171,   154,   157,   155,   159,   185,
   187,     0,   189,     0,     0,     0,   209,   210,     0,    92,
     0,     0,     0,     0,   114,     0,   124,   115,   118,   126,
   119,     0,   121,   129,     0,   130,     0,   142,     0,   166,
   411,     0,     0,   131,     0,   173,     0,   176,     0,   180,
     0,     0,     0,     0,   413,     0,     0,     0,   221,   412,
     0,     0,   230,   253,   254,     0,   310,   281,   403,   284,
   268,     0,     0,   391,   395,   396,   271,     0,     0,   260,
     0,     0,     0,     0,     0,   292,     0,     0,     0,   358,
     0,     0,     0,     0,   362,   363,     0,   273,   274,   277,
   278,   307,     0,   301,     0,   304,     0,     0,     0,     0,
   336,   337,     0,   342,   412,   347,     0,     0,   241,     0,
    70,    83,    72,    83,    80,    83,   134,     0,     0,   359,
   392,   393,     0,     0,     0,   245,    66,     0,    84,    85,
    87,    88,     0,     0,     0,     0,     0,     0,   188,     0,
   193,   403,   208,   207,   391,    94,     0,    96,    98,   100,
   388,   103,     0,     0,     0,   108,   109,   110,   116,   120,
   144,   148,     0,     0,   387,   150,   152,   132,   175,   178,
   182,   184,   212,     0,   218,     0,   412,   226,     0,   412,
   412,     0,     0,   380,     0,     0,   372,     0,     0,   262,
   291,   351,   352,     0,   354,   356,    -2,   364,   365,   367,
   368,   370,     0,     0,     0,     0,     0,     0,   285,   403,
     0,     0,     0,   339,     0,     0,     0,     0,     0,   386,
     0,     0,     0,     0,     0,   389,   399,     0,     0,     0,
     0,     0,   246,     0,     0,     0,   317,     0,   319,     0,
   321,   316,   323,   324,   332,     0,     0,   325,   326,   327,
   328,   329,   330,   331,   168,   170,     0,   158,     0,   161,
   163,   190,   196,   198,     0,   202,    -2,   200,   405,     0,
     0,   408,   409,   410,    -2,     0,    95,     0,     0,     0,
   104,     0,     0,   391,   112,   113,   165,   167,     0,     0,
     0,     0,     0,     0,     0,     0,   265,     0,     0,   282,
   283,   269,   390,   272,   373,   275,   279,   308,   302,   305,
     0,     0,     0,     0,     0,   338,     0,   344,   412,   343,
   235,   240,     0,     0,     0,     0,     0,     0,   401,   400,
     0,   394,   232,   264,    68,    86,   315,   318,   320,     0,
   333,   334,   172,   348,   160,     0,     0,     0,     0,     0,
   406,   407,     0,     0,    97,    99,   101,     0,   107,   106,
     0,   213,   217,   219,     0,   227,   222,     0,     0,   266,
     0,     0,     0,     0,   287,   289,   296,   286,   298,   300,
   340,     0,     0,   248,     0,   244,    71,    73,    81,   402,
   322,   162,   164,   191,   197,   199,   203,   204,     0,   105,
   111,   220,   223,   412,   267,     0,   276,   280,     0,   345,
     0,     0,   242,   205,     0,   294,   288,   236,   249,     0,
     0,   206,   228 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1,9021 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto yyerrlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*yyf[])(); \
			register int yyret; \
			if (yyf[yytmp]) \
			    if ((yyret=(*yyf[yytmp])()) == -2) \
				    goto yyerrlab; \
				else if (yyret>=0) return(yyret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
YYSTYPE *yypvt;			/* top of value stack for $vars */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(yytmp){

case 5:
# line 207 "fortran.y"
{
				/* Create id token for prog if unnamed. */
			  if(current_module_hash == -1) {
			    implied_id_token(&(yypvt[-0]),unnamed_prog);
			    def_function(
				type_PROGRAM,&(yypvt[-0]),(Token*)NULL);
			    current_module_hash =
			      def_curr_module(&(yypvt[-0]));
			    current_module_type = type_PROGRAM;
			  }
			  prev_stmt_class = curr_stmt_class;
			  integer_context = FALSE;
			} /*NOTREACHED*/ break;
case 6:
# line 221 "fortran.y"
{
			  if(current_module_hash == -1) {
			    implied_id_token(&(yypvt[-0]),unnamed_prog);
			    def_function(
				type_PROGRAM,&(yypvt[-0]),(Token*)NULL);
			    current_module_hash =
			      def_curr_module(&(yypvt[-0]));
			    current_module_type = type_PROGRAM;
			  }
			  if(prev_stmt_class != tok_RETURN)
			    do_RETURN(current_module_hash,&(yypvt[-0]));
			  END_processing(&(yyval));
			  goto_flag = prev_goto = FALSE;
			  prev_stmt_class = curr_stmt_class;
			} /*NOTREACHED*/ break;
case 9:
# line 246 "fortran.y"
{
			  if(executable_stmt)
			    prev_goto = goto_flag;
			} /*NOTREACHED*/ break;
case 10:
# line 251 "fortran.y"
{
			  if(executable_stmt) {
			    if(prev_goto)
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"No path to this statement");
			    prev_goto = goto_flag;
			  }
			} /*NOTREACHED*/ break;
case 11:
# line 262 "fortran.y"
{
			    exec_stmt_count = 0;
			    executable_stmt = FALSE;
			} /*NOTREACHED*/ break;
case 12:
# line 267 "fortran.y"
{
			    executable_stmt = FALSE;
			} /*NOTREACHED*/ break;
case 13:
# line 271 "fortran.y"
{	/* handle statement functions correctly */
			  if(is_true(STMT_FUNCTION_EXPR, yypvt[-0].subclass)
				     && stmt_sequence_no <= seq_stmt_fun) {
			    stmt_sequence_no = seq_stmt_fun;
			    executable_stmt = FALSE;
			  }
			  else {
			    stmt_sequence_no = seq_exec;
			    ++exec_stmt_count;
			    executable_stmt = TRUE;
			  }
			} /*NOTREACHED*/ break;
case 14:
# line 284 "fortran.y"
{
			    stmt_sequence_no = seq_exec;
			    ++exec_stmt_count;
			    executable_stmt = TRUE;
			} /*NOTREACHED*/ break;
case 15:
# line 290 "fortran.y"
{
			    executable_stmt = TRUE;
			    if(stmt_sequence_no == 0)
			      stmt_sequence_no = seq_header;
			    complex_const_allowed = FALSE; /* turn off flags */
			    inside_format=FALSE;
			    integer_context = FALSE;
			    yyval.line_num = prev_stmt_line_num; /* best guess */
			    yyerrok; /* (error message already given) */
			} /*NOTREACHED*/ break;
case 16:
# line 303 "fortran.y"
{
			    current_module_type = type_PROGRAM;
			} /*NOTREACHED*/ break;
case 17:
# line 307 "fortran.y"
{
			    current_module_type = type_SUBROUTINE;
			} /*NOTREACHED*/ break;
case 18:
# line 311 "fortran.y"
{
			    current_module_type = type_SUBROUTINE;
			} /*NOTREACHED*/ break;
case 19:
# line 315 "fortran.y"
{
			    current_module_type = type_BLOCK_DATA;
			} /*NOTREACHED*/ break;
case 23:
# line 328 "fortran.y"
{
#ifdef ALLOW_INCLUDE
			  if(f77_standard) {
			      nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			  }
 			  open_include_file(yypvt[-1].value.string);
#else
			  syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
				"statement not permitted");
#endif
 			} /*NOTREACHED*/ break;
case 24:
# line 348 "fortran.y"
{
			     if(stmt_sequence_no < seq_implicit) {
	   			stmt_sequence_no = seq_implicit;
			     }
			     goto_flag = prev_goto = FALSE;
			} /*NOTREACHED*/ break;
case 25:
# line 355 "fortran.y"
{
			     if(stmt_sequence_no < seq_implicit) {
				stmt_sequence_no = seq_implicit;
			     }
			} /*NOTREACHED*/ break;
case 26:
# line 361 "fortran.y"
{
			     if(stmt_sequence_no > seq_specif) {
			   	syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			     }
			     else {
				if(stmt_sequence_no < seq_implicit) {
				   stmt_sequence_no = seq_implicit;
				}
			     }
			} /*NOTREACHED*/ break;
case 27:
# line 373 "fortran.y"
{
			     if(stmt_sequence_no > seq_implicit) {
			 	syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			     }
			     else {
			    	stmt_sequence_no = seq_implicit;
			     }
			} /*NOTREACHED*/ break;
case 28:
# line 383 "fortran.y"
{
			     if(stmt_sequence_no < seq_stmt_fun) {
				stmt_sequence_no = seq_stmt_fun;
		 	     }
			} /*NOTREACHED*/ break;
case 29:
# line 389 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 30:
# line 399 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 31:
# line 409 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 32:
# line 419 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 33:
# line 429 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 34:
# line 439 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 35:
# line 449 "fortran.y"
{
			    if(stmt_sequence_no > seq_specif) {
				syntax_error(yypvt[-0].line_num, NO_COL_NUM,
					"Statement out of order.");
			    }
			    else {
				stmt_sequence_no = seq_specif;
			    }
			} /*NOTREACHED*/ break;
case 36:
# line 464 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 37:
# line 468 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 38:
# line 472 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 39:
# line 476 "fortran.y"
{
			    goto_flag=FALSE;	/* fallthru allowed */
			} /*NOTREACHED*/ break;
case 40:
# line 480 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 41:
# line 484 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 42:
# line 488 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 43:
# line 492 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 44:
# line 496 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 45:
# line 500 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 46:
# line 504 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 47:
# line 508 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 48:
# line 512 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 49:
# line 516 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 50:
# line 520 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 51:
# line 524 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 52:
# line 528 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 53:
# line 532 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 54:
# line 536 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 55:
# line 540 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 56:
# line 544 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 57:
# line 548 "fortran.y"
{
			    goto_flag=TRUE;
			} /*NOTREACHED*/ break;
case 58:
# line 555 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 59:
# line 559 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 60:
# line 563 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 61:
# line 567 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 62:
# line 571 "fortran.y"
{
			    prev_goto = goto_flag =FALSE;
			} /*NOTREACHED*/ break;
case 63:
# line 575 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 64:
# line 579 "fortran.y"
{
			    goto_flag=FALSE;
			} /*NOTREACHED*/ break;
case 65:
# line 585 "fortran.y"
{check_seq_header(&(yypvt[-0]));} /*NOTREACHED*/ break;
case 66:
# line 587 "fortran.y"
{
			     def_function(
				type_PROGRAM,&(yypvt[-1]),(Token*)NULL);
			     current_module_hash =
			       def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 67:
# line 600 "fortran.y"
{
			  do_ENTRY(&(yypvt[-1]),(Token*)NULL
				   ,current_module_hash);
			} /*NOTREACHED*/ break;
case 68:
# line 605 "fortran.y"
{
			  do_ENTRY(&(yypvt[-4]),&(yypvt[-2])
				   ,current_module_hash);
			     if(debug_parser)
				print_exprlist("entry stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 70:
# line 619 "fortran.y"
{
			     if(f77_standard) {
				nonstandard(yypvt[-1].line_num,
				  yypvt[-1].col_num+strlen(token_name(yypvt[-1])));
				msg_tail(": parentheses required");
			     }
			 def_function(
				current_datatype,&(yypvt[-1]),(Token*)NULL);
			 current_module_hash=
			   def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 71:
# line 632 "fortran.y"
{
			 def_function(
				current_datatype,&(yypvt[-4]),&(yypvt[-2]));
			 current_module_hash=
			   def_curr_module(&(yypvt[-4]));
			 if(debug_parser)
			   print_exprlist("function stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 72:
# line 641 "fortran.y"
{
			     if(f77_standard) {
				nonstandard(yypvt[-1].line_num,
				  yypvt[-1].col_num+strlen(token_name(yypvt[-1])));
				msg_tail(": parentheses required");
			     }
			 def_function(
				type_UNDECL,&(yypvt[-1]),(Token*)NULL);
			 current_module_hash=
			   def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 73:
# line 654 "fortran.y"
{
			 def_function(
				type_UNDECL,&(yypvt[-4]),&(yypvt[-2]));
			 current_module_hash=
			   def_curr_module(&(yypvt[-4]));
			 if(debug_parser)
			   print_exprlist("function stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 74:
# line 666 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 75:
# line 673 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 80:
# line 692 "fortran.y"
{
			  def_function(
				 type_SUBROUTINE,&(yypvt[-1]),(Token*)NULL);
			  current_module_hash=
			    def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 81:
# line 700 "fortran.y"
{
			  def_function(
				 type_SUBROUTINE,&(yypvt[-4]),&(yypvt[-2]));
			  current_module_hash=
			    def_curr_module(&(yypvt[-4]));
			  if(debug_parser)
			    print_exprlist("subroutine stmt",&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 82:
# line 711 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 83:
# line 717 "fortran.y"
{
			    yyval.next_token = (Token*)NULL;
			} /*NOTREACHED*/ break;
case 85:
# line 724 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 86:
# line 728 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 87:
# line 734 "fortran.y"
{
			     def_arg_name(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 88:
# line 739 "fortran.y"
{
			     yyval.class = type_byte(class_LABEL,type_LABEL);
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 90:
# line 750 "fortran.y"
{
			  def_function(
				 type_BLOCK_DATA,&(yypvt[-1]),(Token*)NULL);
			  current_module_hash=
			    def_curr_module(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 91:
# line 759 "fortran.y"
{
			  check_seq_header(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 95:
# line 773 "fortran.y"
{
			     def_array_dim(&(yypvt[-3]),&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 96:
# line 780 "fortran.y"
{
			     yyval.class = 1;
			     yyval.subclass = yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 97:
# line 785 "fortran.y"
{
			     yyval.class = yypvt[-2].class + 1;
			     yyval.subclass = yypvt[-2].subclass *
			       yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 98:
# line 793 "fortran.y"
{
			     yyval.subclass = yypvt[-0].value.integer;
			} /*NOTREACHED*/ break;
case 99:
# line 797 "fortran.y"
{
			     yyval.subclass = yypvt[-0].value.integer -
				yypvt[-2].value.integer + 1;
			} /*NOTREACHED*/ break;
case 100:
# line 802 "fortran.y"
{
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 101:
# line 806 "fortran.y"
{
			     yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 102:
# line 812 "fortran.y"
{equivalence_flag = TRUE;} /*NOTREACHED*/ break;
case 103:
# line 813 "fortran.y"
{equivalence_flag = FALSE;} /*NOTREACHED*/ break;
case 106:
# line 821 "fortran.y"
{
			  equivalence(&(yypvt[-2]), &(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 107:
# line 825 "fortran.y"
{
			  equivalence(&(yypvt[-2]), &(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 108:
# line 832 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 109:
# line 836 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 110:
# line 840 "fortran.y"
{
			     def_equiv_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 114:
# line 855 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			     def_com_block(&(yyval), &(yypvt[-1]));
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
			   	syntax_error(
					yypvt[-1].line_num,yypvt[-1].col_num,
					"trailing comma");
			     if(debug_parser)
				print_comlist("blank common",&(yypvt[-1]));

			} /*NOTREACHED*/ break;
case 115:
# line 867 "fortran.y"
{
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					yypvt[-1].line_num,yypvt[-1].col_num,
					"trailing comma");

			} /*NOTREACHED*/ break;
case 116:
# line 875 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			     def_com_block(&(yyval),&(yypvt[-2]));
			     if(is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					yypvt[-1].line_num,yypvt[-1].col_num,
					"trailing comma");
			     if(debug_parser)
				print_comlist("blank common",&(yypvt[-2]));

			} /*NOTREACHED*/ break;
case 117:
# line 892 "fortran.y"
{
			     yyval.subclass = yypvt[-0].subclass;
			} /*NOTREACHED*/ break;
case 118:
# line 896 "fortran.y"
{
			     yyval.subclass = yypvt[-0].subclass;
			     yyval.line_num = yypvt[-0].line_num;
			     yyval.col_num = yypvt[-0].col_num;
			} /*NOTREACHED*/ break;
case 119:
# line 904 "fortran.y"
{
			     def_com_block(&(yypvt[-1]),&(yypvt[-0]));
			     yyval.subclass = yypvt[-0].subclass;
			     yyval.line_num = yypvt[-0].line_num;
			     yyval.col_num = yypvt[-0].col_num;
			     if(debug_parser)
				print_comlist("labeled common",&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 120:
# line 915 "fortran.y"
{
			     yyval = yypvt[-1];
			} /*NOTREACHED*/ break;
case 121:
# line 920 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			} /*NOTREACHED*/ break;
case 122:
# line 924 "fortran.y"
{
			     implied_id_token(&(yyval),blank_com_name);
			} /*NOTREACHED*/ break;
case 123:
# line 930 "fortran.y"
{
			    yyval.subclass = yypvt[-0].subclass;
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 124:
# line 935 "fortran.y"
{
			    if(!is_true(COMMA_FLAG,yypvt[-1].subclass))
				syntax_error(
					yypvt[-1].line_num,yypvt[-1].col_num,
					"missing comma");
			    yyval.subclass = yypvt[-0].subclass;
			    yyval.line_num = yypvt[-0].line_num;
			    yyval.col_num = yypvt[-0].col_num;
			    yyval.next_token = append_token(yypvt[-1].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 125:
# line 948 "fortran.y"
{			   /* no comma */
			     yyval.subclass = yypvt[-0].subclass;
			     make_false(COMMA_FLAG,yyval.subclass);
			} /*NOTREACHED*/ break;
case 126:
# line 953 "fortran.y"
{			   /* has comma */
			     yyval.subclass = yypvt[-1].subclass;
			     make_true(COMMA_FLAG,yyval.subclass);
   			} /*NOTREACHED*/ break;
case 127:
# line 960 "fortran.y"
{
			     def_com_variable(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 128:
# line 965 "fortran.y"
{
			     def_com_variable(&(yypvt[-0]));
			     primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 134:
# line 983 "fortran.y"
{
				/* Only REAL*8 is actually recognized */
			    if(current_datatype == type_REAL
			       && yypvt[-0].value.integer == 8)
				current_datatype = type_DP;

			     if(f77_standard) {
				nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
			     }
			} /*NOTREACHED*/ break;
case 136:
# line 998 "fortran.y"
{
			     current_datatype = type_INTEGER;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 137:
# line 1003 "fortran.y"
{
			     current_datatype = type_REAL;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 138:
# line 1008 "fortran.y"
{
			     current_datatype = type_COMPLEX;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 139:
# line 1013 "fortran.y"
{
			     current_datatype = type_LOGICAL;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 140:
# line 1020 "fortran.y"
{
			     current_datatype = type_DP;
			} /*NOTREACHED*/ break;
case 141:
# line 1026 "fortran.y"
{
			     current_datatype = type_STRING;
			     integer_context = TRUE;
			} /*NOTREACHED*/ break;
case 142:
# line 1033 "fortran.y"
{
			     current_datatype = type_STRING;
			} /*NOTREACHED*/ break;
case 145:
# line 1043 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 146:
# line 1047 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 149:
# line 1057 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 150:
# line 1061 "fortran.y"
{
			     declare_type(&(yypvt[-2]),current_datatype);
			} /*NOTREACHED*/ break;
case 151:
# line 1065 "fortran.y"
{
			     declare_type(&(yypvt[-0]),current_datatype);
			} /*NOTREACHED*/ break;
case 152:
# line 1069 "fortran.y"
{
			     declare_type(&(yypvt[-2]),current_datatype);
			} /*NOTREACHED*/ break;
case 153:
# line 1076 "fortran.y"
{implicit_flag=TRUE;} /*NOTREACHED*/ break;
case 154:
# line 1080 "fortran.y"
{
			    {implicit_flag=FALSE;}
			    if(implicit_none) {
				syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
				     "conflicts with IMPLICIT NONE");
			    }
			    else {
				implicit_type_given = TRUE;
			    }
			} /*NOTREACHED*/ break;
case 155:
# line 1091 "fortran.y"
{
			    int h=yypvt[-1].value.integer;
			    {implicit_flag=FALSE;}
			    if( strcmp(hashtab[h].name,"NONE") == 0 ) {
				if(implicit_type_given) {
				    syntax_error(yypvt[-2].line_num,yypvt[-2].col_num,
					 "conflicts with IMPLICIT statement");
				}
				else {
				    if(f77_standard)
				      nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
				    implicit_none = TRUE;
				}
			    }
			    else {
				syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				     "unknown keyword -- ignored");
			    }
			} /*NOTREACHED*/ break;
case 157:
# line 1113 "fortran.y"
{initial_flag = TRUE;} /*NOTREACHED*/ break;
case 159:
# line 1119 "fortran.y"
{implicit_letter_flag = TRUE;} /*NOTREACHED*/ break;
case 160:
# line 1120 "fortran.y"
{implicit_letter_flag = FALSE;} /*NOTREACHED*/ break;
case 163:
# line 1128 "fortran.y"
{
			     set_implicit_type(current_datatype,
			     		yypvt[-0].subclass,yypvt[-0].subclass);
			} /*NOTREACHED*/ break;
case 164:
# line 1133 "fortran.y"
{
			     set_implicit_type(current_datatype,
					yypvt[-2].subclass,yypvt[-0].subclass);
			} /*NOTREACHED*/ break;
case 171:
# line 1154 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 172:
# line 1156 "fortran.y"
{
			     def_parameter(&(yypvt[-3]),&(yypvt[-0]));
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 174:
# line 1167 "fortran.y"
{
			     def_ext_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 175:
# line 1171 "fortran.y"
{
			     def_ext_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 177:
# line 1181 "fortran.y"
{
			     def_intrins_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 178:
# line 1185 "fortran.y"
{
			     def_intrins_name(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 183:
# line 1200 "fortran.y"
{
			     ref_variable(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 184:
# line 1204 "fortran.y"
{
			     def_com_block(&(yypvt[-1]),(Token*)NULL);
			} /*NOTREACHED*/ break;
case 189:
# line 1219 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 190:
# line 1221 "fortran.y"
{complex_const_allowed=FALSE;} /*NOTREACHED*/ break;
case 194:
# line 1230 "fortran.y"
{
			     use_lvalue(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 201:
# line 1246 "fortran.y"
{
			     use_parameter(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 203:
# line 1253 "fortran.y"
{
			     use_parameter(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 204:
# line 1259 "fortran.y"
{
			    use_implied_do_index(&(yypvt[-3]));
			} /*NOTREACHED*/ break;
case 209:
# line 1273 "fortran.y"
{
			     use_lvalue(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 211:
# line 1281 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 212:
# line 1282 "fortran.y"
{
			  assignment_stmt_type(&(yypvt[-3]),&(yypvt[-2]),
					&(yypvt[-0]));
			  complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 213:
# line 1288 "fortran.y"
{
				/* Clear u-b-s flags spuriously set */
			  if(is_true(STMT_FUNCTION_EXPR, yypvt[-5].subclass)
				     && stmt_sequence_no <= seq_stmt_fun)
			     stmt_function_stmt(&(yypvt[-5]));
		        } /*NOTREACHED*/ break;
case 217:
# line 1305 "fortran.y"
{
			    do_ASSIGN(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 221:
# line 1322 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 222:
# line 1326 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-4]));
			} /*NOTREACHED*/ break;
case 223:
# line 1330 "fortran.y"
{
			     do_assigned_GOTO(&(yypvt[-5]));
			} /*NOTREACHED*/ break;
case 231:
# line 1356 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 232:
# line 1357 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			    complex_const_allowed = FALSE;

			    initial_flag = TRUE;	/* for is_keyword */
			} /*NOTREACHED*/ break;
case 234:
# line 1369 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 235:
# line 1370 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			    complex_const_allowed = FALSE;

			    initial_flag = TRUE;
			} /*NOTREACHED*/ break;
case 240:
# line 1400 "fortran.y"
{
			     use_lvalue(&(yypvt[-3]));
			     use_variable(&(yypvt[-3]));
			} /*NOTREACHED*/ break;
case 241:
# line 1405 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 242:
# line 1406 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			    complex_const_allowed=FALSE;
			    /* (N.B. nonportability flagged in do_handle) */
			} /*NOTREACHED*/ break;
case 243:
# line 1414 "fortran.y"
{complex_const_allowed=TRUE;} /*NOTREACHED*/ break;
case 244:
# line 1415 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			    complex_const_allowed=FALSE;
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-5].line_num,yypvt[-5].col_num);
#else
			    syntax_error(yypvt[-5].line_num,yypvt[-5].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 247:
# line 1433 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			    integer_context=FALSE;
			} /*NOTREACHED*/ break;
case 250:
# line 1451 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 251:
# line 1461 "fortran.y"
{
#ifdef ALLOW_DO_ENDO
			    if(f77_standard)
				nonstandard(yypvt[-1].line_num,yypvt[-1].col_num);
#else
			    syntax_error(yypvt[-1].line_num,yypvt[-1].col_num,
				    "Nonstandard syntax");
#endif
			} /*NOTREACHED*/ break;
case 257:
# line 1487 "fortran.y"
{
			     use_variable(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 259:
# line 1495 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 261:
# line 1497 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 263:
# line 1500 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 264:
# line 1502 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 270:
# line 1515 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 271:
# line 1519 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			} /*NOTREACHED*/ break;
case 272:
# line 1524 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-4].line_num,yypvt[-4].col_num);
			} /*NOTREACHED*/ break;
case 274:
# line 1533 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 275:
# line 1534 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 277:
# line 1538 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-2].line_num,yypvt[-2].col_num);
			} /*NOTREACHED*/ break;
case 278:
# line 1543 "fortran.y"
{complex_const_allowed = TRUE;} /*NOTREACHED*/ break;
case 279:
# line 1544 "fortran.y"
{complex_const_allowed = FALSE;} /*NOTREACHED*/ break;
case 280:
# line 1545 "fortran.y"
{
			    if(f77_standard)
				nonstandard(yypvt[-6].line_num,yypvt[-6].col_num);
			} /*NOTREACHED*/ break;
case 281:
# line 1553 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 282:
# line 1557 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 283:
# line 1566 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			} /*NOTREACHED*/ break;
case 284:
# line 1570 "fortran.y"
{
			    if( yypvt[-0].class != '*'
			       && is_true(ID_EXPR,yypvt[-0].subclass)){
					/* WRITE(string,...) means store
					   output in the string */
				if(curr_stmt_class == tok_WRITE
				 && control_item_count == 0
				 && datatype_of(yypvt[-0].class) == type_STRING)
				    use_lvalue(&(yypvt[-0]));

				use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 285:
# line 1591 "fortran.y"
{
			    if( yypvt[-0].class != '*'
			       && is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 286:
# line 1599 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 287:
# line 1604 "fortran.y"
{
			    ++control_item_count;
			} /*NOTREACHED*/ break;
case 288:
# line 1610 "fortran.y"
{
			    use_io_keyword(&(yypvt[-2]),&(yypvt[-0]),curr_stmt_class);
			} /*NOTREACHED*/ break;
case 289:
# line 1614 "fortran.y"
{
			    use_special_open_keywd(&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 292:
# line 1625 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				if( curr_stmt_class == tok_READ ||
				    curr_stmt_class == tok_ACCEPT )
				    use_lvalue(&(yypvt[-0]));
				else
				    use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 294:
# line 1639 "fortran.y"
{
			     use_implied_do_index(&(yypvt[-3]));
			} /*NOTREACHED*/ break;
case 295:
# line 1645 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 297:
# line 1650 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 299:
# line 1655 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 303:
# line 1663 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 306:
# line 1670 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 309:
# line 1677 "fortran.y"
{control_item_count = 0;} /*NOTREACHED*/ break;
case 312:
# line 1691 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_variable(&(yypvt[-0]));
			    }
			} /*NOTREACHED*/ break;
case 314:
# line 1700 "fortran.y"
{inside_format=TRUE;} /*NOTREACHED*/ break;
case 315:
# line 1701 "fortran.y"
{
			  inside_format=FALSE;
			} /*NOTREACHED*/ break;
case 330:
# line 1728 "fortran.y"
{
			  if(f77_standard)
			     nonstandard(yypvt[-0].line_num,yypvt[-0].col_num);
			} /*NOTREACHED*/ break;
case 335:
# line 1746 "fortran.y"
{
			     call_subr(&(yypvt[-0]),(Token*)NULL);
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 337:
# line 1752 "fortran.y"
{
			     call_subr(&(yypvt[-2]),(Token*)NULL);
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 339:
# line 1758 "fortran.y"
{
			     call_subr(&(yypvt[-3]),&(yypvt[-1]));
			     if(debug_parser)
				print_exprlist("call stmt",&(yypvt[-1]));
			     complex_const_allowed = FALSE;
			} /*NOTREACHED*/ break;
case 341:
# line 1767 "fortran.y"
{
			     complex_const_allowed = TRUE;
			     yyval = yypvt[-0];
			} /*NOTREACHED*/ break;
case 342:
# line 1773 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_actual_arg(&(yypvt[-0]));
				 use_variable(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 343:
# line 1781 "fortran.y"
{
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 344:
# line 1785 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_actual_arg(&(yypvt[-0]));
				 use_variable(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 345:
# line 1793 "fortran.y"
{
			    yyval.next_token = append_token(yypvt[-4].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 346:
# line 1800 "fortran.y"
{
			     do_RETURN(current_module_hash,&(yypvt[-1]));
			} /*NOTREACHED*/ break;
case 347:
# line 1804 "fortran.y"
{
			     do_RETURN(current_module_hash,&(yypvt[-2]));
			} /*NOTREACHED*/ break;
case 348:
# line 1815 "fortran.y"
{
			    if( ! is_true(CONST_EXPR,yypvt[-0].subclass) ) {
				syntax_error(
				   yypvt[-0].line_num,yypvt[-0].col_num,
				   "constant expression expected");
			    }
			    else if( ! is_const_type(yypvt[-0].class) ){
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
			"arithmetic, char, or logical expression expected");
			    }
			} /*NOTREACHED*/ break;
case 349:
# line 1831 "fortran.y"
{
			    if(debug_parser) {
				fprintf(list_fd,
					"\nexpr: class=0x%x subclass=0x%x",
					yypvt[-0].class,
					yypvt[-0].subclass);
			    }
			} /*NOTREACHED*/ break;
case 351:
# line 1844 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 352:
# line 1849 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 354:
# line 1858 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 356:
# line 1867 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 358:
# line 1876 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 360:
# line 1884 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 362:
# line 1894 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 363:
# line 1898 "fortran.y"
{
			    unexpr_type(&(yypvt[-1]),&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 364:
# line 1902 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 365:
# line 1907 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 367:
# line 1916 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			    if(div_check &&
			       !is_true(CONST_EXPR,yypvt[-0].subclass)){
				warning(yypvt[-1].line_num,yypvt[-1].col_num,
					"Possible division by zero");
			    }
			} /*NOTREACHED*/ break;
case 368:
# line 1926 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 370:
# line 1935 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 372:
# line 1944 "fortran.y"
{
			    binexpr_type(&(yypvt[-2]),&(yypvt[-1]),&(yypvt[-0])
					 ,&(yyval));
			} /*NOTREACHED*/ break;
case 373:
# line 1951 "fortran.y"
{
			    DBGstr(primary<--id=,token_name(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 376:
# line 1959 "fortran.y"
{
			    make_true(CONST_EXPR,yyval.subclass);
			    make_true(NUM_CONST,yyval.subclass);
			} /*NOTREACHED*/ break;
case 377:
# line 1964 "fortran.y"
{
			    DBGstr(primary<--str=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_STRING);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 378:
# line 1971 "fortran.y"
{
			    DBGstr(primary<--h=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_HOLLERITH);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			    if(port_check) {
				warning(yypvt[-0].line_num,yypvt[-0].col_num,
				"hollerith constant may not be portable");
			    }
			} /*NOTREACHED*/ break;
case 379:
# line 1982 "fortran.y"
{
			    DBGstr(primary<--log=,yypvt[-0].value.string)
			    yyval.class = type_byte(class_VAR,type_LOGICAL);
			    yyval.subclass = 0;
			    make_true(CONST_EXPR,yyval.subclass);
			} /*NOTREACHED*/ break;
case 380:
# line 1989 "fortran.y"
{
			    yyval = yypvt[-1];
			} /*NOTREACHED*/ break;
case 381:
# line 1995 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_INTEGER);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 382:
# line 2000 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_REAL);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 383:
# line 2005 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_DP);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 384:
# line 2010 "fortran.y"
{
			    yyval.class = type_byte(class_VAR,type_COMPLEX);
			    yyval.subclass = 0;
			} /*NOTREACHED*/ break;
case 385:
# line 2018 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    if(datatype_of(yypvt[-0].class) != type_INTEGER) {
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"expression must be integer type");
			    }
			} /*NOTREACHED*/ break;
case 386:
# line 2032 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    {
				int t=datatype_of(yypvt[-0].class);
				    if(t != type_INTEGER && t != type_REAL
					&& t != type_DP ) {
					syntax_error(
					  yypvt[-0].line_num,yypvt[-0].col_num,
		"expression must be integer, real, or double precision type");
			    	    }
			    }
			} /*NOTREACHED*/ break;
case 387:
# line 2052 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }
			    if( ! is_true(CONST_EXPR,yypvt[-0].subclass) ) {
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"constant expression expected");
			    }
			    else
			      if(datatype_of(yypvt[-0].class) != type_INTEGER){
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"integer expression expected");
			    }

			} /*NOTREACHED*/ break;
case 388:
# line 2073 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				use_variable(&(yypvt[-0]));
			    }

			    if( datatype_of(yypvt[-0].class) != type_INTEGER ){
				syntax_error(
					yypvt[-0].line_num,yypvt[-0].col_num,
					"integer dimension expected");
				yyval.value.integer = 0;
			    }
			    else {
			      if( is_true(CONST_EXPR,yypvt[-0].subclass) )
				yyval.value.integer =
				  int_expr_value(&(yypvt[-0]));
			      else		/* must be dummy */
				yyval.value.integer = 0;
			    }
			} /*NOTREACHED*/ break;
case 389:
# line 2099 "fortran.y"
{
			    if( is_true (ARRAY_ID_EXPR, yypvt[-3].subclass)){
				ref_array(&(yypvt[-3]),&(yypvt[-1]));
				if(debug_parser)
				    print_exprlist("array lvalue",&(yypvt[-1]));
					/* array now becomes scalar */
				make_false(ARRAY_ID_EXPR,yyval.subclass);
			    }
			    else {          /* statement-function */
				if(stmt_sequence_no > seq_stmt_fun) {
				    syntax_error(
					yypvt[-3].line_num, NO_COL_NUM,
				    	"statement out of order");
		 		}
				def_stmt_function(&(yypvt[-3]),&(yypvt[-1]));
					/* remake token info */
				primary_id_expr(&(yypvt[-3]),&(yyval));
				if(debug_parser)
				  print_exprlist("stmt function",&(yypvt[-1]));
			    }
			} /*NOTREACHED*/ break;
case 390:
# line 2122 "fortran.y"
{

			    if( is_true(ARRAY_ID_EXPR,yypvt[-3].subclass) ) {
				ref_array(&(yypvt[-3]),&(yypvt[-1]));
				if(debug_parser)
				    print_exprlist("array",&(yypvt[-1]));
					/* array now becomes scalar */
				make_false(ARRAY_ID_EXPR,yyval.subclass);
			    }
			    else {
				call_func(&(yypvt[-3]),&(yypvt[-1]));
							/* remake token info */
				func_ref_expr(&(yypvt[-3]),&(yypvt[-1])
					      ,&(yyval));
				if(debug_parser)
				    print_exprlist("function",&(yypvt[-1]));
			    }
			} /*NOTREACHED*/ break;
case 391:
# line 2143 "fortran.y"
{
			    yyval.class = 0;
			    yyval.next_token = NULL;
			} /*NOTREACHED*/ break;
case 393:
# line 2151 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
				 use_var_as_subscr(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token((Token*)NULL,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 394:
# line 2158 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-0].subclass)){
			     	 use_var_as_subscr(&(yypvt[-0]));
			    }
			    yyval.next_token = append_token(yypvt[-2].next_token,&(yypvt[-0]));
			} /*NOTREACHED*/ break;
case 400:
# line 2177 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-2].subclass)){
				use_variable(&(yypvt[-2]));
			    }
			} /*NOTREACHED*/ break;
case 401:
# line 2183 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }
			} /*NOTREACHED*/ break;
case 402:
# line 2189 "fortran.y"
{
			    if(is_true(ID_EXPR,yypvt[-3].subclass)){
				use_variable(&(yypvt[-3]));
			    }
			    if(is_true(ID_EXPR,yypvt[-1].subclass)){
				use_variable(&(yypvt[-1]));
			    }

			} /*NOTREACHED*/ break;
case 403:
# line 2204 "fortran.y"
{
			    ref_variable(&(yypvt[-0]));
			    primary_id_expr(&(yypvt[-0]),&(yyval));
			} /*NOTREACHED*/ break;
case 412:
# line 2233 "fortran.y"
{
			    integer_context=TRUE;
			} /*NOTREACHED*/ break;
case 413:
# line 2240 "fortran.y"
{
				integer_context=FALSE;
				yyval.class = type_byte(class_LABEL,type_LABEL);
				yyval.subclass = 0;
			} /*NOTREACHED*/ break;
}


	goto yystack;		/* reset registers in driver code */
}
