.TH FTNCHEK 1L "11 January 1992"
.\"======================================================================
.SH "NAME"
ftnchek \- Fortran program checker
.SH "SYNOPSIS"
.B ftnchek
[
.B \-[no]declare
]
[
.B \-[no]division
]
[
.B \-[no]extern
]
.if n .ti +5
[
.B \-[no]f77
]
.if t .ti +.5i
[
.B \-[no]library
]
[
.B \-[no]linebreak
]
.if n .ti +5
[
.B \-[no]list
]
[
.B \-[no]portability
]
.if t .ti +.5i
[
.B \-[no]project
]
.if n .ti +5
[
.B \-[no]sixchar
]
[
.B \-[no]symtab
]
[
.B \-[no]usage
]
.if n .ti +5
[
.B \-[no]verbose
]
.if t .ti +.5i
[
.BI \-output= str
]
[
.BI \-columns= num
]
.if n .ti +5
[
.BI \-common= num
]
[
.BI \-novice= num
]
.SH "INTRODUCTION"
.B Ftnchek
(short for Fortran checker) is designed to detect certain errors in a Fortran
program that a compiler usually does not.
.B Ftnchek
is not primarily intended to detect syntax errors.  Its purpose is to assist
the user in finding semantic errors.  Semantic errors are legal in the Fortran
language but are wasteful or may cause incorrect operation.  For example,
variables which are never used may indicate some omission in the program;
uninitialized variables contain garbage which may cause incorrect results to
be calculated; and variables which are not declared may not have the intended
type.
.B Ftnchek
is intended to assist users in the debugging of their Fortran program.  It is
not intended to catch all syntax errors.  This is the function of the
compiler.  Prior to using
.BR Ftnchek ,
the user should verify that the program compiles correctly.
.PP
This document first summarizes how to invoke
.BR Ftnchek .
That section should be read before beginning to use
.BR Ftnchek .
Later sections describe
.BR Ftnchek 's
options in more detail, give an example of its use, and explain how to
interpret the output.  The final sections mention the limitations and known
bugs in
.BR Ftnchek .
.PP
NOTE:  as of Version 2.5, the name of this program has been changed from
.B Forchek
to
.BR Ftnchek ,
to avoid confusion with a similar program named
.BR Forcheck ,
developed earlier at Leiden University.  We apologize for any inconvenience
this change may cause.
.SH "INVOKING FTNCHEK"
.B Ftnchek
is invoked through a command of the form:
.nf
\fC
$ ftnchek [-option -option ...] filename [filename ...]
\fP
.fi
.PP
(The brackets indicate something which is optional.  The brackets themselves
are not actually typed.) Here options are command-line switches or settings,
which control the operation of the program and the amount of information that
will be printed out.  If no option is specified, the default action is to
print error messages, warnings, and informational messages, but not the
program listing or symbol tables.
.PP
Each option begins with the '\-' character.  (On VAX/VMS systems you may use
either '/' or '\-'.) The options are described at greater length in the next
section.
.PP
.B Ftnchek
options fall into two categories:  switches, which are either true or false,
and settings, which have a numeric or string value.  The name of a switch can
be preceded by 'no' to turn it off:  e.g.
.B \-nousage
would turn off the warnings about variable usage.  Only the first 3 characters
of an option name (not counting the '\-') need be provided.  The switches
which
.B Ftnchek
currently recognizes are:
.TP
.B \-declare
Print a list of all identifiers whose datatype is not explicitly declared.
Default = no.
.TP
.B \-division
Warn wherever division is done (except division by a constant).  Default = no.
.TP
.B \-extern
Warn if external subprograms which are invoked are never defined.  Default =
yes.
.TP
.B \-f77
Warn about violations of the Fortran 77 standard.  Default = no.
.TP
.B \-library
Begin library mode:  do not warn if subprograms in file are defined but never
used.  Default = no.
.TP
.B \-linebreak
Treat linebreaks in continued statements as space.  Default = yes.
.TP
.B \-list
Print source listing of program.  Default = no.
.TP
.B \-portability
Warn about non-portable usages.  Default = no.
.TP
.B \-project
Create project file (see explanation below).  Default = no.
.TP
.B \-sixchar
List any variable names which clash at 6 characters length.  Default = no.
.TP
.B \-symtab
Print out symbol table.  Default = no.
.TP
.B \-usage
Warn if variables not used, etc.  Default = yes.
.TP
.B \-verbose
Produce full amount of output.  Default = yes.
.PP
There are four settings:
.TP
.BI \-columns= n
Set maximum line length to
.I n
columns.  (Beyond this is ignored.) Max is 132.  Default = 72.
.TP
.BI \-common= n
Level of strictness in checking
.I COMMON
blocks.  Min is 0 (no checking).  Max is 3 (must be identical).  Default = 3.
.TP
.BI \-novice= n
Set novice level, which controls certain types of warnings.  Min is 1 (tyro).
Max is 5 (wizard).  Default = 1.
.TP
.BI \-output= filename
Send output to the given file.  Default is to send output to the screen.
(Default filename extension is
.IR .\|lis ).
.PP
When more than one option is used, they should be separated by a blank space.
No blank spaces may be placed around the equals (=) in a setting.
\fBFtnchek "?"\fP
will produce a list of all options and settings.
.PP
When giving a name of an input file, the extension is optional.  If no
extension is given,
.B Ftnchek
will first look for a project file with extension
.I .\|prj
and will use that if it exists.  If not, then
.B Ftnchek
will look for a Fortran source file with the extension
.I .\|for
for VMS systems,
.I .\|f
for Unix systems.  More than one file name can be given to
.BR Ftnchek ,
and it will process the modules in all files as if they were in a single file.
.PP
If no filename is given,
.B Ftnchek
will read input from the standard input.
.SH "FTNCHEK OPTIONS"
This section provides a more detailed discussion of
.B Ftnchek
command-line options.  Options and filenames may be interspersed on a command
line.  Each option remains in effect from the point it is encountered until it
is overridden by a later option.  Thus for example, the listing may be
suppressed for some files and not for others.
.PP
The option names in the following list are in alphabetical order.
.TP
.BI \-columns= n
Set maximum line length to
.I n
columns.  (Beyond this is ignored.) This setting is provided to allow checking
of programs which may violate the Fortran standard limit of 72 columns for the
length of a line.  According to the standard, all characters past column 72
are ignored.  This setting does not affect the reporting of overlength lines
under the
.B \-f77
option.  Max is 132.  Default = 72.
.TP
.BI \-common= n
This setting varies the strictness of checking of
.I COMMON
blocks.  Level 3 is the strictest:  it requires that in each declaration of a
given
.I COMMON
block, corresponding variables agree in data type and (if arrays) size and
number of dimensions.  Levels 1 and 2 require only that corresponding memory
locations agree in data type.  The difference between Levels 1 and 2 is that
Level 2 warns if the blocks are not equal in total length, while Level 1 does
not.  Level 0 suppresses all checking.  Default = 3.
.TP
.B \-declare
If this flag is set, all identifiers whose datatype is not declared in each
module will be listed.  This flag is useful for helping to find misspelled
variable names, etc.  The same listing will be given if the module contains an
.I "IMPLICIT NONE"
statement.  Default = no.
.TP
.B \-division
This switch is provided to help users spot potential division by zero
problems.  If this switch is selected, every division except by a constant
will be flagged.  (It is assumed that the user is intelligent enough not to
divide by a constant which is equal to zero!) Default = no.
.TP
.B \-extern
Causes
.B Ftnchek
to report whether any subprograms invoked by the program are never defined, or
are multiply defined.  Ordinarily, if
.B Ftnchek
is being run on a complete program, each subprogram other than the intrinsic
functions should be defined once and only once somewhere.  Turn off this
switch if you just want to check a subset of files which form part of a larger
complete program, or to check all at once a number of unrelated files which
might each contain an unnamed main program.  Subprogram arguments will still
be checked for correctness.  Default = yes.
.TP
.B \-f77
Use this flag to catch language extensions which violate the Fortran 77
standard.  Such extensions may cause your program not to be portable.
Examples include the use of underscores in variable names; variable names
longer than six characters; statement lines longer than 72 characters; and
nonstandard statements such as the
.I DO ...
.I ENDDO
structure.
.B Ftnchek
does not report on the use of lowercase letters.  Default=no.
.TP
.B \-library
This switch is used when a number of subprograms are contained in a file, but
not all of them are used by the application.  Normally,
.B Ftnchek
warns you if any subprograms are defined but never used.  This switch will
suppress these warnings.  Default = no.
.TP
.B \-linebreak
Normally, when scanning a statement which is continued onto the next line,
.B Ftnchek
treats the end of the line as a space.  This behavior is the same as for
Pascal and C, and also corresponds to how humans normally would read and write
programs.  However, occasionally one would like to use
.B Ftnchek
to check a program in which identifiers and keywords are split across lines,
for instance programs which are produced using a preprocessor.  Choosing the
option
.B \-nolinebreak
will cause
.B Ftnchek
to skip over the end of line and also any leading space on the continuation
line (from the continuation mark up to the first nonspace character).  Default
= yes, i.e.  treat linebreaks as space.
.IP
Note that in nolinebreak mode, if token pairs requiring intervening space (for
instance,
.IR "GOTO 100" )
are separated only by a linebreak, they will be rejoined.
.IP
Also, tokens requiring more than one character of lookahead for the resolution
of ambiguities must not be split across lines.  In particular, a complex
constant may not be split across a line.
.TP
.B \-list
Specifies that a listing of the Fortran program is to be printed out with line
numbers.  If
.B Ftnchek
detects an error, the error message follows the program line with a caret (^)
specifying the location of the error.  If no source listing was requested,
.B Ftnchek
will still print out any line containing an error, to aid the user in
determining where the error occurred.  Default = no.
.TP
.BI \-novice= n
This setting controls certain messages about conditions which are likely to be
errors for novice programmers, but which are often intentional by more
sophisticated programmers.  Some of these warnings deal with cases in which
.B Ftnchek
suspects that what appears to be a function is intended to be an array, which
the user forgot to declare in a
.I DIMENSION
statement.  Since a function invocation and an array reference are identical
in syntax, undeclared arrays are interpreted by the Fortran compiler and by
.B Ftnchek
as functions.  Novice users are often confused by the messages which result.
.B Ftnchek
attempts to remedy this confusion.  Default level = 1.
.IP
The novice levels are given below.  The warning corresponding to each number
will be suppressed if the novice level is set to greater than that value.
.RS
.TP \w'1.'u+2n
1.
Warn if arrays passed as arguments to a subprogram do not match the
corresponding dummy arguments in both number of dimensions and size.
Exception:  if the declared size of the dummy array is 1 or if it is
dimensioned with a dummy variable, only the number of dimensions will be
checked.
.TP
2.
Warn the user if any argument of a subprogram appears to be a function.  This
warning is suppressed if the dummy argument is declared in an
.I EXTERNAL
statement.  Novice programmers seldom pass functions as arguments of a
subprogram, so it is more likely that such an argument was intended to be an
array, but was not dimensioned.
.TP
3.
If a function was invoked but never defined, advise the user that it may be an
array which was not dimensioned.  This warning is suppressed if the function
is declared in an
.I EXTERNAL
or
.I INTRINSIC
statement in any module of the program.  This warning is completely suppressed
by the
.B \-noextern
option.
.TP
4.
Warn if a function has side effects:  i.e.  if it modifies any of its
arguments, or modifies a variable in
.IR COMMON .
Ideally, a function has no side effects, and acts only by computing a value
based on its arguments, whereas a subroutine normally acts through side
effects.  Advanced programmers sometimes wish to combine the features of a
subroutine and a function in a single module.
.RE
.TP
.BI \-output= filename
This setting is provided for convenience on systems which do not allow easy
redirection of output from programs.  When this setting is given, the output
which normally appears on the screen will be sent instead to the named file.
Note, however, that operational errors of
.B Ftnchek
itself (e.g.  out of space or cannot open file) will still be sent to the
screen.  The extension for the filename is optional, and if no extension is
given, the extension
.I .\|lis
will be used.
.TP
.B \-portability
.B Ftnchek
will give warnings for a variety of non-portable usages.  These include the
use of tabs except in comments or inside strings, the use of hollerith
constants, and the equivalencing of variables of different data types.  This
option does not produce warnings for violations of the Fortran 77 standard,
which may also cause portability problems.  To catch those, use the
.B \-f77
option.  Default = no.
.TP
.B \-project
.B Ftnchek
will create a project file from each source file that is input while this flag
is in effect.  The project file will be given the same name as the input file,
but with the extension
.I .\|f
or
.I .\|for
replaced by
.IR .\|prj .
(If input is from standard input, the project file is named
.IR ftnchek.\|prj .)
Default = no.
.IP
A project file contains a summary of information from the source file, for use
in checking agreement among
.IR FUNCTION ,
.IR SUBROUTINE ,
and
.I COMMON
block usages in other files.  It allows incremental checking, which saves time
whenever you have a large set of files containing shared subroutines, most of
which seldom change.  You can run
.B Ftnchek
once on each file with the
.B \-project
flag set, creating the project files.  Usually you would also set the
.B \-library
and
.B \-noextern
flags at this time, to suppress messages relating to consistency with other
files.  Only error messages pertaining to each file by itself will be printed
at this time.  Thereafter, run
.B Ftnchek
without these flags on all the project files together, to check consistency
among the different files.  All messages internal to the individual files will
now be omitted.  Only when a file is altered will a new project file need to
be made for it.
.IP
The information saved in the project file consists of all subprogram
declarations, all subprogram invocations not resolved by declarations in the
same file, and one instance of each
.I COMMON
block declaration.  Thus project files contain only information for checking
agreement between files.  This means that a project file is of no use if all
modules of the complete program are contained in a single file.
.IP
Naturally, when the
.B \-project
flag is set,
.B Ftnchek
will not read project files as input.
.IP
Here is an example of how to use the Unix
.B make
utility to automatically create a new project file each time the corresponding
source file is altered, and to check the set of files for consistency.  The
example assumes that a macro
.I OBJS
has been defined which lists all the names of object files to be linked
together to form the complete executable program.
.nf
\fC
    # tell make what a project file suffix is
    .SUFFIXES: .prj

    # tell make how to create a .prj file from a .f file
    .f.prj:
            ftnchek -project -noextern -library $<

    # set up macro PRJS containing project filenames
    PRJS= $(OBJS:.o=.prj)

    # "make check" will check everything that has been changed.
    check: $(PRJS)
            ftnchek $(PRJS)
\fP
.fi
.TP
.B \-sixchar
One of the goals of the
.B Ftnchek
program is to help users to write portable Fortran programs.  One potential
source of nonportability is the use of variable names that are longer than six
characters.  Some compilers just ignore the extra characters.  This behavior
could potentially lead to two different variables being considered as the
same.  For instance, variables named
.I AVERAGECOST
and
.I AVERAGEPRICE
are the same in the first six characters.  If you wish to catch such possible
conflicts, use this flag.  Default = no.
.TP
.B \-symtab
A symbol table will be printed out for each module, listing all identifiers
mentioned in the module.  This table gives the name of each variable, its
datatype, and the number of dimensions for arrays.  An asterisk (*) indicates
that the variable has been implicitly typed, rather than being named in an
explicit type declaration statement.  The table also lists all subprograms
invoked by the module, all
.I COMMON
blocks declared, etc.  Default = no.
.TP
.B \-usage
This switch is on by default.  It causes
.B Ftnchek
to list all variables which may be used before they are initialized, or which
are given a value but never subsequently used, or which are declared but never
used.  Sometimes
.B Ftnchek
makes a mistake about this.  Usually it errs on the side of giving a warning
where no problem exists, but in rare cases it will fail to warn where the
problem does exist.  See the section on bugs for examples.  If variables are
equivalenced, the rule used by
.B Ftnchek
is that a reference to any variable implies the same reference to all
variables it is equivalenced to.  Default = yes.
.TP
.B \-verbose
This option is on by default.  Turning it off reduces the amount of output
relating to normal operation, so that error messages are more apparent.  This
option is provided for the convenience of users who are checking large suites
of files.  The eliminated output includes the names of project files, and the
message reporting that no syntax errors were found.  (Some of this output is
turned back on by the
.B \-list
and
.B \-symtab
options.) Default = yes.
.SH "CHANGING THE DEFAULTS"
.B Ftnchek
includes a mechanism for changing the default values of all options by
defining environment variables.  When
.B Ftnchek
starts up, it looks in its environment for any variables whose names are
composed by prefixing the string "FTNCHEK_" onto the uppercased version of the
option name (the quote marks are not part of the name.) If such a variable is
found, its value is used to specify the default for the corresponding switch
or setting.  In the case of settings (for example, the novice level) the value
of the environment variable is read as the default setting value.  In the case
of switches, the default switch will be taken as true or "YES" unless the
environment variable has the value "0" or "NO" (again, the quotes are not part
of the value).  Of course, command-line options will override these defaults
the same way as they override the built-in defaults.
.PP
Note that the environment variable name must be constructed with the
full-length option name, which must be in uppercase.  For example, to make
.B Ftnchek
print a source listing by default, set the environment variable "FTNCHEK_LIST"
to "1" or "YES" or anything other than "0" or "NO".  The names "FTNCHEK_LIS"
(not the full option name) or "ftnchek_list" (lower case) would not be
recognized.
.PP
Here are some examples of how to set environment variables on various systems.
For simplicity, all the examples set the default
.B \-list
switch to "yes."
.PP
.fc > @
.if n .ta 30 +35
.if t .ta 2i +2i
>1. Unix, Bourne shell:  >\fC$ FTNCHEK_LIST=YES\fP
>                        >\fC$ export FTNCHEK_LIST\fP

>2. Unix, C shell:       >\fC% setenv FTNCHEK_LIST YES\fP

>3. VAX/VMS:             >\fC$ DEFINE FTNCHEK_LIST YES\fP

>4. MSDOS:               >\fC$ SET FTNCHEK_LIST=YES\fP
.fc
.SH "AN EXAMPLE"
The following simple Fortran program illustrates the messages given by
.BR Ftnchek .
The program is intended to accept an array of test scores and then compute the
average for the series.
.PP
.nf
\fC
C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
C       DATE:    MAY 8, 1989
C       Variables:
C               SCORE -> an array of test scores
C               SUM ->   sum of the test scores
C               COUNT -> counter of scores read in
C               I ->     loop counter
        REAL FUNCTION COMPAV(SCORE,COUNT)
            INTEGER SUM,COUNT,J,SCORE(5)
            DO 30 I = 1,COUNT
                SUM = SUM + SCORE(I)
30          CONTINUE
            COMPAV = SUM/COUNT
        END
        PROGRAM AVENUM
C
C                       MAIN PROGRAM
C
C       AUTHOR:   LOIS BIGBIE
C       DATE:     MAY 15, 1990
C
C       Variables:
C               MAXNOS -> maximum number of input values
C               NUMS    -> an array of numbers
C               COUNT   -> exact number of input values
C               AVG     -> average returned by COMPAV
C               I       -> loop counter
C
            PARAMETER(MAXNOS=5)
            INTEGER I, COUNT
            REAL NUMS(MAXNOS), AVG
            COUNT = 0
            DO 80 I = 1,MAXNOS
                READ (5,*,END=100) NUMS(I)
                COUNT = COUNT + 1
80          CONTINUE
100         AVG = COMPAV(NUMS, COUNT)
        END
\fP
.fi
.PP
The compiler gives no error messages when this program is compiled.  Yet here
is what happens when it is run:
.PP
.nf
\fC
$ run average
70
90
85
<EOF>
$
\fP
.fi
.PP
What happened?  Why didn't the program do anything?  The following is the
output from
.B Ftnchek
when it is used to debug the above program:
.PP
.nf
\fC

$ ftnchek -list -symtab average

FTNCHEK Version 2.5 January 1992

File average.f:

      1 C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
      2 C       DATE:    MAY 8, 1989
      3
      4 C       Variables:
      5 C               SCORE -> an array of test scores
      6 C               SUM ->   sum of the test scores
      7 C               COUNT -> counter of scores read in
      8 C               I ->     loop counter
      9
     10         REAL FUNCTION COMPAV(SCORE,COUNT)
     11             INTEGER SUM,COUNT,J,SCORE(5)
     12
     13             DO 30 I = 1,COUNT
     14                 SUM = SUM + SCORE(I)
     15 30          CONTINUE
     16             COMPAV = SUM/COUNT
                           ^
Warning near line 16 col 20: integer quotient expr converted to real
     17         END
     18

Module COMPAV: func: real

Variables:

      Name Type Dims     Name Type Dims     Name Type Dims     Name Type Dims
    COMPAV real         COUNT intg             I intg*            J intg
     SCORE intg  1        SUM intg

* Variable not declared. Type has been implicitly defined.


Variables declared but never referenced in module COMPAV:
         J

Variables may be used before set in module COMPAV:
       SUM


     19
     20         PROGRAM AVENUM
     21 C
     22 C                       MAIN PROGRAM
     23 C
     24 C       AUTHOR:   LOIS BIGBIE
     25 C       DATE:     MAY 15, 1990
     26 C
     27 C       Variables:
     28 C               MAXNOS -> maximum number of input values
     29 C               NUMS    -> an array of numbers
     30 C               COUNT   -> exact number of input values
     31 C               AVG     -> average returned by COMPAV
     32 C               I       -> loop counter
     33 C
     34
     35             PARAMETER(MAXNOS=5)
     36             INTEGER I, COUNT
     37             REAL NUMS(MAXNOS), AVG
     38             COUNT = 0
     39             DO 80 I = 1,MAXNOS
     40                 READ (5,*,END=100) NUMS(I)
     41                 COUNT = COUNT + 1
     42 80          CONTINUE
     43 100         AVG = COMPAV(NUMS, COUNT)
     44         END

Module AVENUM: prog

External subprograms referenced:

    COMPAV: real*

Variables:

      Name Type Dims     Name Type Dims     Name Type Dims     Name Type Dims
       AVG real         COUNT intg             I intg        MAXNOS intg*
      NUMS real  1

* Variable not declared. Type has been implicitly defined.


Variables set but never used in module AVENUM:
       AVG



 0 syntax errors detected in file average.f
 1 warning issued in file average.f

Subprogram COMPAV:  argument data type mismatch
  at position 1:
        Dummy type intg  in module COMPAV line 10 file average.f
        Actual type real  in module AVENUM line 43 file average.f
\fP
.fi
.PP
According to
.BR Ftnchek ,
the program contains variables which may be used before they are assigned an
initial value, and variables which are not needed.
.B Ftnchek
also warns the user that an integer quotient has been converted to a real.
This may assist the user in catching an unintended roundoff error.  Since the
.B \-symtab
flag was given,
.B Ftnchek
prints out a table containing identifiers from the local module and their
corresponding datatype and number of dimensions.  Finally,
.B Ftnchek
warns that the function is not used with the proper type of arguments.
.PP
With
.BR Ftnchek 's
help, we can debug the program.  We can see that there were the following
errors:
.TP \w'1.'u+2n
1.
.I SUM
and
.I COUNT
should have been converted to real before doing the division.
.TP
2.
.I SUM
should have been initialized to 0 before entering the loop.
.TP
3.
.I AVG
was never printed out after being calculated.
.TP
4.
.I NUMS
should have been declared
.I INTEGER
instead of
.IR REAL .
.PP
We also see that
.IR I ,
not
.IR J ,
should have been declared
.I INTEGER
in function
.IR COMPAV .
Also,
.I MAXNOS
was not declared as
.IR INTEGER ,
and
.I COMPAV
as
.IR REAL ,
in program
.IR AVENUM .
These are not errors, but they may indicate carelessness.  As it happened, the
default type of these variables coincided with the intended type.
.PP
Here is the corrected program, and its output when run:
.PP
.nf
\fC
C       AUTHORS: MIKE MYERS AND LUCIA SPAGNUOLO
C       DATE:    MAY 8, 1989
C
C       Variables:
C               SCORE -> an array of test scores
C               SUM ->   sum of the test scores
C               COUNT -> counter of scores read in
C               I ->     loop counter
C
       REAL FUNCTION COMPAV(SCORE,COUNT)
            INTEGER SUM,COUNT,I,SCORE(5)
C
            SUM = 0
            DO 30 I = 1,COUNT
                SUM = SUM + SCORE(I)
30          CONTINUE
            COMPAV = FLOAT(SUM)/FLOAT(COUNT)
        END
C
C
        PROGRAM AVENUM
C
C                       MAIN PROGRAM
C
C       AUTHOR:   LOIS BIGBIE
C       DATE:     MAY 15, 1990
C
C       Variables:
C               MAXNOS -> maximum number of input values
C               NUMS    -> an array of numbers
C               COUNT   -> exact number of input values
C               AVG     -> average returned by COMPAV
C               I       -> loop counter
C
C
            INTEGER MAXNOS
            PARAMETER(MAXNOS=5)
            INTEGER I, NUMS(MAXNOS), COUNT
            REAL AVG,COMPAV
            COUNT = 0
            DO 80 I = 1,MAXNOS
                READ (5,*,END=100) NUMS(I)
                COUNT = COUNT + 1
80          CONTINUE
100         AVG = COMPAV(NUMS, COUNT)
            WRITE(6,*) 'AVERAGE =',AVG
        END
\fP
.fi
.PP
.nf
\fC

$ run average
70
90
85
<EOF>
AVERAGE =   81.66666
$
\fP
.fi
.PP
With
.BR Ftnchek 's
help, our program is a success!
.SH "INTERPRETING THE OUTPUT"
.B Ftnchek
will print out four main types of messages.  They are portability warnings,
other warnings, informational messages, and syntax errors.  Portability
warnings specify nonstandard usages that may not be accepted by other
compilers.  Other warning messages report potential errors that are not
normally flagged by a compiler.  Informational messages consist of warnings
which may assist the user in the debugging of their Fortran program.
.PP
Syntax errors are violations of the Fortran language.  The user should have
already eliminated these by using the Fortran compiler.
.B Ftnchek
does not detect all syntax errors.  Generally,
.B Ftnchek
only does as much syntactic error checking as is necessary in order for it to
work properly.
.PP
If
.B Ftnchek
gives you a syntax error message when the compiler does not, it is probably
because your program contains an extension to standard Fortran which is
accepted by the compiler but not by
.BR Ftnchek .
On a VAX/VMS system, you can use the compiler option
\fC/STANDARD\fP
to cause the compiler to accept only standard Fortran.  On most Unix systems,
this can be accomplished by setting the flag
.BR \-ansi .
.PP
Most error messages are self-explanatory.  Those which need a brief
explanation are listed below.  Please note that any error messages which begin
with
.I oops
refer to technical conditions and indicate bugs in
.B Ftnchek
or that its resources have been exceeded.
.PP
The following messages warn about portability or nonstandard usages:
.TP
.I "Nonstandard format item"
.B Ftnchek
will flag nonstandard items in a
.I FORMAT
statement which may not be compatible with other systems.
.TP
.I "characters past 72 columns"
A statement has been read which has nonblank characters past column 72.
Standard Fortran ignores all text in those columns, but many compilers do not.
Thus the program may be treated differently by different compilers.
.TP
.I "Warning:  file contains tabs.  May not be portable."
.B Ftnchek
expands tabs to be equivalent to spaces up to the next column which is a
multiple of 8.  Some compilers treat tabs differently, and also it is possible
that files sent by electronic mail will have the tabs converted to blanks in
some way.  Therefore files containing tabs may not be compiled correctly after
being transferred.
.B Ftnchek
does not give this message if tabs only occur within comments or strings.
.TP
.I "nonstandard type usage in expression"
The program contains an operation such as a logical operation between
integers, which is not standard, and may not be acceptable to some compilers.
.TP
.I "Common block has mixed character and non-character variables"
.TP
.I "Common block has long data type following short data type"
The ANSI standard requires that if any variable in a
.I COMMON
block is of type
.IR CHARACTER ,
then all other variables in the same
.I COMMON
block must also be of type
.IR CHARACTER .
Some compilers additionally require that if a
.I COMMON
block contains mixed data types, all long types (namely
.I "DOUBLE PRECISION"
and
.IR "COMPLEX" )
must precede all short types (namely
.IR INTEGER ,
.IR REAL ,
.IR etc.  ).
.PP
The following messages are warning messages:
.TP
.I "Integer quotient expr converted to real"
.TP
.I "integer quotient expr used in exponent"
The quotient of two integers results in an integer type result, in which the
fractional part is dropped.  If such an integer expression involving division
is later converted to a real datatype, it may be that a real type division had
been intended.  Likewise, if it is used as an exponent, it is likely that a
real type division was intended.
.TP
.I "real truncated to intg"
.B Ftnchek
has detected an assignment statement which has a real expression on the right,
but an integer variable on the left.  The fractional part of the real value
will be lost.  If you explicitly convert the real expression to integer using
the
.I INT
or
.I NINT
intrinsic function, no warning will be printed.  A similar message is printed
if a double precision expression is assigned to a real variable, etc.
.TP
.I "Continuation follows comment or blank line"
.B Ftnchek
issues this warning message to alert the user that a continuation of a
statement is interspersed with comments, making it easy to overlook.
.TP
.I "Possible division by zero"
This message is printed out wherever division is done (except division by a
constant), if the
.B \-division
option was selected.
.TP
.I "NAME not set when RETURN encountered"
The way that functions in Fortran return a value is by assigning the value to
the name of the function.  This message indicates that the function was not
assigned a value before the point where a
.I RETURN
statement was found.  Therefore it is possible that the function could return
an undefined value.
.TP
.I "Unknown intrinsic function"
This message warns the user that a name declared in an
.I INTRINSIC
statement is unknown to
.BR Ftnchek .
Probably it is a nonstandard intrinsic function, and so the program will not
be portable.  The function will be treated by
.B Ftnchek
as a user-defined function.
.PP
The following messages are syntax errors:
.TP
.I "syntax error"
The parser, which analyzes the Fortran program into expressions, statements,
etc., has been unable to find a valid interpretation for some portion of a
statement in the program.  If the compiler does not report a syntax error at
the same place, the most common explanations are:  (1) use of a reserved word
as an array or character variable (see Table 2 in the section entitled
"Limitations and Extensions"), or (2) use of an extension to ANSI standard
Fortran that is not recognized by
.BR Ftnchek .
.TP
.I "No path to this statement"
.B Ftnchek
will detect statements which are ignored or by-passed because there is no
foreseeable route to the statement.  For example, an unnumbered statement (a
statement without a statement label), occurring immediately after a
.I GOTO
statement, cannot possibly be executed.
.TP
.I "Statement out of order."
.B Ftnchek
will detect statements that are out of the sequence specified for ANSI
standard Fortran-77.  Table 1 illustrates the allowed sequence of statements
in the Fortran language.  Statements which are out of order are nonetheless
interpreted by
.BR Ftnchek ,
to prevent "cascades" of error messages.
.IP
.nf
.if n .ne 11
.if t .ne 1.75i
\fC
--------------------------------------------------------
                  |               | implicit
                  |  parameter    |---------------------
                  |               | other specification
        format    |---------------|---------------------
         and      |               | statement-function
        entry     |  data         |---------------------
                  |               | executable
--------------------------------------------------------
                      \fRTable 1\fP
\fP
.fi
.PP
The following messages are informational messages:
.TP
.I "Declared but never referenced"
Detects any identifiers that were declared in your program but were never
used, either to be assigned a value or to have their value accessed.
Variables in
.I COMMON
are excluded.
.TP
.I "Variables used before set"
This message indicates that an identifier is used to compute a value prior to
its initialization.  Such usage may lead to an incorrect value being computed.
.TP
.I "Variables may be used before set"
Similar to used before set except that
.B Ftnchek
is not able to determine its status with certainty.
.B Ftnchek
assumes a variable may be used before set if the first usage of the variable
occurs prior in the program text to its assignment.
.TP
.I "Variables set but never used"
.B Ftnchek
will notify the user when a variable has been assigned a value, but the
variable is not otherwise used in the program.  Usually this results from an
oversight.
.TP
.I "Type has been implicitly defined"
.B Ftnchek
will flag all identifiers that are not explicitly typed and will show the
datatype that was assigned through implicit typing.  This provides support for
users who wish to declare all variables as is required in Pascal or some other
languages.  This message is printed only when the
.B \-symtab
option is in effect.
.TP
.I "Identifiers which are not unique in first six chars"
Warns that two identifiers which are longer than 6 characters do not differ in
first 6 characters.  This is for portability:  they may not be considered
distinct by some compilers.  This message is printed only if the
.B \-sixchar
option was selected.
.TP
.I "Subprogram NAME:  varying length argument lists:"
An inconsistency has been found between the number of dummy arguments
(parameters) a subprogram has and the number of actual arguments given it in
an invocation.
.B Ftnchek
keeps track of all invocations of subprograms
.RI ( CALL
statements and expressions using functions) and compares them with the
definitions of the subprograms elsewhere in the source code.  The Fortran
compiler normally does not catch this type of error.
.TP
.I "Subprogram NAME:  argument data type mismatch at position n"
The subprogram's
.IR n -th
actual argument (in the
.I CALL
or the usage of a function) differs in datatype from the
.IR n -th
dummy argument (in the
.I SUBROUTINE
or
.I FUNCTION
declaration).  For instance, if the user defines a subprogram by
.nf
\fC
     SUBROUTINE SUBA(X)
     REAL X
\fP
.fi
.IP
and elsewhere invokes
.I SUBA
by
.nf
\fC
     CALL SUBA(2)
\fP
.fi
.IP
.B Ftnchek
will detect the error.  The reason here is that the number 2 is integer, not
real.  The user should have said
.nf
\fC
     CALL SUBA(2.0)
\fP
.fi
.IP
When checking an argument which is a subprogram,
.B Ftnchek
must be able to determine whether it is a function or a subroutine.  The rules
used by
.B Ftnchek
to do this are as follows:  If the subprogram, besides being passed as an
actual argument, is also invoked directly elsewhere in the same module, then
its type is determined by that usage.  If not, then if the name of the
subprogram does not appear in an explicit type declaration, it is assumed to
be a subroutine; if it is explicitly typed it is taken as a function.
Therefore, subroutines passed as actual arguments need only be declared by an
.I EXTERNAL
statement in the calling module, whereas functions must also be explicitly
typed in order to avoid generating this error message.
.TP
.I "Subprogram invoked inconsistently"
Here the mismatch is between the datatype of the subprogram itself as used and
as defined.  For instance, if the user declares
.nf
\fC
     INTEGER FUNCTION COUNT(A)
.fi
\fP
.IP
and invokes
.I COUNT
in another module as
.nf
\fC
     N = COUNT(A)
.fi
\fP
.IP
without declaring its datatype, it will default to real type, based on the
first letter of its name.  The calling module should have included the
declaration
.nf
\fC
     INTEGER COUNT
.fi
\fP
.TP
.I "possibly it is an array which was not declared"
This message refers to a function invocation or to an argument type mismatch,
for which the possibility exists that what appears to be a function is
actually meant to be an array.  If the programmer forgot to dimension an
array, references to the array will be interpreted as function invocations.
This message will be suppressed if the name in question appears in an
.I EXTERNAL
or
.I INTRINSIC
statement.
.TP
.I "Subprogram NAME:  argument usage mismatch"
.B Ftnchek
detects a possible conflict between the way a subprogram uses an argument and
the way in which the argument is supplied to the subprogram.  The conflict can
be one of two types, as outlined below.
.TP
.I "Dummy arg is modified, Actual arg is const or expr"
A dummy argument is an argument as named in a
.I SUBROUTINE
or
.I FUNCTION
statement and used within the subprogram.  An actual argument is an argument
as passed to a subroutine or function by the caller.
.B Ftnchek
is saying that a dummy argument is modified by the subprogram, i.e.  its value
will be changed in the calling module.  The corresponding actual argument
should not be a constant or expression, but rather a variable or array element
which can be legitimately assigned to.
.TP
.I "Dummy arg used before set, Actual arg not set"
Here a dummy argument may be used in the subprogram before having a value
assigned to it by the subprogram.  The corresponding actual argument should
have a value assigned to it by the caller prior to invoking the subprogram.
.TP
.I "Common block NAME:  varying length"
A
.I COMMON
block declared in different subprograms has different numbers of variables in
it in different declarations.  This is not necessarily an error, but it may
indicate that a variable is missing from the list.
.TP
.I "Common block NAME:  data type mismatch at position n"
The
.IR n -th
variable in the
.I COMMON
block differs in data type in two different declarations of the
.I COMMON
block.  By default (common strictness level 3),
.B Ftnchek
is very picky about
.I COMMON
blocks:  the variables listed in them must match exactly by data type and
array dimensions.  That is, the legal pair of declarations in different
modules:
.nf
\fC
     COMMON /COM1/ A,B
.fi
\fP
.IP
and
.nf
\fC
     COMMON /COM1/ A(2)
.fi
\fP
.IP
will cause
.B Ftnchek
to give warnings at strictness level 3.  These two declarations are legal in
Fortran since they both declare two real variables.  At strictness level 1 or
2, no warning would be given in this example.
.SH "LIMITATIONS AND EXTENSIONS"
.B Ftnchek
accepts ANSI standard Fortran-77 programs with the following exceptions:
.TP
.B Restrictions:
.B Ftnchek
is sensitive to blank spaces.  This encourages the user to use good
programming style.  The rules are similar to Pascal or C where a blank space
is required between identifiers or keywords and not allowed inside identifiers
or keywords.  The following keywords which occur in pairs may be written as
either one or two words:
.I "DO WHILE"
or
.IR DOWHILE ,
.I "ELSE IF"
or
.IR ELSEIF ,
.I "END DO"
or
.IR ENDDO ,
.I "END IF"
or
.IR ENDIF ,
.I "GO TO"
or
.IR GOTO .
Unlike Pascal and C,
.B Ftnchek
allows blanks inside numeric constants, except within the exponent part of E
and D form numbers.  Also, if the
.B \-nolinebreak
option is selected, the end of line in continued statements is ignored.
.IP
Complex constants are subject to a special restriction:  they may not be split
across lines, even in
.B \-nolinebreak
mode.
.IP
The dummy arguments in statement functions are treated like ordinary variables
of the program.  That is, their scope is the entire module, not just the
statement function definition.
.IP
Some keywords and identifiers are partially reserved.  See Table 2 for
details.
.PP
The following keywords may be freely used as variables:
.PP
.nf
\fC
ASSIGN          BLOCK           CALL            CHARACTER
COMMON          COMPLEX         CONTINUE        DIMENSION
DO              DOUBLE          ELSE            END
ENDDO           ENDIF           ENTRY           EXTERNAL
FUNCTION        GO              IMPLICIT        INCLUDE
INTEGER         INTRINSIC       LOGICAL         PAUSE
PRECISION       PROGRAM         REAL            SAVE
STOP            SUBROUTINE      THEN            TO
\fP
.fi
.PP
The following keywords may be used in scalar contexts only, for example, not
as arrays or as character variables used in substring expressions.
.PP
.nf
\fC
ACCEPT          BACKSPACE       CLOSE           DATA
DOWHILE         ELSEIF          ENDFILE         EQUIVALENCE
FORMAT          GOTO            IF              INQUIRE
OPEN            PARAMETER       PRINT           READ
RETURN          REWIND          TYPE            WRITE
WHILE
                      \fRTable 2\fP
\fP
.fi
.TP
.B Extensions:
Tabs are permitted, and translated into equivalent blanks which correspond to
tab stops every 8 columns.  The standard does not recognize tabs.  Note that
some compilers allow tabs, but treat them differently.
.IP
Lower case characters are permitted, and are converted internally to uppercase
except in strings.  The standard specifies upper case only, except in comments
and strings.
.IP
Hollerith constants are permitted, in accordance with the ANSI Manual,
appendix C.  They should not be used in expressions, or confused with datatype
.IR CHARACTER .
.IP
Statements may be longer than 72 columns provided that the setting
.B \-column
was used to increase the limit.  According to the standard, all text from
columns 73 through 80 is ignored, and no line may be longer than 80 columns.
.IP
Variable names may be longer than six characters.  The standard specifies six
as the maximum.
.IP
Variable names may contain underscores, which are treated the same as
alphabetic letters.  The VAX version of
.B Ftnchek
also allows dollar signs in variable names, but not as the initial character.
.IP
The
.IR DO ...
.I ENDDO
control structure is permitted.  The syntax which is recognized is according
to either of the following two forms:
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fIvar\fP \fC=\fP
\fIexpr\fP \fC,\fP \fIexpr\fP [\fC,\fP \fIexpr\fP]
.br
 ...
.br
\fCEND DO\fP
.in -5
or
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fCWHILE (\fP \fIexpr\fP \fC)\fP
.br
 ...
.br
\fCEND DO\fP
.in -5
where square brackets indicate optional elements.
.IP
The
.I ACCEPT
and
.I TYPE
statements are permitted, with the same syntax as
.IR PRINT .
.IP
Statements may have any number of continuation lines.  The standard allows a
maximum of 19.
.IP
Inline comments, beginning with an exclamation mark, are permitted.
.IP
The
.I "IMPLICIT NONE"
statement is supported.  The meaning of this statement is that all variables
must have their data types explicitly declared.  Rather than flag the
occurrences of such variables with syntax error messages,
.B Ftnchek
waits till the end of the module, and then prints out a list of all undeclared
variables.
.IP
Data types
.IR INTEGER ,
.IR REAL ,
.IR COMPLEX ,
and
.I LOGICAL
are allowed to have an optional length specification in type declarations.
For instance, REAL*8 means an 8-byte floating point data type.  The REAL*8
datatype is interpreted by
.B Ftnchek
as equivalent to
.I DOUBLE
.IR PRECISION .
.B Ftnchek
ignores length specifications on all other types.  The standard allows a
length specification only for
.I CHARACTER
data.
.IP
.B Ftnchek
permits the
.I INCLUDE
statement, which causes inclusion of the text of the given file.  The syntax
is
.in +5
\fCINCLUDE '\fP\fIfilename\fP\fC'\fP
.in -5
.IP
When compiled for VMS,
.B Ftnchek
will assume a default extension of
.I .\|for
if no filename extension is given.  Also for compatibility with VMS, the VMS
version allows the qualifier
\fC/[NO]LIST\fP
following the filename, to control the listing of the included file.  There is
no support for including VMS text modules.
.IP
At this time, diagnostic output relating to items contained in include files
is minimal.  Only information about the location in the include file is given.
There is no traceback giving the parent file(s), although usually this can be
inferred from the context.
.SH "NEW FEATURES"
Here are the changes from Version 2.4 to Version 2.5:
.TP \w'1.'u+2n
1.
The name was changed from Forchek to Ftnchek, to avoid confusion with a
similar program named Forcheck, developed earlier at Leiden University.
.TP
2.
Some bugs were fixed:  Version 2.4 incorrectly processed
.I DO
index variable names beginning with D or E; it did not support the
.I +kP
format descriptor; the VMS version failed to accept the
.IR NOSPANBLOCKS ,
.I READONLY
or
.I SHARED
keywords in
.I OPEN
statements; and a couple of error messages were improved.
.PP
Here are the changes from Version 2.3 to Version 2.4:
.TP \w'1.'u+2n
1.
Fixed bugs:  the
.I SAVE
statement was incorrectly parsed, a
.I CALL
of a user function with the same name as an intrinsic function assumed by
default to refer to the intrinsic function, and adjustable-size arrays passed
as arguments were not correctly checked.  Also, the usage of variables in some
I/O control-list specifiers was handled incorrectly.
.TP
2.
New options
.BR \-declare ,
.BR \-f77 ,
.B \-linebreak
and
.BR \-verbose .
.TP
3.
Allow embedded space in numeric constants.
.TP
4.
Support
.IR "ACCEPT" ,
.I "IMPLICIT NONE"
and
.I "INCLUDE"
statements.
.TP
5.
Analyze
.I EQUIVALENCE
statements.
.TP
6.
Common block checking levels 1 and 2.
.TP
7.
.I Important:
the project-file format has been changed.  Project files created by Version
2.3 are not compatible with Version 2.4 or later, and will need to be remade.
.PP
.SH "BUGS"
.B Ftnchek
still has much room for improvement.  Your feedback is appreciated.  We want
to know about any bugs you notice.  Bugs include not only cases in which
.B Ftnchek
issues an error message where no error exists, but also if
.B Ftnchek
fails to issue a warning when it ought to.  Note, however, that
.B Ftnchek
is not intended to catch all syntax errors.  Also, it is not considered a bug
for a variable to be reported as used before set, if the reason is that the
usage of the variable occurs prior in the text to where the variable is set.
For instance, this could occur when a
.I GOTO
causes execution to loop backward to some previously skipped statements.
.B Ftnchek
does not analyze the program flow, but assumes that statements occurring
earlier in the text are executed before the following ones.
.PP
We especially want to know if
.B Ftnchek
crashes for any reason.  It is not supposed to crash, even on programs with
syntax errors.  Suggestions are welcomed for additional features which you
would find useful.  Tell us if any of
.BR Ftnchek 's
messages are incomprehensible.  Comments on the readability and accuracy of
this document are also welcome.
.PP
You may also suggest support for additional extensions to the Fortran
language.  These will be included only if it is felt that the extensions are
sufficiently widely accepted by compilers.
.PP
If you find a bug in
.BR Ftnchek ,
first consult the list of known bugs below to see if it has already been
reported.  Also check the section entitled "Limitations and Extensions" above
for restrictions that could be causing the problem.  If you do not find the
problem documented in either place, then send a report including
.TP \w'1.'u+2n
1.
The operating system and CPU type on which
.B Ftnchek
is running.
.TP
2.
The version of
.BR Ftnchek .
.TP
3.
A brief description of the bug.
.TP
4.
If possible, a small sample program showing the bug.
.PP
The report should be sent to either of the following addresses:
.PP
.nf
        MONIOT@FORDMULC.BITNET
        moniot@mary.fordham.edu
.fi
.PP
Highest priority will be given to bugs which cause
.B Ftnchek
to crash.  Bugs involving incorrect warnings or error messages may take longer
to fix.
.PP
The following is a list of known bugs.
.TP \w'1.'u+2n
1.
Bug:  Functions which modify their arguments may cause used-before-set
warning.  For example,
.I A
in the statement
.nf
\fC
        X = FUN(A)
\fP
.fi
if
.I A
is not previously set.  If
.I FUN
has the purpose of setting
.IR A ,
this situation will not be a bug.  Generally, however, it is not considered
good style for functions to modify their arguments, and so the warning may be
to good purpose.
.IP
Prognosis:  Probably will not be fixed anytime soon.
.TP
2.
Bug:  Used-before-set message is suppressed for any variable which is used as
the loop index in an implied-do loop, even if it was in fact used before being
set in some earlier statement.  For example, consider
.I J
in the statement
.nf
\fC
        WRITE(5,*) (A(J), J=1,10)
\fP
.fi
Here
.B Ftnchek
parses the I/O expression,
.IR A(J) ,
where
.I J
is used, before it parses the implied loop where
.I J
is set.  Normally this would cause
.B Ftnchek
to report a spurious used-before-set warning for
.IR J .
Since this report is usually in error and occurs fairly commonly,
.B Ftnchek
suppresses the warning for
.I J
altogether.
.IP
Prognosis:  A future version of
.B Ftnchek
is planned which will handle implied-do loops correctly.
.TP
3.
Bug:  Variables used (not as arguments) in statement-function subprograms do
not have their usage status updated when the statement function is invoked.
.IP
Prognosis:  To be fixed in a future version of
.BR Ftnchek .
.SH "CONCLUSION"
.B Ftnchek
was designed by Dr.  Robert Moniot, professor at Fordham University, College
at Lincoln Center.  During the academic year of 1988-1989, Michael Myers and
Lucia Spagnuolo developed the program to perform the variable usage checks.
During the following year it was augmented by Lois Bigbie to check subprogram
arguments and
.I COMMON
block declarations.  Brian Downing assisted with the implementation of the
.I INCLUDE
statement.  Additional features will be added as time permits.
.PP
We would like to thank Markus Draxler of the University of Stuttgart, Greg
Flint of Purdue University, Phil Sterne of Lawrence Livermore National
Laboratory, and Warren J.  Wiscombe of NASA Goddard for reporting some bugs in
Versions 2.1 and 2.2.  We also thank John Amor of the University of British
Columbia, Daniel P.  Giesy of NASA Langley Research Center, Hugh Nicholas of
the Pittsburgh Supercomputing Center, Dan Severance of Yale University, and
Larry Weissman of the University of Washington for suggesting some
improvements.  Nelson H.  F.  Beebe of the University of Utah kindly helped
with the documentation, and pointed out several bugs in Version 2.3.  Reg
Clemens of the Air Force Phillips Lab in Albuquerque and Fritz Keinert of Iowa
State University helped debug Version 2.4.  We also thank Jack Dongarra for
putting
.B Ftnchek
into the Netlib library of publicly available software.
.PP
For further information, you may contact Dr.  Robert Moniot at either of the
following network addresses:
.PP
.nf
        MONIOT@FORDMULC.BITNET
        moniot@mary.fordham.edu
.fi
.PP
This document is named
.IR ftnchek.man .
The
.B Ftnchek
program can be obtained by sending the message
\fCsend ftnchek from fortran\fP
to the Internet address:
\fCnetlib@ornl.gov\fP .
Installation requires a C compiler for your computer.
.\"==============================[The End]==============================
