#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include "sort_def.h"
#include "sort_mem.h"

int DBX_val = 0;

static long next1d = 0, next2d = 0;

/*
 *  getdtablesize() is a BSD function
 *  keep name but use Solaris equivalent if SVR4
 */
#ifdef SVR4
#include <sys/time.h>
#include <sys/resource.h>

static int getdtablesize(void)
{
    struct rlimit rlp;
    if ( getrlimit(RLIMIT_NOFILE, &rlp) == -1)
	return(-1);
    else
	return((int) rlp.rlim_cur);
}
#endif

static pid_t start_process(char *name)
{
    pid_t child;
    int i;

    switch(child = fork1())
    {
    case -1:
	perror("fork");
	return 0;
    case 0:
	for(i=getdtablesize(); i>2; i--)
	    close(i);
	for(i=NSIG+1; i--; )
	    signal(i, SIG_DFL);
	execlp(name, name, "-sort", NULL);
	perror(name);
	return 0;
    default:
	return child;
    }
}

/* Start up 1d display process */
int start1d(void)
{
    struct timeval t;

    gettimeofday(&t, NULL);
    next1d = t.tv_sec + 5;

    return pshm->pid_1d = start_process("sort_xvgr");
}
/* Start up 2d display process */
int start2d(void)
{
    struct timeval t;

    gettimeofday(&t, NULL);
    next2d = t.tv_sec + 5;

    return pshm->pid_2d = start_process("sort_spec2d");
}

static pid_t signal_process(pid_t pid, int sig, char *name)
{
    if (pid)
    {
	if (kill(pid, sig) != -1)
	    return pid;
	if (errno != ESRCH)
	{
	    perror("Error sending signal to display process");
	    return pid;
	}
	fprintf(stderr, "Display process has died, attempting to restart.\n");
    }
    else
	fprintf(stderr, "No display process running, starting it up.\n");
    if ((pid = start_process(name)) == 0)
	return 0;
    sleep(5);
    if (kill(pid, sig) != -1)
	return pid;
    perror("Error sending signal to new process");
    return (errno == ESRCH) ? 0 : pid;
}


static char filename[12] = ".SORT_pipe0";

/* Write out a 1d spectrum */
void write1d(char *com, char *name, int more, int channels, int *data)
{
    struct timeval t;
    static int number = 0;

    strncpy(pshm->com_str, com, NAME_SIZE);
    strncpy(pshm->name, name, NAME_SIZE);
    pshm->more = more;
    pshm->size = channels;
    memcpy(pshm->array, data, channels*sizeof(int));

    filename[10] = number + '0';
    gettimeofday(&t, NULL);
    if (t.tv_sec < next1d)
	sleep(next1d - t.tv_sec);
    write_to_pipe(filename, channels);
    if (more)
	number++;
    else
    {
	number = 0;
	pshm->pid_1d = signal_process(pshm->pid_1d, SIGUSR1, "sort_xvgr");
	gettimeofday(&t, NULL);
	next1d = t.tv_sec + 2;
    }
}

/* Write out a 2d spectrum */
void write2d(char *com, char *name, int more, int channels, int arraysize,
	    int *data)
{
    static int number = 0;
    int i, *ap, *dp;
    struct timeval t;

    strncpy(pshm->com_str, com, NAME_SIZE);
    strncpy(pshm->name, name, NAME_SIZE);
    pshm->more = more;
    pshm->size = channels;

    for(ap = pshm->array, dp = data, i = channels; i--;
	ap += channels, dp += arraysize)
	memcpy(ap, dp, channels*sizeof(int));

    filename[10] = '\0';
    gettimeofday(&t, NULL);
    if (t.tv_sec < next2d)
	sleep(next2d - t.tv_sec);
    write_to_pipe(filename, channels*channels);
    if (more)
	number++;
    else
    {
	number = 0;
	pshm->pid_2d = signal_process(pshm->pid_2d, SIGUSR2, "sort_spec2d");
	gettimeofday(&t, NULL);
	next2d = t.tv_sec + 2;
    }
}

/* FORTRAN interface routines */

void start1d_(void)
{
    (void) start1d();
}

void start2d_(void)
{
    (void) start2d();
}

void write1d_(char *com, char *name, int *more, int *channels, int *data)
{
    write1d(com, name, *more, *channels, data);
}

void write2d_(char *com, char *name, int *more, int *channels,
	     int *arraysize, int *data)
{
    write2d(com, name, *more, *channels, *arraysize, data);
}
