/* 
last modified 10/1/96   Strip comments from sort.f
                        allow input of bare sortfile
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>

#include <sys/types.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include "sort_def.h"
#include "sort_thread.h"

#define TRIGGER 1
#define SPECTRA 2
#define FORT_OR_C 3

#define MAX_DTRIGS        16
#define MAX_DTRIG_ADCS    64
#define NOS_ADC_WORDS     1024

#define AUTOGEN1 "WARNING: This file is automatically generated by " \
    "makesort. Do not edit by"
#define AUTOGEN2 "hand, any changes to this file will be lost."

static int numadcs;
static int trig_dat[MAX_DTRIGS+1][MAX_DTRIG_ADCS+1];

void c_initadc_file P((FILE *));
int direct_trig P((char *));
void common_initadc_file P((FILE *));
void end_c_file P((FILE *));
int end_fort_file P((FILE *));

int
main
#if NeedFunctionPrototype
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif
{
    FILE *sort_fp, *spec_fp, *source_fp, *initadc_fp, *cinitadc_fp;
    char buf[BUFSIZ];
    int  section = 0;
    int c_flag = FALSE;
    int baresort_flag = FALSE;
    int i, j, line = 0;
    
    if (argc <= 1) {
	fprintf(stderr,"make_sort: no sort file provided\n");
	exit(1);
    }
    
    /* open sort file for processing */	
    if ((source_fp=fopen(argv[1],"r")) == NULL) {
	perror("make_sort");
	fprintf(stderr,"make_sort: error opening file sort file %s\n",argv[1]);
	exit(2);
    }
    
    /* check for any other command line arguments */
    for (i=2; argv[i] != NULL; i++) {
	if (strncmp("-C",argv[i],2) == 0)
	    c_flag = TRUE;
	if (strncmp("-S",argv[i],2) == 0)
	    baresort_flag = TRUE;
    }
    
    /* Confirm sort file type */
    if (c_flag)
	fprintf(stderr,"make_sort: C SortFile\n");
    if (baresort_flag)
	fprintf(stderr,"make_sort: Bare SortFile\n");
    
    /* create sort file and open for writing */
    if ( (sort_fp = fopen(".sunsort_sort.src","w")) == NULL) {
	perror("make_sort");
	fprintf(stderr,"make_sort: error opening output file"
		" sunsort_sort.src\n");
	exit(3);
    }
      
    /* create spectra file and open for writing */
    if (!baresort_flag) {
	if ( (spec_fp=fopen(".sunsort_spectra","w")) == NULL) {
	    perror("make_sort");
	    fprintf(stderr,"make_sort: error opening file spectra\n");
	    exit(3);
	}
    }
    
    /* create include initadc file and open for writing */
    if ( (initadc_fp = fopen(".sunsort_initadc.i","w")) == NULL) {
	perror("make_sort");
	fprintf(stderr, "make_sort: error opening output file "
		".sunsort_initadc.i\n");
	exit(3);
    }
    
    if ( (cinitadc_fp = fopen(".sunsort_initadc.h","w")) == NULL) {
	perror("make_sort");
	fprintf(stderr, "make_sort: error opening output file "
		".sunsort_initadc.h\n");
	exit(3);
    }

    if (c_flag)
	fprintf(sort_fp, "/*\n * " AUTOGEN1 "\n * " AUTOGEN2 "\n */\n\n");
    else
	fprintf(sort_fp, "* " AUTOGEN1 "\n* " AUTOGEN2 "\n\n");
    
    /* loop over input file and generate data files required for sunsort */
    while(fgets(buf,BUFSIZ,source_fp)) {
	line++;
	/* handle input line according to which section we are currently in */
	if (section != FORT_OR_C) {
	    switch (section) {
	    case TRIGGER:       /* in *trigger section */
		if (strncasecmp(buf,"*oned",5) == 0 ) {
		    if (!baresort_flag)
			fprintf(spec_fp,"%s",buf);
		    section = SPECTRA;
		    break;
		}
		if ((baresort_flag) &&
		    (strncasecmp(buf,"*sort",5) == 0)) {
		    section = FORT_OR_C;
		    fprintf(sort_fp, "# %d \"%s\"\n", line+1, argv[1]);
		    break;
		}
		if (direct_trig(buf)) {
		    fprintf(stderr,"make_sort: error in direct trigger "
			    "specification\n"
			    "[Are you using a Bare sortfile?]\n"
			    "[Is the *oned definition correct?]\n"
			    "make_sort: ... Stopping\n");
		    exit(5);
		}
		break;
	    case SPECTRA:      /* in *oned or *twod  or *variables section */
		if (strncasecmp(buf,"*sort",5) == 0) {
		    section = FORT_OR_C;
		    fprintf(sort_fp, "# %d \"%s\"\n", line+1, argv[1]);
		    break;
		}
		if (!baresort_flag)
		    fprintf(spec_fp,"%s",buf);
		break;
	    default: /* in file header section contains user comments etc */
		if (strncasecmp(buf,"*trigger",8) == 0) {
		    /* next line should contain the number of adcs expected */
		    if (fgets(buf,BUFSIZ,source_fp) == NULL ||
			sscanf(buf,"%d",&numadcs) != 1) {
			fprintf(stderr,"make_sort: number of adcs not "
				"specified immediately after *trigger "
				"statement ... stopping\n");
			exit(4);
		    }
		    line++;
		    section = TRIGGER;
		}
		break;
	    }
	}
	else {
	    fprintf(sort_fp,"%s",buf);
	}
    }

/* check that each of the required sections were read in */
    if ( section != FORT_OR_C) {
	if (section == TRIGGER)
	    fprintf(stderr,"make_sort: no *trigger statement was found\n");
	else if (section == SPECTRA && !baresort_flag)
	    fprintf(stderr,"make_sort: no *oned statement was found\n");
	exit(6);
    }

    /* Put common initadc declarations in a file */
    common_initadc_file(initadc_fp);
    c_initadc_file(cinitadc_fp);

    /* write initadc subroutine */
    if (c_flag)
	end_c_file(sort_fp);
    else
	end_fort_file(sort_fp);
      
    /* close i/o stream  */
    (void) fclose(source_fp);
    (void) fclose(sort_fp);
    if (!baresort_flag)
	(void) fclose(spec_fp);
    (void) fclose(initadc_fp);
    (void) fclose(cinitadc_fp);
      
    exit(0);
}


/*
 * common blocks used in a number of subroutines put in an include file [SPGC]
 */
void
common_initadc_file(
#if NeedFunctionPrototype
			FILE *initadc_fp)
#else
      initadc_fp)
FILE * initadc_fp;
#endif
{
    fprintf(initadc_fp,"\n"
	    "* " AUTOGEN1 "\n"
	    "* " AUTOGEN2 "\n\n"
	    "*--Common Declarations for subroutine initadc etcetera----------"
	    "--------\n"
	    "       common/adcnum/numadc,dtrig\n"
	    "       common/adcs/event,record,wrtevt,bitpat,trign,adc\n"
	    "       common/filenm/filein,fileou,runnumber\n"
	    "       common/vars/var\n"
	    "       common/adclist/adclist\n\n");
    fprintf(initadc_fp,"       real var(%d)\n", (int)TAB_SIZE_VAR);
    fprintf(initadc_fp,"       integer dtrig(0:%d,0:%d)\n",
	    MAX_NOS_TRIGS+1, MAX_NOS_TRIGS+1);
    fprintf(initadc_fp,"       integer event,record,numadc,runnumber\n");
    fprintf(initadc_fp,"       character filein*%d,fileou*%d\n",
	    filenm_SIZE, filenm_SIZE);

/* sanity check on number of adcs */
    if (numadcs > NOS_ADC_WORDS) {
	fprintf(stderr,"make_sort: Max number of allowed adcs = %d\n",
		NOS_ADC_WORDS);
	numadcs = NOS_ADC_WORDS;
    }      

    fprintf(initadc_fp,
	    "       integer*2 bitpat(8),trign,adc(%d),adclist(%d)\n",
	    (numadcs < 768) ? 768:numadcs, (numadcs < 768) ? 769 : numadcs+1);
    fprintf(initadc_fp,"       logical wrtevt\n\n");

    fprintf(initadc_fp,"       integer val1d, val2d, sval1d, sval2d\n");
    fprintf(initadc_fp,"       integer fval1d, fval2d, dval1d, dval2d\n");
    fprintf(initadc_fp,"       external val1d, val2d, sval1d, sval2d\n");
    fprintf(initadc_fp,"       external fval1d, fval2d, dval1d, dval2d\n\n");
    
    fprintf(initadc_fp,"\n*-------------------------------------------------"
	    "----------------------\n");
}

/*
 * append initadc subroutine to end of FORTRAN source file
 */

int
end_fort_file(
#if NeedFunctionPrototype
	      FILE *sort_fp)
#else
      sort_fp)
FILE * sort_fp;
#endif
{
    int i,j;

    /*
     * write out subroutine initadc ...
     * this ensures that storage for various common blocks exists
     */
    fprintf(sort_fp,"\n*~~Set up ADC common block etc~~~~~~~~~~~~~~~~~~~~~~~~"
	    "~~~~~~~~~~~~~~~~~~\n"
	    "       subroutine initadc\n       save\n\n"
	    "       include '.sunsort_initadc.i'\n");

    /* trigger related data */

    fprintf(sort_fp,"       numadc = %d\n",numadcs);

    for (i=1; i <= MAX_DTRIGS; i++) {
	if (trig_dat[i][0] > 0) {
	    for (j=0; trig_dat[i][j] > 0; j++) {
		fprintf(sort_fp,"       dtrig( %d, %d ) = %d\n", i, j,
			trig_dat[i][j]);
	    }
	}
    }

    fprintf(sort_fp,"       return\n       end\n"
	    "\n*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~end "
	    "initadc~~~~~\n");
    
    return(0);
}

void
c_initadc_file
#if NeedFunctionPrototype
(FILE *cinitadc_fp)
#else
(cinitadc_fp)
FILE *cinitadc_fp;
#endif
{
    fprintf(cinitadc_fp,"/*\n * " AUTOGEN1 "\n"
	    " * " AUTOGEN2 "\n"
	    " */\n\n"
	    "#include \"sort_def.h\"\n"
	    "#include \"rdtape.h\"\n"
            "#include \"spectra.h\"\n\n"
	    "#define ADC(i) adcs_.adcs[(i)-1]\n"
	    "#define VAR(i) vars_.var[(i)-1]\n\n");
}

/*
 *   append initadc subroutine to end of C source file
 */
void
end_c_file(
#if NeedFunctionPrototype
	   FILE *sort_fp)
#else
      sort_fp)
FILE * sort_fp;
#endif
{
    int i,j;

    /*
     * write out subroutine initadc ... 
     */
    fprintf(sort_fp,"\n"
	    "/***************************************************************"
	    "*****/\n"

	    "void initadc_()\n{\n");
      
	    /* trigger related data */
    if (numadcs > NOS_ADC_WORDS) {
	fprintf(stderr,"make_sort: Max number of allowed adcs = %d\n",
		NOS_ADC_WORDS);
	numadcs = NOS_ADC_WORDS;
    }
    fprintf(sort_fp, "adcnum_.nos_adcs = %d;\n", numadcs);

    for (i=1; i <= MAX_DTRIGS; i++) {
	if (trig_dat[i][0] > 0) {
	    for (j=0; trig_dat[i][j] > 0; j++) {
		fprintf(sort_fp,"adcnum_.dtrig[ %d ][ %d ] = %d;\n", j, i,
			trig_dat[i][j]);
	    } /* NB trig nos other way around FORTRAN convention */
	}
    }
    fprintf(sort_fp,"}\n\n"
	    "\n/*************************************************************"
	    "*******/\n");
}


void
adjust_white_space(string)
char  *string;
{
    register int i;
    int len = strlen(string);
    for(i=len; i>=0; i--) {
	if ( isspace((int) string[i]))
	    string[i] = ' ';
    }
    return;
}

int
direct_trig(
#if NeedFunctionPrototype
            char *string)
#else
      string)
char *string;
#endif
{
    char buf[BUFSIZ];
    char *token;
    int  trignos, nadcs;

    /* copy string into temp work buffer */
    strncpy(buf,string,BUFSIZ);

    /* remove any extra unwanted spaces */      
    adjust_white_space(buf);

    /* get trigger number from string */      
    token = strtok(buf, " ");
    if (token == NULL)
	return(0); /* blank line ? */
    trignos = atoi(token);
    if (trignos <= 0 || trignos > MAX_DTRIGS) {
	fprintf(stderr,"make_sort: direct trigger number %d out of allowable "
		"range !\n", trignos);
	return(-1);
    }

    /* decode adcs associated with this direct trigger */
    for (nadcs=0; nadcs < MAX_DTRIG_ADCS; nadcs++) {
	token = strtok(NULL, " ");
	if (token == NULL) break;
	trig_dat[trignos][nadcs+1] = atoi(token);
    }
    trig_dat[trignos][0] = nadcs;
    if (nadcs == 0)
	fprintf(stderr,"make_sort: ** WARNING ** direct trigger %d declared "
		"with 0 adcs\n", trignos);
    return(0);
}
