#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>

#include <sys/param.h>
#include <sys/types.h>

#include <errno.h>

#include <kvm.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/user.h>
#include <sys/proc.h>

#define SVR4
#define NeedFunctionPrototype 1

#ifdef SVR4
extern pid_t lookup_proc();
#else
extern int   lookup_proc();
#endif

int
main(
#if NeedFunctionPrototype
     int     argc,
     char    **argv)
#else
     argc,   **argv)
      int     argc;
      char    **argv;
#endif
{
      char *proc_name;
#ifdef SVR4      
      pid_t pid;
#else
      int   pid;
#endif
      
      proc_name = argv[1];
      pid = lookup_proc(proc_name);
      fprintf(stderr,"process id returned for %s = %d\n",proc_name,(int) pid);
      exit(0);
}

      
#ifdef SVR4
pid_t lookup_proc(
#if NeedFunctionPrototype
		  char *proc_name)
#else
      proc_name)
      char *proc_name;
#endif               /* if NeedFunctionPrototype */
{
      pid_t        pgroup;
      
#else               /* ifdef SVR4 */
      
int   lookup_proc(
#if NeedFunctionPrototype
      char *proc_name)
#else
      proc_name)
      char *proc_name;
#endif              /* if NeedFunctionPrototype */
{
      int          pgroup;

#endif              /* ifdef SVR4 */

      kvm_t        *kernal;    
      struct proc  *proc_ent;
      struct user  *user_ent;
      struct pid   pid_data;
      char         **argv;

/* get process group id */      
      if ( (pgroup = getpgrp()) == -1) {
	    perror("slicing");
	    return(-1);
      }

/* open connection to kernal */
      kernal = kvm_open(NULL, NULL, NULL, O_RDONLY, "slicing");
      if (kernal == NULL) {
	    perror("slicing kvm_open");
	    return(-1);
      }

/* loop over list of processes trying to find process with name proc_name */      
      while ( (proc_ent = kvm_nextproc(kernal)) != NULL) {
	    user_ent = kvm_getu(kernal, proc_ent);
	    
	    if ( kvm_getcmd(kernal, proc_ent, user_ent, &argv, NULL) == -1)
		  break;
	    
	    if (strncmp(argv[0], proc_name, strlen(proc_name)) == 0) {
		  if (kvm_read(kernal, (unsigned long) proc_ent->p_pidp,
			       (char *) &pid_data, sizeof(struct pid)) == -1)
			break;
		  (void) kvm_close(kernal);
		  return(pid_data.pid_id);
	    }
      }
      (void) kvm_close(kernal);
      return(-1);
}  
