#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>

#include <sys/param.h>
#include <sys/types.h>

#include <errno.h>

#include <kvm.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/user.h>
#include <sys/proc.h>

#define SVR4
#define NeedFunctionPrototype 1

#ifdef SVR4
extern pid_t lookup_proc();
#else
extern int   lookup_proc();
#endif

int
main(
#if NeedFunctionPrototype
     int     argc,
     char    **argv)
#else
     argc,   **argv)
      int     argc;
      char    **argv;
#endif
{
      char *proc_name;
#ifdef SVR4      
      pid_t pid;
#else
      int   pid;
#endif
      
      proc_name = argv[1];
      pid = lookup_proc(proc_name);
      fprintf(stderr,"process id returned for %s = %d\n",proc_name,(int) pid);
      exit(0);
}

      
/*
 *  try and find process with name = proc_name and belonging
 *  to process group of this process
 */

#ifdef SVR4

#include <dirent.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/fault.h> 
#include <sys/syscall.h>
#include <sys/procfs.h>
#include <sys/stat.h>
#include <fcntl.h>

pid_t lookup_proc(
#if NeedFunctionPrototype
		  char *proc_name)
#else
      proc_name)
      char *proc_name;
#endif               /* if NeedFunctionPrototype */
{
      pid_t          psid;
      DIR	     *dirp;
      struct dirent  *dp;
      int            fd;
      prpsinfo_t     proc_info;
      char           buf[BUFSIZ];
      
/* get process group id */      
      if ( (psid = getsid((pid_t)0)) == -1) {
	    perror("slicing");
	    return(-1);
      }

      fprintf(stderr,"process session id = %d\n",(int) psid);
      
/* open /proc directory for reading and loop through all enteries */
      if ((dirp = opendir("/proc")) == NULL) {
	    perror("slicing");
	    return(-1);
      }

/* cycle through systems processes */      
      for (dp=readdir(dirp); dp != NULL; dp=readdir(dirp)) {
	    sprintf(buf,"/proc/%s",dp->d_name);
	    if (dp->d_name[0] == '.') continue;
	    if (access(buf, R_OK) == 0) {
		  if ( (fd = open(buf,  O_RDONLY)) == -1) {
			perror("slicing");
			break;
		  }
		  if ( ioctl(fd, PIOCPSINFO, (void *) &proc_info) == -1) {
			perror("slicing");
			(void) close(fd);
			break;
		  }
		  if (proc_info.pr_sid == psid) {
			int len = strlen(proc_name);
			len = (len > PRFNSZ) ? PRFNSZ : len;
			if (strncmp(proc_name, proc_info.pr_fname, len) == 0) {
			      (void) close(fd);
			      return(proc_info.pr_pid);
			}
		  }
		  (void) close(fd);
	    }
	    else {
		  if (errno != EACCES)
			perror("slicing");
	    }
      }
      closedir(dirp);
      return(-1);
}

#else               /* ifdef SVR4 */
      
int   lookup_proc(
#if NeedFunctionPrototype
      char *proc_name)
#else
      proc_name)
      char *proc_name;
#endif              /* if NeedFunctionPrototype */
{
      return(-1);
}

#endif              /* ifdef SVR4 */

