/*cal.h     declarations used in calibration and sort routines*/

#include <loadadcs.h>
#include <markhits.h>
#include <detector.h>

/*Calibration parameters*/
#define MAXCHAN 768
#define PULVETO   22                  /*minimum pulser signal multiplicity*/
#define PULVETOS  30, 30, 30, 30, 30, 30, 30, 30, 22, 30  /*crate by crate*/
#define MULTMAX   500
#define PSCALE   256.0
#ifndef MIN_ENERGY
#define MIN_ENERGY 0.0
#endif
#ifndef MAX_ENERGY
#define MAX_ENERGY 9999999999.0
#endif
#define MIN_T 0
#define MAX_T 8000

/*Event classification*/
#define EV_ABORTSORT -2
#define EV_SKIPEVENT -1
#define EV_OK 0
#define EV_PULSER 1
#define EV_MULTMAX 2

/*spectrum scaling*/
#ifndef ASCALE
#define ASCALE 32
#endif
#ifndef TSCALE
#define TSCALE 8
#endif
#ifndef ESCALE
#define ESCALE 32
#endif
#ifndef THSCALE
#define THSCALE 4
#endif
#ifndef Q2SCALE
#define Q2SCALE 32
#endif

/*Special spectrum numbers*/
#define SP_MONITOR 385
#define SP_CHANNSAT 386
#define SP_ZEROAT   387
#define SP2_AHIT    1
#define SP2_THIT    2
#define SP2_CMULT   3
#define SP2_PMULT   4
#define SP2_CHANNSA 5
#define SP2_CHANNST 6
#define SP2_PULSERA 7
#define SP2_PULSERT 8
#define SP2_THPHI   11
#define SP2_TDIFF   12
#define SP2_TABS    13
#define SP2_CAL     100  /*ALL detector calibrations into one spectrum*/
#define SP2_EVX     51

/*detector_event procedure calls*/
#define CHECK_PROC 1
#define HIT_PROC 2
#define PULSER_PROC 3

/* 
 * Channel plotting macros
 */
#ifdef WRTSP_CAL  /*plot calibrated spectra*/
#define CHANAMP  siga->value
#define CHANTIM  sigt->value
#else             /*default: plot uncalibrated spectra*/
#define CHANAMP  ADC(siga->adcnum)
#define CHANTIM  ADC(sigt->adcnum)
#endif

#define CHANSPECS2(siga, sigt) \
    inc2d(SP2_CHANNSA, (int) ((CHANAMP)/ASCALE + 0.5), siga->adcnum); \
    inc2d(SP2_CHANNST, (int) ((CHANTIM)/TSCALE +0.5), siga->adcnum)

#ifdef WRTSP_A
#define CHANSPECS(siga, sigt) CHANSPECS2(siga, sigt); \
    dinc1d(siga->adcnum, CHANAMP)
#elif WRTSP_T
#define CHANSPECS(siga, sigt) CHANSPECS2(siga, sigt); \
    dinc1d(siga->adcnum, CHANTIM)
#elif WRTSP_AT
#define CHANSPECS(siga, sigt) CHANSPECS2(siga, sigt); \
    dinc1d(siga->adcnum, CHANAMP/2); \
    dinc1d(siga->adcnum, CHANTIM/2 + 4096)
#else
#define CHANSPECS(siga, sigt) CHANSPECS2(siga, sigt)
#endif



void write_xstats(void); /*write extra stats*/

extern struct xstats {   /*extra stats structure*/
    int chanok; 
    int bada;
    int badt;
    int detelok;
    int detpartial;
    int goodjunk;
    int badjunk;
} xstats;
extern int ndet, ndetjunk;

extern struct detectors *expt;
extern int ndets, ndetsjunk;

int calset(void);  /*Calibration initialisation*/
int cal(void);     /*Ebye calibration routines*/
void plothits(void); /*Routine to plot channel hits*/

struct stripdata {
    float gcal[2];
    float toff[2];
    float xlim[2];
};

int strip_event(int, struct detectors *);
int monitor_event(int, struct detectors *);
int junksig_event(int, struct detectors *);
