/*
 * Main code for calculating detector array coverage         Steve Chappell
 *
 * usage: coord_main coordfile ndet
 */

#include <stdio.h>
#include <stdlib.h>
#include "../subs.h"

int main(int argc, char **argv)
{
    FILE *fp;
    char *infile;
    int i,j,ndet;
    struct xy xydat, *cp = &xydat;
    struct hit_coord hit_coord, *hp = &hit_coord;
    float xdat[] = {-0.5, 0.5, 0.5,-0.5,0.0,-0.0362}; /*-1.81/50.0=xoffset*/
    float ydat[] = {-0.5,-0.5, 0.5, 0.5,0.0,0.0};
    float th,phi;
            
    if (argc != 3){
	printf("usage: coord_main coordfile ndet\n");
	return 1;
    }
    infile = *++argv;
    ndet = atoi(*++argv);
    
    if(coord_init(ndet) != 0){  /*initialise detector coordinates*/
	fprintf(stderr, "Error initialising Co-ordinates\n");
	return 1;
    }
    
    if((fp = fopen(infile, "r")) == NULL)
    {
	perror(infile);
	return 1;
    }

    /*read abcd coordinates for each detector*/
    
    for(i=1;i<ndet+1;i++){
	if(coord_det(i,fp) != 0)
	    return 1;
    }
    fclose(fp);
    /*End of Inputs*/

    
    if((fp = fopen("coord_cov.out","w"))!= NULL){
	fprintf(stderr, "Writing complete th,phi coverage to file \"%s\".\n",
		"coord_cov.out");
    }
    
    fprintf(stderr, "\n xdat ydat :  x y z r th phi\n\n");
    
    for(i=1; i<ndet+1; i++){
	fprintf(stderr,"\ndet: %i\n",i);
	for(j=0; j<6; j++){
	    cp->x=xdat[j];
	    cp->y=ydat[j]; 
	    coord(i,cp,hp);
	    fprintf(stderr, " %8.3f %8.3f : %8.3f %8.3f %8.3f ",
		    cp->x,cp->y,hp->x,hp->y,hp->z);
	    fprintf(stderr, " %8.3f %8.3f %8.3f\n", 
		    hp->r, hp->th,hp->phi);
	}
#ifndef NDET /*coverage detector by detector*/    
	fprintf(fp,"\n");
	for(th=1/(2.0*HITBINSIZE); th<180; th += 1.0/HITBINSIZE)
	{
	    for(phi=1/(2.0*HITBINSIZE); phi<360; phi += 1.0/HITBINSIZE)
	    {
		if(det_hit(i,th,phi))
		    fprintf(fp, "%f %f\n", th,phi);
	    }
	}
#endif	
    }

#ifdef NDET /*alternative*/
    fprintf(stderr," ....still calculating\n");
	for(th=1/(2.0*HITBINSIZE); th<180; th += 1.0/HITBINSIZE)
	{
	    for(phi=1/(2.0*HITBINSIZE); phi<360; phi += 1.0/HITBINSIZE)
	    {
		if(ndet_hit(ndet,th,phi))
		    fprintf(fp, "%f %f\n", th,phi);
	    }
	}
#endif
    fprintf(stderr,"finished\n");
    fclose(fp);
    return 0;
}
