/* 
 * Strip detector Energy calibration                     SPGC
 *
 * usage "egain evxraw evthcalc"
 */

#include <stdio.h>

#define DISP 4    /* 4 "calibration channels" per MeV */
#define XDISP 256 /* X channels in range 0 to 256*/


int main(int argc, char **argv)
{
    double xlim[2],elim[2],gsig[2],ecal[2],a[2],b[2];
    char *evxfile;               /*Raw positions v energies*/
    char *ecalcfile;             /*angle/energy from 2body calculation*/
    char *gfile="egain.out";     /*file to write gain values into*/

    FILE *evxf,*ec,*gf;

    if (argc != 3){
	printf("usage: egain evxraw evthcalc\n");
	return 1;
    }
    
    evxfile=*++argv;
    ecalcfile=*++argv;


    if((evxf = fopen(evxfile, "r")) == NULL)
    {
	perror(evxfile);
	return 1;
    }
    if((ec = fopen(ecalcfile, "r")) == NULL)
    {
	perror(ecalcfile);
	return 1;
    }
    if((gf = fopen(gfile, "w")) == NULL)
    {
	perror(gfile);
	return 1;
    }

    while(fscanf(evxf, "%lf %lf %lf %lf", xlim,elim,xlim+1,elim+1) == 4){
	if(fscanf(ec, "%*f %lf %*f %lf", ecal, ecal+1) != 2){
	    fprintf(stderr,"Error in ecal!\n");
	    return 1;
	}
	
#ifdef SWAP
	if ((ecal[0] < ecal[1]) != (elim[0] < elim[1]))
	{
	    double tmp;	    
	    fprintf(stderr, "Swapping ecals: %d %d %d %d\n", elim[0],
		    elim[1], ecal[0], ecal[1]);
	    tmp = ecal[0];
	    ecal[0] = ecal[1];
	    ecal[1] = tmp;
	}
#endif
	
	b[0] = xlim[0]/XDISP*elim[0];
	a[0] = (XDISP-xlim[0])/XDISP*elim[0];
	b[1] = xlim[1]/XDISP*elim[1];
	a[1] = (XDISP-xlim[1])/XDISP*elim[1];
	gsig[0] = (ecal[0] - ecal[1]*b[0]/b[1])/(a[0] - a[1]*b[0]/b[1]);
	gsig[1] = (ecal[1] - gsig[0]*a[1])/b[1];
#ifdef DEBUG
	fprintf(stderr," %f %f %f %f  %f %f\n", xlim[0],xlim[1],
		elim[0],elim[1],ecal[0],ecal[1]);
	fprintf(stderr, "0: %f %f %f %f %f %f\n", xlim[0], elim[0],
		a[0], b[0], (b[0] - a[0])/(b[0] + a[0])*XDISP/2.+XDISP/2.,
		a[0] + b[0]);
	fprintf(stderr, "1: %f %f %f %f %f %f\n", xlim[1], elim[1],
		a[1], b[1], (b[1] - a[1])/(b[1] + a[1])*XDISP/2.+XDISP/2.,
		a[1] + b[1]);
	fprintf(stderr, "%f %f %f %f %f %f\n", gsig[0], gsig[1],
		gsig[0]*a[0] + gsig[1]*b[0], ecal[0], 
		gsig[0]*a[1] + gsig[1]*b[1], ecal[1]); 
#endif	
	fprintf(gf, " %f %f\n", gsig[0]*DISP ,gsig[1]*DISP); 
    }
    
    fclose(evxf);
    fclose(ec);
    fclose(gf);
    fprintf(stderr,"Output in egain.out\n");
    fprintf(stderr,"%d \"E calibration channels\" per MeV\n", DISP);
    fprintf(stderr,"\"X calibration channels\" in range 0 to %d\n",XDISP);

    return 0;
}
