/* 
 * Compare two matchstick calibration files                      SPGC
 *
 * usage "go_diff file1 file2"
 */

#include <stdio.h>

int main(int argc, char **argv)
{

    float g[2],o[2],gdiff,odiff;
    int i,j;
    char *gofile1;
    char *gofile2;

    FILE *gf1,*gf2;

    if (argc != 3){
	printf("usage: go_diff file1 file2\n");
	return 1;
    }
    
    gofile1=*++argv;
    gofile2=*++argv;

    if((gf1 = fopen(gofile1, "r")) == NULL)
    {
	perror(gofile1);
	return 1;
    }
    if((gf2 = fopen(gofile2, "r")) == NULL)
    {
	perror(gofile2);
	return 1;
    }

    while(fscanf(gf1, "%d %f %f", &i,g,o) == 3){
	if(fscanf(gf2, "%d %f %f", &j,g+1,o+1) != 3 || i != j){
	    fprintf(stderr,"Error or end!\n");
	    return 1;
	}
	if((gdiff=g[0]-g[1]) < 0) gdiff = -1.0*gdiff;
	if((odiff=o[0]-o[1]) < 0) odiff = -1.0*odiff;
	if(gdiff > 0.001 || odiff > 1.0) fprintf(stderr,"*");
	fprintf(stderr, "%d %f %f\n", i, gdiff,odiff);	
    }

    fclose(gf1);
    fclose(gf2);

}
