/* coord.h     coordinate header file*/

#define HITBINSIZE 2	/* number of bins per degree */
int hitbins[180*HITBINSIZE*360*HITBINSIZE]; /*bins in th,phi*/

struct xy {     /*2 components of a trajectory*/
    float x;
    float y;
}; 

struct xyz {     /*3 components of a trajectory*/
    float x;
    float y;
    float z;
}; 

struct det_coord { 
    struct xyz ra; /*detector corner coordinates*/
    struct xyz rb;
    struct xyz rc;
    struct xyz rd;
    struct xyz r0; /*detector centre coordinates*/
    struct xyz Xp; /*X position vector*/
    struct xyz Yp; /*Y position vector*/
    struct xyz n;  /*normal vector*/
    float Xp0;    /*X position of detector centre*/
    float Yp0;    /*Y position of detector centre*/
    float Xp2;    /*modulus squared of X vector*/
    float Yp2;    /*modulus squared of Y vector*/
                  
};

struct hit_coord { /* hit coordinates */
    float x;
    float y;
    float z;
    float r;
    float th;
    float phi;
};

struct traj {    /* Trajectories for correlations*/
    float ths;          /* Nb.Particles hi,li in lab, vrp in c.m. frame */
    float phis;        
    float psi;
    float chi;
    struct xyz vrel;    /*relative velocities between hi and li*/
    struct xyz p_li;    /*li momenta*/
    struct xyz p_hi;    /*hi momenta*/
    struct xyz p_vrp;   /*vrp momenta*/
};

struct coords {   /*co-ordinate schemes for correlations*/
    struct traj polar;
    struct traj axial;
    struct traj basel;
};

extern struct coords pspace, *psp;
extern struct det_coord *dp;

int coord_input(int, char *);
int coord(int, struct xy *, struct hit_coord *);
int coord_init(int);
int coord_det(int, FILE *);
int coord_andet(int, FILE *);
int det_hit(int, float, float);
int ndet_hit(int, float, float);
int *gethitbin(float, float);
