/*
 * ''crhit''      Recalculate and copy hit                      Steve Chappell
 *
 *   General Subroutines to recalculate event parameters of a hit
 *   given that the mass originally associated with the 
 *   particle has been changed

 * Updates
 *   6th Mar 98: Recalculates resonant particles too
 *   10th Jun 98: chit to copy hit to new position in ev array
 *              : crhit to copy hit then recalculate mass for new position
 *   
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "subs.h"

void rhit(float newmass, int vrp)
{
    float oldmass, factor, mrec;
    
    oldmass = ev[vrp].m;
    ev[vrp].m = newmass;
    
    factor = sqrt(newmass/oldmass);
    ev[vrp].px = ev[vrp].px*factor; 
    ev[vrp].py = ev[vrp].py*factor;
    ev[vrp].pz = ev[vrp].pz*factor;
    ev[vrp].p = ev[vrp].p*factor;
    mrec=reac.mass[1]+reac.mass[2]-ev[vrp].m;
    if(mrec > 0)
	ev[vrp].q2=((ev[vrp].m+mrec)*ev[vrp].e - 
		    (mrec-reac.mass[1])*reac.e1   - 
		    2.0*(sqrt(reac.mass[1]*ev[vrp].m*reac.e1*ev[vrp].e)) *
		    cos(ev[vrp].th*RAD)
		    )/mrec;
    else
	ev[vrp].q2=0.0;
}

int chit(int vrp_old, int vrp_new)
{
    if(vrp_new > NP_MAX){
	fprintf(stderr,"chit: Error ev[%d] > MAX(%d)!\n",vrp_new,NP_MAX);
	return 1;
    }
    memcpy(ev+vrp_new, ev+vrp_old, sizeof(struct ev_struct));
    return 0;
}

int crhit(float newmass, int old, int new)
{
    if(chit(old,new))
	return 1;
    rhit(newmass, new);
    return 0;
}
