/*
 *  Detector Routines                                   Steve Chappell
 *
 *  Generic procedures to set up detector structure
 */

#include <stdio.h>
#include "structure.h"
#include "detector.h"

int detector_init(struct detectors *dp)
{
    int i;

    while (dp != NULL)
    {
	if (dp->info->preinit != NULL)
	{
	    if (DET_SOFT(i = dp->info->preinit(dp)))
		continue;
	    else if (DET_HARD(i))
		return i;
	}
	if (dp->children != NULL &&
	    DET_HARD(i = detector_init(dp->children)))
	    return i;
	if (dp->info->init != NULL)
	    if (DET_HARD(i = dp->info->init(dp)))
		return i;
	dp = dp->next;
    }

    return DET_OK;
}

/*
 * Detector event handler
 *        loops through all detector signals
 */
int detector_event(int proc, struct detectors *dp)
{
    int i;

    while (dp != NULL)
    {
	if (dp->info->preevent != NULL)
	{
	    if (DET_SOFT(i = dp->info->preevent(proc, dp)))
		continue;
	    else if (DET_HARD(i))
		return i;
	}
	if (dp->hitlist.head != NULL &&
	    DET_HARD(i = detector_event(proc, dp->hitlist.head)))
	    return i;
	if (dp->info->event != NULL)
	    if (DET_HARD(i = dp->info->event(proc, dp)))
		return i;
	dp = dp->hitlist.next;
    }

    return DET_OK;
}
