/* 
 * Event Structure routines
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ev.h" 

struct evhead evhead;
struct ev_struct *ev = NULL;

/*
 * create space for ev[1 to n particles] structure array
 */
int ev_init(int n)
{
    if (ev != NULL)
	free(ev);
    
    if ((ev = (struct ev_struct *) 
	 calloc(n+1, sizeof(struct ev_struct))) == NULL)
    {
	fprintf(stderr,
		"Unable to allocate memory for event structure.\n");
	return(1);
    }
    
    return(0);
}

void ev_zeroheader(void)
{
    memset(&evhead, 0, sizeof(evhead));
    evhead.p[1] = 1; /*singles always start at position 1*/
}

/*fortran compatability functions*/

int ev_init_(int *n)
{
    return(ev_init(*n));
}

void ev_zeroheader_(void)
{
    ev_zeroheader();
}

int evhead_cmult(int i) { return(evhead.cmult[i]); }
void evheads_cmult(int i, int v) { evhead.cmult[i] = v; }
int evhead_cmult_(int *i) { return(evhead.cmult[(*i)]); }
void evheads_cmult_(int *i, int *v) { evhead.cmult[(*i)] = *v; }

int evhead_pmult(int i) { return(evhead.pmult[i]); }
void evheads_pmult(int i, int v) { evhead.pmult[i] = v; }
int evhead_pmult_(int *i) { return(evhead.pmult[(*i)]); }
void evheads_pmult_(int *i, int *v) { evhead.pmult[(*i)] = *v; }

int evhead_n(int i) { return(evhead.n[i]); }
void evheads_n(int i, int v) { evhead.n[i] = v; }
int evhead_n_(int *i) { return(evhead.n[(*i)]); }
void evheads_n_(int *i, int *v) { evhead.n[(*i)] = *v; }

int evhead_p(int i) { return(evhead.p[i]); }
void evheads_p(int i, int v) { evhead.p[i] = v; }
int evhead_p_(int *i) { return(evhead.p[(*i)]); }
void evheads_p_(int *i, int *v) { evhead.p[(*i)] = *v; }

int evhead_type(void) { return(evhead.type); }
void evheads_type(int v) { evhead.type = v; }
int evhead_type_(void) { return(evhead.type); }
void evheads_type_(int *v) { evhead.type = *v; }

float evhead_etot(void) { return(evhead.etot); }
void evheads_etot(float v) { evhead.etot = v; }
float evhead_etot_(void) { return(evhead.etot); }
void evheads_etot_(float *v) { evhead.etot = *v; }

int ev_fold(int i) { return(ev[i].fold); }
void evs_fold(int i, int v) { ev[i].fold = v; }
int ev_fold_(int *i) { return(ev[(*i)].fold); }
void evs_fold_(int *i, int *v) { ev[(*i)].fold = *v; }

float ev_vx(int i) { return(ev[i].vx); }
void evs_vx(int i, float v) { ev[i].vx = v; }
float ev_vx_(int *i) { return(ev[(*i)].vx); }
void evs_vx_(int *i, float *v) { ev[(*i)].vx = *v; }

float ev_vy(int i) { return(ev[i].vy); }
void evs_vy(int i, float v) { ev[i].vy = v; }
float ev_vy_(int *i) { return(ev[(*i)].vy); }
void evs_vy_(int *i, float *v) { ev[(*i)].vy = *v; }

float ev_vz(int i) { return(ev[i].vz); }
void evs_vz(int i, float v) { ev[i].vz = v; }
float ev_vz_(int *i) { return(ev[(*i)].vz); }
void evs_vz_(int *i, float *v) { ev[(*i)].vz = *v; }

float ev_v(int i) { return(ev[i].v); }
void evs_v(int i, float v) { ev[i].v = v; }
float ev_v_(int *i) { return(ev[(*i)].v); }
void evs_v_(int *i, float *v) { ev[(*i)].v = *v; }

float ev_px(int i) { return(ev[i].px); }
void evs_px(int i, float v) { ev[i].px = v; }
float ev_px_(int *i) { return(ev[(*i)].px); }
void evs_px_(int *i, float *v) { ev[(*i)].px = *v; }

float ev_py(int i) { return(ev[i].py); }
void evs_py(int i, float v) { ev[i].py = v; }
float ev_py_(int *i) { return(ev[(*i)].py); }
void evs_py_(int *i, float *v) { ev[(*i)].py = *v; }

float ev_pz(int i) { return(ev[i].pz); }
void evs_pz(int i, float v) { ev[i].pz = v; }
float ev_pz_(int *i) { return(ev[(*i)].pz); }
void evs_pz_(int *i, float *v) { ev[(*i)].pz = *v; }

float ev_p(int i) { return(ev[i].p); }
void evs_p(int i, float v) { ev[i].p = v; }
float ev_p_(int *i) { return(ev[(*i)].p); }
void evs_p_(int *i, float *v) { ev[(*i)].p = *v; }

float ev_e(int i) { return(ev[i].e); }
void evs_e(int i, float v) { ev[i].e = v; }
float ev_e_(int *i) { return(ev[(*i)].e); }
void evs_e_(int *i, float *v) { ev[(*i)].e = *v; }

float ev_etot(int i) { return(ev[i].etot); }
void evs_etot(int i, float v) { ev[i].etot = v; }
float ev_etot_(int *i) { return(ev[(*i)].etot); }
void evs_etot_(int *i, float *v) { ev[(*i)].etot = *v; }

float ev_t(int i) { return(ev[i].t); }
void evs_t(int i, float v) { ev[i].t = v; }
float ev_t_(int *i) { return(ev[(*i)].t); }
void evs_t_(int *i, float *v) { ev[(*i)].t = *v; }

float ev_th(int i) { return(ev[i].th); }
void evs_th(int i, float v) { ev[i].th = v; }
float ev_th_(int *i) { return(ev[(*i)].th); }
void evs_th_(int *i, float *v) { ev[(*i)].th = *v; }

float ev_thcm(int i) { return(ev[i].thcm); }
void evs_thcm(int i, float v) { ev[i].thcm = v; }
float ev_thcm_(int *i) { return(ev[(*i)].thcm); }
void evs_thcm_(int *i, float *v) { ev[(*i)].thcm = *v; }

float ev_phi(int i) { return(ev[i].phi); }
void evs_phi(int i, float v) { ev[i].phi = v; }
float ev_phi_(int *i) { return(ev[(*i)].phi); }
void evs_phi_(int *i, float *v) { ev[(*i)].phi = *v; }

float ev_q(int i) { return(ev[i].q); }
void evs_q(int i, float v) { ev[i].q = v; }
float ev_q_(int *i) { return(ev[(*i)].q); }
void evs_q_(int *i, float *v) { ev[(*i)].q = *v; }

float ev_q2(int i) { return(ev[i].q2); }
void evs_q2(int i, float v) { ev[i].q2 = v; }
float ev_q2_(int *i) { return(ev[(*i)].q2); }
void evs_q2_(int *i, float *v) { ev[(*i)].q2 = *v; }

float ev_m(int i) { return(ev[i].m); }
void evs_m(int i, float v) { ev[i].m = v; }
float ev_m_(int *i) { return(ev[(*i)].m); }
void evs_m_(int *i, float *v) { ev[(*i)].m = *v; }

float ev_z(int i) { return(ev[i].z); }
void evs_z(int i, float v) { ev[i].z = v; }
float ev_z_(int *i) { return(ev[(*i)].z); }
void evs_z_(int *i, float *v) { ev[(*i)].z = *v; }

int ev_hi(int i) { return(ev[i].hi); }
void evs_hi(int i, int v) { ev[i].hi = v; }
int ev_hi_(int *i) { return(ev[(*i)].hi); }
void evs_hi_(int *i, int *v) { ev[(*i)].hi = *v; }

int ev_li(int i) { return(ev[i].li); }
void evs_li(int i, int v) { ev[i].li = v; }
int ev_li_(int *i) { return(ev[(*i)].li); }
void evs_li_(int *i, int *v) { ev[(*i)].li = *v; }

int ev_det(int i) { return(ev[i].det); }
void evs_det(int i, int v) { ev[i].det = v; }
int ev_det_(int *i) { return(ev[(*i)].det); }
void evs_det_(int *i, int *v) { ev[(*i)].det = *v; }

int ev_seg(int i) { return(ev[i].seg); }
void evs_seg(int i, int v) { ev[i].seg = v; }
int ev_seg_(int *i) { return(ev[(*i)].seg); }
void evs_seg_(int *i, int *v) { ev[(*i)].seg = *v; }


