/*
 * ''event_dump''     Dump Events                      Steve Chappell
 *
 *  Routines to dump sunsort events for viewing
 
 * Notes
 *  sort adc numbering will depend on the egmap file
 *  Requires MAXCHAN+2 1d spectra for spectrum dump

 * Updates
 *   21st Oct 97: Birth
 
 */

#include <stdio.h>
#include "sort_def.h"
#include "rdtape.h"
#include "spectra.h"
#include "subs.h"

#define DUMP_ONLY 1         /*Just Dump event data to output*/
#define SPEC_ONLY 2         /*Just increment spectra*/
#define DUMP_N_SPEC 3       /*Dump events and increment spectra*/
#define ADC(i) adcs_.adcs[(i)-1]

int chann_dump(int dumpflag, int maxchans)
{

    int i, format = 1, dump = 0, spec = 0;
    short *sp;

    if(dumpflag == DUMP_ONLY)
	dump = 1;
    else if(dumpflag == SPEC_ONLY)
	spec = 1;
    else if(dumpflag == DUMP_N_SPEC){
	dump = 1;
	spec = 1;
    }
    else
	return(0);
    
    for(sp = adcs_.adcs, i = maxchans; i--; sp++) /* Loop over all ADCs */
	if (*sp >= 0)
	{

	    if(spec){
		if (*sp > 0)
		{
		    inc1d(sp - adcs_.adcs + 1, *sp);
		    inc1d((maxchans+1), sp - adcs_.adcs + 1); /*values data*/
		} 
		else
		    inc1d((maxchans+2), sp - adcs_.adcs + 1); /*zeros data*/
	    }	
	    
	    if(dump)
	    {
		printf("%4d=%5d;", sp - adcs_.adcs + 1, *sp);
		if(format == 8){
		    format = 1;
		    printf("\n");
		}
		else
		    format++;
	    }
	}
    
    if (dump)
	printf("\n---\n");
    
    return(0);
}



/*
 * Dumps Experimental Set-up info 
 */
void expt_dump(struct detectors *dp, int indent)
{
    int i;

    while(dp != NULL)
    {
	for(i = indent; i--; )
	    putc(' ', stderr);
	fprintf(stderr, "%s %d (%d, %f %f %d %d)\n", dp->info->name,
		dp->number, dp->adcnum, dp->gain, dp->offset, dp->threshmin,
		dp->threshmax);
	expt_dump(dp->children, indent+4);
	dp = dp->next;
    }
}

/*
 * Dumps info on each event
 */
void event_dump(struct detectors *dp, int indent)
{
    int i;

    while(dp != NULL)
    {
	for(i = indent; i--; )
	    putc(' ', stderr);
	fprintf(stderr, "%s %d, hits = %d", dp->info->name, dp->number,
		dp->hits);
	if (dp->adcnum != -1)
	    fprintf(stderr, " on ADC %d, value %d -> %f", dp->adcnum,
		    adcs_.adcs[dp->adcnum-1], dp->value);
	putc('\n', stderr);
	event_dump(dp->hitlist.head, indent+4);
	dp = dp->hitlist.next;
    }
}

/*
 * Dumps adclist
 */
void adclist_dump(void)
{
    int i;
    fprintf(stderr, "adclist[]:");
    for(i=0; adclist_.adclist[i] != -1; i++)
	fprintf(stderr, " %d", adclist_.adclist[i]);
    fprintf(stderr, "\nadc[]:");
    for(i=1; i<=768; i++)
	if (ADC(i) >= 0)
	    fprintf(stderr, " %d(%d)", i, ADC(i));
    fprintf(stderr, "\n");
}
