#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "structure.h"
#include "loadadcs.h"
#include "fortprop.h"

static int loadsub(struct detectors *dp, FILE *fp, int tdcoffset)
{
    int i, t = 0, c;

    for(; dp != NULL; dp = dp->next)
    {
	if (!strncmp(dp->info->name, "signal", 6))
	{
	    if (t)
	    {
		dp->adcnum = i + tdcoffset;
		t = 0;
	    }
	    else
	    {
		do {
		    c = getc(fp);
		    if (c == '!' || c == '#' || c == '*')
			while((c = getc(fp)) != '\n' && c != EOF)
			    ;
		} while(isspace(c));
		if (c != EOF)
		    ungetc(c, fp);
		if (fscanf(fp, " %d ", &i) != 1)
		{
		    fprintf(stderr, "loadadcs: Number of entries in file"
			    " does not match "
			    "number of signals in detector structure.\n");
		    return(-1);
		}
		dp->adcnum = i;
		t = tdcoffset;
	    }
	}
	else
	{
	    if ((t = loadsub(dp->children, fp, tdcoffset)) < 0)
		return(t);
	}
    }

    return(0);
}

int loadadcs(struct detectors *dp, char *filename, int tdcoffset)
{
    FILE *fp;
    int err;

    if (dp == NULL)
    {
	fprintf(stderr, "loadadcs: Unable to load ADC map"
		" as detector structure empty.\n");
	return(-1);
    }

    fprintf(stderr, "loadadcs: Loading ADC map from file %s.\n", filename);
    if (tdcoffset == 0)
	fprintf(stderr, "loadadcs: Expecting TDC addresses in file.\n");
    else
	fprintf(stderr, "loadadcs: Setting TDC addresses to ADC + %d.\n",
		tdcoffset);

    if ((fp = fopen(filename, "r")) == NULL)
    {
	perror(filename);
	return(-1);
    }

    err = loadsub(dp, fp, tdcoffset);

    fclose(fp);

    return(err);
}


/* FORTRAN interface routines */

int loadadcs_(char *filename, int *tdcoffset)
{
    return(loadadcs(experiment_, filename, *tdcoffset));
}
