#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fortprop.h"
#include "subs.h"

struct detectors **detparray = NULL;
static short *dethits = NULL;
static int numadcs;

static int markdetectors(struct detectors *dp)
{
    int adc;

    for( ; dp != NULL; dp = dp->next)
    {
	adc = dp->adcnum;
	if (adc > numadcs)
	{
	    fprintf(stderr, "initmarkhits: ADC %d is out of range.\n",
		    adc);
	    return(-1);
	}
	if (adc >= 0)
	{
	    if (detparray[adc-1] != NULL)
	    {
		fprintf(stderr, "initmarkhits: ADC %d occurs twice.\n", adc);
		return(-1);
	    }
	    detparray[adc-1] = dp;
	}
	dp->hits = 0;
	dp->hitlist.head = NULL;
	if ((adc = markdetectors(dp->children)) < 0)
	    return(adc);
    }

    return(0);
}


int initmarkhits(struct detectors *dp, int nadcs)
{
    int i;

    if (detparray != NULL)
    {
	free(detparray);
	detparray = NULL;
    }
    
    if ((detparray = (struct detectors **)
	 calloc(nadcs, sizeof(struct detectors **))) == NULL)
    {
	fprintf(stderr, "initmarkhits: Out of memory\n");
	return(-1);
    }

    if ((dethits = calloc(nadcs+1, sizeof(short))) == NULL)
    {
	free(detparray);
	fprintf(stderr, "initmarkhits: Out of memory\n");
	return(-1);
    }
    
    numadcs = nadcs;
    
    for(i = 0; i < nadcs; i++)
	detparray[i] = NULL;
    
    dethits[0] = -1;

    if ((i = markdetectors(dp)) < 0)
    {
	free(detparray);
	free(dethits);
	detparray = NULL;
	return(i);
    }

    return(0);
}

static void erasehits(void)
{
    struct detectors *dp;
    short *p;

    for(p = dethits; *p != -1; p++)
    {
	dp = detparray[*p-1];
	dp->hits = 0;
	for(dp = dp->parent; dp != NULL && dp->hits > 0; dp = dp->parent)
	{
	    dp->hits = 0;
	    dp->value = -1.0;
	    dp->hitlist.head = NULL;
	}
    }
}

void markhits(short *adc)
{
    struct detectors *dp, *dp2;
    struct detectors **mp;
    short *p;
    int i;
    short *ap;

    /* Erase any hits left over from last time */

    erasehits();

    /* Put in hits */

    for(ap = adc, p = dethits, mp = detparray, i = numadcs; i--;
	ap++, mp++)
    {
	if ((dp = *mp) == NULL)
	    continue;
	if (*ap >= dp->threshmin && *ap <= dp->threshmax)
	{
	    *p++ = (mp - detparray)+1;
	    dp->hits = 1;
	    dp->value = (*ap - dp->offset)*dp->gain;
	    while(dp->hits == 1 && (dp2 = dp->parent) != NULL)
	    {
		dp->hitlist.next = dp2->hitlist.head;
		dp2->hitlist.head = dp;
		dp2->hits++;
		dp = dp2;
	    }
	}
    }
    *p++ = -1;
}

void markhitslist(short *adclist, short *adc)
{
    struct detectors *dp, *dp2;
    int n, v;
    short *ap;

    /* Erase any hits left over from last time */

    erasehits();

    /* Put in hits */

    for(ap = adclist; (n = *ap) != -1; ap++)
    {
	if ((dp = detparray[n-1]) == NULL)
	    continue;
	v = adc[n-1];
	if (v >= dp->threshmin && v <= dp->threshmax)
	{
 	    dp->hits = 1;
	    dp->value = (v - dp->offset)*dp->gain;
	    while(dp->hits == 1 && (dp2 = dp->parent) != NULL)
	    {
		dp->hitlist.next = dp2->hitlist.head;
		dp2->hitlist.head = dp;
		dp2->hits++;
		dp = dp2;
	    }
	}
    }

    memcpy(dethits, adclist, ((char *) (ap + 1)) - ((char *) adclist));
}

int loadgainoffset(char *filename)
{
    FILE *fp;
    int i;
    float g, o;
    char buffer[SUBS_BUFSIZE];

    if (detparray == NULL)
    {
	fprintf(stderr, "Can't load gain and offset file before initmarkhits "
		"has been called.\n");
	return -1;
    }

    if ((fp = fopen(filename, "r")) != NULL)
    {
	fprintf(stderr, "markhits: Reading file \"%s\".\n", filename);
	while (mygetline(buffer, SUBS_BUFSIZE, fp) != NULL)
	{
	    if (sscanf(buffer, " %d %f %f", &i, &g, &o) != 3)
		fprintf(stderr, "markhits: Expected 'adc gain offset',"
			" got \"%s\".\n",buffer);
	    else
	    {
		detparray[i-1]->gain = g;
		detparray[i-1]->offset = o;
	    }
	}
    }
    else
    {
	fprintf(stderr, "markhits: No file \"%s\", using default settings.\n",
		filename);
	return 1;
    }
    return 0;
}
    

int loadthresholds(char *filename)
{
    FILE *fp;
    int i, min, max;
    char buffer[SUBS_BUFSIZE];

    if (detparray == NULL)
    {
	fprintf(stderr, "Can't load thresholds file before initmarkhits "
		"has been called.\n");
	return -1;
    }

    if ((fp = fopen(filename, "r")) != NULL)
    {
	fprintf(stderr, "markhits: Reading file \"%s\".\n", filename);
	while (mygetline(buffer, SUBS_BUFSIZE, fp) != NULL)
	{
	    if (sscanf(buffer, " %d %d %d", &i, &min, &max) != 3)
		fprintf(stderr, "markhits: Expected 'adc min max',"
			" got \"%s\".\n",buffer);
	    else
	    {
		detparray[i-1]->threshmin = min;
		detparray[i-1]->threshmax = max;
	    }
	}
    }
    else
    {
	fprintf(stderr, "markhits: No file \"%s\", using default settings.\n",
		filename);
	return 1;
    }
    return 0;
}

/* FORTRAN interface routines */

int initmarkhits_(int *numadcs)
{
    return(initmarkhits(experiment_, *numadcs));
}

void markhits_(short *adc)
{
    markhits(adc);
}
