/*
 * ''missing_p''     Missing Momentum                      Steve Chappell
 *
 *   General Subroutine to reconstruct a new particle from the missing 
 *   momentum and fill out the event structure
 
 * Notes
   evhead.pmult[*] is NOT changed here, but evhead.etot, evhead.n[*] IS
   The actual hit multiplicity can therefore be tracked! 
 

 * Updates
 *   20th May 98: Birth
     22nd May 98: Keep the convention of Phi in positive range 0->360

 */
#include <stdio.h>
#include <math.h>
#include "subs.h"

int missing_p(void){

    float px=0, py=0, pz=0;
    float vcm, mrec, pcm_z, pcm;
	int i,k;
    
    /*fill out header with singles*/
    evhead.n[0]++;
    evhead.n[1]++;
    k = evhead.n[1];
    
    /*generate particle and fill out event structure*/

    for(i=1; i<k ; i++){
	px += ev[i].px;
	py += ev[i].py;
	pz += ev[i].pz;
    }
    
    ev[k].px = -px;
    ev[k].py = -py;
    ev[k].pz = sqrt(2*reac.mass[1]*reac.e1) -pz;
    ev[k].p = sqrt(ev[k].px*ev[k].px + ev[k].py*ev[k].py + ev[k].pz*ev[k].pz);
    ev[k].t = 0;
    ev[k].m = reac.mass[0];
    ev[k].det = 0;
    ev[k].seg = 0;
    ev[k].fold = 1;
    ev[k].e = (ev[k].p*ev[k].p)/(2*ev[k].m);
    evhead.etot += ev[k].e;
    ev[k].th = (acos(ev[k].pz/ev[k].p))/RAD;
    ev[k].phi = (atan2(ev[k].py,ev[k].px))/RAD + ((ev[k].py >= 0) ? 0 : 360);
	
    vcm=(sqrt(2.0*reac.e1*reac.mass[1]))/(reac.mass[1]+reac.mass[2]);
    pcm_z=ev[k].pz-ev[k].m*vcm;
    pcm=sqrt(ev[k].px*ev[k].px+ev[k].py*ev[k].py+pcm_z*pcm_z);
    ev[k].thcm=(acos(pcm_z/pcm))/RAD;
    ev[k].q = 0.0;
    mrec=reac.mass[1]+reac.mass[2]-ev[k].m;
    if(mrec > 0)
	ev[k].q2=((ev[k].m+mrec)*ev[k].e - 
		  (mrec-reac.mass[1])*reac.e1   - 
		  2.0*(sqrt(reac.mass[1]*ev[k].m*reac.e1*ev[k].e)) *
		  cos(ev[k].th*RAD)
		  )/mrec;
    else
	ev[k].q2=0.0;
    ev[k].hi = 0;
    ev[k].li = 0;
    
    return 0;
}
