/*
 * ''nrhit''      Recalculate N hit dependencies                Steve Chappell
 *
 *   General Subroutine to recalculate all dependencies
 *   in the event array given that the mass originally
 *   associated with a particle has been changed.

 *   Note: Can only recalculate for composite particles if
 *         lower fold changed. It does NOT propogate downwards.

 * Updates
 *   20th Jul 97: 
 *
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "subs.h"

void nrhit(float newmass, int vrp)
{
    char flag[NP_MAX+1]; /*particle properties altered flag*/
    int i;
    
    memset(flag, 0, evhead.n[0]+1);
    /*recalculate for vrp*/
    if(ev[vrp].fold == 1)
	rhit(newmass, vrp);
    else
	rp(ev[vrp].hi,ev[vrp].li,vrp);
    flag[vrp] = 1;

    /*Check dependencies and recalculate for other particles*/
    for(i=vrp+1; i <=  evhead.n[0]; i++)
    {
	if (flag[ev[i].li] || flag[ev[i].hi])
	{
	    rp(ev[i].hi,ev[i].li,i);
	    flag[i] = 1;
	}
    }
}
