*-----------------------------------------------------------------------
* ''corr''      Angular Correlations                      Steve Chappell
*
*   General Subroutine to reconstruct angular correlations for
*   decay of a resonant particle into two breakup fragments...
*   1(rp*) -> 2(Heavy Ion) + 3(Light Ion)

* Notes

*   3 components of momentum p_corr(particle 1 to 3 , [x,y,z])
*   In Polar Co-ord  (hor,vert,beam)=(x,y,z)  --> p_corr   pspace(*,1,*)
*   In Fixed Axial Co-ord          (x0,y0,z0) --> p0_corr  pspace(*,2,*)
*   In Basel Co-ord                (xb,yb,zb) --> pb_corr  pspace(*,3,*)

* Updates
*   Error in pcm_corr(1,3) calculation fixed 24th Jun 97

*-----------------------------------------------------------------------

      subroutine corr(vrp_corr,pspace_corr)

      implicit none
      include 'subs.i'
      common/reac/ e1,mass
      real e1,mass(0:4)
      real m_corr(3),vcm_corr
      real p_corr(3,3),p0_corr(3,3),pb_corr(3,3)
      real psum_corr(3),pcm_corr(3,3),psumcm_corr
      real vrel_corr(3),vrel0_corr(3),vrelb_corr(3)
      real pspace_corr(CORR_MAX,CORR_REC)
      real th0_corr(3),dths
      integer hi_corr,li_corr,vrp_corr

      hi_corr=ev_hi(vrp_corr)
      li_corr=ev_li(vrp_corr)

      vcm_corr=(sqrt(2.0*e1*mass(1)))/(mass(1)+mass(2))

* Particle 3 = Light Ion
      m_corr(3)=ev_m(li_corr)
      p_corr(3,1)=ev_px(li_corr)
      p_corr(3,2)=ev_py(li_corr)
      p_corr(3,3)=ev_pz(li_corr)
      psum_corr(3)=ev_p(li_corr)

* Particle 2 = Heavy Ion
      m_corr(2)=ev_m(hi_corr)
      p_corr(2,1)=ev_px(hi_corr)
      p_corr(2,2)=ev_py(hi_corr)
      p_corr(2,3)=ev_pz(hi_corr)
      psum_corr(2)=ev_p(hi_corr)

* Particle 1 = Resonant Particle
      m_corr(1)=ev_m(vrp_corr)
      p_corr(1,1)=ev_px(vrp_corr)
      p_corr(1,2)=ev_py(vrp_corr)
      p_corr(1,3)=ev_pz(vrp_corr)
      psum_corr(1)=ev_p(vrp_corr)

**Resonant Particle Analysis ...
      pcm_corr(1,1)=p_corr(1,1)
      pcm_corr(1,2)=p_corr(1,2)
      pcm_corr(1,3)=p_corr(1,3)-m_corr(1)*vcm_corr

      psumcm_corr=
     +          sqrt(pcm_corr(1,1)**2+pcm_corr(1,2)**2+pcm_corr(1,3)**2)
      vrel_corr(1)=p_corr(3,1)/m_corr(3)-p_corr(2,1)/m_corr(2)
      vrel_corr(2)=p_corr(3,2)/m_corr(3)-p_corr(2,2)/m_corr(2)
      vrel_corr(3)=p_corr(3,3)/m_corr(3)-p_corr(2,3)/m_corr(2)      

* Phase Space Parameters (Nb.Particles 2,3 in lab, 1 in c.m. frame)
* 1,2,3,4 -> (ths,phis,psi,chi)

      pspace_corr(CORR_POL,CORR_THS)=(acos(pcm_corr(1,3)/psumcm_corr))
     +                                                              /rad
      pspace_corr(CORR_POL,CORR_PHIS)=sign(1.0,p_corr(1,2))*
     +     (acos(p_corr(1,1)/(sqrt(p_corr(1,1)**2+p_corr(1,2)**2))))/rad
      pspace_corr(CORR_POL,CORR_PSI)=(acos(vrel_corr(3)/
     +     (sqrt(vrel_corr(1)**2+vrel_corr(2)**2+vrel_corr(3)**2))))/rad
      pspace_corr(CORR_POL,CORR_CHI)=sign(1.0,vrel_corr(2))*
     +  (acos(vrel_corr(1)/(sqrt(vrel_corr(1)**2+vrel_corr(2)**2))))/rad

**FIXED ``AXIAL'' Co-ordinates (x0,y0,z0)=(beam,horiz,vert)
* Transformation from ``CHAPPELL'' frame (x,y,z) ---> (z0,x0,y0)

      p0_corr(3,1)=p_corr(3,3)
      p0_corr(3,2)=p_corr(3,1)
      p0_corr(3,3)=p_corr(3,2)
      th0_corr(3)=acos(p0_corr(3,3)/psum_corr(3))/rad

      p0_corr(2,1)=p_corr(2,3)
      p0_corr(2,2)=p_corr(2,1)
      p0_corr(2,3)=p_corr(2,2)
      th0_corr(2)=acos(p0_corr(2,3)/psum_corr(2))/rad

      p0_corr(1,1)=pcm_corr(1,3)
      p0_corr(1,2)=p_corr(1,1)
      p0_corr(1,3)=p_corr(1,2)
      th0_corr(1)=acos(p0_corr(1,3)/psum_corr(1))/rad

      vrel0_corr(1)=p0_corr(3,1)/m_corr(3)-p0_corr(2,1)/m_corr(2)
      vrel0_corr(2)=p0_corr(3,2)/m_corr(3)-p0_corr(2,2)/m_corr(2)
      vrel0_corr(3)=p0_corr(3,3)/m_corr(3)-p0_corr(2,3)/m_corr(2)

* Phase Space Parameters
* 1,2,3,4 -> (ths_0,phis_0,psi_0,chi_0)

      pspace_corr(CORR_AX0,CORR_THS)=(acos(p0_corr(1,3)/psumcm_corr))
     +                                                              /rad
      pspace_corr(CORR_AX0,CORR_PHIS)=sign(1.0,p0_corr(1,2))*
     +  (acos(p0_corr(1,1)/(sqrt(p0_corr(1,1)**2+p0_corr(1,2)**2))))/rad
      pspace_corr(CORR_AX0,CORR_PSI)=(acos(vrel0_corr(3)/
     +  (sqrt(vrel0_corr(1)**2+vrel0_corr(2)**2+vrel0_corr(3)**2))))/rad
      pspace_corr(CORR_AX0,CORR_CHI)=sign(1.0,vrel0_corr(2))*(acos
     +    (vrel0_corr(1)/(sqrt(vrel0_corr(1)**2+vrel0_corr(2)**2))))/rad

**FLOATING ``BASEL'' Co-ords (xb,yb,zb) => (ths_b=90,phis_b,psi_b,chi_b)
* ebye Rotn about x0 to define c trajectory in the reac plane (xb,yb)

      dths=90.0-pspace_corr(CORR_AX0,CORR_THS)

      pb_corr(3,1)=p0_corr(3,1)
      pb_corr(3,2)=p0_corr(3,2)/(cos(dths*rad))
      pb_corr(3,3)=psum_corr(3)*(cos((th0_corr(3)+dths)*rad))

      pb_corr(2,1)=p0_corr(2,1)
      pb_corr(2,2)=p0_corr(2,2)/(cos(dths*rad))
      pb_corr(2,3)=psum_corr(2)*(cos((th0_corr(2)+dths)*rad))

      pb_corr(1,1)=p0_corr(1,1)
      pb_corr(1,2)=p0_corr(1,2)/(cos(dths*rad))
      pb_corr(1,3)=psumcm_corr*(cos(
     +                (pspace_corr(CORR_AX0,CORR_THS)+dths)*rad))

      vrelb_corr(1)=pb_corr(3,1)/m_corr(3)-pb_corr(2,1)/m_corr(2)
      vrelb_corr(2)=pb_corr(3,2)/m_corr(3)-pb_corr(2,2)/m_corr(2)
      vrelb_corr(3)=pb_corr(3,3)/m_corr(3)-pb_corr(2,3)/m_corr(2)

* Phase Space Parameters
* 1,2,3,4 -> (ths_b,phis_b,psi_b,chi_b)

      pspace_corr(CORR_BAS,CORR_THS)=(acos(pb_corr(1,3)/psumcm_corr))
     +                                                              /rad
      pspace_corr(CORR_BAS,CORR_PHIS)=sign(1.0,pb_corr(1,2))*
     +  (acos(pb_corr(1,1)/(sqrt(pb_corr(1,1)**2+pb_corr(1,2)**2))))/rad
      pspace_corr(CORR_BAS,CORR_PSI)=(acos(vrelb_corr(3)/
     +  (sqrt(vrelb_corr(1)**2+vrelb_corr(2)**2+vrelb_corr(3)**2))))/rad
      pspace_corr(CORR_BAS,CORR_CHI)=sign(1.0,vrelb_corr(2))*(acos
     +    (vrelb_corr(1)/(sqrt(vrelb_corr(1)**2+vrelb_corr(2)**2))))/rad


      end
