*-----------------------------------------------------------------------
* ''nrp''      N Fold Resonant Particles                  Steve Chappell
*
* General Subroutine to Generate resonant particles 
* from N breakup products and add the particles to the
* the ev array. Restricted to NCR_MAX=6 fold and below.

* Notes

* Includes subroutine ''ncr'' to calculate r combinations from n

* Reconstruct Pairs from two singles
* Reconstruct Triples from Pairs plus singles
* Reconstruct Quads from Triples plus singles
* etc etc
* Result is ``heavy ion'' and ``light ion''  point back up the tree 
* to the single particle numbers and DO NOT correspond to the 
* sequential breakup into HI and LI.

* In the event array.... If N=nhits  nCr combinations of each type
* Singles  1              --> N
* Doubles  N +1           --> N +1 +NC2-1
* Triples  N +1 NC2-1 +1  --> N +1 +NC2-1 +1 +NC3-1
* Quads

* Updates
* Last Edited 6th Jan 1997

*-----------------------------------------------------------------------

      subroutine nrp()

      implicit none
      include 'subs.i'
      integer ncr
      integer vrp_nrp(NCR_MAX)
      integer i1_nrp,i2_nrp,i3_nrp,i4_nrp,i5_nrp,i6_nrp

      if(ev_n1().gt.NCR_MAX)then
        print*, 'ncr: ',ev_n1(),' hit event dumped. ',
     +       'Max fold ',NCR_MAX,' exceeded!'
        return
      endif


*Put Number of different Nfold combinations
*Plus Pointers to ``start'' and ``Next'' locations 
*of Nfold particles in the Event Header

      vrp_nrp(1)=ev_p1()

      if(ev_n1().ge.2) then
          call evs_n2(ncr(ev_n1(),2))
          call evs_p2(ev_p1()+ev_n1())
          call evs_np(ev_np()+ev_n2())
          vrp_nrp(2)=ev_p2()
      endif
      if(ev_n1().ge.3) then
          call evs_n3(ncr(ev_n1(),3))
          call evs_p3(ev_p2()+ev_n2())
          call evs_np(ev_np()+ev_n3())
          vrp_nrp(3)=ev_p3()
      endif
      if(ev_n1().ge.4) then
          call evs_n4(ncr(ev_n1(),4))
          call evs_p4(ev_p3()+ev_n3())
          call evs_np(ev_np()+ev_n4())
          vrp_nrp(4)=ev_p4()
      endif
      if(ev_n1().ge.5) then
          call evs_n5(ncr(ev_n1(),5))
          call evs_p5(ev_p4()+ev_n4())
          call evs_np(ev_np()+ev_n5())
          vrp_nrp(5)=ev_p5()
      endif
      if(ev_n1().ge.6) then
          call evs_n6(ncr(ev_n1(),6))
          call evs_p6(ev_p5()+ev_n5())
          call evs_np(ev_np()+ev_n6())
          vrp_nrp(6)=ev_p6()
      endif

*      print*, 'nrp : NHITS ',ev_n1()
*      print*, 'nrp : NCOMBS ',ev_np()

*Build the combinations of virtual fold particles

*singles
      if(1.le.ev_n1()-1)then
       do i1_nrp=1,ev_n1()-1
*doubles
         if(i1_nrp+1.le.ev_n1())then
          do i2_nrp=i1_nrp+1,ev_n1()
            call rp(vrp_nrp(1),i2_nrp,vrp_nrp(2))
*           print*, vrp_nrp(2),': ',
*     +                 i1_nrp,i2_nrp
*     +          ,ev_hi(vrp_nrp(2)),ev_li(vrp_nrp(2))
*     +          ,ev_m(vrp_nrp(2)),ev_fold(vrp_nrp(2))
*triples
            if(i2_nrp+1.le.ev_n1())then
             do i3_nrp=i2_nrp+1,ev_n1()
               call rp(vrp_nrp(2),i3_nrp,vrp_nrp(3))
*              print*, vrp_nrp(3),': ',
*     +                    i1_nrp,i2_nrp,i3_nrp
*     +          ,ev_hi(vrp_nrp(3)),ev_li(vrp_nrp(3))
*     +          ,ev_m(vrp_nrp(3)),ev_fold(vrp_nrp(3))
*quads
              if(i3_nrp+1.le.ev_n1())then
                do i4_nrp=i3_nrp+1,ev_n1()
                  call rp(vrp_nrp(3),i4_nrp,vrp_nrp(4))
*                 print*, vrp_nrp(4),': ',
*     +                       i1_nrp,i2_nrp,i3_nrp,i4_nrp
*     +          ,ev_hi(vrp_nrp(4)),ev_li(vrp_nrp(4))
*     +          ,ev_m(vrp_nrp(4)),ev_fold(vrp_nrp(4))
*quins
                  if(i4_nrp+1.le.ev_n1())then
                   do i5_nrp=i4_nrp+1,ev_n1()
                     call rp(vrp_nrp(4),i5_nrp,vrp_nrp(5))
*                    print*, vrp_nrp(5),': ',
*     +                       i1_nrp,i2_nrp,i3_nrp,i4_nrp,
*     +                       i5_nrp
*     +          ,ev_hi(vrp_nrp(5)),ev_li(vrp_nrp(5))
*     +          ,ev_m(vrp_nrp(5)),ev_fold(vrp_nrp(5))
*sextuplets
                     if(i5_nrp+1.le.ev_n1())then
                      do i6_nrp=i5_nrp+1,ev_n1()
                        call rp(vrp_nrp(5),i6_nrp,vrp_nrp(6))
*                       print*, vrp_nrp(6),': ',
*     +                             i1_nrp,i2_nrp,i3_nrp,
*     +                             i4_nrp,i5_nrp,i6_nrp
*     +          ,ev_hi(vrp_nrp(6)),ev_li(vrp_nrp(6))
*     +          ,ev_m(vrp_nrp(6)),ev_fold(vrp_nrp(6))
                        vrp_nrp(6)=vrp_nrp(6)+1
                      enddo
                     endif
                     vrp_nrp(5)=vrp_nrp(5)+1
                   enddo
                  endif
                  vrp_nrp(4)=vrp_nrp(4)+1
                enddo
               endif
               vrp_nrp(3)=vrp_nrp(3)+1
             enddo
            endif
            vrp_nrp(2)=vrp_nrp(2)+1
          enddo
         endif
         vrp_nrp(1)=vrp_nrp(1)+1
       enddo
      endif

      end


*-----------------------------------------------------------------------
*''ncr''  Calculate r combinations out of n               Steve Chappell
*-----------------------------------------------------------------------

      integer function ncr(n_ncr,r_ncr)

      integer n_ncr,r_ncr,i_ncr

      if(n_ncr.lt.0 .or. r_ncr.lt.0 .or. n_ncr.lt.r_ncr)then
        print*, 'ncr: Error! n,r= ',n_ncr,r_ncr
         ncr=0
         return
      endif

      ncr=1
      do i_ncr=1,r_ncr
         ncr=(n_ncr-i_ncr+1)*ncr/i_ncr
      enddo

      end


