*-----------------------------------------------------------------------
* ''rhit''      Recalculate hit                           Steve Chappell
*
*   General Subroutine to recalculate event parameters of a hit
*   given that the mass originally associated with the 
*   particle has been changed
* Notes

* Updates
*   Last Edited 6th Jan 1997

*-----------------------------------------------------------------------

      subroutine rhit(newmass_rhit,vrp_rhit)

      implicit none
      include 'subs.i'
      common/reac/ e1,mass
      real e1,mass(0:4)
      real newmass_rhit,oldmass_rhit
      integer vrp_rhit

      oldmass_rhit=ev_m(vrp_rhit)
      call evs_m(vrp_rhit,newmass_rhit)
      call evs_px(vrp_rhit,ev_px(vrp_rhit)*sqrt(newmass_rhit/oldmass_rhit))
      call evs_py(vrp_rhit,ev_py(vrp_rhit)*sqrt(newmass_rhit/oldmass_rhit))
      call evs_pz(vrp_rhit,ev_pz(vrp_rhit)*sqrt(newmass_rhit/oldmass_rhit))
      call evs_p(vrp_rhit,ev_p(vrp_rhit)*sqrt(newmass_rhit/oldmass_rhit))

      end
