float thydmin[NDET_MAX+1],thydmax[NDET_MAX+1];
float thzdmin[NDET_MAX+1],thzdmax[NDET_MAX+1];
float thymax[NDET_MAX+1][NSEG_MAX+1],thzmax[NDET_MAX+1][NSEG_MAX+1];
float thymin[NDET_MAX+1][NSEG_MAX+1],thzmin[NDET_MAX+1][NSEG_MAX+1];
float ylow,yhi,zlow,zhi;
int isminy,ismaxy,isminz,ismaxz;

    int isegy,isegz;
    int hitseg[50+1][NSEG_MAX+1][NSEG_MAX+1];
    int tag[50+1][SIM_NPMAX];
    float thys,thzs,thly[SIM_NPMAX],thlz[SIM_NPMAX],thl[SIM_NPMAX];


/*detector coverage generation bits*/

	for(i=1; i<sim.ndet+1; i++){
	    
	    /*Y = HORIZONTAL in lab*/
	    thydmin[i]=180;
	    thydmax[i]=-180;
	    isminy=-sim.segy[i]/2.0;
	    ismaxy=sim.segy[i]/2.0 -1;
	    for(j=isminy ; j<ismaxy+1 ; j++){
		if(fmod(sim.segy[i],2) == 0){
		    ylow=j*sim.l[i]/sim.segy[i];
		    yhi =(j+1)*sim.l[i]/sim.segy[i];
		}
		else{
		    ylow=(j-0.5)*sim.l[i]/sim.segy[i];
		    yhi =(j+1-0.5)*sim.l[i]/sim.segy[i];
		}
		
		thymax[i][j+(int)(sim.segy[i]/2.0)+1]=
		    sim.thyd[i]+(atan(yhi/sim.rr[i]))/RAD;
		thymin[i][j+(int)(sim.segy[i]/2.0)+1]=
		    sim.thyd[i]+(atan(ylow/sim.rr[i]))/RAD;
		if(thymax[i][j+(int)(sim.segy[i]/2.0)+1] >= thydmax[i])
		    thydmax[i]=thymax[i][j+(int)(sim.segy[i]/2.0)+1];
		if(thymin[i][j+(int)(sim.segy[i]/2.0)+1] <= thydmin[i])
		    thydmin[i]=thymin[i][j+(int)(sim.segy[i]/2.0)+1];
	    }
	    
	    /*Z = VERTICAL in lab*/
	    thzdmin[i]=180;
	    thzdmax[i]=-180;
	    isminz=-sim.segz[i]/2.0;
	    ismaxz=sim.segz[i]/2.0 -1;	  
	    for(j=isminz; j<ismaxz+1; j++){
		if(fmod(sim.segz[i],2)== 0){
		    zlow=j*sim.h[i]/sim.segz[i];
		    zhi =(j+1)*sim.h[i]/sim.segz[i];
		}
		else{
		    zlow=(j-0.5)*sim.h[i]/sim.segz[i];
		    zhi =(j+1-0.5)*sim.h[i]/sim.segz[i];
		}
		
		thzmax[i][j+(int)(sim.segz[i]/2.0)+1]=
		    sim.thzd[i]+(atan(zhi/sim.rr[i]))/RAD;  
		thzmin[i][j+(int)(sim.segz[i]/2.0)+1]=
		    sim.thzd[i]+(atan(zlow/sim.rr[i]))/RAD;
		if(thzmax[i][j+(int)(sim.segz[i]/2.0)+1] >= thzdmax[i])
		    thzdmax[i]=thzmax[i][j+(int)(sim.segz[i]/2.0)+1];
		if(thzmin[i][j+(int)(sim.segz[i]/2.0)+1] <= thzdmin[i])
		    thzdmin[i]=thzmin[i][j+(int)(sim.segz[i]/2.0)+1];
	    }
	    
	    fprintf(stderr,"\nDet(%2d) "
		  "Thymin= %6.2f Thymax= %6.2f Thzmin=%6.2f Thzmax= %6.2f\n",
		    i,thydmin[i],thydmax[i],thzdmin[i],thzdmax[i]);
	    
	    if( MAX(sim.segy[i],sim.segz[i]) > 1){	    
		for(j=1; j < MAX(sim.segy[i],sim.segz[i]) +1; j++){
		    fprintf(stderr,"Seg(%2d) "
			    "        %6.2f         %6.2f    |"
			    "%6.2f         %6.2f\n",
			    j,thymin[i][j],thymax[i][j],
			    thzmin[i][j],thzmax[i][j]);  
		}
	    }
	    
	}




/*particle detection simulation bits*/

		nhits=0;
		for(k=3 ;k<13; k++){
		    sim.hit[k]=0;
		    if(evsim[k].e >= sim.ethrsh[k]){
			for(j=1; j<=sim.ndet; j++){
			    tag[j][k]= 0;
			    if( sim.hitpat[j][k] == 1 &&
			       thly[k] > thydmin[j] && thly[k] < thydmax[j] &&
			       thlz[k] > thzdmin[j] && thlz[k] < thzdmax[j] &&
			       thl[k] > sim.thabs){
				tag[j][k]=1;
				sim.hit[k]++;
				nhits++;
			    }
			}
		    }
		    /*Minimum coincidence requirement in final state*/
		    if(sim.hit[k] < sim.fstate[k]) goto detection_failed;
		}
		
		
		/*Check no two particles enter same detector segment*/
		
		/*Initialize arrays*/
		for(j=1; j<=sim.ndet; j++)
		    for(isegy=1; isegy <= sim.segy[sim.ndet]; isegy++)
			for(isegz=1; isegz <= sim.segz[sim.ndet]; 
			    isegz++)
			    hitseg[j][isegy][isegz]=0;
		
		for(k=3; k<=12; k++){
		    if(sim.hit[k] > 0){
			for(j=1; j<=sim.ndet; j++){
			    if(tag[j][k] > 0){
				for(isegy=1;isegy<=sim.segy[sim.ndet];
				    isegy++){
				    if(
				       thly[k] > thymin[j][isegy] &&
				       thly[k] < thymax[j][isegy]){
					for(isegz=1; isegz<=
					    sim.segz[sim.ndet];
					    isegz++){
					    if(
					       thlz[k] > thzmin[j][isegz] &&
					       thlz[k] < thzmax[j][isegz]){
						hitseg[j][isegy][isegz]
						    =hitseg[j][isegy][isegz]++;
						if(hitseg[j][isegy][isegz]> 1)
						    goto detection_failed;
					    }
					}
				    }
				}
			    }
			}
		    }
		}




    /*Write kinematic output*/
    /*	    fprintf(stdout,"%f %f %f %f\n",
	    evsim[3].e+evsim[4].e+sim.ex[3]+sim.ex[4]+sim.q1,
	    evsim[5].e+evsim[6].e-(sim.ex[3]+sim.qb[3]) + 
	    evsim[4].e+sim.q1+sim.ex[3]+sim.ex[4],
	    evsim[7].e+evsim[8].e-(sim.ex[4]+sim.qb[4]) + 
	    evsim[3].e+sim.q1+sim.ex[3]+sim.ex[4],
	    evsim[5].e+evsim[6].e-(sim.ex[3]+sim.qb[3])+
	    evsim[7].e+evsim[8].e-(sim.ex[4]+sim.qb[4])+
	    sim.q1+sim.ex[3]+sim.ex[4]
	    );
	    */    



    
static FILE *fpdat;

    /*Open a data write file*/
    if ((fpdat = fopen(SCANGA_HOME "data.sca", "w")) != NULL){
	fprintf(stderr, "Data output file \"%s\".\n",SCANGA_HOME "data.sca");
    }
    else{	    
	fprintf(stderr, "Error! Opening file \"%s\".\n", 
		SCANGA_HOME "data.sca");
	return(-1);
    }    


    /*Write simulated event (eg. part of structure) to file*/
    if(wrt_evsim(nhits) != 0){
	fprintf(stderr, "Error writing simulated event to file\n");
	return(-1);
    }

    fclose(fpdat);



    /* cylindrical geometry*/
    dths=sim.dthsmin+(sim.dthsmax-sim.dthsmin)*drand(iflag);
    if(sim.effcalc == 4)
	phis=sim.effvar;
    else
	phis=sim.phismin+(sim.phismax-sim.phismin)*drand(iflag);
    
    /* m12*->m3*+m4* */
    vrelz[3]=vrel[3]*cos(phis*RAD);
    vrelx[3]=vrel[3]*sin(phis*RAD)*cos(dths*RAD);
    vrely[3]=vrel[3]*sin(phis*RAD)*sin(dths*RAD);
    vrelz[4]=-vrelz[3]*evsim[3].m/evsim[4].m;
    vrelx[4]=-vrelx[3]*evsim[3].m/evsim[4].m;
    vrely[4]=-vrely[3]*evsim[3].m/evsim[4].m;
    evsim[3].vz=vrelz[3] + vcm;
    evsim[3].vx=vrelx[3];
    evsim[3].vy=vrely[3];
    evsim[3].v=sqrt(evsim[3].vz*evsim[3].vz+evsim[3].vx*evsim[3].vx+
		     evsim[3].vy*evsim[3].vy);
    evsim[4].vz=vrelz[4] + vcm;
    evsim[4].vx=vrelx[4];
    evsim[4].vy=vrely[4];
    evsim[4].v=sqrt(evsim[4].vz*evsim[4].vz+evsim[4].vx*evsim[4].vx+
		     evsim[4].vy*evsim[4].vy);
    evsim[3].e=0.5*evsim[3].m*evsim[3].v*evsim[3].v;
    evsim[4].e=0.5*evsim[4].m*evsim[4].v*evsim[4].v;
    evsim[3].pz=evsim[3].m*evsim[3].vz;
    evsim[3].px=evsim[3].m*evsim[3].vx;
    evsim[3].py=evsim[3].m*evsim[3].vy;
    evsim[3].p=evsim[3].m*evsim[3].v;
    evsim[4].pz=evsim[4].m*evsim[4].vz;
    evsim[4].px=evsim[4].m*evsim[4].vx;
    evsim[4].py=evsim[4].m*evsim[4].vy;
    evsim[4].p=evsim[4].m*evsim[3].v;
    evsim[3].th=(acos(evsim[3].vz/evsim[3].v))/RAD;
    evsim[4].th=(acos(evsim[4].vz/evsim[4].v))/RAD;
    evsim[3].phi=((evsim[3].vy >= 0) ? 1 : -1)*
	(acos(evsim[3].vx/(evsim[3].v*sin(evsim[3].th*RAD))))/RAD
	    +((evsim[3].vy >= 0) ? 0 : 360);
    evsim[4].phi=((evsim[4].vy >= 0) ? 1 : -1)*
	(acos(evsim[4].vx/(evsim[4].v*sin(evsim[4].th*RAD))))/RAD
	    +((evsim[4].vy >= 0) ? 0 : 360);

    phisr=(atan(vrelx[4]/vrelz[4]))/RAD;
        
    /*vrp->hi+li*/
    for(i=3;i<5;i++){
	j=i-3;
	if(bkup[i]){
	    chi=sim.chimin[j]+(sim.chimax[j]-sim.chimin[j])
		*drand(iflag);
	    psi=sim.psimin[j]+(sim.psimax[j]-sim.psimin[j])
		*drand(iflag);
	    vrelz[evsim[i].hi]= -vrel[evsim[i].hi]
		*cos(chi*RAD)*sin(psi*RAD);
	    vrelx[evsim[i].hi]= +vrel[evsim[i].hi]
		*sin(chi*RAD)*sin(psi*RAD);
	    vrely[evsim[i].hi]= -vrel[evsim[i].hi]*cos(psi*RAD);
	    vrelz[evsim[i].li]= +vrel[evsim[i].li]
		*cos(chi*RAD)*sin(psi*RAD);
	    vrelx[evsim[i].li]= -vrel[evsim[i].li]
		*sin(chi*RAD)*sin(psi*RAD);
	    vrely[evsim[i].li]= +vrel[evsim[i].li]*cos(psi*RAD);
	    evsim[evsim[i].hi].vz=vrelz[evsim[i].hi] + evsim[i].vz;
	    evsim[evsim[i].hi].vx=vrelx[evsim[i].hi] + evsim[i].vx;
	    evsim[evsim[i].hi].vy=vrely[evsim[i].hi] + evsim[i].vy;
	    evsim[evsim[i].hi].v=sqrt(
			       evsim[evsim[i].hi].vz*evsim[evsim[i].hi].vz+
			       evsim[evsim[i].hi].vx*evsim[evsim[i].hi].vx+
			       evsim[evsim[i].hi].vy*evsim[evsim[i].hi].vy);
	    evsim[evsim[i].li].vz=vrelz[evsim[i].li] + evsim[i].vz;
	    evsim[evsim[i].li].vx=vrelx[evsim[i].li] + evsim[i].vx;
	    evsim[evsim[i].li].vy=vrely[evsim[i].li] + evsim[i].vy;
	    evsim[evsim[i].li].v=sqrt(
			       evsim[evsim[i].li].vz*evsim[evsim[i].li].vz+
			       evsim[evsim[i].li].vx*evsim[evsim[i].li].vx+
			       evsim[evsim[i].li].vy*evsim[evsim[i].li].vy); 
            evsim[evsim[i].hi].pz=evsim[evsim[i].hi].m*evsim[evsim[i].hi].vz;
	    evsim[evsim[i].hi].px=evsim[evsim[i].hi].m*evsim[evsim[i].hi].vx;
	    evsim[evsim[i].hi].py=evsim[evsim[i].hi].m*evsim[evsim[i].hi].vy;
	    evsim[evsim[i].hi].p=evsim[evsim[i].hi].m*evsim[evsim[i].hi].v;
            evsim[evsim[i].li].pz=evsim[evsim[i].li].m*evsim[evsim[i].li].vz;
	    evsim[evsim[i].li].px=evsim[evsim[i].li].m*evsim[evsim[i].li].vx;
	    evsim[evsim[i].li].py=evsim[evsim[i].li].m*evsim[evsim[i].li].vy;
	    evsim[evsim[i].li].p=evsim[evsim[i].li].m*evsim[evsim[i].li].v;
	    evsim[evsim[i].hi].e=0.5*evsim[evsim[i].hi].m*
		evsim[evsim[i].hi].v*evsim[evsim[i].hi].v;
	    evsim[evsim[i].li].e=0.5*evsim[evsim[i].li].m*
		evsim[evsim[i].li].v*evsim[evsim[i].li].v;
	    evsim[evsim[i].hi].th=(acos(evsim[evsim[i].hi].vz/
					evsim[evsim[i].hi].v))/RAD;
	    evsim[evsim[i].li].th=(acos(evsim[evsim[i].li].vz/
					evsim[evsim[i].li].v))/RAD;
	    evsim[evsim[i].hi].phi=((evsim[evsim[i].hi].vy >= 0) ? 1 : -1)*
		(acos(evsim[evsim[i].hi].vx/(evsim[evsim[i].hi].v
					*sin(evsim[evsim[i].hi].th*RAD))))/RAD
				+((evsim[evsim[i].hi].vy >= 0) ? 0 : 360);
	    evsim[evsim[i].li].phi=((evsim[evsim[i].li].vy >= 0) ? 1 : -1)*
		(acos(evsim[evsim[i].li].vx/(evsim[evsim[i].li].v
					*sin(evsim[evsim[i].li].th*RAD))))/RAD;
				+((evsim[evsim[i].li].vy >= 0) ? 0 : 360);
	}
    }

float dths,phis,phisr,chi,psi;


    /*Phase Space Coverage*/
	while(strncmp(buf, "PSPACE",6)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "No PSPACE section in file.\n", -1)
	}
	MYGETLINE(buf, SUBS_BUFSIZE, fp, 
		  "End of file reading dths:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.dthsmin,&sim.dthsmax) !=2){
	fprintf(stderr,"\n**\n");
	fprintf(stderr,"Error! Expected "
		"'dths:min,max'\ngot \"%s\".\n", buf);
	return;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading phis:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.phismin,&sim.phismax) !=2){
	fprintf(stderr,"Error! Expected "
		"'phis:min,max'\ngot \"%s\".\n", buf);
	return;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading chi:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.chimin[0],&sim.chimax[0]) !=2){
	fprintf(stderr,"Error! Expected "
		"'chi:min,max'\ngot \"%s\".\n", buf);
	return;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading psi:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.psimin[0],&sim.psimax[0]) !=2){
	fprintf(stderr,"Error! Expected "
		"'psi:min,max'\ngot \"%s\".\n", buf);
	return;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp, 
	      "End of file reading chir:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.chimin[1],&sim.chimax[1]) !=2){
	fprintf(stderr,"Error! Expected "
		"'chir:min,max'\ngot \"%s\".\n", buf);
	return;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp, 
	      "End of file reading psir:min,max.\n", -1)
    if( sscanf(buf, " %f %f",&sim.psimin[1],&sim.psimax[1]) !=2){
	fprintf(stderr,"Error! Expected "
		"'psir:min,max'\ngot \"%s\".\n", buf);
	return;
    }


*----- Restrictions on Phase Space ---*
PSPACE
0.0 360.0		*DThs:Min,Max		BASEL CO-ORDS
0.0 180.0		*Phis:Min,Max
0.0 360.0		*Chi: Min,Max
0.0 180.0		*Psi: Min,Max
0.0 360.0		*Chir:Min,Max
0.0 180.0		*Psir:Min,Max


    float phismin,phismax,dthsmin,dthsmax;
    float chimin[2],chimax[2];
    float psimin[2],psimax[2];

    fprintf(stderr,"\n\nPhase Space Restricted to :\n"
	    "DThs: min %5.1f   max %5.1f\n"
	    "Phis: min %5.1f   max %5.1f\n"
	    "Chi:  min %5.1f   max %5.1f\n"
	    "Psi:  min %5.1f   max %5.1f\n",
	    sim.dthsmin,sim.dthsmax,sim.phismin,sim.phismax,sim.chimin[1],
	    sim.chimax[1],sim.psimin[1],sim.psimax[1]);
    
    if(bkup[4]) fprintf(stderr,"Chir: min %5.1f   max %5.1f\n"
			"Psir: min %5.1f   max %5.1f\n",
			sim.chimin[1],sim.chimax[1],
			sim.psimin[1],sim.psimax[1]);
    if(bkup[5]) fprintf(stderr,"Simulating Particle5 Isotropic breakup\n");
    if(bkup[7]) fprintf(stderr,"Simulating Particle7 Isotropic breakup\n");
    
