#include <stdio.h>
#include <stdarg.h>
#include "structure.h"
#include "fortprop.h"

struct detectors *vgetchild(char *, va_list);

/* This routine is called by instance() in structure.c to initialise
   properties defined in this file */

void initprops(struct detectors *dp)
{
    dp->hits = 0;
    dp->adcnum = -1;
    dp->hitlist.head = NULL;
    dp->hitlist.next = NULL;
    dp->gain = 1.0;
    dp->offset = 0.0;
    dp->threshmin = 1;
    dp->threshmax = 0x10000000;
    dp->value = -1.0;
    dp->user = NULL;
}

/* FORTRAN routines for the property `hits' */

int getthishits_()
{
    return (detector_ == NULL) ? 0 : detector_->hits;
}

int gethits_(char *reference, ...)
{
    struct detectors *child;

    va_list ap;
    va_start(ap, reference);

    child = vgetchild(reference, ap);

    va_end(ap);

    return(child->hits);
}

void setthishits_(int value)
{
    if (detector_ != NULL)
	detector_->hits = value;
}

void sethits_(int value, char *reference, ...)
{
    struct detectors *child;

    va_list ap;
    va_start(ap, reference);

    child = vgetchild(reference, ap);

    va_end(ap);

    child->hits = value;
}

/* FORTRAN routines for the property `adcnum' */

int getthisadcnum_()
{
    return (detector_ == NULL) ? -1 : detector_->adcnum;
}

int getadcnum_(char *reference, ...)
{
    struct detectors *child;

    va_list ap;
    va_start(ap, reference);

    child = vgetchild(reference, ap);

    va_end(ap);

    return(child->adcnum);
}

void setthisadcnum_(int value)
{
    if (detector_ != NULL)
	detector_->adcnum = value;
}

void setadcnum_(int value, char *reference, ...)
{
    struct detectors *child;

    va_list ap;
    va_start(ap, reference);

    child = vgetchild(reference, ap);

    va_end(ap);

    child->adcnum = value;
}

/* FORTRAN routines for the property `hitlist' */

int detectorhitlistnext_()
{
    struct detectors *dp;

    if (detector_ == NULL || (dp = detector_->hitlist.next) == NULL)
	return 0;

    detector_ = dp;
    return 1;
}

int detectorhitlisthead_()
{
    struct detectors *dp;

    if (detector_ == NULL || (dp = detector_->hitlist.head) == NULL)
	return 0;

    detector_ = dp;
    return 1;
}
