/*
 * ''reac''      Reaction definition                           Steve Chappell
 *
 *   General Subroutine to setup default reaction parameters
 *   from file
 
 * Updates
 *   26th Jun 97
 *
 */

#include <stdio.h>
#include <math.h>
#include "subs.h"

struct reac reac;

/*
 * Reaction definition routine
 */

int reac_init(void)
{
    FILE *fp;
    char buffer[SUBS_BUFSIZE];
    float m0,m1,m2,e1,edisp;
    /* Define this once to save space and typing */
    
    /*default settings*/
    reac.edisp=1.0;
    reac.e1=reac.edisp*65.0;
    reac.mass[0]=4.0;
    reac.mass[1]=12.0;
    reac.mass[2]=12.0;
    
    if ((fp = fopen(CALIB_DIR "reac.cal", "r")) != NULL)
    {
	fprintf(stderr, "reac: Reading file \"%s\".\n",CALIB_DIR "reac.cal");
	MYGETLINE(buffer, SUBS_BUFSIZE, fp,
		  "reac: End of file reading e1 e1disp.\n", 1)
	if (sscanf(buffer, " %f %f", &e1, &edisp) != 2)
	{
	    fprintf(stderr, "reac:Expected 'e1 edisp', got \"%s\".\n", buffer);
	    return 1;
	}
	reac.e1= e1*edisp;
	reac.edisp= edisp;
	
	MYGETLINE(buffer, SUBS_BUFSIZE, fp,
		  "reac: End of file reading masses.\n", 1)
	if (sscanf(buffer, " %f %f", &m1, &m2) != 2)
	{
	    fprintf(stderr, "reac:Expected 'mass1 mass2 mass3 mass4\n'"
		    "got \"%s\".\n", buffer);
	    return 1;
	}
	reac.mass[1]= m1;
	reac.mass[2]= m2;
	
	MYGETLINE(buffer, SUBS_BUFSIZE, fp,
		  "reac: End of file reading m0.\n", 1)
	if (sscanf(buffer, " %f", &m0) != 1)
	{
	    fprintf(stderr, "reac:Expected 'm0', got \"%s\".\n", buffer);
	    return 1;
	}
	reac.mass[0]= m0;

	fclose(fp);
    }
    else
    {
	fprintf(stderr, "reac: No file \"%s\", using default settings.\n",
		CALIB_DIR "reac.cal");
    }

    
    fprintf(stderr,"\nDefault Sort Reaction:\n"
	    "%5.1f[%7.2f MeV] ->%5.1f ==> ...",
	    reac.mass[1],reac.e1/reac.edisp,reac.mass[2]);
    fprintf(stderr,"Hitmass=%5.1f\n",reac.mass[0]);
    fprintf(stderr,"Edisp = %7.2f Channs/MeV\n\n",reac.edisp);

    return(0);
}


/*fortran compatability*/

int reac_init_(void)
{
    return(reac_init());
}

float reac_edisp(void){ return(reac.edisp); }
void reacs_edisp(float v){ reac.edisp = v; }
float reac_edisp_(void){ return(reac.edisp); }
void reacs_edisp_(float *v){ reac.edisp = *v; }

float reac_e1(void){ return(reac.e1); }
void reacs_e1(float v){ reac.e1 = v; }
float reac_e1_(void){ return(reac.e1); }
void reacs_e1_(float *v){ reac.e1 = *v; }

float reac_mass(int i){ return(reac.mass[i]); }
void reacs_mass(int i, float v){ reac.mass[i] = v; }
float reac_mass_(int *i){ return(reac.mass[(*i)]); }
void reacs_mass_(int *i, float *v){ reac.mass[(*i)] = *v; }


