/*
 * ''rp''      Resonant Particle                           Steve Chappell
 *
 *   General Subroutine to reconstruct a resonant particle
 *   from two breakup fragments given the particle positions
 *   in the event array...
 *   rp* -> Heavy Ion (hi) + Light Ion (li)

 * Updates
 *   17th Dec 97: Angles in positive range 0->360
 *   6th Jul 98: q calc now independent of daughter grouping into hi and li
 *
 */

#include <stdio.h>
#include <math.h>
#include "subs.h"

int rp(int hi, int li, int vrp)
{
    
    float vcm,mrec,vrel_x,vrel_y,vrel_z;
    float pcm_x,pcm_y,pcm_z,pcm;

    vcm=(sqrt(2.0*reac.e1*reac.mass[1]))/(reac.mass[1]+reac.mass[2]);
    
    ev[vrp].hi=hi;
    ev[vrp].li=li;
    ev[vrp].fold=ev[hi].fold+ev[li].fold;
    ev[vrp].t=0.0;
    ev[vrp].det=0;
    ev[vrp].seg=0;
    ev[vrp].m=ev[hi].m+ev[li].m;
    ev[vrp].px=ev[hi].px+ev[li].px;
    ev[vrp].py=ev[hi].py+ev[li].py;
    ev[vrp].pz=ev[hi].pz+ev[li].pz;
    ev[vrp].p=sqrt(
       ev[vrp].px*ev[vrp].px+ev[vrp].py*ev[vrp].py+ev[vrp].pz*ev[vrp].pz);
    ev[vrp].e=(ev[vrp].p*ev[vrp].p)/(2.0*ev[vrp].m);
    
    if(ev[li].fold < 2)
	ev[li].etot=ev[li].e;
    if(ev[hi].fold < 2)
	ev[hi].etot=ev[hi].e;

    ev[vrp].etot = ev[hi].etot + ev[li].etot;
    ev[vrp].q = ev[vrp].etot - ev[vrp].e;

    pcm_x=ev[vrp].px;
    pcm_y=ev[vrp].py;
    pcm_z=ev[vrp].pz-ev[vrp].m*vcm;
    pcm=sqrt(pcm_x*pcm_x+pcm_y*pcm_y+pcm_z*pcm_z);
    
    ev[vrp].th=(acos(ev[vrp].pz/ev[vrp].p))/RAD;
    
    if((ev[vrp].phi=(atan2(ev[vrp].py,ev[vrp].px))/RAD)<0)
	ev[vrp].phi+=360;

    mrec=reac.mass[1]+reac.mass[2]-ev[vrp].m;
    
    if(mrec > 0)
	ev[vrp].q2=((ev[vrp].m+mrec)*ev[vrp].e - 
		   (mrec-reac.mass[1])*reac.e1   - 
		   2.0*(sqrt(reac.mass[1]*ev[vrp].m*reac.e1*ev[vrp].e)) *
		   cos(ev[vrp].th*RAD)
		   )/mrec;
    else
	ev[vrp].q2=0.0;
    
    ev[vrp].thcm=(acos(pcm_z/pcm))/RAD;
    
    return(0);
}


