/*
 * Input file reader for scanga
 */
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "../subs.h"

int scanga_input(char *filename)
{
    FILE  *fp;
    char  buf[SUBS_BUFSIZE];
    char det_type,det_sims,det_covs;
    float distabs,radabs;
    int i,det_num;

/*initialise*/
    sim.thabs=0;
    sim.ndet=0;
    
    /* open the input file */
    if(filename == NULL){
	fprintf(stderr, "Scanga: Enter name of input file: " );
	if(scanf("%s",buf) != 1)
	    fprintf(stderr, "Scanga: Error reading name of input file\n");
	filename = buf;
    }
    if ((fp = fopen(filename, "r")) != NULL){
	fprintf(stderr, "Scanga: Using input file \"%s\".\n",filename);
    }
    else{	    
	fprintf(stderr, "Error! could not open \"%s\".\n", buf);
	return -1;
    }


    /*Process Input file.......................*/
   
    /*Simulate the detection of particles?*/    
    MYGETLINE(buf, SUBS_BUFSIZE, fp, 
	      "End of file reading detection system flag", -1)
    if(sscanf(buf, " %c", &det_sims) !=1){
	fprintf(stderr,"Error! Expected Y/N for Simulate detection system?\n"
		"got \"%s\"\n",buf);	
	return -1;
    }
    switch(det_sims){
    case 'y':
    case 'Y':
	sim.det_sim=1;
	break;
    default:
	sim.det_sim=0;
    }
    
    /*Detection System*/    
    if(!sim.det_sim){
	fprintf(stderr, "\nKinematics with no Detection Simulation:\n");
    }
    else{
	fprintf(stderr, "\nDefining Detection System:\n\n");


	if(coord_init(NDET_MAX) != 0){  /*initialise detector coordinates*/
	    fprintf(stderr, "Error initialising Co-ordinates\n");
	    return -1;
	}
	
	while(strncmp(buf, "DETSYS",6)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Can't find DETSYS line.\n" , -1)
	}	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading coverage flag.\n" , -1)
	if(sscanf(buf, " %c", &det_covs) !=1){
	    fprintf(stderr,"Error! Expected Y/N for Generate coverage?\n"
		    "got \"%s\"\n",buf);	
	    return -1;
	}
	switch(det_covs){
	case 'y':
	case 'Y':
	    sim.cov=1;
	    break;
	default:
	    sim.cov=0;
	}
	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading Eres.\n", -1)
	if(sscanf(buf, " %f", &sim.eres) !=1){
	  fprintf(stderr,"Error! Expected Eres\n"
		  "got \"%s\"\n",buf);	
	  return -1;
	}
	else
	  fprintf(stderr, "Smearing particle Energies by %f MeV\n\n",sim.eres);
	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "No REAC section in file.\n", -1)
	while(strncmp(buf, "REAC",4)){
	    if(sscanf(buf, " %c %d", &det_type, &det_num) !=2){
		switch(det_type){
		case 'M':
		    break;
		case 'S':
		    break;
		case 'R':
		    break;
		default:
		    fprintf(stderr,"Error! Expected Array M/S or"
			    " detector type and number\n"
			    "got \"%s\"\n",buf);
		    return -1;
		}
	    }
	    
	    switch(det_type){
	    case 'a':
		fprintf(stderr, "%d (a)ncillary detectors\n",det_num);
		for(i=1; i<det_num+1; i++){
		    sim.det_type[++sim.ndet]=DTYPE_a;
		    if(coord_andet(sim.ndet,fp) !=0)
			return -1;
		}
		break;
	    case 'm':
		fprintf(stderr, "%d Megha (m)odules\n",det_num);
		break;
	    case 's':
		fprintf(stderr, "%d (s)trip detectors\n",det_num);
		break;
	    case 'p':
		fprintf(stderr, "%d (p)sd detectors\n",det_num);
		break;
	    case 'M':
		fprintf(stderr, "(M)EGHA\n");
		break;
	    case 'S':
		fprintf(stderr, "(S)trip Array with %d detectors\n",det_num);
		for(i=1 ; i<det_num+1; i++){
		    sim.det_type[++sim.ndet]=DTYPE_S;
		    if(coord_det(sim.ndet,fp) !=0)
			return -1;
		}
		break;
	    case 'R':
		fprintf(stderr, "circular absorbe(R) around beam axis\n");
		MYGETLINE(buf, SUBS_BUFSIZE, fp,
			  "End of file reading distabs radabs.\n", -1)
		if( sscanf(buf, " %f %f", &distabs,&radabs) !=2){
		    fprintf(stderr,"Error! Expected "
			    "'distabs radabs'\n"
			    "got \"%s\".\n", buf);
		    return -1;
		}
		else{
		    sim.thabs=(atan(radabs/distabs))/RAD;	
		}	    
		break;
	    default:
		fprintf(stderr,"Error! Expected 'a/m/s/p/M/S'\n"
			" got \"%c\".\n", det_type);
		return -1;
	    }
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "No REAC section in file.\n", -1)
	}
	fprintf(stderr,"Total of %d Detectors defined\n\n",sim.ndet);

    }
    
    
    /*Reaction*/
    while(strncmp(buf, "REAC",4)){
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "No REAC section in file.\n", -1)
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading m1 m2 m3 m4 ex3 ex4.\n", -1)
    if( sscanf(buf, " %f %f %f %f %f %f",
	       &(evsim[1].m),&(evsim[2].m),&(evsim[3].m),
	       &(evsim[4].m),&sim.ex[3],&(sim.ex[4])) !=6){
	fprintf(stderr,"Error! Expected "
		"'m1 m2 m3 m4 ex3 ex4'\n"
		"got \"%s\".\n", buf);
	return -1;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading e1 q1.\n", -1)
    if( sscanf(buf, " %f %f", &sim.e1,&sim.q1)!=2){
	fprintf(stderr,"Error! Expected "
		"'e1 q1'\ngot \"%s\".\n", buf);
	return -1;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading m5 m6 qb3 ex5.\n", -1)
    if( sscanf(buf, " %f %f %f %f", &evsim[5].m,&evsim[6].m,
	       &sim.qb[3],&sim.ex[5])!=4){
	fprintf(stderr,"Error! Expected "
		"'m5 m6 qb3 ex5'\ngot \"%s\".\n", buf);
	return -1;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading m7 m8 qb4 ex7.\n", -1)
    if( sscanf(buf, " %f %f %f %f",  &(evsim[7].m),&(evsim[8].m),
	       &sim.qb[4],&sim.ex[7])!=4){
	fprintf(stderr,"Error! Expected "
		"'m7 m8 qb4 ex7'\ngot \"%s\".\n", buf);
	return -1;
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading m9 m10 qb5.\n", -1)
    if( sscanf(buf, " %f %f %f", &(evsim[9].m),&(evsim[10].m),&sim.qb[5])!=3){
	fprintf(stderr,"Error! Expected "
		"'m9 m10 qb5'\ngot \"%s\".\n", buf);
	return -1;
    }	  
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading m11 m12 qb7.\n", -1)
    if( sscanf(buf, " %f %f %f",  &(evsim[11].m),&(evsim[12].m),
	       &sim.qb[7])!=3){
	fprintf(stderr,"Error! Expected "
		"'m11 m12 qb7'\ngot \"%s\".\n", buf);
	return -1;
    }

    /*Breakup simulation*/
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading breakup simulation type.\n", -1)   	
    if(sscanf(buf, " %c", &sim.bkup_coords) !=1){
	fprintf(stderr,"Error! Expected Bkup coords\n"
		"got \"%s\"\n",buf);
	return -1;
    }
    switch(sim.bkup_coords){
    case 'b':
	fprintf(stderr, "Simulating breakup over Basel Coordinates:\n");
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading breakup simulation Nl'.\n",
		  -1)
	if(sscanf(buf, " %d %d %d", &sim.b_nl) !=1){
	    fprintf(stderr,"Error! Expected Nl' value\n"
		    "got \"%s\"\n",buf);
	    return -1;
	}
	fprintf(stderr,"Nl'=%d\n",sim.b_nl);
        for(i=0;i<sim.b_nl;i++){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading breakup simulation a_l',l'....\n",-1)
	    if(sscanf(buf, " %f %d %d %d", 
		      &sim.b_al[i], &sim.b_l[i],
		      &sim.b_k[i], &sim.b_kp[i]) !=4){
		fprintf(stderr,"Error! Expected al', l', k, k' values\n"
			"got \"%s\"\n",buf);
		return -1;
	    }
	    fprintf(stderr,"al'=%f l'=%d k=%d  k'=%d\n",
		    sim.b_al[i],sim.b_l[i],sim.b_k[i],sim.b_kp[i]);	
	}
      	break;
    default:
	fprintf(stderr, "Simulating Structureless Isotropic breakup\n");
    }
    
    
    if(sim.det_sim){
	/*Hit patterns*/
	while(strncmp(buf, "HITPAT",6)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "No HITPAT section in file.\n", -1)
	}	
	for(i=1; i<sim.ndet+1; i++){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "End of file reading hitpat 3-12.\n", -1)
	    if( sscanf(buf, " %d %d %d %d %d %d %d %d %d %d",
		       &sim.hitpat[i][3],&sim.hitpat[i][4],&sim.hitpat[i][5],
		       &sim.hitpat[i][6],&sim.hitpat[i][7],&sim.hitpat[i][8],
		       &sim.hitpat[i][9],&sim.hitpat[i][10],&sim.hitpat[i][11]
		       ,&sim.hitpat[i][12]) !=10){
		fprintf(stderr,"Error! Expected "
			"'hitpat 3-12'\ngot \"%s\".\n", buf);
		return -1;
	    }
	}
	
	/*Final state*/
	while(strncmp(buf, "COINC",5)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "No COINC section in file.\n", -1)
	}	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading fstate 3-12.\n", -1)
	if( sscanf(buf, " %d %d %d %d %d %d %d %d %d %d",
		   &sim.coinc[3],&sim.coinc[4],&sim.coinc[5],&sim.coinc[6],
		   &sim.coinc[7],&sim.coinc[8],&sim.coinc[9],
		   &sim.coinc[10],&sim.coinc[11],&sim.coinc[12]) !=10){
	    fprintf(stderr,"Error! Expected "
		    "'fstate 3-12'\ngot \"%s\".\n", buf);
	    return -1;
	}
	
	/*Particle Energy Thresholds : Should do this by detector really*/
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading ethrsh 3-12.\n", -1)
	    if( sscanf(buf, " %f %f %f %f %f %f %f %f %f %f",
		       &sim.ethrsh[3],&sim.ethrsh[4],&sim.ethrsh[5],
		       &sim.ethrsh[6],&sim.ethrsh[7],&sim.ethrsh[8],
		       &sim.ethrsh[9],&sim.ethrsh[10],
		       &sim.ethrsh[11],&sim.ethrsh[12]) !=10){
		fprintf(stderr,"Error! Expected "
			"'ethrsh 3-12'\ngot \"%s\".\n", buf);
		return -1;
	    }
    }
    
    
    /*Calculation Type for Monte Carlo*/
    while(strncmp(buf, "EFFCALC",7)){
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "No EFFCALC section in file.\n", -1)
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "End of file reading Effcalc.\n", -1)
    if(sscanf(buf, " %d",&sim.effcalc) !=1){
	fprintf(stderr,"Error! Expected "
		"'Effcalc'\ngot \"%s\".\n", buf);
	return -1;
    }    
    if(sim.effcalc != 0){
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "End of file reading effmin effmax effstep.\n", -1)
	if( sscanf(buf, " %f %f %f", &sim.effmin,&sim.effmax,
		   &sim.effstep)!=3){
	    fprintf(stderr,"Error! Expected "
		    "' effmin,effmax,effstep'\ngot \"%s\".\n", buf);
	    return -1;
	}    
    }
    
    fclose(fp);
    /* End of Inputs */
    
    
    return(0);   
}

