/*
 * Main code for stand alone running of scanga               Steve Chappell
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../subs.h"

static int tot_nevents=0;
static char *inputfile;

int main(int argc,char **argv)
{
 int nevents,nn=0/*,nhits*/;
 float eff=0.0,efferr;

 /* check to see which options have been set in the command line */      
 if(read_scanga_args(argc,argv)){
     fprintf(stderr,"Scanga: Error reading command line\n"); 
     return 1;
 }
 
 /*Number of events for Monte Carlo*/
 if(tot_nevents < 1){
     fprintf(stderr, "Enter Nevents for simulation: ");
     if(scanf("%d",&tot_nevents) != 1){
	 fprintf(stderr,"Error reading Nevents\n");
	 return 1;
     }
 }


 if(scanga_init(inputfile)){
     fprintf(stderr, "Error initialising Scanga\n");
     return 1;
 }
 
 /*loop over Desired Efficiency Variable*/
 for(sim.effvar=sim.effmin ; sim.effvar <= sim.effmax ; 
     sim.effvar+=sim.effstep){
     
     if(sim.effcalc == 1){
	 sim.ex[3]=sim.effvar;
	 fprintf(stderr,"\nEx3 = %7.2f\n",sim.ex[3]);
     }
     else if(sim.effcalc == 2){
	 sim.ex[4]=sim.effvar;
	 fprintf(stderr,"\nEx4 = %7.2f\n",sim.ex[3]);
     }
     else if(sim.effcalc == 3){
	 sim.e1=sim.effvar;
	 fprintf(stderr,"\nE1 = %7.2f\n",sim.e1);
     }
     else if(sim.effcalc == 4)
	 fprintf(stderr,"\nPhis = %7.2f\n",sim.effvar);
     else if(sim.effcalc){
	 fprintf(stderr,"\nError! Can't do effcalc=%d\n",sim.effcalc);
	 return 1;
     }
     
     if(scanga_kin_init()){
	 fprintf(stderr, "Error initialising Scanga kinematics\n");
	 return 1;
     } ;
     
     /*loop over sim.nevents */
     fprintf(stderr,"\n>>: ");
     for(nevents=1; nevents <= tot_nevents; nevents++){
	 
	 /*Show progress every nn events*/
	 nn++;
	 if(nn == tot_nevents/50){
	     nn=0;
	     fprintf(stderr,"#");
	 }
	 
	 if((/*nhits = */scanga_event())){
	     eff++; /*fractional efficiency*/
	     /*interesting event*/
	 }
	 
     } /* End Nevents Loop */
     
 } /* End Efficiency Loop */
 
 /*Output Efficiency in percent*/
 if(sim.det_sim && sim.effcalc){
     efferr=(sqrt(eff))/((float) nevents ) *100.0;
     eff=eff/((float) nevents) *100.0;
     fprintf(stderr,"\n\n %% Eff = %10.6f +/- %10.6f\n",
	     eff,efferr);
 }
 
 
 if(scanga_finish()){
     fprintf(stderr, "Error finishing Scanga\n");
     return 1;
 }
 
 return 0;
}


/*
 * Read command line options for scanga
 */
int read_scanga_args(int argc, char **argv)
{
    int i; 
    
    for(i=1 ; i< argc; i++){
	if (strncmp(argv[i],"-n",2) == 0) {
	    if (argv[i+1] != NULL) {
		if(tot_nevents = (int) atoi(argv[i+1])){
		    fprintf(stderr,"Scanga: Simulation of %d events\n",
			    tot_nevents);
		    i++;
		}
		else{
		    fprintf(stderr,"Scanga: Canny simulate nevents < 1 !\n");
		    return(-1);
		}
	    }	    
	}
	else if (strncmp(argv[i],"-i",2) == 0) {
	    if (argv[i+1] != NULL)
		inputfile = argv[i+1];
	    i++;
	}
	else{
	    fprintf(stderr,"Scanga: command line option "
		    "\"%s\" unrecognised\n",argv[i]);
	    fprintf(stderr, "\nUsage: scanga -n (nevents)"
		    " -i (inputfile)\n\n");
	    return(-1);
	}
    }
    return(0);
}



