/* sim.h   Simulation routine Declarations */

#define SIM_NPMAX 13 /*Max Number of particles+1 in simulation*/

/*Detector Types*/
#define DTYPE_S 1 /*Detector in the (S)trip Array*/
#define DTYPE_a 2 /*(a)ncillary detector*/

extern struct ev_struct *evsim;

extern struct sim{         /*Simulation inputs structure*/
  float q1;
  float e1;
  float ex[SIM_NPMAX];
  float qb[SIM_NPMAX];
  float  effmin,effmax,effstep;
  int effcalc;
  float effvar;
  char bkup_coords;
  int b_nl,b_l[10],b_k[10],b_kp[10];    /*basel l and k values for simulation*/
  float b_al[10];
  /*detector stuff*/
  float eres;
  int det_sim;
  int cov;
  int ndet;
  int det_type[NDET_MAX+1];
  float thabs;
  int hitpat[NDET_MAX+1][SIM_NPMAX],fstate[SIM_NPMAX];
  int coinc[SIM_NPMAX],hit[SIM_NPMAX];
  float ethrsh[SIM_NPMAX];
} sim;


int evsim_init(int);                    /*Simulated event structure init*/
int scanga_init(char *);                /*Scanga simulation init*/
int scanga_kin_init(void);              /*Scanga simulation kin init*/
int scanga_event(void);                 /*Scanga simulation event*/
int scanga_finish(void);                /*Scanga simulation finish*/
int scanga_input(char *);               /*input file reader for scanga*/
int wrt_evsim(int, FILE *);             /*writes simulated event to file*/
int read_evsim(void);                   /*reads simulated event from file*/
float grand(double, double);            /*gaussian random number generator*/
int read_scanga_args(int, char **);     /*read Scanga command line args*/
