struct namelist {
    char *name;
    struct namelist *next;
};

struct detectors {
    struct detectors *parent;
    struct detectors *children;
    struct detectors *next;
    struct information *info;
    int number;
    short adcnum;	/* used by loadadcs and markhits */
    short hits;		/* here onwards used by markhits */
    struct {
	struct detectors *head; /* first detector on next level */
	struct detectors *next; /* next detector on same level */
    } hitlist;
    float gain;
    float offset;
    int threshmin;
    int threshmax;
    float value;
    void *user;		/* Hook to attach user data */
};

struct information {
    char *name;
    struct namelist *childnames;
    int (*preinit)(struct detectors *);
    int (*init)(struct detectors *);
    int (*preevent)(int, struct detectors *);
    int (*event)(int, struct detectors *);
    struct information *next;
};

struct detectors *loadexperiment(char *);
void dumpdetectors(struct detectors *, int);
/* This is a wonderful declaration :-) */
int setdetprocs(char *, int (*)(struct detectors *),
		int (*)(struct detectors *), int (*)(int, struct detectors *),
		int (*)(int, struct detectors *));
