/* subs.h   Standard Subroutine Declarations */

#define NDET_MAX 50          /*Max Number of detectors*/
#define NMOD_MAX 5           /*Max Number of MEGHA modules*/
#define NSEG_MAX 16          /*Max Number of segments*/

#include "event-struct/ev.h" /*event structure*/
#include "reac.h"            /*reaction structure*/
#include "files.h"           /*file handling*/
#include "simulations/sim.h" /*event simulation*/
#include "coord.h"           /*coordinates*/
#include "structure.h"       /*detector structure*/

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#define RAD (M_PI/180)       /*degrees to radians conversion*/
#define SUBS_BUFSIZE 256

#define NP_MAX 63            /*Max number of particles in the event array*/
#define N1_MAX 6             /*Max number of single particle hits*/
#define N2_MAX 15            /*Max number of doubles*/
#define N3_MAX 20            /*Max number of triples*/
#define N4_MAX 15            /*Max number of quads*/
#define N5_MAX 6             /*Max number of quins*/
#define N6_MAX 1             /*Max number of sextuplets*/

int nrp(int);                /*Builds event array for n resonant particles*/
int ncr(int, int);           /*r combinations out of n*/
int rp(int, int, int);       /*Resonant Particle Kinematics*/
void rhit(float, int);       /*Recalculate hit for new mass assignment*/
void nrhit(float, int);      /*Recalculate for all dependencies*/
int chit(int, int);          /*Copy hit to another position in ev array*/
int crhit(float, int, int);  /*Copy hit and recalculate for new mass*/
int corr(int);               /*Calculate correlation phase space*/
int chann_dump(int, int);    /*dump sunsort event data*/
void expt_dump(struct detectors *, int); /*dump experiment info*/
void event_dump(struct detectors *, int);/*dump event info*/
void adclist_dump(void);     /*dump adclist info*/
int missing_p(void);         /*generate a new particle from missing momentum*/
