#include <stdio.h>
#include <string.h>
#include "structure.h"
#include "loadadcs.h"
#include "markhits.h"

int main()
{
    struct detectors *expt, *det, *strip, *sig;
    short adc[768];
    int n;

    /* This would be in subroutine init */

    if ((expt = loadexperiment("testexpt.det")) == NULL)
    {
	fprintf(stderr, "Unable to load experiment structure file.\n");
	return 1;
    }
    printf("struct:Experiment structure file loaded.\n");

    if (loadadcs(expt, "testexpt.adcs",384) < 0)
    {
	fprintf(stderr, "Unable to load ADC numbers.\n");
	return 1;
    }
    printf("ADC numbers loaded.\n");

    if (initmarkhits(expt, 768)<0)
    {
	fprintf(stderr, "Unable to initialise markhits.\n");
	return 1;
    }
    printf("Markhits initialised.\n");

    for(;;)
    {
	/* Simulate sunsort setting adc array */

	memset(adc, 0, sizeof(adc));
	printf("Enter ADC numbers and values, end with -1\n");
	do {
	    if (scanf("%d", &n) == EOF)
		return 0;
	    if (n != -1)
		if (scanf("%hd", adc + n - 1) == EOF)
		    return 0;
	} while(n != -1);

	/* This would be in entry sortin */

	markhits(adc); /* A separate entry using adclist will be provided */


	printf("%d hit%s at the top level.\n", expt->hits,
	       (expt->hits == 1) ? "" : "s");

	for(det = expt->hitlist.head; det != NULL; det = det->hitlist.next)
	{
	    printf("%d hit%s in detector %d.\n", det->hits,
		   (det->hits == 1) ? "" : "s", det->number);
	    for(strip = det->hitlist.head; strip != NULL;
		strip = strip->hitlist.next)
	    {
		printf("%d hit%s in strip %d:", strip->hits,
		       (strip->hits == 1) ? "" : "s", strip->number);
		for(sig = strip->hitlist.head; sig != NULL;
		    sig=sig->hitlist.next)
		    /* This line prints the signal number 
		       (1,2,3,4 = A, At, B, Bt),
		       the adc number and the adc value */
		    printf(" %d(%d=%d)", sig->number, sig->adcnum,
			   adc[sig->adcnum-1]);
		putchar('\n');
	    }
	}
    }
}

